/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.editors;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import oracle.ide.util.ResourceUtils;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.Voice;
import oracle.tip.tools.ide.common.bpelparser.iface.Assign;
import oracle.tip.tools.ide.common.bpelparser.iface.Copy;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.graph.model.Node;
import oracle.tip.tools.ide.common.graph.view.GraphPane;
import oracle.tip.tools.ide.common.ui.GlobalImageCache;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.utils.MixedXPathExpressionParser;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.EditorPage;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.EditorPageChangeListener;
import oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.editors.NotificationGenEditPage;
import oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.model.VoiceNode;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.lookup.LookupDialog;
import oracle.tip.tools.ide.pm.modules.notification.util.NotificationsUtil;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class VoiceGenEditPage
extends NotificationGenEditPage
implements ActionListener,
EditorPage {
    private JTextField m_nameField = new JTextField();
    private JLabel toLabel = new JLabel();
    private JTextField toText = new JTextField();
    private JButton m_toExpBuilderBtn;
    private JLabel bodyLabel = new JLabel();
    private JTextArea bodyText = new JTextArea();
    private JButton m_bodyExpBuilderBtn;
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JButton toUButton = null;
    private boolean isEmpty;
    private boolean m_bEditing = false;
    private boolean m_saved = false;
    private Assign assign;

    public VoiceGenEditPage(GraphPane pane, Node n) {
        super((BPELGraphPane)pane);
        this.m_notificationNode = (VoiceNode)n;
    }

    @Override
    public void setUserObject(Object model) {
        this.m_notificationActivity = (Voice)model;
        boolean bl = this.isEmpty = this.getInvoke() == null;
        if (this.m_notificationActivity != null && !this.isEmpty) {
            this.m_nameField.setText(this.m_notificationActivity.getName());
            this.m_bEditing = true;
            this.initSequence();
        } else {
            String name = BPELModelUtil.generateUniqueName((Process)this.m_processModel, (String)"Voice", Voice.class);
            this.m_nameField.setText(name);
            this.createNewNotificationNode();
        }
        this.invoke = this.getInvoke();
        try {
            this.jbInit();
            if (this.m_bEditing) {
                this.loadUI();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadUI() {
        this.m_notificationNode.setUserObject(this.m_notificationActivity);
        this.assign = ((Voice)this.m_notificationActivity).getNotifParamsAssign();
        if (this.assign != null) {
            this.setUIData(this.assign);
        }
        this.m_notificationNode.setName(this.m_nameField.getText());
        this.m_notificationActivity.setName(this.m_nameField.getText());
    }

    private void setUIData(Assign assign) {
        List copyRules = assign.getCopyRules();
        if (copyRules != null) {
            for (int i = 0; i < copyRules.size(); ++i) {
                Copy copy = (Copy)copyRules.get(i);
                String query = copy.getTo().getQuery();
                String value = copy.getFrom().getExpression();
                if (value == null) continue;
                if (value.equalsIgnoreCase("string('')")) {
                    value = "";
                } else {
                    MixedXPathExpressionParser parser = new MixedXPathExpressionParser();
                    value = parser.convertXPathComplaintStringToMixedForm(value);
                }
                if (query.endsWith("To")) {
                    this.toText.setText(value);
                    continue;
                }
                if (!query.endsWith("ContentBody")) continue;
                this.bodyText.setText(value);
            }
        }
    }

    private void jbInit() throws Exception {
        this.createExpBuilderBtn();
        Icon flashImage = GlobalImageCache.getIcon((String)"browse16");
        this.setLayout(this.gridBagLayout1);
        ResourceUtils.resLabel((JLabel)this.toLabel, (Component)this.toText, (String)BPELStringTranslator.getString("TEL_NUMBER_LABEL"));
        this.toText.setEditable(true);
        JScrollPane bodyTextScroll = new JScrollPane(this.bodyText);
        this.bodyText.setEditable(true);
        this.bodyText.setFocusTraversalKeys(1, null);
        ResourceUtils.resLabel((JLabel)this.bodyLabel, (Component)this.bodyText, (String)BPELStringTranslator.getString("BODY_LABEL"));
        this.add((Component)this.toText, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.toUButton = new JButton(flashImage);
        this.toUButton.addActionListener(this);
        this.addLookupButtons(this.toUButton, this.m_toExpBuilderBtn, 2, 0, 10);
        this.add((Component)this.toLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        JToolBar tbBody = new JToolBar();
        tbBody.setBorderPainted(false);
        tbBody.add(this.m_bodyExpBuilderBtn);
        JPanel bodyPanel = new JPanel(new GridBagLayout());
        bodyPanel.add((Component)bodyTextScroll, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
        bodyPanel.add((Component)tbBody, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.bodyLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)bodyPanel, new GridBagConstraints(1, 1, 2, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 0, 10), 0, 0));
        JLabel bodyHelp = new JLabel();
        bodyHelp.setText(BPELStringTranslator.getString("VOICE_BODY_EXPLANATION"));
        this.add((Component)bodyHelp, new GridBagConstraints(1, 2, 0, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 10, 0), 0, 0));
    }

    private void createExpBuilderBtn() {
        this.m_toExpBuilderBtn = UIHelper.createModelerButton((Icon)ImageCache.getIcon("expressionbuilder"));
        this.m_toExpBuilderBtn.setToolTipText(BPELStringTranslator.getString("XPATH_EXPRESSSION_BUILDER", "XPath Expression Builder"));
        this.m_toExpBuilderBtn.addActionListener(this);
        this.m_bodyExpBuilderBtn = UIHelper.createModelerButton((Icon)ImageCache.getIcon("expressionbuilder"));
        this.m_bodyExpBuilderBtn.setToolTipText(BPELStringTranslator.getString("XPATH_EXPRESSSION_BUILDER", "XPath Expression Builder"));
        this.m_bodyExpBuilderBtn.addActionListener(this);
    }

    public Node getNode() {
        if (!this.m_bEditing && !this.m_saved) {
            return null;
        }
        return this.m_notificationNode;
    }

    @Override
    protected void createCopyRules() {
        MixedXPathExpressionParser parser = new MixedXPathExpressionParser();
        try {
            Element processElem = this.m_processModel.getDOMElement();
            Document doc = processElem.getOwnerDocument();
            String part = "";
            String query = "";
            String prefix = NotificationsUtil.getNamespacePrefix(this.m_graphModel.getProcess());
            part = "VoicePayload";
            query = '/' + part + '/' + prefix + ':';
            if (this.assign == null) {
                this.assign = this.createAssignNode("VoiceParamsAssign");
            }
            NotificationsUtil.createOrReplaceCopy(parser.convertMixedStringToXPathCompliantForm(this.convertToNotEmptyValue(this.bodyText.getText())), part, query + "Content" + "/" + prefix + ':' + "ContentBody", doc, this.assign);
            NotificationsUtil.createOrReplaceCopy("string('text/vxml')", part, query + "Content" + "/" + prefix + ':' + "MimeType", doc, this.assign);
            NotificationsUtil.createOrReplaceCopy(parser.convertMixedStringToXPathCompliantForm(this.convertToNotEmptyValue(this.toText.getText())), part, query + "To", doc, this.assign);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        int lookupType = 0;
        if (source.equals(this.toUButton)) {
            LookupDialog dialog = new LookupDialog(lookupType, this, LookupDialog.VOICE_LOOKUP);
            boolean success = dialog.showDialog();
            if (success) {
                this.toText.setText(dialog.getPhoneNumber());
            }
        } else if (source == this.m_toExpBuilderBtn) {
            this.invokeGraphicalXPathBuilder(this.toText);
        } else if (source == this.m_bodyExpBuilderBtn) {
            this.invokeGraphicalXPathBuilder(this.bodyText);
        }
    }

    @Override
    public Object getUserObject() {
        return this.m_notificationActivity;
    }

    @Override
    public String getTitle() {
        return BPELStringTranslator.getString("VOICE");
    }

    @Override
    public JComponent getPagePanel() {
        return this;
    }

    @Override
    public void saveChanges() {
        this.saveChanges(this.isEmpty, this.m_bEditing, this.m_saved, "sendVoiceNotification", this.m_nameField.getText());
        this.m_saved = true;
    }

    @Override
    public boolean validateEditorChanges() {
        return true;
    }

    @Override
    public void removeEditorPageChangeListener(EditorPageChangeListener l) {
    }

    @Override
    public void onSelection() {
    }

    @Override
    public void onDeselection() {
    }
}

