/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.ide.util.ModelUtil;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.Validate;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Variable;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.pm.bpelgraph.editors.BaseEditingPage;
import oracle.tip.tools.ide.pm.bpelgraph.editors.TextFieldListener;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariablesListEditPanel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;

public class ValidateEditPage
extends BaseEditingPage {
    protected JTextField m_nameField;
    protected VariablesListEditPanel m_panel;
    protected Validate m_activity;

    public ValidateEditPage(BPELGraphPane pane) {
        super(pane);
        this.createControls();
        this.layoutControls();
    }

    @Override
    public void loadData() {
    }

    @Override
    public void setUserObject(Object model) {
        super.setUserObject(model);
        this.m_activity = (Validate)model;
        this.loadControls();
    }

    public void setFocus() {
        this.m_nameField.requestFocus();
    }

    protected void loadControls() {
        if (this.m_activity == null) {
            return;
        }
        if (this.m_activity.getName() != null) {
            this.m_nameField.setText(this.m_activity.getName());
        }
        this.m_panel.load((Activity)this.m_activity);
    }

    protected void createControls() {
        this.m_nameField = new JTextField();
        this.m_nameField.getDocument().addDocumentListener(new TextFieldListener(this));
        this.m_panel = new VariablesListEditPanel(this.m_graphPane);
    }

    protected void layoutControls() {
        this.setLayout(new GridBagLayout());
        JLabel lblName = new JLabel();
        BPELStringTranslator.setLabel(lblName, this.m_nameField, BPELStringTranslator.getString("GENERAL_EDITOR_NAME"));
        GraphUtils.addComponent((Container)this, (Component)lblName, (int)0, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(10, 10, 5, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_nameField, (int)1, (int)0, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(10, 5, 5, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_panel, (int)0, (int)1, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)1.0);
    }

    @Override
    public boolean validateEditorChanges() {
        if (!ModelUtil.hasLength((String)this.m_nameField.getText())) {
            GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)this), (String)BPELStringTranslator.getString("GENERAL_EDITOR_NAME_ERROR"), (String)BPELStringTranslator.getString("GENERAL_EDITOR_ERROR"), (int)2);
            return false;
        }
        String name = this.m_nameField.getText();
        if (!Helper.isValidName((String)name, (boolean)true)) {
            GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)this), (String)BPELStringTranslator.getString("GENERAL_EDITOR_NAME_INVALID"), (String)BPELStringTranslator.getString("GENERAL_EDITOR_ERROR"), (int)2);
            return false;
        }
        return true;
    }

    @Override
    public void saveChanges() {
        if (this.m_activity == null) {
            return;
        }
        this.m_activity.setName(this.m_nameField.getText());
        List list = this.m_panel.getVariables();
        if (list != null && list.size() > 0) {
            ArrayList<String> newVarList = new ArrayList<String>(list.size());
            for (int i = 0; i < list.size(); ++i) {
                Variable var = (Variable)list.get(i);
                newVarList.add(var.getName());
            }
            this.m_activity.setVariables(newVarList);
        }
    }
}

