/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import oracle.ide.util.ResourceUtils;
import oracle.tip.tools.ide.common.bpelparser.extension.notification.iface.UserNotification;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Assign;
import oracle.tip.tools.ide.common.bpelparser.iface.Copy;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.graph.model.Node;
import oracle.tip.tools.ide.common.graph.view.GraphPane;
import oracle.tip.tools.ide.common.ui.GlobalImageCache;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.utils.MixedXPathExpressionParser;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.EditorPage;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.EditorPageChangeListener;
import oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.editors.NotificationGenEditPage;
import oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.editors.UserNotificationAdvEditPage;
import oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.model.UserNotificationNode;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.lookup.LookupDialog;
import oracle.tip.tools.ide.pm.modules.notification.util.NotificationsUtil;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class UserNotificationGenEditPage
extends NotificationGenEditPage
implements ActionListener,
EditorPage {
    private JTextField m_nameField = new JTextField();
    private JLabel toLabel = new JLabel();
    private JTextField toText = new JTextField();
    private JTextField subjectText = new JTextField();
    private JLabel subjectLabel = new JLabel();
    private JButton m_toExpBuilderBtn;
    private JLabel bodyLabel = new JLabel();
    private JScrollPane jScrollPane = new JScrollPane();
    private JTextArea m_bodyXPathBuilder;
    private JButton m_bodyExpBuilderBtn;
    private JButton toButton = null;
    private boolean m_validate = false;
    private boolean m_bEditing = false;
    private boolean m_saved = false;
    private JToolBar toToolBar;
    private JLabel toHelp;
    private JToolBar tbBody;
    private JLabel bodyHelp;
    private JButton m_subjectExpBuilderBtn;
    private boolean isEmpty;
    private Assign userAssign;
    private Assign commonPayloadAssign;
    private UserNotificationAdvEditPage advPage;

    public UserNotificationGenEditPage(GraphPane pane, Node n) {
        super((BPELGraphPane)pane);
        this.m_notificationNode = (UserNotificationNode)n;
    }

    @Override
    public void setUserObject(Object model) {
        this.m_notificationActivity = (UserNotification)model;
        boolean bl = this.isEmpty = this.getInvoke() == null;
        if (this.m_notificationActivity != null && !this.isEmpty) {
            this.m_nameField.setText(this.m_notificationActivity.getName());
            this.m_bEditing = true;
            this.initSequence();
        } else {
            String name = BPELModelUtil.generateUniqueName((Process)this.m_processModel, (String)"UserNotification", UserNotification.class);
            this.m_nameField.setText(name);
            this.createNewNotificationNode();
        }
        this.invoke = this.getInvoke();
        try {
            this.createControls();
            this.layoutControls();
            if (this.m_bEditing) {
                this.loadUI();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadUI() {
        this.m_notificationNode.setUserObject(this.m_notificationActivity);
        this.userAssign = ((UserNotification)this.m_notificationActivity).getAssignByName("AssignUser");
        this.commonPayloadAssign = ((UserNotification)this.m_notificationActivity).getAssignByName("AssignCommonPayload");
        if (this.userAssign != null) {
            this.setUserUIData(this.userAssign);
        }
        if (this.commonPayloadAssign != null) {
            this.setPayloadUIData(this.commonPayloadAssign);
        }
        this.m_notificationNode.setName(this.m_nameField.getText());
        this.m_notificationActivity.setName(this.m_nameField.getText());
    }

    private void setUserUIData(Assign userAssign) {
        List copyRules = userAssign.getCopyRules();
        if (copyRules != null) {
            for (int i = 0; i < copyRules.size(); ++i) {
                Copy copy = (Copy)copyRules.get(i);
                String query = copy.getTo().getQuery();
                String value = copy.getFrom().getExpression();
                if (value == null) continue;
                if (value.equalsIgnoreCase("string('')")) {
                    value = "";
                } else {
                    MixedXPathExpressionParser parser = new MixedXPathExpressionParser();
                    value = parser.convertXPathComplaintStringToMixedForm(value);
                }
                if (!query.endsWith("UserId")) continue;
                this.toText.setText(value);
            }
        }
    }

    private void setPayloadUIData(Assign commonPayloadAssign) {
        List copyRules = commonPayloadAssign.getCopyRules();
        if (copyRules != null) {
            for (int i = 0; i < copyRules.size(); ++i) {
                Copy copy = (Copy)copyRules.get(i);
                String query = copy.getTo().getQuery();
                String value = copy.getFrom().getExpression();
                if (value == null) continue;
                if (value.equalsIgnoreCase("string('')")) {
                    value = "";
                } else {
                    MixedXPathExpressionParser parser = new MixedXPathExpressionParser();
                    value = parser.convertXPathComplaintStringToMixedForm(value);
                }
                if (query.endsWith("Subject")) {
                    this.subjectText.setText(value);
                    continue;
                }
                if (!query.endsWith("ContentBody")) continue;
                this.m_bodyXPathBuilder.setText(value);
            }
        }
    }

    private void createControls() {
        this.createExpBuilderBtn();
        Icon flashImage = GlobalImageCache.getIcon((String)"browse16");
        this.toButton = new JButton(flashImage);
        this.toButton.addActionListener(this);
        this.toButton.setEnabled(true);
        ResourceUtils.resLabel((JLabel)this.toLabel, (Component)this.toText, (String)BPELStringTranslator.getString("IM_TO_LABEL"));
        ResourceUtils.resLabel((JLabel)this.subjectLabel, (Component)this.subjectText, (String)BPELStringTranslator.getString("SUBJECT_LABEL"));
        this.toText.setEditable(true);
        this.subjectText.setEditable(true);
        this.m_bodyXPathBuilder = new JTextArea();
        this.m_bodyXPathBuilder.setEditable(true);
        ResourceUtils.resLabel((JLabel)this.bodyLabel, (Component)this.m_bodyXPathBuilder, (String)BPELStringTranslator.getString("USER_NOTIF_BODY_LABEL"));
        this.jScrollPane.getViewport().add((Component)this.m_bodyXPathBuilder, null);
        this.toToolBar = new JToolBar();
        this.toToolBar.setBorderPainted(false);
        this.toToolBar.add(this.m_toExpBuilderBtn);
        this.toToolBar.add(this.toButton);
        this.toHelp = new JLabel();
        this.toHelp.setText(BPELStringTranslator.getString("USER_NOTIF_TO_LABEL_DESC"));
        this.toHelp.setEnabled(false);
        this.tbBody = new JToolBar();
        this.tbBody.setBorderPainted(false);
        this.tbBody.add(this.m_bodyExpBuilderBtn);
        this.bodyHelp = new JLabel();
        this.bodyHelp.setText(BPELStringTranslator.getString("USER_NOTIF_BODY_LABEL_DESC"));
        this.bodyHelp.setEnabled(false);
    }

    private void layoutControls() {
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(427, 305));
        int x = 0;
        int y = 0;
        GraphUtils.addComponent((Container)this, (Component)this.toLabel, (int)x, (int)y++, (int)1, (int)1, (int)18, (int)1, (Insets)new Insets(10, 5, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.toText, (int)x++, (int)y, (int)1, (int)1, (int)18, (int)1, (Insets)new Insets(5, 5, 0, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.toToolBar, (int)x++, (int)y, (int)1, (int)1, (int)18, (int)0, (Insets)new Insets(5, 5, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        x = 0;
        GraphUtils.addComponent((Container)this, (Component)this.toHelp, (int)x, (int)(++y), (int)1, (int)1, (int)18, (int)1, (Insets)new Insets(5, 5, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        x = 0;
        int n = ++y;
        GraphUtils.addComponent((Container)this, (Component)this.subjectLabel, (int)x, (int)n, (int)1, (int)1, (int)18, (int)1, (Insets)new Insets(10, 5, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.subjectText, (int)x++, (int)(++y), (int)1, (int)1, (int)18, (int)1, (Insets)new Insets(5, 5, 0, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_subjectExpBuilderBtn, (int)x++, (int)y, (int)1, (int)1, (int)18, (int)0, (Insets)new Insets(5, 5, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        x = 0;
        JPanel bodyPanel = new JPanel(new GridBagLayout());
        bodyPanel.add((Component)this.jScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        int n2 = ++y;
        GraphUtils.addComponent((Container)this, (Component)this.bodyLabel, (int)x, (int)n2, (int)1, (int)1, (int)18, (int)0, (Insets)new Insets(10, 5, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)bodyPanel, (int)x++, (int)(++y), (int)1, (int)1, (int)18, (int)1, (Insets)new Insets(5, 5, 0, 0), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)this, (Component)this.tbBody, (int)x, (int)y, (int)1, (int)1, (int)18, (int)0, (Insets)new Insets(5, 5, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        x = 0;
        GraphUtils.addComponent((Container)this, (Component)this.bodyHelp, (int)x, (int)(++y), (int)1, (int)1, (int)18, (int)0, (Insets)new Insets(10, 5, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
    }

    private void createExpBuilderBtn() {
        this.m_toExpBuilderBtn = UIHelper.createModelerButton((Icon)ImageCache.getIcon("expressionbuilder"));
        this.m_toExpBuilderBtn.setToolTipText(BPELStringTranslator.getString("XPATH_EXPRESSSION_BUILDER", "XPath Expression Builder"));
        this.m_toExpBuilderBtn.addActionListener(this);
        this.m_subjectExpBuilderBtn = UIHelper.createModelerButton((Icon)ImageCache.getIcon("expressionbuilder"));
        this.m_subjectExpBuilderBtn.setToolTipText(BPELStringTranslator.getString("XPATH_EXPRESSSION_BUILDER", "XPath Expression Builder"));
        this.m_subjectExpBuilderBtn.addActionListener(this);
        this.m_bodyExpBuilderBtn = UIHelper.createModelerButton((Icon)ImageCache.getIcon("expressionbuilder"));
        this.m_bodyExpBuilderBtn.setToolTipText(BPELStringTranslator.getString("XPATH_EXPRESSSION_BUILDER", "XPath Expression Builder"));
        this.m_bodyExpBuilderBtn.addActionListener(this);
    }

    public Node getNode() {
        if (!this.m_bEditing && !this.m_saved) {
            return null;
        }
        return this.m_notificationNode;
    }

    @Override
    protected void createCopyRules() {
        MixedXPathExpressionParser parser = new MixedXPathExpressionParser();
        try {
            Element processElem = this.m_processModel.getDOMElement();
            Document doc = processElem.getOwnerDocument();
            String prefix = NotificationsUtil.getNamespacePrefix(this.m_graphModel.getProcess());
            String part = "UserNotificationPayload";
            String query = '/' + part + '/' + prefix + ':';
            if (this.userAssign == null) {
                this.userAssign = this.createAssignNode("AssignUser");
            }
            this.userAssign.setCopyRules(new ArrayList());
            this.userAssign.addCopyRule(NotificationsUtil.createCopy(parser.convertMixedStringToXPathCompliantForm(this.convertToNotEmptyValue(this.toText.getText())), part, query + "UserId", doc, this.userAssign));
            if (this.commonPayloadAssign == null) {
                this.commonPayloadAssign = this.createAssignNode("AssignCommonPayload");
            }
            this.commonPayloadAssign.setCopyRules(new ArrayList());
            this.createCommonPayloadAssignRules(this.commonPayloadAssign, parser, part, query, prefix, doc);
            if (!this.isEmpty) {
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createSMSPayloadAssignRules(Assign smsPayloadAssign, MixedXPathExpressionParser parser, String part, String query, String prefix, Document doc) {
        String voicePayloadQuery = query + "GenericPayload" + "/" + prefix + ":" + "SMSPayload" + "/" + prefix + ":";
        String voicePayloadContentQuery = voicePayloadQuery + "Content" + "/" + prefix + ":";
        smsPayloadAssign.addCopyRule(NotificationsUtil.createCopy(parser.convertMixedStringToXPathCompliantForm(this.convertToNotEmptyValue("Default")), part, voicePayloadQuery + "From", doc, smsPayloadAssign));
        smsPayloadAssign.addCopyRule(NotificationsUtil.createCopy(parser.convertMixedStringToXPathCompliantForm(this.convertToNotEmptyValue("")), part, voicePayloadQuery + "To", doc, smsPayloadAssign));
        smsPayloadAssign.addCopyRule(NotificationsUtil.createCopy(parser.convertMixedStringToXPathCompliantForm(this.convertToNotEmptyValue("")), part, voicePayloadQuery + "Subject", doc, smsPayloadAssign));
        smsPayloadAssign.addCopyRule(NotificationsUtil.createCopy(parser.convertMixedStringToXPathCompliantForm(this.convertToNotEmptyValue("text/plain")), part, voicePayloadContentQuery + "MimeType", doc, smsPayloadAssign));
        smsPayloadAssign.addCopyRule(NotificationsUtil.createCopy(parser.convertMixedStringToXPathCompliantForm(this.convertToNotEmptyValue("")), part, voicePayloadContentQuery + "ContentBody", doc, smsPayloadAssign));
    }

    private void createVoicePayloadAssignRules(Assign voicePayloadAssign, MixedXPathExpressionParser parser, String part, String query, String prefix, Document doc) {
        String voicePayloadQuery = query + "GenericPayload" + "/" + prefix + ":" + "VoicePayload" + "/" + prefix + ":";
        String voicePayloadContentQuery = voicePayloadQuery + "Content" + "/" + prefix + ":";
        voicePayloadAssign.addCopyRule(NotificationsUtil.createCopy(parser.convertMixedStringToXPathCompliantForm(this.convertToNotEmptyValue("")), part, voicePayloadQuery + "To", doc, voicePayloadAssign));
        voicePayloadAssign.addCopyRule(NotificationsUtil.createCopy(parser.convertMixedStringToXPathCompliantForm(this.convertToNotEmptyValue("text/plain")), part, voicePayloadContentQuery + "MimeType", doc, voicePayloadAssign));
        voicePayloadAssign.addCopyRule(NotificationsUtil.createCopy(parser.convertMixedStringToXPathCompliantForm(this.convertToNotEmptyValue("")), part, voicePayloadContentQuery + "ContentBody", doc, voicePayloadAssign));
    }

    private void createCommonPayloadAssignRules(Assign commonPayloadAssign, MixedXPathExpressionParser parser, String part, String query, String prefix, Document doc) {
        String commonPayloadQuery = query + "GenericPayload" + "/" + prefix + ":" + "CommonPayload" + "/" + prefix + ":";
        String commonPayloadContentQuery = commonPayloadQuery + "Content" + "/" + prefix + ":";
        commonPayloadAssign.addCopyRule(NotificationsUtil.createCopy(parser.convertMixedStringToXPathCompliantForm(this.convertToNotEmptyValue("")), part, commonPayloadQuery + "To", doc, commonPayloadAssign));
        commonPayloadAssign.addCopyRule(NotificationsUtil.createCopy(parser.convertMixedStringToXPathCompliantForm(this.convertToNotEmptyValue(this.subjectText.getText())), part, commonPayloadQuery + "Subject", doc, commonPayloadAssign));
        commonPayloadAssign.addCopyRule(NotificationsUtil.createCopy(parser.convertMixedStringToXPathCompliantForm(this.convertToNotEmptyValue(this.m_bodyXPathBuilder.getText())), part, commonPayloadContentQuery + "ContentBody", doc, commonPayloadAssign));
        commonPayloadAssign.addCopyRule(NotificationsUtil.createCopy(parser.convertMixedStringToXPathCompliantForm(this.convertToNotEmptyValue("text/plain; charset=UTF-8")), part, commonPayloadContentQuery + "MimeType", doc, commonPayloadAssign));
        commonPayloadAssign.addCopyRule(NotificationsUtil.createCopy(parser.convertMixedStringToXPathCompliantForm(this.convertToNotEmptyValue("")), part, commonPayloadQuery + "From", doc, commonPayloadAssign));
    }

    private void createEmailPayloadAssignRules(Assign emailPayloadAssign, MixedXPathExpressionParser parser, String part, String query, String prefix, Document doc) {
        String emailPayloadQuery = query + "GenericPayload" + "/" + prefix + ":" + "EmailPayload" + "/" + prefix + ":";
        String emailPayloadContentQuery = emailPayloadQuery + "Content" + "/" + prefix + ":";
        emailPayloadAssign.addCopyRule(NotificationsUtil.createCopy(parser.convertMixedStringToXPathCompliantForm(this.convertToNotEmptyValue("Default")), part, emailPayloadQuery + "FromAccountName", doc, emailPayloadAssign));
        emailPayloadAssign.addCopyRule(NotificationsUtil.createCopy(parser.convertMixedStringToXPathCompliantForm(this.convertToNotEmptyValue("")), part, emailPayloadQuery + "To", doc, emailPayloadAssign));
        emailPayloadAssign.addCopyRule(NotificationsUtil.createCopy(parser.convertMixedStringToXPathCompliantForm(this.convertToNotEmptyValue("")), part, emailPayloadQuery + "ReplyToAddress", doc, emailPayloadAssign));
        emailPayloadAssign.addCopyRule(NotificationsUtil.createCopy(parser.convertMixedStringToXPathCompliantForm(this.convertToNotEmptyValue("")), part, emailPayloadQuery + "Subject", doc, emailPayloadAssign));
        emailPayloadAssign.addCopyRule(NotificationsUtil.createCopy(parser.convertMixedStringToXPathCompliantForm(this.convertToNotEmptyValue("")), part, emailPayloadQuery + "Bcc", doc, emailPayloadAssign));
        emailPayloadAssign.addCopyRule(NotificationsUtil.createCopy(parser.convertMixedStringToXPathCompliantForm(this.convertToNotEmptyValue("")), part, emailPayloadQuery + "Cc", doc, emailPayloadAssign));
        emailPayloadAssign.addCopyRule(NotificationsUtil.createCopy(parser.convertMixedStringToXPathCompliantForm(this.convertToNotEmptyValue("text/html; charset=UTF-8")), part, emailPayloadContentQuery + "MimeType", doc, emailPayloadAssign));
        emailPayloadAssign.addCopyRule(NotificationsUtil.createCopy(parser.convertMixedStringToXPathCompliantForm(this.convertToNotEmptyValue("")), part, emailPayloadContentQuery + "ContentBody", doc, emailPayloadAssign));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        int lookupType = 0;
        if (source.equals(this.toButton)) {
            LookupDialog dialog = new LookupDialog(lookupType, this, LookupDialog.DEFAULT_LOOKUP);
            boolean success = dialog.showDialog();
            if (success) {
                this.toText.setText(dialog.getSelectedPrinciple());
            }
        } else if (source == this.m_toExpBuilderBtn) {
            this.invokeGraphicalXPathBuilder(this.toText);
        } else if (source == this.m_bodyExpBuilderBtn) {
            this.invokeGraphicalXPathBuilder(this.m_bodyXPathBuilder);
        } else if (source == this.m_subjectExpBuilderBtn) {
            this.invokeGraphicalXPathBuilder(this.subjectText);
        }
    }

    @Override
    public Object getUserObject() {
        return this.m_notificationActivity;
    }

    @Override
    public String getTitle() {
        return BPELStringTranslator.getString("USER_NOTIF_GEN_TITLE");
    }

    @Override
    public JComponent getPagePanel() {
        return this;
    }

    @Override
    public void saveChanges() {
        this.saveChanges(this.isEmpty, this.m_bEditing, this.m_saved, "sendNotificationToUser", this.m_nameField.getText());
        this.m_saved = true;
    }

    @Override
    protected void saveChanges(boolean isEmpty, boolean bEditing, boolean isSaved, String operationName, String name) {
        if (isEmpty && !isSaved) {
            if (this.m_sequenceNode == null) {
                this.createSequenceNode();
            }
            this.m_graphModel.addChildNode(this.m_notificationNode, (Node)this.m_sequenceNode);
        }
        this.createCopyRules();
        this.advPage.saveAdvancedScopeNode();
        if (isEmpty && !isSaved) {
            this.invoke = this.createInvoke();
            this.invoke.setOperation(operationName);
            try {
                this.m_sequence.addActivity((Activity)this.invoke);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            BPELGraphModel model = (BPELGraphModel)this.m_graphPane.getModel();
            model.addChildNode((Node)this.m_sequenceNode, (Node)this.invokeNode);
        }
        if (!bEditing && !isSaved) {
            this.createPartnerLinkAndVariable();
        }
        this.updateNotificationNode(name);
    }

    @Override
    public boolean validateEditorChanges() {
        return true;
    }

    @Override
    public void removeEditorPageChangeListener(EditorPageChangeListener l) {
    }

    @Override
    public void onSelection() {
    }

    @Override
    public void onDeselection() {
    }

    public void setAdvancedPage(UserNotificationAdvEditPage advPage) {
        this.advPage = advPage;
    }
}

