/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.editors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.JTextComponent;
import oracle.tip.tools.ide.common.bpelparser.BPELParser;
import oracle.tip.tools.ide.common.bpelparser.extension.notification.iface.UserNotification;
import oracle.tip.tools.ide.common.bpelparser.extension.workflow.WorkflowDataLoader;
import oracle.tip.tools.ide.common.bpelparser.extension.workflow.notifications.NotificationHeader;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Assign;
import oracle.tip.tools.ide.common.bpelparser.iface.BPELBaseType;
import oracle.tip.tools.ide.common.bpelparser.iface.Copy;
import oracle.tip.tools.ide.common.bpelparser.iface.Invoke;
import oracle.tip.tools.ide.common.bpelparser.iface.ParserContext;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.Scope;
import oracle.tip.tools.ide.common.bpelparser.iface.Sequence;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.expressionbuilder.ExpressionBuilder;
import oracle.tip.tools.ide.common.expressionbuilder.ExpressionBuilderPicker;
import oracle.tip.tools.ide.common.expressionbuilders.FunctionsExpressionBuilderPicker;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.graph.model.Node;
import oracle.tip.tools.ide.common.graph.view.GraphPane;
import oracle.tip.tools.ide.common.ui.BrowsableTableCellEditor;
import oracle.tip.tools.ide.common.ui.BrowsableTableCellEditorCallback;
import oracle.tip.tools.ide.common.ui.ComponentPanel;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.utils.MixedXPathExpressionParser;
import oracle.tip.tools.ide.common.xpath.editor.XPathEditorPane;
import oracle.tip.tools.ide.common.xpath.editor.util.VariableDataCallBack;
import oracle.tip.tools.ide.pm.addin.model.BPELXmlModel;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariableDataCallBackImpl;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariableExpressionBuilderPicker;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariablePickerPanel;
import oracle.tip.tools.ide.pm.bpelgraph.model.ScopeNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.SequenceNode;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.EditorPage;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.EditorPageChangeListener;
import oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.editors.NotificationGenEditPage;
import oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.model.UserNotificationNode;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.notification.util.NotificationsUtil;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class UserNotificationAdvEditPage
extends NotificationGenEditPage
implements EditorPage {
    private JTable headerTable = null;
    private boolean m_saved = false;
    private ScopeNode advancedScopeNode;
    private Scope advancedScope;
    private SequenceNode advSequenceNode;
    private Action mDeleteAction = null;
    private Action mAddAction = null;
    private HeaderTableModel model = new HeaderTableModel();
    private Sequence advSequence;
    protected static final String PREFERENCE_PROPERTIES_RULE_START = "<PreferenceProperties\t  xmlns=\"http://xmlns.oracle.com/ias/pcbpel/NotificationService\">\n";
    protected static final String PREFERENCE_PROPERTIES_RULE = "<Parameter xmlns=\"http://xmlns.oracle.com/ias/pcbpel/NotificationService\">\n<Name xmlns=\"http://xmlns.oracle.com/ias/pcbpel/NotificationService\"/>\n<Value xmlns=\"http://xmlns.oracle.com/ias/pcbpel/NotificationService\"/>\n</Parameter>\n";
    protected static final String PREFERENCE_PROPERTIES_RULE_END = "</PreferenceProperties>";

    public UserNotificationAdvEditPage(GraphPane pane, Node n) {
        super((BPELGraphPane)pane);
        this.m_notificationNode = (UserNotificationNode)n;
    }

    @Override
    public void setUserObject(Object model) {
        this.m_notificationActivity = (UserNotification)model;
        this.initSequence();
        this.initAdvancedScopeNode();
        this.setUserUIData();
        try {
            this.createControls();
            this.layoutControls();
            this.loadUI();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadUI() {
        this.m_notificationNode.setUserObject(this.m_notificationActivity);
    }

    private void createControls() {
        this.mDeleteAction = new DeleteContentAction();
        this.mAddAction = new AddContentAction();
        this.headerTable = new JTable(this.model);
        this.setRenderers();
        this.headerTable.getSelectionModel().addListSelectionListener(new LocalListSelectionListener());
    }

    private JPanel prepareTopPanel() {
        JPanel panel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        panel.setLayout(gbl);
        int x = 0;
        int y = 0;
        JButton deleteButton = new JButton(this.mDeleteAction);
        this.mDeleteAction.setEnabled(false);
        JButton addButton = new JButton(this.mAddAction);
        deleteButton.setOpaque(false);
        addButton.setOpaque(false);
        UIHelper.setupButton((JButton)deleteButton);
        UIHelper.setupButton((JButton)addButton);
        Component strip = Box.createHorizontalGlue();
        gbl.setConstraints(strip, new GridBagConstraints(x, y, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add(strip);
        gbl.setConstraints(addButton, new GridBagConstraints(++x, y, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 5), 0, 0));
        panel.add(addButton);
        gbl.setConstraints(deleteButton, new GridBagConstraints(++x, y, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add(deleteButton);
        return panel;
    }

    private void layoutControls() {
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(427, 305));
        int x = 0;
        int y = 0;
        GraphUtils.addComponent((Container)this, (Component)this.prepareTopPanel(), (int)x, (int)y++, (int)1, (int)1, (int)12, (int)0, (Insets)new Insets(10, 5, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)GraphUtils.getScrollPane((Component)this.headerTable), (int)x, (int)y++, (int)1, (int)1, (int)18, (int)1, (Insets)new Insets(10, 5, 0, 0), (int)0, (int)0, (double)1.0, (double)1.0);
    }

    public Node getNode() {
        if (!this.m_saved) {
            return null;
        }
        return this.m_notificationNode;
    }

    private void createPrefInstanceAssign(Assign prefInstanceCreateAssign, MixedXPathExpressionParser parser, String part, String query, String prefix, Document doc) {
        prefInstanceCreateAssign.addCopyRule(NotificationsUtil.createLiteralCopy(this.createFromLiteral(), part, query + "PreferenceProperties", doc, prefInstanceCreateAssign));
    }

    private void createPrefInstanceAssignCopy(Assign assign, MixedXPathExpressionParser parser, String part, String query, String prefix, Document doc) {
        String prefQuery = query + "PreferenceProperties" + "/" + prefix + ":" + "Parameter";
        for (int count = 0; count < this.model.getFilteredData().size(); ++count) {
            HeaderValues h = this.model.getFilteredData().get(count);
            assign.addCopyRule(NotificationsUtil.createCopy(parser.convertMixedStringToXPathCompliantForm(h.getName()), part, prefQuery + "[" + (count + 1) + "]" + "/" + prefix + ":" + "Name", doc, assign));
            assign.addCopyRule(NotificationsUtil.createCopy(parser.convertMixedStringToXPathCompliantForm(h.getValue().trim()), part, prefQuery + "[" + (count + 1) + "]" + "/" + prefix + ":" + "Value", doc, assign));
        }
    }

    private String createFromLiteral() {
        String s = PREFERENCE_PROPERTIES_RULE_START;
        for (int count = 0; count < this.model.getFilteredData().size(); ++count) {
            s = s + PREFERENCE_PROPERTIES_RULE;
        }
        s = s + PREFERENCE_PROPERTIES_RULE_END;
        return s;
    }

    @Override
    public Object getUserObject() {
        return this.m_notificationActivity;
    }

    @Override
    public String getTitle() {
        return BPELStringTranslator.getString("USER_NOTIF_ADV_TITLE");
    }

    @Override
    public JComponent getPagePanel() {
        return this;
    }

    @Override
    public void saveChanges() {
    }

    public void saveAdvancedScopeNode() {
        this.removeAdvancedScopeNode();
        if (this.model.getFilteredData().size() == 0) {
            return;
        }
        this.createAdvancedScopeNode();
        this.advSequence = this.createAdvancedScopeSequenceNode();
        MixedXPathExpressionParser parser = new MixedXPathExpressionParser();
        Element processElem = this.m_processModel.getDOMElement();
        Document doc = processElem.getOwnerDocument();
        String prefix = NotificationsUtil.getNamespacePrefix(this.m_graphModel.getProcess());
        String part = "UserNotificationPayload";
        String query = '/' + part + '/' + prefix + ':';
        Assign prefInstanceCreateAssign = this.createAssignNode("CreatePrefInstance", this.advSequence, this.advSequenceNode);
        this.createPrefInstanceAssign(prefInstanceCreateAssign, parser, part, query, prefix, doc);
        Assign prefPropAssign = this.createAssignNode("AssignPrefProp", this.advSequence, this.advSequenceNode);
        this.createPrefInstanceAssignCopy(prefPropAssign, parser, part, query, prefix, doc);
        this.m_saved = true;
    }

    private void removeAdvancedScopeNode() {
        if (this.advancedScope == null) {
            return;
        }
        List activityList = this.advancedScope.getActivityList();
        for (Activity ac : activityList) {
            try {
                this.advancedScope.deleteActivity(ac);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            this.m_sequence.deleteActivity((Activity)this.advancedScope);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initAdvancedScopeNode() {
        if (this.m_sequence == null) {
            return;
        }
        List l = this.m_sequence.getActivityList();
        for (Activity activity : l) {
            if (!(activity instanceof Scope)) continue;
            this.advancedScope = (Scope)activity;
            return;
        }
    }

    @Override
    public boolean validateEditorChanges() {
        return true;
    }

    @Override
    public void removeEditorPageChangeListener(EditorPageChangeListener l) {
    }

    @Override
    public void onSelection() {
    }

    @Override
    public void onDeselection() {
    }

    private void createAdvancedScopeNode() {
        Element processElem = this.m_processModel.getDOMElement();
        Document doc = processElem.getOwnerDocument();
        this.advancedScope = (Scope)BPELParser.createImplementation(Scope.class);
        this.advancedScope.setDOMElement(this.advancedScope.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true));
        ParserContext parserContext = ((BPELBaseType)this.m_notificationActivity).getParserContext();
        ((BPELBaseType)this.advancedScope).setParserContext(parserContext);
        String name = BPELModelUtil.generateUniqueName((Process)this.m_processModel, (String)"AdvancedScope", Scope.class);
        this.advancedScope.setName(name);
        int pos = -1;
        for (Activity activity : this.m_sequence.getActivityList()) {
            if (!(activity instanceof Invoke)) continue;
            pos = this.m_sequence.getActivityList().indexOf(activity);
            break;
        }
        try {
            if (pos == -1) {
                this.m_sequence.addActivity((Activity)this.advancedScope);
            } else {
                this.m_sequence.insertActivity(pos, (Activity)this.advancedScope);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.advancedScopeNode = new ScopeNode();
        this.advancedScopeNode.setUserObject(this.advancedScope);
        this.m_graphModel.addChildNode((Node)this.m_sequenceNode, this.advancedScopeNode);
    }

    private Sequence createAdvancedScopeSequenceNode() {
        Element processElem = this.m_processModel.getDOMElement();
        Document doc = processElem.getOwnerDocument();
        Sequence sequence = (Sequence)BPELParser.createImplementation(Sequence.class);
        sequence.setDOMElement(sequence.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true));
        ParserContext parserContext = ((BPELBaseType)this.m_notificationActivity).getParserContext();
        ((BPELBaseType)sequence).setParserContext(parserContext);
        String name = BPELModelUtil.generateUniqueName((Process)this.m_processModel, (String)"Sequence", Sequence.class);
        sequence.setName(name);
        try {
            this.advancedScope.addActivity((Activity)sequence);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.advSequenceNode = new SequenceNode();
        this.advSequenceNode.setUserObject(sequence);
        this.m_graphModel.addChildNode(this.advancedScopeNode, (Node)this.advSequenceNode);
        return sequence;
    }

    private void setRenderers() {
        TableColumn col = this.headerTable.getColumnModel().getColumn(0);
        col.setCellEditor(new DefaultCellEditor(this.getHeaderCellEditor()){

            @Override
            public Component getComponent() {
                return UserNotificationAdvEditPage.this.getHeaderCellEditor();
            }
        });
        col.setCellRenderer(new LocalCellRenderer());
        TableColumn col1 = this.headerTable.getColumnModel().getColumn(1);
        MyBrowsableTableCellEditorCallback btc = new MyBrowsableTableCellEditorCallback();
        BrowsableTableCellEditor editor = new BrowsableTableCellEditor((BrowsableTableCellEditorCallback)btc);
        editor.setClickCountToStart(1);
        col1.setCellEditor((TableCellEditor)editor);
        col1.setWidth(375);
        col1.setPreferredWidth(375);
    }

    private JComboBox getHeaderCellEditor() {
        List<String> list = this.getNotificationHeaders();
        JComboBox<String> c = new JComboBox<String>();
        for (String s : list) {
            c.addItem(s);
        }
        c.setEditable(true);
        return c;
    }

    private void setUserUIData() {
        if (this.advancedScope == null) {
            return;
        }
        Activity a = BPELModelUtil.getActivityForName((Activity)this.advancedScope, (String)"AssignPrefProp");
        if (!(a instanceof Assign)) {
            return;
        }
        List copyRules = ((Assign)a).getCopyRules();
        this.populateModel(copyRules);
    }

    private synchronized List<String> getNotificationHeaders() {
        WorkflowDataLoader loader = new WorkflowDataLoader();
        List headers = loader.getNotificationHeaders();
        ArrayList<String> list = new ArrayList<String>();
        for (NotificationHeader header : headers) {
            list.add(header.getName());
        }
        return list;
    }

    private void populateModel(List copyRules) {
        MixedXPathExpressionParser parser = new MixedXPathExpressionParser();
        if (copyRules != null) {
            int i = 0;
            while (i < copyRules.size()) {
                HeaderValues h = new HeaderValues("", "");
                Copy copy1 = (Copy)copyRules.get(i++);
                Copy copy2 = (Copy)copyRules.get(i++);
                String query1 = copy1.getFrom().getExpression();
                String query2 = copy2.getFrom().getExpression();
                h.setName(parser.convertXPathComplaintStringToMixedForm(query1));
                h.setValue(parser.convertXPathComplaintStringToMixedForm(query2));
                this.model.list.add(h);
            }
        }
    }

    @Override
    protected void createCopyRules() {
    }

    class MyTableCellRenderer
    extends JPanel
    implements TableCellRenderer {
        private ComponentPanel mCP = new ComponentPanel(null, null);

        public MyTableCellRenderer() {
            this.layoutComponent();
        }

        private void layoutComponent() {
            this.setLayout(new BorderLayout());
            this.add((Component)this.mCP);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return this;
        }
    }

    class MyBrowsableTableCellEditorCallback
    implements BrowsableTableCellEditorCallback {
        public boolean shouldSelectCell(EventObject anEvent) {
            return false;
        }

        public Object showChooser(JTable table, int row, int col) {
            String val = (String)UserNotificationAdvEditPage.this.model.getValueAt(row, col);
            if (val != null) {
                val = new MixedXPathExpressionParser().convertMixedStringToXPathCompliantForm(val);
            }
            BPELXmlModel mainModel = UserNotificationAdvEditPage.this.m_graphPane.getBPELXmlModel();
            VariableDataCallBackImpl dataCallBack = new VariableDataCallBackImpl(mainModel, (Activity)UserNotificationAdvEditPage.this.m_notificationActivity);
            VariablePickerPanel p = new VariablePickerPanel(UserNotificationAdvEditPage.this.m_graphPane, dataCallBack, UserNotificationAdvEditPage.this.getNSResolver((Activity)UserNotificationAdvEditPage.this.m_notificationActivity));
            VariableExpressionBuilderPicker picker = new VariableExpressionBuilderPicker(p, (Activity)UserNotificationAdvEditPage.this.m_notificationActivity);
            ExpressionBuilderPicker[] pickers = new ExpressionBuilderPicker[]{picker, new FunctionsExpressionBuilderPicker(UserNotificationAdvEditPage.this.m_nsResolver)};
            XPathEditorPane pane = new XPathEditorPane();
            pane.initializeDocument();
            pane.initializeEditorPane((VariableDataCallBack)dataCallBack, val, UserNotificationAdvEditPage.this.m_nsResolver, false);
            ExpressionBuilder expressionDialog = new ExpressionBuilder(GraphUtils.getFrame((Component)((Object)UserNotificationAdvEditPage.this.m_graphPane)), (JTextComponent)pane, pickers);
            if (expressionDialog.display() == 0) {
                return expressionDialog.getExpressionText();
            }
            return null;
        }
    }

    public class AddContentAction
    extends AbstractAction {
        public AddContentAction() {
            this.putValue("SmallIcon", ImageCache.getIcon("add16"));
        }

        @Override
        public void actionPerformed(ActionEvent pEvent) {
            UserNotificationAdvEditPage.this.model.createNewRow();
        }
    }

    public class DeleteContentAction
    extends AbstractAction {
        public DeleteContentAction() {
            this.putValue("SmallIcon", ImageCache.getIcon("delete16"));
        }

        @Override
        public void actionPerformed(ActionEvent pEvent) {
            int[] rows = UserNotificationAdvEditPage.this.headerTable.getSelectedRows();
            UserNotificationAdvEditPage.this.model.removeData(rows);
        }
    }

    class LocalListSelectionListener
    implements ListSelectionListener {
        LocalListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent pEvent) {
            if (pEvent.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel model = UserNotificationAdvEditPage.this.headerTable.getSelectionModel();
            UserNotificationAdvEditPage.this.mDeleteAction.setEnabled(false);
            int start = model.getMinSelectionIndex();
            int end = model.getMaxSelectionIndex();
            if (start == -1) {
                return;
            }
            if (start <= end) {
                UserNotificationAdvEditPage.this.mDeleteAction.setEnabled(true);
            }
        }
    }

    class LocalCellRenderer
    extends DefaultTableCellRenderer {
        LocalCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable pTable, Object pData, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setHorizontalTextPosition(0);
            this.setToolTipText((String)pData);
            return super.getTableCellRendererComponent(pTable, pData, isSelected, hasFocus, row, column);
        }
    }

    class HeaderTableModel
    extends AbstractTableModel {
        List<HeaderValues> list = new ArrayList<HeaderValues>();
        private MixedXPathExpressionParser parser = new MixedXPathExpressionParser();

        HeaderTableModel() {
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        @Override
        public int getRowCount() {
            return this.list.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            HeaderValues h = this.list.get(rowIndex);
            if (columnIndex == 0) {
                return h.getName();
            }
            if (columnIndex == 1) {
                return h.getValue();
            }
            return null;
        }

        public void createNewRow() {
            HeaderValues h = new HeaderValues("", "");
            this.list.add(h);
            this.fireTableDataChanged();
        }

        @Override
        public void setValueAt(Object val, int rowIndex, int columnIndex) {
            if (rowIndex > this.list.size() - 1) {
                return;
            }
            HeaderValues h = this.list.get(rowIndex);
            if (columnIndex == 0) {
                h.setName(val.toString());
            } else if (columnIndex == 1) {
                h.setValue(this.parser.convertXPathComplaintStringToMixedForm(val.toString()));
            }
            this.fireTableDataChanged();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return "Header";
            }
            return "Name";
        }

        public void removeData(int[] rows) {
            ArrayList<HeaderValues> deletes = new ArrayList<HeaderValues>();
            for (int i = 0; i < rows.length; ++i) {
                HeaderValues obj = this.list.get(rows[i]);
                deletes.add(obj);
            }
            for (HeaderValues obj : deletes) {
                this.list.remove(obj);
            }
            if (deletes.size() > 0) {
                this.fireTableDataChanged();
            }
        }

        public List<HeaderValues> getFilteredData() {
            ArrayList<HeaderValues> l = new ArrayList<HeaderValues>();
            for (int count = 0; count < this.list.size(); ++count) {
                HeaderValues h = this.list.get(count);
                if (h == null || h.getName() == null || h.getValue() == null) continue;
                l.add(h);
            }
            return l;
        }
    }

    class HeaderValues {
        private String name;
        private String value;

        public HeaderValues(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

