/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.editors;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import oracle.ide.util.ResourceUtils;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.SMS;
import oracle.tip.tools.ide.common.bpelparser.iface.Assign;
import oracle.tip.tools.ide.common.bpelparser.iface.Copy;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.graph.model.Node;
import oracle.tip.tools.ide.common.graph.view.GraphPane;
import oracle.tip.tools.ide.common.ui.GlobalImageCache;
import oracle.tip.tools.ide.common.ui.ToolBar;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.utils.MixedXPathExpressionParser;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.EditorPage;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.EditorPageChangeListener;
import oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.editors.NotificationGenEditPage;
import oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.model.SMSNode;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.lookup.LookupDialog;
import oracle.tip.tools.ide.pm.modules.notification.util.NotificationsUtil;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SMSGenEditPage
extends NotificationGenEditPage
implements ActionListener,
EditorPage {
    private JTextField m_nameField = new JTextField();
    private JLabel fromLabel = new JLabel();
    private JTextField fromText = new JTextField();
    private JButton m_fromExpBuilderBtn;
    private JButton toUButton;
    private JLabel toLabel = new JLabel();
    private JTextField toText = new JTextField();
    private JButton m_toExpBuilderBtn;
    private JLabel subjectLabel = new JLabel();
    private JTextField m_subjectXPathBuilder = new JTextField();
    private JButton m_subjectExpBuilderBtn;
    private JLabel bodyLabel = new JLabel();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JLabel introPrompt = new JLabel();
    private JScrollPane m_bodyXPathScrollPane = new JScrollPane();
    private JTextArea m_bodyXPathBuilder;
    private JButton m_bodyExpBuilderBtn;
    private boolean m_bEditing = false;
    private boolean m_saved = false;
    private boolean isEmpty;
    private Assign assign;

    public SMSGenEditPage(GraphPane pane, Node n) {
        super((BPELGraphPane)pane);
        this.m_notificationNode = (SMSNode)n;
    }

    @Override
    public void setUserObject(Object model) {
        this.m_notificationActivity = (SMS)model;
        boolean bl = this.isEmpty = this.getInvoke() == null;
        if (this.m_notificationActivity != null && !this.isEmpty) {
            this.m_nameField.setText(this.m_notificationActivity.getName());
            this.m_bEditing = true;
            this.initSequence();
        } else {
            String name = BPELModelUtil.generateUniqueName((Process)this.m_processModel, (String)"SMS", SMS.class);
            this.m_nameField.setText(name);
            this.createNewNotificationNode();
        }
        this.invoke = this.getInvoke();
        try {
            this.jbInit();
            if (this.m_bEditing) {
                this.loadUI();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadUI() {
        this.m_notificationNode.setUserObject(this.m_notificationActivity);
        this.assign = ((SMS)this.m_notificationActivity).getNotifParamsAssign();
        if (this.assign != null) {
            this.setUIData(this.assign);
        }
        this.m_notificationNode.setName(this.m_nameField.getText());
        this.m_notificationActivity.setName(this.m_nameField.getText());
    }

    private void setUIData(Assign assign) {
        List copyRules = assign.getCopyRules();
        if (copyRules != null) {
            for (int i = 0; i < copyRules.size(); ++i) {
                Copy copy = (Copy)copyRules.get(i);
                String query = copy.getTo().getQuery();
                String value = copy.getFrom().getExpression();
                if (value == null) continue;
                if (value.equalsIgnoreCase("string('')")) {
                    value = "";
                } else {
                    MixedXPathExpressionParser parser = new MixedXPathExpressionParser();
                    value = parser.convertXPathComplaintStringToMixedForm(value);
                }
                if (query.endsWith("To")) {
                    this.toText.setText(value);
                    continue;
                }
                if (query.endsWith("From")) {
                    this.fromText.setText(value);
                    continue;
                }
                if (query.endsWith("Subject")) {
                    this.m_subjectXPathBuilder.setText(value);
                    continue;
                }
                if (!query.endsWith("ContentBody")) continue;
                this.m_bodyXPathBuilder.setText(value);
            }
        }
    }

    private void jbInit() throws Exception {
        this.createExpBuilderBtn();
        Icon flashImage = GlobalImageCache.getIcon((String)"browse16");
        this.setLayout(this.gridBagLayout1);
        this.setSize(new Dimension(427, 305));
        this.introPrompt.setText(BPELStringTranslator.getString("CONFIG_SMS"));
        ResourceUtils.resLabel((JLabel)this.fromLabel, (Component)this.fromText, (String)BPELStringTranslator.getString("FROM_NUMBER_LABEL"));
        this.fromText.setFocusCycleRoot(true);
        this.fromText.setEditable(true);
        ResourceUtils.resLabel((JLabel)this.toLabel, (Component)this.toText, (String)BPELStringTranslator.getString("TEL_NUMBER_LABEL"));
        this.toText.setEditable(true);
        this.toText.setText("");
        ResourceUtils.resLabel((JLabel)this.subjectLabel, (Component)this.m_subjectXPathBuilder, (String)BPELStringTranslator.getString("SUBJECT_LABEL"));
        this.m_subjectXPathBuilder.setEditable(true);
        this.m_bodyXPathBuilder = new JTextArea();
        this.m_bodyXPathBuilder.setEditable(true);
        ResourceUtils.resLabel((JLabel)this.bodyLabel, (Component)this.m_bodyXPathBuilder, (String)BPELStringTranslator.getString("BODY_LABEL"));
        this.m_bodyXPathScrollPane.getViewport().add((Component)this.m_bodyXPathBuilder, null);
        ToolBar tbSubject = new ToolBar();
        tbSubject.add((Component)this.m_subjectExpBuilderBtn);
        ToolBar tbBody = new ToolBar();
        tbBody.add((Component)this.m_bodyExpBuilderBtn);
        this.add((Component)this.bodyLabel, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.m_bodyXPathScrollPane, new GridBagConstraints(1, 7, 1, 1, 0.0, 1.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)tbBody, new GridBagConstraints(2, 7, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 5, 0, 10), 0, 0));
        this.add((Component)this.subjectLabel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.m_subjectXPathBuilder, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)tbSubject, new GridBagConstraints(2, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 10), 0, 0));
        JLabel bodyHelp = new JLabel();
        bodyHelp.setText(BPELStringTranslator.getString("SMS_BODY_EXPLANATION"));
        this.add((Component)bodyHelp, new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 10, 0), 0, 0));
        this.toUButton = UIHelper.createModelerButton((Icon)flashImage);
        this.toUButton.addActionListener(this);
        ToolBar tbTo = new ToolBar();
        tbTo.add((Component)this.toUButton);
        tbTo.add((Component)this.m_toExpBuilderBtn);
        JPanel telPanel = new JPanel(new GridBagLayout());
        telPanel.add((Component)this.toText, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        telPanel.add((Component)tbTo, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.toLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)telPanel, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 10), 0, 0));
        ToolBar tbFrom = new ToolBar();
        tbFrom.add((Component)this.m_fromExpBuilderBtn);
        this.add((Component)this.fromText, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.fromLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)tbFrom, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 5, 0, 10), 0, 0));
    }

    private void createExpBuilderBtn() {
        this.m_fromExpBuilderBtn = UIHelper.createModelerButton((Icon)ImageCache.getIcon("expressionbuilder"));
        this.m_fromExpBuilderBtn.setToolTipText(BPELStringTranslator.getString("XPATH_EXPRESSSION_BUILDER", "XPath Expression Builder"));
        this.m_fromExpBuilderBtn.addActionListener(this);
        this.m_toExpBuilderBtn = UIHelper.createModelerButton((Icon)ImageCache.getIcon("expressionbuilder"));
        this.m_toExpBuilderBtn.setToolTipText(BPELStringTranslator.getString("XPATH_EXPRESSSION_BUILDER", "XPath Expression Builder"));
        this.m_toExpBuilderBtn.addActionListener(this);
        this.m_subjectExpBuilderBtn = UIHelper.createModelerButton((Icon)ImageCache.getIcon("expressionbuilder"));
        this.m_subjectExpBuilderBtn.setToolTipText(BPELStringTranslator.getString("XPATH_EXPRESSSION_BUILDER", "XPath Expression Builder"));
        this.m_subjectExpBuilderBtn.addActionListener(this);
        this.m_bodyExpBuilderBtn = UIHelper.createModelerButton((Icon)ImageCache.getIcon("expressionbuilder"));
        this.m_bodyExpBuilderBtn.setToolTipText(BPELStringTranslator.getString("XPATH_EXPRESSSION_BUILDER", "XPath Expression Builder"));
        this.m_bodyExpBuilderBtn.addActionListener(this);
    }

    public Node getNode() {
        if (!this.m_bEditing && !this.m_saved) {
            return null;
        }
        return this.m_notificationNode;
    }

    @Override
    protected void createCopyRules() {
        MixedXPathExpressionParser parser = new MixedXPathExpressionParser();
        try {
            Element processElem = this.m_processModel.getDOMElement();
            Document doc = processElem.getOwnerDocument();
            String part = "";
            String query = "";
            String prefix = NotificationsUtil.getNamespacePrefix(this.m_graphModel.getProcess());
            part = "SMSPayload";
            query = '/' + part + '/' + prefix + ':';
            if (this.assign == null) {
                this.assign = this.createAssignNode("SMSParamsAssign");
            }
            if (this.m_bEditing) {
                this.assign.setCopyRules(new ArrayList());
            }
            this.assign.addCopyRule(NotificationsUtil.createCopy(parser.convertMixedStringToXPathCompliantForm(this.convertToNotEmptyValue(this.fromText.getText())), part, query + "From", doc, this.assign));
            this.assign.addCopyRule(NotificationsUtil.createCopy(parser.convertMixedStringToXPathCompliantForm(this.convertToNotEmptyValue(this.m_bodyXPathBuilder.getText())), part, query + "Content" + "/" + prefix + ':' + "ContentBody", doc, this.assign));
            this.assign.addCopyRule(NotificationsUtil.createCopy("string('text/plain')", part, query + "Content" + "/" + prefix + ':' + "MimeType", doc, this.assign));
            this.assign.addCopyRule(NotificationsUtil.createCopy(parser.convertMixedStringToXPathCompliantForm(this.convertToNotEmptyValue(this.m_subjectXPathBuilder.getText())), part, query + "Subject", doc, this.assign));
            this.assign.addCopyRule(NotificationsUtil.createCopy(parser.convertMixedStringToXPathCompliantForm(this.convertToNotEmptyValue(this.toText.getText())), part, query + "To", doc, this.assign));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        LookupDialog dialog;
        boolean success;
        Object source = e.getSource();
        if (source == this.toUButton && (success = (dialog = new LookupDialog(0, this, LookupDialog.VOICE_LOOKUP)).showDialog())) {
            this.toText.setText(dialog.getPhoneNumber());
        }
        if (source == this.m_toExpBuilderBtn) {
            this.invokeGraphicalXPathBuilder(this.toText);
        } else if (source == this.m_fromExpBuilderBtn) {
            this.invokeGraphicalXPathBuilder(this.fromText);
        } else if (source == this.m_subjectExpBuilderBtn) {
            this.invokeGraphicalXPathBuilder(this.m_subjectXPathBuilder);
        } else if (source == this.m_bodyExpBuilderBtn) {
            this.invokeGraphicalXPathBuilder(this.m_bodyXPathBuilder);
        }
    }

    @Override
    public Object getUserObject() {
        return this.m_notificationActivity;
    }

    @Override
    public String getTitle() {
        return BPELStringTranslator.getString("SMS");
    }

    @Override
    public JComponent getPagePanel() {
        return this;
    }

    @Override
    public void saveChanges() {
        this.saveChanges(this.isEmpty, this.m_bEditing, this.m_saved, "sendSMSNotification", this.m_nameField.getText());
        this.m_saved = true;
    }

    @Override
    public boolean validateEditorChanges() {
        return true;
    }

    @Override
    public void removeEditorPageChangeListener(EditorPageChangeListener l) {
    }

    @Override
    public void onSelection() {
    }

    @Override
    public void onDeselection() {
    }
}

