/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.ListSelectionModel;
import oracle.tip.tools.ide.common.ui.ButtonMenu;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.ui.models.BaseTableModel;
import oracle.tip.tools.ide.pm.bpelgraph.editors.BaseEditingPage;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.editors.RuleTableModelBase;
import oracle.tip.tools.ide.pm.gui.generalpurpose.TablePanel;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class RuleTablePanelBase
extends TablePanel {
    protected BPELGraphPane m_graphPane;
    protected JButton m_upBtn;
    protected JButton m_downBtn;
    protected JButton m_emptyBtn;

    public RuleTablePanelBase(BaseTableModel tabModel, BPELGraphPane pane) {
        super(tabModel);
        this.m_graphPane = pane;
        this.m_table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Point origin = e.getPoint();
                int row = RuleTablePanelBase.this.m_table.rowAtPoint(origin);
                int column = RuleTablePanelBase.this.m_table.columnAtPoint(origin);
                if (row == -1 || column == -1) {
                    return;
                }
                if (e.getClickCount() == 2) {
                    RuleTablePanelBase.this.doEdit(row);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        this.m_upBtn = UIHelper.createModelerButton((String)BPELStringTranslator.getString("EDIT_UP_TEXT"), (Icon)ImageCache.getIcon("arrow_up_blue16"));
        BPELStringTranslator.setButton(this.m_upBtn, BPELStringTranslator.getString("EDIT_UP_TEXT_RES"));
        this.m_downBtn = UIHelper.createModelerButton((String)BPELStringTranslator.getString("EDIT_DOWN_TEXT"), (Icon)ImageCache.getIcon("arrow_down_blue16"));
        BPELStringTranslator.setButton(this.m_downBtn, BPELStringTranslator.getString("EDIT_DOWN_TEXT_RES"));
        this.m_emptyBtn = UIHelper.createModelerButton((String)BPELStringTranslator.getString("EDIT_REMOVE_ALL_TEXT"), (Icon)ImageCache.getIcon("garbage_empty16"));
        BPELStringTranslator.setButton(this.m_emptyBtn, BPELStringTranslator.getString("EDIT_REMOVE_ALL_TEXT_RES"));
        this.m_emptyBtn.addActionListener(this);
        this.m_toolBar.removeAll();
        ButtonMenu btnMenu = new ButtonMenu("Create", ImageCache.getIcon("create16"));
        Action[] actions = new Action[]{new CopyRuleAction()};
        btnMenu.setActions(actions);
        this.m_toolBar.add((Component)btnMenu);
        this.m_toolBar.add((Component)this.m_editBtn);
        this.m_toolBar.add((Component)this.m_removeBtn);
        this.m_toolBar.add((Component)this.m_upBtn);
        this.m_toolBar.add((Component)this.m_downBtn);
        this.m_upBtn.addActionListener(this);
        this.m_downBtn.addActionListener(this);
        this.m_emptyBtn.addActionListener(this);
    }

    public void performAdd(int pageType) {
    }

    @Override
    protected void doEdit(int row) {
    }

    @Override
    public void performRemove() {
    }

    protected void setModified(boolean b) {
        Container p;
        for (p = this.getParent(); p != null && !(p instanceof BaseEditingPage); p = p.getParent()) {
        }
        if (p instanceof BaseEditingPage) {
            BaseEditingPage page = (BaseEditingPage)p;
            page.setModified(b);
        }
    }

    @Override
    public void updateButtons() {
        super.updateButtons();
        ListSelectionModel model = this.m_table.getSelectionModel();
        int sel = model.getMinSelectionIndex();
        if (sel == -1) {
            this.m_upBtn.setEnabled(false);
            this.m_downBtn.setEnabled(false);
        } else if (sel == 0) {
            this.m_upBtn.setEnabled(false);
            this.m_downBtn.setEnabled(this.m_table.getModel().getRowCount() > 1);
        } else {
            this.m_upBtn.setEnabled(true);
            if (sel + 1 == this.m_table.getModel().getRowCount()) {
                this.m_downBtn.setEnabled(false);
            } else {
                this.m_downBtn.setEnabled(true);
            }
        }
        this.m_emptyBtn.setEnabled(!model.isSelectionEmpty());
    }

    public void performMoveUp() {
        RuleTableModelBase model = (RuleTableModelBase)((Object)this.m_table.getModel());
        ListSelectionModel smodel = this.m_table.getSelectionModel();
        int sel = smodel.getMinSelectionIndex();
        model.moveUp(sel);
        if (sel != -1) {
            smodel.setSelectionInterval(sel - 1, sel - 1);
            this.m_table.scrollRectToVisible(this.m_table.getCellRect(sel - 1, 0, true));
        }
    }

    public void performMoveDown() {
        RuleTableModelBase model = (RuleTableModelBase)((Object)this.m_table.getModel());
        ListSelectionModel smodel = this.m_table.getSelectionModel();
        int sel = smodel.getMinSelectionIndex();
        model.moveDown(sel);
        if (sel != -1) {
            smodel.setSelectionInterval(sel + 1, sel + 1);
            this.m_table.scrollRectToVisible(this.m_table.getCellRect(sel + 1, 0, true));
        }
    }

    public void performEmpty() {
        RuleTableModelBase model = (RuleTableModelBase)((Object)this.m_table.getModel());
        model.removeAllData();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_upBtn) {
            this.performMoveUp();
        } else if (src == this.m_downBtn) {
            this.performMoveDown();
        } else if (src == this.m_emptyBtn) {
            this.performEmpty();
        } else {
            super.actionPerformed(e);
        }
    }

    class CopyRuleAction
    extends AbstractAction {
        public CopyRuleAction() {
            super("Copy Rule...", ImageCache.getIcon("copyrule16"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }
}

