/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.editors;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.bpel.services.rules.rpi.IRuleSet;
import oracle.bpel.services.rules.rpi.model.TFactType;
import oracle.bpel.services.rules.rpi.model.TXmlFactType;
import oracle.ide.util.ResourceUtils;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.Scope;
import oracle.tip.tools.ide.common.bpelparser.iface.Variable;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ide.bpel.BPELProject;
import oracle.tip.tools.ide.common.ui.GlobalImageCache;
import oracle.tip.tools.ide.common.ui.ToolBar;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.ui.models.BaseTableModel;
import oracle.tip.tools.ide.common.utils.MessagePart;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariableAutoCreationDialog;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.editors.RuleTableModel;
import oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.editors.RuleTablePanelBase;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.rules.FactMap;
import oracle.tip.tools.ide.pm.modules.rules.RuleActivityDialog;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.editors.VariableXPathBuilderWF;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;
import oracle.xml.parser.schema.XSDNode;

public class RuleTablePanel
extends RuleTablePanelBase
implements DocumentListener {
    protected JLabel m_label = new JLabel();
    Activity m_activity = null;
    BPELProject m_prj;
    BPELGraphModel m_model;
    Process m_process;
    protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    static Icon ERROR_ICON = GlobalImageCache.getIcon((String)"error.png");
    List m_xmlFactList;
    List m_xmlMappedFactList = new ArrayList();
    IRuleSet m_ruleset;
    JDialog m_dlg;
    JComboBox m_factCombo;
    JTextField m_varField;
    JButton m_varCreateBtn;
    JButton m_varBrowseBtn;
    private JButton m_okBtn;
    private JButton m_cancelBtn;
    private JButton m_helpBtn;
    ArrayList m_copyList = new ArrayList();
    Variable m_tmpVar = null;
    static int s_varIndex = 1;

    public RuleTablePanel(BaseTableModel tabModel, BPELGraphPane pane, String title) {
        super(tabModel, pane);
        this.m_label.setText(title);
        this.m_toolBar.removeAll();
        MyRenderer r = new MyRenderer();
        TableColumnModel colModel = this.m_table.getColumnModel();
        for (int i = 0; i < colModel.getColumnCount(); ++i) {
            TableColumn col = colModel.getColumn(i);
            col.setCellRenderer(r);
            col.setWidth(200);
            col.setPreferredWidth(200);
        }
        Dimension d = this.m_label.getPreferredSize();
        d.width += 30;
        this.m_label.setPreferredSize(d);
        this.m_toolBar.add((Component)this.m_label);
        this.m_toolBar.add((Component)this.m_createBtn);
        this.m_toolBar.add((Component)this.m_removeBtn);
        this.m_prj = this.m_graphPane.getBPELProject();
        this.m_model = (BPELGraphModel)this.m_graphPane.getModel();
        this.m_process = this.m_model.getProcess();
    }

    public void setTitle(String title) {
        this.m_label.setText(title);
    }

    public void setXMLFactList(List xmlFactList) {
        this.m_xmlFactList = xmlFactList;
    }

    public void setRuleSet(IRuleSet ruleset) {
        this.m_ruleset = ruleset;
    }

    public void setActivity(Activity activity) {
        this.m_activity = activity;
    }

    @Override
    public void performAdd() {
        this.createVarDialog();
        this.m_dlg.setVisible(true);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        String varName = this.m_varField.getText();
        this.m_okBtn.setEnabled(varName != null && !varName.equals(""));
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.insertUpdate(e);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.insertUpdate(e);
    }

    private void createVarDialog() {
        this.m_varCreateBtn = UIHelper.createModelerButton((Icon)ImageCache.getIcon("create16"));
        this.m_varCreateBtn.setToolTipText(BPELStringTranslator.getString("EDITOR_RCV_AUTO_CRE_VAR"));
        this.m_varCreateBtn.addActionListener(this);
        this.m_varBrowseBtn = UIHelper.createBrowseButton((String)BPELStringTranslator.getString("GENERAL_BROWSE_VARS"));
        this.m_varBrowseBtn.addActionListener(this);
        this.m_dlg = new JDialog((Frame)GraphUtils.getFrame((Component)this), true);
        this.m_dlg.setTitle("Create Fact Map");
        this.m_dlg.setSize(400, 200);
        this.m_dlg.setLocationRelativeTo(this);
        Container container = this.m_dlg.getContentPane();
        container.setLayout(new GridBagLayout());
        JLabel factLbl = new JLabel("Rule Fact");
        JLabel varLbl = new JLabel("Variable");
        String[] factArray = new String[this.m_xmlFactList.size()];
        for (int i = 0; i < factArray.length; ++i) {
            TXmlFactType xmlFact = (TXmlFactType)this.m_xmlFactList.get(i);
            factArray[i] = xmlFact.getName();
        }
        this.m_factCombo = new JComboBox<String>(factArray);
        this.m_varField = new JTextField();
        this.m_varField.setEditable(false);
        this.m_varField.getDocument().addDocumentListener(this);
        JPanel btnPanel = this.createButtonPanel();
        ToolBar varTB = new ToolBar();
        varTB.add((Component)this.m_varCreateBtn);
        varTB.add((Component)this.m_varBrowseBtn);
        GraphUtils.addComponent((Container)container, (Component)factLbl, (int)0, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)container, (Component)this.m_factCombo, (int)1, (int)0, (int)2, (int)1, (int)17, (int)2, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)container, (Component)varLbl, (int)0, (int)1, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)container, (Component)this.m_varField, (int)1, (int)1, (int)2, (int)1, (int)17, (int)2, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)container, (Component)varTB, (int)3, (int)1, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)container, (Component)btnPanel, (int)2, (int)2, (int)2, (int)1, (int)13, (int)0, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
    }

    private JPanel createButtonPanel() {
        this.m_okBtn = new JButton(BPELStringTranslator.getString("OK_BUTTON_TEXT"));
        ResourceUtils.resButton((AbstractButton)this.m_okBtn, (String)BPELStringTranslator.getString("OK_BUTTON_TEXT_RES"));
        this.m_okBtn.addActionListener(this);
        this.m_cancelBtn = new JButton(BPELStringTranslator.getString("CANCEL_BUTTON_TEXT"));
        ResourceUtils.resButton((AbstractButton)this.m_cancelBtn, (String)BPELStringTranslator.getString("CANCEL_BUTTON_TEXT_RES"));
        this.m_cancelBtn.addActionListener(this);
        this.m_helpBtn = new JButton(BPELStringTranslator.getString("HELP_BUTTON_TEXT"));
        ResourceUtils.resButton((AbstractButton)this.m_helpBtn, (String)BPELStringTranslator.getString("HELP_BUTTON_TEXT_RES"));
        this.m_helpBtn.addActionListener(this);
        JPanel btnPnl = new JPanel(new GridLayout(1, 2, 5, 0));
        btnPnl.add(this.m_okBtn);
        btnPnl.add(this.m_cancelBtn);
        this.m_okBtn.setEnabled(false);
        return btnPnl;
    }

    private Variable createVariable(String name, XSDNode node, String schemaURL) {
        String varName = BPELModelUtil.generateUniqueScopeVariableName((Scope)this.m_process, (String)name);
        Variable var = null;
        try {
            var = RuleActivityDialog.createVariable(this.m_prj, this.m_process, (Scope)this.m_process, varName, node, schemaURL);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return var;
    }

    public void addMap(FactMap factMap) {
        RuleTableModel model = (RuleTableModel)((Object)this.m_table.getModel());
        model.insertRow(factMap);
        model.refresh();
        this.m_xmlFactList.remove(factMap.getFact());
        this.m_xmlMappedFactList.add(factMap.getFact());
    }

    private TXmlFactType findFact(String factName) {
        if (factName == null || factName.equals("")) {
            return null;
        }
        for (int i = 0; i < this.m_xmlFactList.size(); ++i) {
            TXmlFactType fact = (TXmlFactType)this.m_xmlFactList.get(i);
            if (!fact.getName().equals(factName)) continue;
            return fact;
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.m_okBtn) {
            String exp = this.m_varField.getText();
            if (this.m_tmpVar != null) {
                exp = "bpws:getVariableData('" + this.m_tmpVar.getName() + "')";
            }
            String factName = (String)this.m_factCombo.getSelectedItem();
            RuleTableModel model = (RuleTableModel)((Object)this.m_table.getModel());
            TXmlFactType xmlFact = this.findFact(factName);
            this.m_xmlFactList.remove(xmlFact);
            this.m_xmlMappedFactList.add(xmlFact);
            FactMap factMap = new FactMap(exp, xmlFact, this.m_tmpVar);
            model.insertRow(factMap);
            model.refresh();
            this.m_dlg.dispose();
            this.m_tmpVar = null;
        } else if (event.getSource() == this.m_cancelBtn) {
            if (this.m_tmpVar != null) {
                this.m_process.deleteVariable(this.m_tmpVar);
            }
            this.m_tmpVar = null;
            this.m_dlg.dispose();
        } else if (event.getSource() == this.m_varCreateBtn) {
            int factIndex = this.m_factCombo.getSelectedIndex();
            if (factIndex < 0) {
                return;
            }
            TXmlFactType xmlFact = (TXmlFactType)this.m_xmlFactList.get(factIndex);
            String factName = xmlFact.getName();
            String varSuffix = factName.substring(factName.lastIndexOf(".") + 1);
            String tmpVarName = BPELModelUtil.generateUniqueScopeVariableName((Scope)this.m_process, (String)("ruleVar" + varSuffix));
            VariableAutoCreationDialog varDlg = new VariableAutoCreationDialog(GraphUtils.getFrame((Component)this), this.m_graphPane, this.m_activity, tmpVarName, xmlFact.getName(), false);
            if (varDlg.display() != 0) {
                return;
            }
            String varName = varDlg.getVariableName();
            if (varName == null || varName.equals("")) {
                return;
            }
            try {
                if (this.m_tmpVar != null) {
                    this.m_process.deleteVariable(this.m_tmpVar);
                }
                this.m_tmpVar = null;
                XSDNode xsdNode = this.m_ruleset.getDataModel().getXSD((TFactType)xmlFact);
                this.m_tmpVar = this.createVariable(varName, xsdNode, xmlFact.getSchemaLocation());
                this.m_varField.setText(this.m_tmpVar.getName());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else if (event.getSource() == this.m_varBrowseBtn) {
            VariableXPathBuilderWF dialog = new VariableXPathBuilderWF(GraphUtils.getFrame((Component)this), this.m_graphPane);
            try {
                String val = "";
                if (dialog.display(this.m_activity) == 0) {
                    if (this.m_tmpVar != null) {
                        this.m_process.deleteVariable(this.m_tmpVar);
                    }
                    this.m_tmpVar = null;
                    Variable var = dialog.getVariable();
                    MessagePart part = dialog.getPart();
                    String xPath = dialog.getXPath();
                    if (xPath != null && xPath.equals("")) {
                        xPath = null;
                    }
                    if (part != null && xPath != null) {
                        val = "bpws:getVariableData('" + var.getName() + "', '" + part.getName() + "', '" + xPath + "')";
                    } else if (part != null && xPath == null) {
                        val = "bpws:getVariableData('" + var.getName() + "', '" + part.getName() + "')";
                    } else if (part == null && xPath == null) {
                        val = "bpws:getVariableData('" + var.getName() + "')";
                    } else if (part == null && xPath != null) {
                        val = "bpws:getVariableData('" + var.getName() + "', '" + xPath + "')";
                    }
                    if (val != null && val.length() != 0) {
                        this.m_varField.setText(val);
                    }
                    this.m_varField.setEnabled(false);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            super.actionPerformed(event);
        }
    }

    @Override
    public void performRemove() {
        TableModel model = this.m_table.getModel();
        if (model instanceof BaseTableModel) {
            BaseTableModel tabModel = (BaseTableModel)model;
            int[] rows = this.m_table.getSelectedRows();
            if (rows != null && rows.length > 0) {
                Vector data = tabModel.getData();
                for (int i = rows.length - 1; i >= 0; --i) {
                    FactMap factMap = (FactMap)data.get(rows[i]);
                    TXmlFactType fact = factMap.getFact();
                    this.m_xmlFactList.add(fact);
                    Variable var = factMap.getVar();
                    if (var != null) {
                        this.m_process.deleteVariable(var);
                    }
                    tabModel.removeRows(rows);
                }
            }
        }
    }

    class FactMapCellPanel
    extends JPanel {
        protected FactMap m_factMap;
        protected boolean m_bFrom;
        protected boolean m_bSelected;
        protected boolean m_bHasFocus;
        protected JTable m_table;

        public FactMapCellPanel(JTable table, FactMap factMap, boolean bFrom, boolean selected, boolean focus) {
            this.m_table = table;
            this.m_bHasFocus = focus;
            this.m_bSelected = selected;
            this.m_bFrom = bFrom;
            this.m_factMap = factMap;
            this.setBackground(Color.white);
            this.createControls();
        }

        protected void createControls() {
            String s;
            if (this.m_bSelected) {
                this.setBackground(this.m_table.getSelectionBackground());
            } else {
                this.setBackground(this.m_table.getBackground());
            }
            if (this.m_bHasFocus) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(noFocusBorder);
            }
            Color txtClr = Color.black;
            if (this.m_bSelected) {
                txtClr = Color.white;
            }
            String type = "No Type Specified!";
            JLabel detailLabel = new JLabel();
            detailLabel.setOpaque(false);
            Icon icon = ERROR_ICON;
            if (this.m_bFrom) {
                s = this.m_factMap.getFactName();
                detailLabel = new JLabel(s, 0);
                detailLabel.setForeground(txtClr);
                this.setToolTipText("<html><body bgcolor=white><table bgcolor=white border=0 ><tr><td align=center><font color=blue><b>Ruleset Fact</b></font></td></tr><tr><td align=center>" + s + "</td></tr></table></body></html>");
            } else {
                s = this.m_factMap.getExp();
                detailLabel = new JLabel(s, 0);
                detailLabel.setForeground(txtClr);
                this.setToolTipText("<html><body bgcolor=white><table bgcolor=white border=0 ><tr><td align=center><font color=blue><b>BPEL Variable</b></font></td></tr><tr><td align=center>" + s + "</td></tr></table></body></html>");
            }
            this.setLayout(new GridBagLayout());
            int row = 0;
            GraphUtils.addComponent((Container)this, (Component)detailLabel, (int)0, (int)row++, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(2, 2, 2, 2), (int)0, (int)0, (double)1.0, (double)1.0);
        }
    }

    class MyRenderer
    extends DefaultTableCellRenderer {
        MyRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            double prefheight;
            FactMapCellPanel p = new FactMapCellPanel(table, (FactMap)value, column == 0, isSelected, hasFocus);
            int height = table.getRowHeight(row);
            if (height < (int)(prefheight = p.getPreferredSize().getHeight())) {
                table.setRowHeight(row, (int)prefheight);
            }
            return p;
        }
    }
}

