/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.editors;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.ResourceUtils;
import oracle.tip.tools.ide.common.resource.MessageBundleUtil;
import oracle.tip.tools.ide.common.ui.DialogCancelListener;
import oracle.tip.tools.ide.common.ui.GlobalImageCache;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.ui.treeexplorer.DefaultTreeExplorerTreeNode;
import oracle.tip.tools.ide.common.ui.treeexplorer.NodeText;
import oracle.tip.tools.ide.common.ui.treeexplorer.TextInfo;
import oracle.tip.tools.ide.common.ui.treeexplorer.TreeExplorer;
import oracle.tip.tools.ide.common.ui.treeexplorer.TreeExplorerDataSource;

public class RuleBrowser
extends JDialog
implements ActionListener,
PropertyChangeListener,
DialogCancelListener {
    protected JButton m_okBtn;
    protected JButton m_cancelBtn;
    protected JButton m_helpBtn;
    protected TreeExplorer m_explorer;
    protected int m_retVal = 2;

    public RuleBrowser(JFrame f) {
        super(f, MessageBundleUtil.getCommonString((String)"RULE_BROWSER", (String)"Rule Browser"), true);
        this.getGlassPane().addMouseListener(new MouseAdapter(){});
        this.getGlassPane().addMouseMotionListener(new MouseMotionAdapter(){});
        this.getGlassPane().addKeyListener(new KeyAdapter(){});
        this.createControls();
        this.layoutControls();
        this.updateButtons();
        this.attachHelpListener();
        UIHelper.attachDialogCancelListener((JDialog)this, (DialogCancelListener)this);
    }

    public void enableUserInput(final boolean bEnable) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                Component glass = RuleBrowser.this.getGlassPane();
                glass.setVisible(!bEnable);
                if (bEnable) {
                    glass.setCursor(Cursor.getDefaultCursor());
                } else {
                    glass.setCursor(Cursor.getPredefinedCursor(3));
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    public int getReturnValue() {
        return this.m_retVal;
    }

    public TreeExplorer getExplorer() {
        return this.m_explorer;
    }

    public URL getUrl() {
        URL url = null;
        if (this.m_explorer != null) {
            DefaultTreeExplorerTreeNode defaultTreeExplorerTreeNode = this.m_explorer.getSelectedNode();
        }
        return url;
    }

    public int display(final TreeExplorerDataSource ds) {
        if (ds != null) {
            this.enableUserInput(false);
            this.m_explorer.showWaitPanel();
            Runnable r = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        TextInfo info1 = new TextInfo(Color.black, TextInfo.PLAIN_FONT, MessageBundleUtil.getCommonString((String)"WSIL_EXPLORER", (String)"WSIL Explorer"));
                        TextInfo info2 = new TextInfo(Color.black, TextInfo.PLAIN_FONT, MessageBundleUtil.getCommonString((String)"WSIL_EXPLORER", (String)"WSIL Explorer"));
                        TextInfo[] expanded = new TextInfo[]{info1};
                        TextInfo[] compact = new TextInfo[]{info2};
                        NodeText nodeText = new NodeText(expanded, compact);
                        Icon[] icons = new Icon[]{GlobalImageCache.getIcon((String)"browse16")};
                        RuleBrowser.this.m_explorer.setDataSource(ds);
                        RuleBrowser.this.m_explorer.load();
                    }
                    finally {
                        RuleBrowser.this.enableUserInput(true);
                        RuleBrowser.this.m_explorer.showExplorerPanel();
                    }
                }
            };
            new Thread(r).start();
        }
        this.show();
        return this.m_retVal;
    }

    protected void createControls() {
        this.m_okBtn = new JButton();
        ResourceUtils.resButton((AbstractButton)this.m_okBtn, (String)MessageBundleUtil.getCommonString((String)"M_OK", (String)"&OK"));
        this.m_okBtn.addActionListener(this);
        this.m_cancelBtn = new JButton();
        ResourceUtils.resButton((AbstractButton)this.m_cancelBtn, (String)MessageBundleUtil.getCommonString((String)"M_CANCEL", (String)"&Cancel"));
        this.m_cancelBtn.addActionListener(this);
        this.m_helpBtn = new JButton();
        ResourceUtils.resButton((AbstractButton)this.m_helpBtn, (String)MessageBundleUtil.getCommonString((String)"M_HELP", (String)"&Help"));
        this.m_helpBtn.addActionListener(this);
        this.m_explorer = new TreeExplorer();
        this.m_explorer.setDescriptionPanelVisible(false);
        this.m_explorer.setBorder(null);
        this.m_explorer.addPropertyChangeListener((PropertyChangeListener)this);
    }

    protected void layoutControls() {
        JPanel btnPnl = new JPanel(new GridLayout(1, 2, 5, 0));
        btnPnl.add(this.m_okBtn);
        btnPnl.add(this.m_cancelBtn);
        Container c = this.getContentPane();
        c.setLayout(new GridBagLayout());
        UIHelper.addComponent((Container)c, (Component)this.m_explorer, (int)0, (int)0, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        UIHelper.addComponent((Container)c, (Component)this.m_helpBtn, (int)0, (int)1, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)c, (Component)btnPnl, (int)1, (int)1, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(0, 5, 5, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        this.setSize(480, 480);
        this.setLocationRelativeTo(this.getParent());
    }

    protected void updateButtons() {
        DefaultTreeExplorerTreeNode node = this.m_explorer.getSelectedNode();
        this.m_okBtn.setEnabled(this.m_explorer.isNodeSelected() && !node.hasChildren());
    }

    public void handleOK() {
        this.m_retVal = 0;
        this.dispose();
    }

    public void handleCancel() {
        this.m_retVal = 2;
        this.dispose();
    }

    protected void helpInvoked() {
        HelpSystem help = HelpSystem.getHelpSystem();
        help.registerClientWindow((Window)this);
        help.goTo("bpmjdev_wsdl_cho");
        help.unregisterClientWindow((Window)this);
    }

    protected void attachHelpListener() {
        AbstractAction f1Action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent pEvent) {
                RuleBrowser.this.helpInvoked();
            }
        };
        JRootPane rootPane = this.getRootPane();
        KeyStroke f1 = KeyStroke.getKeyStroke(112, 0, false);
        rootPane.getInputMap(2).put(f1, "F1_KEY");
        rootPane.getActionMap().put("F1_KEY", f1Action);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_okBtn) {
            this.handleOK();
        } else if (src == this.m_cancelBtn) {
            this.handleCancel();
        } else if (src == this.m_helpBtn) {
            this.helpInvoked();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == "TYPE_SELECTION_CHANGED") {
            this.updateButtons();
        }
    }

    public void cancelOccurred(JDialog dlg) {
        this.handleCancel();
    }
}

