/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.ide.util.ModelUtil;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.ReceiveSignal;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.SignalKindEnum;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.SignalKindEnumException;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.pm.bpelgraph.editors.BaseEditingPage;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;

public class ReceiveSignalEditPage
extends BaseEditingPage {
    protected JTextField m_nameField;
    protected JTextField m_labelField;
    protected JComboBox m_cbFrom;
    protected ReceiveSignal m_activity;

    public ReceiveSignalEditPage(BPELGraphPane graphPane) {
        super(graphPane);
        this.createControls();
        this.layoutControls();
    }

    @Override
    public void loadData() {
        this.setModified(true);
    }

    protected void createControls() {
        this.m_nameField = new JTextField();
        this.m_labelField = new JTextField();
        this.m_cbFrom = new JComboBox();
        this.m_cbFrom.addItem("master");
        this.m_cbFrom.addItem("details");
    }

    protected void layoutControls() {
        this.setLayout(new GridBagLayout());
        int row = 0;
        JLabel lblName = new JLabel();
        BPELStringTranslator.setLabel(lblName, this.m_nameField, BPELStringTranslator.getString("GENERAL_EDITOR_NAME"));
        GraphUtils.addComponent((Container)this, (Component)lblName, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(10, 10, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_nameField, (int)1, (int)row++, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(10, 0, 5, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        JLabel lblTS = new JLabel();
        BPELStringTranslator.setLabel(lblTS, this.m_labelField, BPELStringTranslator.getString("LABEL_LABEL"));
        GraphUtils.addComponent((Container)this, (Component)lblTS, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 10, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_labelField, (int)1, (int)row++, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(5, 0, 5, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        JLabel lblSJF = new JLabel();
        BPELStringTranslator.setLabel(lblSJF, this.m_cbFrom, BPELStringTranslator.getString("FROM_LABEL"));
        GraphUtils.addComponent((Container)this, (Component)lblSJF, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 10, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_cbFrom, (int)1, (int)row++, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(5, 0, 5, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)new JPanel(), (int)0, (int)row++, (int)2, (int)1, (int)18, (int)1, (Insets)new Insets(5, 0, 5, 5), (int)0, (int)0, (double)1.0, (double)1.0);
    }

    @Override
    public void setUserObject(Object model) {
        super.setUserObject(model);
        this.m_activity = (ReceiveSignal)model;
        this.loadControls();
    }

    protected void loadControls() {
        SignalKindEnum from;
        if (this.m_activity == null) {
            return;
        }
        if (this.m_activity.getName() != null) {
            this.m_nameField.setText(this.m_activity.getName());
        }
        if (this.m_activity.getLabel() != null) {
            this.m_labelField.setText(this.m_activity.getLabel());
        }
        if ((from = this.m_activity.getFrom()) != null) {
            String fromStr = from.getKind();
            if (fromStr != null && fromStr.equals("master")) {
                this.m_cbFrom.setSelectedIndex(0);
            } else {
                this.m_cbFrom.setSelectedIndex(1);
            }
        }
    }

    @Override
    public boolean validateEditorChanges() {
        if (!ModelUtil.hasLength((String)this.m_nameField.getText())) {
            GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)this), (String)BPELStringTranslator.getString("GENERAL_EDITOR_NAME_ERROR"), (String)BPELStringTranslator.getString("GENERAL_EDITOR_ERROR"), (int)2);
            return false;
        }
        return true;
    }

    @Override
    public void saveChanges() {
        if (this.m_activity == null) {
            return;
        }
        this.m_activity.setName(this.m_nameField.getText());
        this.m_activity.setLabel(this.m_labelField.getText());
        String fromStr = (String)this.m_cbFrom.getSelectedItem();
        try {
            this.m_activity.setFrom(new SignalKindEnum(fromStr));
        }
        catch (SignalKindEnumException e) {
            e.printStackTrace();
        }
    }
}

