/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JToolBar;
import javax.swing.text.JTextComponent;
import javax.xml.namespace.QName;
import oracle.ide.net.URLFactory;
import oracle.tip.tools.ide.common.bpelparser.BPELParser;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.Email;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.IM;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.SMS;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.Voice;
import oracle.tip.tools.ide.common.bpelparser.extension.notification.iface.UserNotification;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Assign;
import oracle.tip.tools.ide.common.bpelparser.iface.BPELBaseType;
import oracle.tip.tools.ide.common.bpelparser.iface.Invoke;
import oracle.tip.tools.ide.common.bpelparser.iface.ParserContext;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLinks;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.Scope;
import oracle.tip.tools.ide.common.bpelparser.iface.Sequence;
import oracle.tip.tools.ide.common.bpelparser.iface.Variable;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.bpelparser.validation.ValidationContext;
import oracle.tip.tools.ide.common.expressionbuilder.ExpressionBuilder;
import oracle.tip.tools.ide.common.expressionbuilder.ExpressionBuilderPicker;
import oracle.tip.tools.ide.common.expressionbuilders.FunctionsExpressionBuilderPicker;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.graph.model.Node;
import oracle.tip.tools.ide.common.graph.model.PortNode;
import oracle.tip.tools.ide.common.ide.bpel.BPELProject;
import oracle.tip.tools.ide.common.utils.TextManipulator;
import oracle.tip.tools.ide.common.xpath.editor.XPathEditorPane;
import oracle.tip.tools.ide.common.xpath.editor.util.VariableDataCallBack;
import oracle.tip.tools.ide.pm.addin.model.BPELXmlModel;
import oracle.tip.tools.ide.pm.bpelgraph.editors.BaseEditingPage;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariableDataCallBackImpl;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariableExpressionBuilderPicker;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariablePickerPanel;
import oracle.tip.tools.ide.pm.bpelgraph.model.AssignNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.model.InvokeNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.PartnerLinkNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.ScopeNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.SequenceNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.SwimLaneNode;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.SwimLaneView;
import oracle.tip.tools.ide.pm.modules.notification.NotificationWizardContext;
import oracle.tip.tools.ide.pm.modules.notification.util.NotificationsUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class NotificationGenEditPage
extends BaseEditingPage {
    BPELProject m_prj = this.getBPELProject();
    Scope m_notificationActivity;
    protected ScopeNode m_notificationNode;
    protected Sequence m_sequence;
    protected SequenceNode m_sequenceNode;
    protected Invoke invoke;
    protected InvokeNode invokeNode;
    protected static final String mFlashIconLocation = "images/flashlight.png";
    public static final String TEXT_HTML_MIMETYPE = "text/html";
    public static final String TEXT_PLAIN_MIMETYPE = "text/plain";
    public static final String TEXT_VOICEXML_MIMETYPE = "text/vxml";

    public NotificationGenEditPage(BPELGraphPane graphPane) {
        super(graphPane);
    }

    protected final void addLookupButtons(JButton userButton, JButton expBuilderButton, int gridx, int gridy, int top) {
        if (userButton != null) {
            JToolBar bar = new JToolBar();
            bar.setBorderPainted(false);
            if (userButton != null) {
                bar.add(userButton);
            }
            bar.add(expBuilderButton);
            GraphUtils.addComponent((Container)this, (Component)bar, (int)gridx, (int)gridy, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(top, 5, 0, 10), (int)0, (int)0, (double)0.0, (double)0.0);
        }
    }

    protected final void createPartnerLinkAndVariable() {
        String prefix;
        Element processElem = this.m_processModel.getDOMElement();
        Document doc = processElem.getOwnerDocument();
        BPELGraphModel model = (BPELGraphModel)this.m_graphPane.getModel();
        Process process = model.getProcess();
        PortNode partnerLinkPort = null;
        PartnerLinks plinks = process.getPartnerLinks();
        Iterator iter = null;
        if (plinks != null) {
            iter = plinks.getPartnerLinks().iterator();
        }
        boolean bNSExists = false;
        while (iter != null && iter.hasNext() && !bNSExists) {
            PartnerLink plink = (PartnerLink)iter.next();
            if (!plink.getName().equalsIgnoreCase(this.invoke.getPartnerLink())) continue;
            bNSExists = true;
            PartnerLinkNode partnerLinkNode = NotificationsUtil.findPartnerLinkNode(NotificationWizardContext.NS_PLINK_NAME, this.m_graphPane);
            partnerLinkPort = new PortNode(0);
            model.addChildNode((Node)partnerLinkNode, (Node)partnerLinkPort);
        }
        if (!bNSExists) {
            File outputFile = null;
            String strWSDLFileName = "NotificationService.wsdl";
            String strXSDFileName = "NotificationService.xsd";
            try {
                InputStream ipXsdFile = NotificationsUtil.getClassLoader().getResource("oracle/tip/pc/services/wsdl/NotificationService.xsd").openStream();
                URL bpelRootURL = this.m_prj.getBPELDirectoryURL();
                File outputXsdFile = new File(bpelRootURL.getPath(), strXSDFileName);
                outputXsdFile.createNewFile();
                NotificationsUtil.copy(ipXsdFile, outputXsdFile);
                URL outputXsdFileURL = URLFactory.newFileURL((File)outputXsdFile);
                this.m_graphPane.getBPELProject().addXSDNode(outputXsdFileURL);
                InputStream ipFile = NotificationsUtil.getClassLoader().getResourceAsStream("oracle/tip/pc/services/wsdl/NotificationService.wsdl");
                outputFile = new File(bpelRootURL.getPath(), strWSDLFileName);
                outputFile.createNewFile();
                NotificationsUtil.copy(ipFile, outputFile);
                URL outputFileURL = URLFactory.newFileURL((File)outputFile);
                this.m_graphPane.getBPELProject().addWSDLNode(outputFileURL);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            prefix = NotificationsUtil.getNamespacePrefix(this.m_graphModel.getProcess());
            PartnerLink plink = (PartnerLink)BPELParser.createImplementation(PartnerLink.class);
            plink.setDOMElement(plink.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true));
            plink.setName(this.invoke.getPartnerLink());
            QName qName = new QName(NotificationWizardContext.NS_NAMESHPACE, "NotificationServiceLink", prefix);
            plink.setPartnerLinkType(qName);
            plink.setPartnerRole("NotificationServiceProvider");
            try {
                if (outputFile != null && outputFile.exists()) {
                    plink.setWSDLLocation(outputFile.toURL().toString());
                }
            }
            catch (MalformedURLException m) {
                m.printStackTrace();
            }
            process.addPartnerLink(plink);
            PartnerLinkNode partnerLinkNode = new PartnerLinkNode();
            partnerLinkPort = new PortNode(0);
            SwimLaneView swimLaneView = this.m_graphPane.getRightSwimLaneView();
            SwimLaneNode swimLaneNode = (SwimLaneNode)swimLaneView.getNode();
            model.addChildNode((Node)swimLaneNode, (Node)partnerLinkNode);
            model.addChildNode((Node)partnerLinkNode, (Node)partnerLinkPort);
            partnerLinkNode.setUserObject(plink);
            this.firePartnerLinkCreated(plink, model.getProcess(), NotificationWizardContext.NS_PLINK_NAME);
        } else {
            prefix = NotificationsUtil.getNamespacePrefix(this.m_graphModel.getProcess());
        }
        Variable payloadIpVarModel = (Variable)BPELParser.createImplementation(Variable.class);
        payloadIpVarModel.setDOMElement(payloadIpVarModel.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true));
        payloadIpVarModel.setName(NotificationWizardContext.NOTIFICATION_IP_VAR_NAME);
        Variable payloadOpVarModel = (Variable)BPELParser.createImplementation(Variable.class);
        payloadOpVarModel.setDOMElement(payloadOpVarModel.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true));
        payloadOpVarModel.setName(NotificationWizardContext.NOTIFICATION_OP_VAR_NAME);
        String type = "";
        if (this.m_notificationActivity instanceof Email) {
            type = "EmailNotificationRequest";
        } else if (this.m_notificationActivity instanceof SMS) {
            type = "SMSNotificationRequest";
        } else if (this.m_notificationActivity instanceof Voice) {
            type = "VoiceNotificationRequest";
        } else if (this.m_notificationActivity instanceof IM) {
            type = "IMNotificationRequest";
        } else if (this.m_notificationActivity instanceof UserNotification) {
            type = "UserNotificationRequest";
        }
        QName emailIpType = new QName(NotificationWizardContext.NS_NAMESHPACE, type, prefix);
        payloadIpVarModel.setMessageType(emailIpType);
        QName emailOpType = new QName(NotificationWizardContext.NS_NAMESHPACE, "ArrayOfResponse", prefix);
        payloadOpVarModel.setMessageType(emailOpType);
        this.m_notificationActivity.addVariable(payloadIpVarModel);
        this.m_notificationActivity.addVariable(payloadOpVarModel);
        QName nsFaultMessageQName = new QName(NotificationWizardContext.NS_NAMESHPACE, "NotificationServiceErrorMessage", prefix);
        Variable nsFaultMessageVariable = (Variable)BPELParser.createImplementation(Variable.class);
        nsFaultMessageVariable.setDOMElement(nsFaultMessageVariable.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true));
        nsFaultMessageVariable.setName("NotificationServiceFaultVariable");
        nsFaultMessageVariable.setMessageType(nsFaultMessageQName);
        this.m_notificationActivity.addVariable(nsFaultMessageVariable);
    }

    protected void firePartnerLinkCreated(PartnerLink plink, Process process, String componentServiceName) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("OutboundPartnerLink", Boolean.TRUE);
        map.put("CompSvcName", componentServiceName);
        try {
            process.fireModelChanged((Object)process, 5, (Object)plink, map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Invoke createInvoke1() {
        Element processElem = this.m_processModel.getDOMElement();
        Document doc = processElem.getOwnerDocument();
        String prefix = NotificationsUtil.getNamespacePrefix(this.m_graphModel.getProcess());
        Invoke invoke = (Invoke)BPELParser.createImplementation(Invoke.class);
        invoke.setDOMElement(invoke.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true));
        try {
            this.m_sequence.addActivity((Activity)invoke);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        InvokeNode invokeNode = new InvokeNode();
        invokeNode.setUserObject(invoke);
        this.m_sequenceNode.addToEndOfBranch((Node)invokeNode);
        invokeNode.setName("InvokeNotificationService");
        invoke.setName("InvokeNotificationService");
        QName portType = new QName(NotificationWizardContext.NS_NAMESHPACE, "NotificationService", prefix);
        invoke.setPortType(portType);
        String plName = BPELModelUtil.generateUniqueName((Process)this.m_processModel, (String)NotificationWizardContext.NS_PLINK_NAME, PartnerLink.class);
        invoke.setPartnerLink(plName);
        invoke.setInputVariable(NotificationWizardContext.NOTIFICATION_IP_VAR_NAME);
        invoke.setOutputVariable(NotificationWizardContext.NOTIFICATION_OP_VAR_NAME);
        return invoke;
    }

    protected Sequence createSequenceNode() {
        Element processElem = this.m_processModel.getDOMElement();
        Document doc = processElem.getOwnerDocument();
        Sequence sequence = (Sequence)BPELParser.createImplementation(Sequence.class);
        sequence.setDOMElement(sequence.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true));
        String name = BPELModelUtil.generateUniqueName((Process)this.m_processModel, (String)"Sequence", Sequence.class);
        sequence.setName(name);
        try {
            this.m_notificationActivity.addActivity((Activity)sequence);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SequenceNode sequenceNode = new SequenceNode();
        sequenceNode.setUserObject(sequence);
        this.m_sequence = sequence;
        this.m_sequenceNode = sequenceNode;
        return sequence;
    }

    protected Assign createAssignNode(String name) {
        Assign assign = this.createAssignNode(name, this.m_sequence, this.m_sequenceNode);
        return assign;
    }

    protected Assign createAssignNode(String name, Sequence seq, SequenceNode seqNode) {
        Element processElem = this.m_processModel.getDOMElement();
        Document doc = processElem.getOwnerDocument();
        Assign assign = (Assign)BPELParser.createImplementation(Assign.class);
        assign.setDOMElement(assign.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true));
        ParserContext parserContext = ((BPELBaseType)this.m_notificationActivity).getParserContext();
        ((BPELBaseType)assign).setParserContext(parserContext);
        try {
            seq.addActivity((Activity)assign);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        assign.setName(name);
        AssignNode assignNode = new AssignNode();
        assignNode.setUserObject(assign);
        this.m_graphModel.addChildNode((Node)seqNode, (Node)assignNode);
        assignNode.setName(name);
        return assign;
    }

    protected String removeQuotes(String value) {
        int beginIndex = value.indexOf("\"");
        int endIndex = value.lastIndexOf("\"");
        String retVal = value;
        if (beginIndex < endIndex) {
            retVal = value.substring(beginIndex + 1, endIndex);
        }
        return retVal;
    }

    protected String convertToNotEmptyValue(String value) {
        if (value != null && value.trim().equals("")) {
            value = "<%string('')%>";
        }
        return value;
    }

    protected void invokeGraphicalXPathBuilder(JTextComponent editorPane) {
        if (this.m_nsResolver == null) {
            this.m_nsResolver = this.getNSResolver((Activity)this.m_notificationActivity);
        }
        TextManipulator tm = new TextManipulator(editorPane);
        BPELXmlModel mainModel = this.m_graphPane.getBPELXmlModel();
        VariableDataCallBackImpl dataCallBack = new VariableDataCallBackImpl(mainModel, (Activity)this.m_notificationActivity);
        VariablePickerPanel p = new VariablePickerPanel(this.m_graphPane, dataCallBack, this.getNSResolver((Activity)this.m_notificationActivity));
        VariableExpressionBuilderPicker picker = new VariableExpressionBuilderPicker(p, (Activity)this.m_notificationActivity);
        ExpressionBuilderPicker[] pickers = new ExpressionBuilderPicker[]{picker, new FunctionsExpressionBuilderPicker(this.m_nsResolver)};
        XPathEditorPane pane = new XPathEditorPane();
        pane.initializeDocument();
        pane.initializeEditorPane((VariableDataCallBack)dataCallBack, editorPane.getText(), this.m_nsResolver);
        ExpressionBuilder expressionDialog = new ExpressionBuilder(GraphUtils.getFrame((Component)((Object)this.m_graphPane)), (JTextComponent)pane, pickers);
        String expression = tm.getExpression();
        if (expression != null) {
            expressionDialog.setExpressionText(expression);
        }
        if (expressionDialog.display() == 0) {
            expression = expressionDialog.getExpressionText();
            tm.setExpression(expression);
        }
    }

    protected Invoke getInvoke() {
        List activityList = this.m_notificationActivity.getActivityList();
        if (activityList.size() == 0 || !(activityList.get(0) instanceof Sequence)) {
            return null;
        }
        Sequence sequence = (Sequence)activityList.get(0);
        activityList = sequence.getActivityList();
        for (int i = 0; i < activityList.size(); ++i) {
            Activity activity = (Activity)activityList.get(i);
            if (!(activity instanceof Invoke)) continue;
            return (Invoke)activity;
        }
        return null;
    }

    protected final void addLookupButtons(JButton userButton, JButton expBuilderButton, int gridx, int gridy) {
        this.addLookupButtons(userButton, expBuilderButton, gridx, gridy, 3);
    }

    protected void copyParserContext(BPELBaseType from, BPELBaseType to) {
        ParserContext parserContext = from.getParserContext();
        to.setParserContext(parserContext);
    }

    protected void updateNotificationNode(String name) {
        this.m_notificationNode.setName(name);
        this.m_notificationActivity.setName(name);
        this.m_notificationActivity.getValidationReport(new ValidationContext(this.m_processModel), true);
    }

    protected void saveChanges(boolean isEmpty, boolean bEditing, boolean isSaved, String operationName, String name) {
        if (isEmpty && !isSaved) {
            if (this.m_sequenceNode == null) {
                this.createSequenceNode();
            }
            this.m_graphModel.addChildNode(this.m_notificationNode, (Node)this.m_sequenceNode);
        }
        this.createCopyRules();
        if (isEmpty && !isSaved) {
            this.invoke = this.createInvoke();
            this.invoke.setOperation(operationName);
            try {
                this.m_sequence.addActivity((Activity)this.invoke);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            BPELGraphModel model = (BPELGraphModel)this.m_graphPane.getModel();
            model.addChildNode((Node)this.m_sequenceNode, (Node)this.invokeNode);
        }
        if (!bEditing && !isSaved) {
            this.createPartnerLinkAndVariable();
        }
        this.updateNotificationNode(name);
    }

    protected abstract void createCopyRules();

    protected Invoke createInvoke() {
        Element processElem = this.m_processModel.getDOMElement();
        Document doc = processElem.getOwnerDocument();
        String prefix = NotificationsUtil.getNamespacePrefix(this.m_graphModel.getProcess());
        Invoke invoke = (Invoke)BPELParser.createImplementation(Invoke.class);
        invoke.setDOMElement(invoke.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true));
        this.invokeNode = new InvokeNode();
        this.invokeNode.setUserObject(invoke);
        this.invokeNode.setName("InvokeNotificationService");
        invoke.setName("InvokeNotificationService");
        QName portType = new QName(NotificationWizardContext.NS_NAMESHPACE, "NotificationService", prefix);
        invoke.setPortType(portType);
        String plName = BPELModelUtil.generateUniqueName((Process)this.m_processModel, (String)NotificationWizardContext.NS_PLINK_NAME, PartnerLink.class);
        invoke.setPartnerLink(plName);
        invoke.setInputVariable(NotificationWizardContext.NOTIFICATION_IP_VAR_NAME);
        invoke.setOutputVariable(NotificationWizardContext.NOTIFICATION_OP_VAR_NAME);
        return invoke;
    }

    protected void initSequence() {
        List list = this.m_notificationActivity.getActivityList();
        for (int count = 0; count < list.size(); ++count) {
            Sequence seq;
            Activity a = (Activity)list.get(count);
            if (!(a instanceof Sequence)) continue;
            this.m_sequence = seq = (Sequence)a;
            this.m_sequenceNode = (SequenceNode)this.m_graphModel.getNodeForActivity((Activity)this.m_sequence);
            break;
        }
    }

    protected void createNewNotificationNode() {
        List list = this.m_notificationActivity.getActivityList();
        for (int count = 0; count < list.size(); ++count) {
            if (!(list.get(count) instanceof Sequence)) continue;
            this.m_sequence = (Sequence)list.get(count);
            this.m_sequenceNode = (SequenceNode)this.m_graphModel.getNodeForActivity((Activity)this.m_sequence);
            return;
        }
        this.createSequenceNode();
    }
}

