/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.editors;

import javax.xml.namespace.QName;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.KeyValue;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.ui.models.BaseTableModel;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;

class KeysTableModel
extends BaseTableModel {
    public static final int VALUE_COL = 1;
    public static final int KEY_NAME_COL = 0;
    private boolean m_bExpandNamespaces = true;

    KeysTableModel() {
    }

    public void setExpandNamespaces(boolean bExpand) {
        this.m_bExpandNamespaces = bExpand;
        this.refresh();
    }

    public int getColumnCount() {
        return 2;
    }

    public Object getValueAt(int row, int col) {
        KeyValue v = (KeyValue)this.m_data.get(row);
        switch (col) {
            case 1: {
                return v.getValue();
            }
            case 0: {
                QName qname = v.getName();
                if (qname != null) {
                    return this.m_bExpandNamespaces ? BPELModelUtil.getExpandedName((QName)qname) : BPELModelUtil.getPrefixQualifiedName((QName)qname);
                }
                return null;
            }
        }
        return null;
    }

    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public String getColumnName(int col) {
        switch (col) {
            case 1: {
                return BPELStringTranslator.getString("BIND_VALUE", "Value");
            }
            case 0: {
                return BPELStringTranslator.getString("BIND_KEY_NAME", "Key Name");
            }
        }
        return " ";
    }
}

