/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.Bind;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.KeyValue;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.Variable;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ui.ToolBar;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.ui.models.BaseTableModel;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.editors.BindEditPage;
import oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.editors.BindKeyDialog;
import oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.editors.KeysTableModel;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;

class KeysEditPanel
extends JPanel
implements ActionListener,
ListSelectionListener {
    protected JTable m_table;
    protected JButton m_addBtn;
    protected JButton m_editBtn;
    protected JButton m_removeBtn;
    protected JCheckBox m_namespaceCB;
    protected BPELGraphPane m_graph;
    protected Bind m_activity;
    protected BindEditPage m_page;
    protected Variable m_var = null;

    public KeysEditPanel(BPELGraphPane graph, BindEditPage page, Variable var) {
        this.m_graph = graph;
        this.m_page = page;
        this.m_var = var;
        this.createControls();
        this.layoutControls();
        this.updateButtons();
    }

    public Vector getKeys() {
        KeysTableModel model = (KeysTableModel)((Object)this.m_table.getModel());
        return model.getData();
    }

    public void load(Bind b) {
        this.m_activity = b;
        if (b == null) {
            KeysTableModel model = (KeysTableModel)((Object)this.m_table.getModel());
            model.getData().removeAllElements();
            model.refresh();
            return;
        }
        Vector keys = b.getKeyValues();
        if (keys == null) {
            return;
        }
        Vector data = new Vector();
        KeysTableModel model = (KeysTableModel)((Object)this.m_table.getModel());
        data.addAll(keys);
        model.setData(data);
        this.setColumnSizes();
        this.updateButtons();
    }

    protected void setColumnSizes() {
        TableColumnModel colModel = this.m_table.getColumnModel();
        for (int i = 0; i < colModel.getColumnCount(); ++i) {
            TableColumn col = colModel.getColumn(i);
            if (i == 0) {
                col.setPreferredWidth(120);
                continue;
            }
            if (i == 1) {
                col.setPreferredWidth(250);
                continue;
            }
            col.setPreferredWidth(30);
        }
    }

    protected void createControls() {
        this.m_namespaceCB = new JCheckBox("", false);
        BPELStringTranslator.setButton(this.m_namespaceCB, BPELStringTranslator.getString("EDITOR_VARS_EDIT_PNL_SHOW_NS_URI"));
        this.m_namespaceCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeysTableModel model = (KeysTableModel)((Object)KeysEditPanel.this.m_table.getModel());
                model.setExpandNamespaces(KeysEditPanel.this.m_namespaceCB.isSelected());
            }
        });
        this.m_addBtn = UIHelper.createToolBarButton((int)0);
        this.m_addBtn.addActionListener(this);
        this.m_removeBtn = UIHelper.createToolBarButton((int)2);
        this.m_removeBtn.addActionListener(this);
        this.m_editBtn = UIHelper.createToolBarButton((int)1);
        this.m_editBtn.addActionListener(this);
        this.m_table = new JTable((TableModel)((Object)new KeysTableModel()));
        this.m_table.getSelectionModel().addListSelectionListener(this);
        this.m_table.setAutoResizeMode(0);
        this.m_table.setRowHeight(18);
        this.setColumnSizes();
        this.m_table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Point origin = e.getPoint();
                int row = KeysEditPanel.this.m_table.rowAtPoint(origin);
                int column = KeysEditPanel.this.m_table.columnAtPoint(origin);
                if (row == -1 || column == -1) {
                    return;
                }
                if (e.getClickCount() == 2) {
                    KeysEditPanel.this.handleEdit();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
    }

    protected void layoutControls() {
        ToolBar tb = new ToolBar();
        tb.add((Component)this.m_addBtn);
        tb.add((Component)this.m_editBtn);
        tb.add((Component)this.m_removeBtn);
        JLabel lbl = new JLabel();
        BPELStringTranslator.setLabel(lbl, this.m_table, BPELStringTranslator.getString("BIND_KEYS", "Keys:"));
        this.setLayout(new GridBagLayout());
        GraphUtils.addComponent((Container)this, (Component)lbl, (int)0, (int)0, (int)1, (int)1, (int)16, (int)0, (Insets)new Insets(5, 5, 0, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)tb, (int)1, (int)0, (int)1, (int)1, (int)14, (int)0, (Insets)new Insets(5, 5, 0, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)GraphUtils.getScrollPane((Component)this.m_table), (int)0, (int)1, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(2, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)1.0);
    }

    protected void handleEdit() {
        BindKeyDialog dlg = new BindKeyDialog(GraphUtils.getFrame((Component)this), this.m_graph, this.m_page, this.m_activity, this.m_var);
        KeysTableModel tabModel = (KeysTableModel)((Object)this.m_table.getModel());
        KeyValue v = this.getSelectedKeyValue();
        if (dlg.edit(v) == 0) {
            tabModel.refresh();
        }
    }

    protected void handleCreate() {
        BindKeyDialog dlg = new BindKeyDialog(GraphUtils.getFrame((Component)this), this.m_graph, this.m_page, this.m_activity, this.m_var);
        KeysTableModel tabModel = (KeysTableModel)((Object)this.m_table.getModel());
        if (dlg.create() != 0) {
            return;
        }
        KeyValue v = dlg.getKeyValue();
        tabModel.getData().addElement(v);
        tabModel.refresh();
        this.updateButtons();
    }

    protected void handleRemove() {
        TableModel model = this.m_table.getModel();
        if (model instanceof BaseTableModel) {
            BaseTableModel tabModel = (BaseTableModel)model;
            int[] rows = this.m_table.getSelectedRows();
            tabModel.removeRows(rows);
            this.updateButtons();
            BPELGraphModel graphModel = (BPELGraphModel)this.m_graph.getModel();
            Process p = graphModel.getProcess();
            p.fireModelChanged((Object)this, 1, null);
        }
    }

    protected KeyValue getSelectedKeyValue() {
        ListSelectionModel model = this.m_table.getSelectionModel();
        if (model.isSelectionEmpty()) {
            return null;
        }
        int row = model.getLeadSelectionIndex();
        KeysTableModel tabModel = (KeysTableModel)((Object)this.m_table.getModel());
        return (KeyValue)tabModel.getRowData(row);
    }

    protected void updateButtons() {
        int numSelectedRows = this.m_table.getSelectedRowCount();
        if (numSelectedRows > 0) {
            this.m_removeBtn.setEnabled(true);
            this.m_editBtn.setEnabled(true);
        } else {
            this.m_removeBtn.setEnabled(false);
            this.m_editBtn.setEnabled(false);
        }
        this.m_addBtn.setEnabled(this.m_var != null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_addBtn) {
            this.handleCreate();
        } else if (src == this.m_editBtn) {
            this.handleEdit();
        } else if (src == this.m_removeBtn) {
            this.handleRemove();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.updateButtons();
    }

    public void setVariable(Variable v) {
        this.m_var = v;
        this.m_addBtn.setEnabled(this.m_var != null);
    }
}

