/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.text.Document;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.jdevimpl.java.insight.CompletionInsight;
import oracle.jdevimpl.java.insight.ParameterInsight;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.bpelparser.iface.JavaEmbedding;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.pm.bpelgraph.editors.BaseEditingPage;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.help.HelpSystem;

public class JavaEmbeddingGenEditPage
extends BaseEditingPage {
    protected static final String LANGUAGE_JAVA = "java";
    protected JTextField m_nameField;
    protected JTextField m_langField;
    protected JComboBox m_cbVersion;
    protected List<String> m_cbVersionList = null;
    protected BasicEditorPane m_codeSnippet;
    private JavaEmbedding m_activity;

    public JavaEmbeddingGenEditPage(BPELGraphPane pane) {
        super(pane);
        this.createControls();
        this.layoutControls();
    }

    @Override
    public void loadData() {
        this.setModified(true);
    }

    protected void createControls() {
        this.m_nameField = new JTextField();
        this.m_langField = new JTextField();
        this.m_cbVersion = new JComboBox();
        this.addItemsToComboBox();
        this.m_codeSnippet = new BasicEditorPane();
        this.initCodeSnippetPane();
    }

    private void addItemsToComboBox() {
        if (this.m_cbVersionList == null) {
            this.createVersionList();
        }
        for (int count = 0; count < this.m_cbVersionList.size(); ++count) {
            this.m_cbVersion.addItem(this.m_cbVersionList.get(count));
        }
        this.m_cbVersion.setSelectedItem("1.5");
    }

    private void createVersionList() {
        this.m_cbVersionList = new ArrayList<String>();
        this.m_cbVersionList.add("1.3");
        this.m_cbVersionList.add("1.4");
        this.m_cbVersionList.add("1.5");
    }

    protected void layoutControls() {
        this.setLayout(new GridBagLayout());
        int row = 0;
        JLabel nameLbl = new JLabel();
        BPELStringTranslator.setLabel(nameLbl, this.m_nameField, BPELStringTranslator.getString("GENERAL_EDITOR_NAME"));
        GraphUtils.addComponent((Container)this, (Component)nameLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(10, 10, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_nameField, (int)1, (int)row++, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(10, 5, 5, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        JLabel verLbl = new JLabel();
        BPELStringTranslator.setLabel(verLbl, this.m_cbVersion, BPELStringTranslator.getString("EDITOR_JAVA_EMB_VER"));
        GraphUtils.addComponent((Container)this, (Component)verLbl, (int)0, (int)row, (int)1, (int)1, (int)18, (int)0, (Insets)new Insets(5, 10, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_cbVersion, (int)1, (int)row++, (int)1, (int)1, (int)18, (int)2, (Insets)new Insets(5, 5, 5, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        JScrollPane codeScrollPane = new JScrollPane((Component)this.m_codeSnippet);
        codeScrollPane.setVerticalScrollBarPolicy(22);
        JViewport viewport = codeScrollPane.getViewport();
        viewport.setScrollMode(1);
        JLabel codeLbl = new JLabel();
        BPELStringTranslator.setLabel(codeLbl, (Component)this.m_codeSnippet, BPELStringTranslator.getString("EDITOR_JAVA_CODE_SNIPPET"));
        GraphUtils.addComponent((Container)this, (Component)codeLbl, (int)0, (int)row, (int)1, (int)1, (int)18, (int)0, (Insets)new Insets(5, 10, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)codeScrollPane, (int)1, (int)row++, (int)1, (int)1, (int)18, (int)1, (Insets)new Insets(5, 5, 10, 10), (int)0, (int)0, (double)1.0, (double)1.0);
    }

    @Override
    public void setUserObject(Object model) {
        super.setUserObject(model);
        this.m_activity = (JavaEmbedding)model;
        this.loadControls();
    }

    protected void loadControls() {
        this.m_langField.setText(LANGUAGE_JAVA);
        if (this.m_activity == null) {
            return;
        }
        if (this.m_activity.getName() != null) {
            this.m_nameField.setText(this.m_activity.getName());
        }
        if (this.m_activity.getLanguage() != null) {
            this.m_langField.setText(this.m_activity.getLanguage());
        }
        String ver = this.m_activity.getVersion();
        this.selectVersion(ver);
        if (this.m_activity.getCodeSnippet() != null) {
            this.m_codeSnippet.setText(this.m_activity.getCodeSnippet());
        } else {
            String javaCode = "/*Write your java code below e.g. \n\tSystem.out.println(\"Hello, World\");\n*/\n";
            this.m_codeSnippet.setText(javaCode);
        }
    }

    private void selectVersion(String version) {
        if (version != null) {
            this.m_cbVersion.setSelectedItem(version.trim());
        }
    }

    @Override
    public boolean validateEditorChanges() {
        String name = this.m_nameField.getText();
        if (!Helper.isValidName((String)name, (boolean)true)) {
            GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)this), (String)BPELStringTranslator.getString("GENERAL_EDITOR_NAME_INVALID"), (String)BPELStringTranslator.getString("GENERAL_EDITOR_ERROR"), (int)2);
            return false;
        }
        return true;
    }

    @Override
    public void saveChanges() {
        if (this.m_activity == null) {
            return;
        }
        this.m_activity.setName(this.m_nameField.getText());
        this.m_activity.setVersion((String)this.m_cbVersion.getSelectedItem());
        this.m_activity.setLanguage(this.m_langField.getText());
        this.m_activity.setCodeSnippet(this.m_codeSnippet.getText());
    }

    private void initCodeSnippetPane() {
        BasicDocument doc = new BasicDocument();
        doc.setLanguageSupport("Temp.java");
        this.m_codeSnippet.setDocument((Document)doc);
        this.m_codeSnippet.putProperty("editor-ide-context", this.m_graphPane.getBPELProject().getIDEContext());
        this.m_codeSnippet.installPlugin((EditorPlugin)new CompletionInsight());
        this.m_codeSnippet.installPlugin((EditorPlugin)new ParameterInsight());
    }

    @Override
    public void showHelp() {
        if (this.m_activity == null) {
            HelpSystem.showHelp(this, "bpmjdev_java_embed_create");
        } else {
            HelpSystem.showHelp(this, "bpmjdev_java_embed_edit");
        }
    }
}

