/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import oracle.ide.util.ResourceUtils;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.IM;
import oracle.tip.tools.ide.common.bpelparser.iface.Assign;
import oracle.tip.tools.ide.common.bpelparser.iface.Copy;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.graph.model.Node;
import oracle.tip.tools.ide.common.graph.view.GraphPane;
import oracle.tip.tools.ide.common.ui.GlobalImageCache;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.utils.MixedXPathExpressionParser;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.EditorPage;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.EditorPageChangeListener;
import oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.editors.NotificationGenEditPage;
import oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.model.IMNode;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.lookup.LookupDialog;
import oracle.tip.tools.ide.pm.modules.notification.util.NotificationsUtil;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class IMGenEditPage
extends NotificationGenEditPage
implements ActionListener,
EditorPage {
    private JTextField m_nameField = new JTextField();
    private JLabel toLabel = new JLabel();
    private JTextField toText = new JTextField();
    private JButton m_toExpBuilderBtn;
    private JLabel bodyLabel = new JLabel();
    private JScrollPane jScrollPane1 = new JScrollPane();
    private JTextArea m_bodyXPathBuilder;
    private JButton m_bodyExpBuilderBtn;
    private JButton toUButton = null;
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private boolean m_bEditing = false;
    private boolean m_saved = false;
    private Assign assign;
    private boolean isEmpty;

    public IMGenEditPage(GraphPane pane, Node n) {
        super((BPELGraphPane)pane);
        this.m_notificationNode = (IMNode)n;
    }

    @Override
    public void setUserObject(Object model) {
        this.m_notificationActivity = (IM)model;
        boolean bl = this.isEmpty = this.getInvoke() == null;
        if (this.m_notificationActivity != null && !this.isEmpty) {
            this.m_nameField.setText(this.m_notificationActivity.getName());
            this.m_bEditing = true;
            this.initSequence();
        } else {
            String name = BPELModelUtil.generateUniqueName((Process)this.m_processModel, (String)"IM", IM.class);
            this.m_nameField.setText(name);
            this.createNewNotificationNode();
        }
        this.invoke = this.getInvoke();
        try {
            this.jbInit();
            if (this.m_bEditing) {
                this.loadUI();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadUI() {
        this.m_notificationNode.setUserObject(this.m_notificationActivity);
        this.assign = ((IM)this.m_notificationActivity).getNotifParamsAssign();
        if (this.assign != null) {
            this.setUIData(this.assign);
        }
        this.m_notificationNode.setName(this.m_nameField.getText());
        this.m_notificationActivity.setName(this.m_nameField.getText());
    }

    private void setUIData(Assign assign) {
        List copyRules = assign.getCopyRules();
        if (copyRules != null) {
            for (int i = 0; i < copyRules.size(); ++i) {
                Copy copy = (Copy)copyRules.get(i);
                String query = copy.getTo().getQuery();
                String value = copy.getFrom().getExpression();
                if (value == null) continue;
                if (value.equalsIgnoreCase("string('')")) {
                    value = "";
                } else {
                    MixedXPathExpressionParser parser = new MixedXPathExpressionParser();
                    value = parser.convertXPathComplaintStringToMixedForm(value);
                }
                if (query.endsWith("To")) {
                    this.toText.setText(value);
                    continue;
                }
                if (!query.endsWith("ContentBody")) continue;
                this.m_bodyXPathBuilder.setText(value);
            }
        }
    }

    private void jbInit() {
        this.createExpBuilderBtn();
        Icon flashImage = GlobalImageCache.getIcon((String)"browse16");
        this.toUButton = new JButton(flashImage);
        this.toUButton.addActionListener(this);
        this.setLayout(this.gridBagLayout1);
        this.setSize(new Dimension(427, 305));
        ResourceUtils.resLabel((JLabel)this.toLabel, (Component)this.toText, (String)BPELStringTranslator.getString("IM_TO_LABEL"));
        this.toText.setEditable(true);
        this.m_bodyXPathBuilder = new JTextArea();
        this.m_bodyXPathBuilder.setEditable(true);
        ResourceUtils.resLabel((JLabel)this.bodyLabel, (Component)this.m_bodyXPathBuilder, (String)BPELStringTranslator.getString("IM_BODY_LABEL"));
        this.jScrollPane1.getViewport().add((Component)this.m_bodyXPathBuilder, null);
        GraphUtils.addComponent((Container)this, (Component)this.toLabel, (int)0, (int)1, (int)1, (int)1, (int)18, (int)1, (Insets)new Insets(10, 5, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.toText, (int)1, (int)1, (int)1, (int)1, (int)18, (int)1, (Insets)new Insets(0, 5, 0, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        JToolBar toolBar = new JToolBar();
        toolBar.setBorderPainted(false);
        toolBar.add(this.m_toExpBuilderBtn);
        toolBar.add(this.toUButton);
        GraphUtils.addComponent((Container)this, (Component)toolBar, (int)2, (int)1, (int)1, (int)1, (int)18, (int)0, (Insets)new Insets(0, 5, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        JLabel toHelp = new JLabel();
        toHelp.setText(BPELStringTranslator.getString("IM_TO_LABEL_DESC"));
        toHelp.setEnabled(false);
        GraphUtils.addComponent((Container)this, (Component)toHelp, (int)1, (int)2, (int)1, (int)1, (int)18, (int)1, (Insets)new Insets(10, 5, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        JToolBar tbBody = new JToolBar();
        tbBody.setBorderPainted(false);
        tbBody.add(this.m_bodyExpBuilderBtn);
        JPanel bodyPanel = new JPanel(new GridBagLayout());
        bodyPanel.add((Component)this.jScrollPane1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        GraphUtils.addComponent((Container)this, (Component)this.bodyLabel, (int)0, (int)3, (int)1, (int)1, (int)18, (int)0, (Insets)new Insets(10, 5, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)bodyPanel, (int)1, (int)3, (int)1, (int)1, (int)18, (int)1, (Insets)new Insets(10, 5, 0, 0), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)this, (Component)tbBody, (int)2, (int)3, (int)1, (int)1, (int)18, (int)0, (Insets)new Insets(10, 5, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        JLabel bodyHelp = new JLabel();
        bodyHelp.setText(BPELStringTranslator.getString("IM_BODY_LABEL_DESC"));
        bodyHelp.setEnabled(false);
        GraphUtils.addComponent((Container)this, (Component)bodyHelp, (int)1, (int)4, (int)1, (int)1, (int)18, (int)0, (Insets)new Insets(10, 5, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
    }

    private void createExpBuilderBtn() {
        this.m_toExpBuilderBtn = UIHelper.createModelerButton((Icon)ImageCache.getIcon("expressionbuilder"));
        this.m_toExpBuilderBtn.setToolTipText(BPELStringTranslator.getString("XPATH_EXPRESSSION_BUILDER", "XPath Expression Builder"));
        this.m_toExpBuilderBtn.addActionListener(this);
        this.m_bodyExpBuilderBtn = UIHelper.createModelerButton((Icon)ImageCache.getIcon("expressionbuilder"));
        this.m_bodyExpBuilderBtn.setToolTipText(BPELStringTranslator.getString("XPATH_EXPRESSSION_BUILDER", "XPath Expression Builder"));
        this.m_bodyExpBuilderBtn.addActionListener(this);
    }

    public Node getNode() {
        if (!this.m_bEditing && !this.m_saved) {
            return null;
        }
        return this.m_notificationNode;
    }

    @Override
    protected void createCopyRules() {
        MixedXPathExpressionParser parser = new MixedXPathExpressionParser();
        try {
            Element processElem = this.m_processModel.getDOMElement();
            Document doc = processElem.getOwnerDocument();
            String part = "";
            String query = "";
            String prefix = NotificationsUtil.getNamespacePrefix(this.m_graphModel.getProcess());
            part = "IMPayload";
            query = '/' + part + '/' + prefix + ':';
            if (this.assign == null) {
                this.assign = this.createAssignNode("IMParamsAssign");
            }
            if (this.m_bEditing) {
                // empty if block
            }
            NotificationsUtil.createOrReplaceCopy(parser.convertMixedStringToXPathCompliantForm(this.convertToNotEmptyValue(this.toText.getText())), part, query + "To", doc, this.assign);
            NotificationsUtil.createOrReplaceCopy(parser.convertMixedStringToXPathCompliantForm(this.convertToNotEmptyValue(this.m_bodyXPathBuilder.getText())), part, query + "Content" + "/" + prefix + ':' + "ContentBody", doc, this.assign);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        int lookupType = 0;
        if (source.equals(this.toUButton)) {
            LookupDialog dialog = new LookupDialog(lookupType, this, LookupDialog.IM_LOOKUP);
            boolean success = dialog.showDialog();
            if (success) {
                this.toText.setText(dialog.getIMId());
            }
        } else if (source == this.m_toExpBuilderBtn) {
            this.invokeGraphicalXPathBuilder(this.toText);
        } else if (source == this.m_bodyExpBuilderBtn) {
            this.invokeGraphicalXPathBuilder(this.m_bodyXPathBuilder);
        }
    }

    @Override
    public Object getUserObject() {
        return this.m_notificationActivity;
    }

    @Override
    public String getTitle() {
        return BPELStringTranslator.getString("IM");
    }

    @Override
    public JComponent getPagePanel() {
        return this;
    }

    @Override
    public void saveChanges() {
        this.saveChanges(this.isEmpty, this.m_bEditing, this.m_saved, "sendIMNotification", this.m_nameField.getText());
        this.m_saved = true;
    }

    @Override
    public boolean validateEditorChanges() {
        return true;
    }

    @Override
    public void removeEditorPageChangeListener(EditorPageChangeListener l) {
    }

    @Override
    public void onSelection() {
    }

    @Override
    public void onDeselection() {
    }
}

