/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.Entity;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Scope;
import oracle.tip.tools.ide.common.bpelparser.iface.Variable;
import oracle.tip.tools.ide.common.bpelparser.iface.Variables;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ui.ToolBar;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariablesFilter;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.gui.dialogs.choosers.variable.VariableChooser;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;

public class EntityVarPanel
extends JPanel
implements ActionListener {
    protected JTextField m_nameField;
    protected JTextField m_variablelField;
    protected JButton m_varBrowseBtn;
    protected Variable m_var;
    protected Entity m_entity;
    protected BPELGraphPane m_graph;

    public EntityVarPanel(BPELGraphPane graphPane, Entity entity) {
        this.m_graph = graphPane;
        this.m_entity = entity;
        this.createControls();
        this.layoutControls();
    }

    protected void createControls() {
        this.m_nameField = new JTextField();
        this.m_variablelField = new JTextField();
        this.m_variablelField.setEditable(false);
        this.m_varBrowseBtn = UIHelper.createBrowseButton((String)BPELStringTranslator.getString("GENERAL_BROWSE_VARS"));
        this.m_varBrowseBtn.addActionListener(this);
    }

    protected void layoutControls() {
        ToolBar varTB = new ToolBar();
        varTB.add((Component)this.m_varBrowseBtn);
        JLabel lblName = new JLabel();
        BPELStringTranslator.setLabel(lblName, this.m_nameField, BPELStringTranslator.getString("GENERAL_EDITOR_NAME"));
        JLabel lblTS = new JLabel();
        BPELStringTranslator.setLabel(lblTS, this.m_variablelField, BPELStringTranslator.getString("BIND_ENTITY_VARIABLE", "Entity &Variable:"));
        this.setLayout(new GridBagLayout());
        int row = 0;
        GraphUtils.addComponent((Container)this, (Component)lblName, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 0, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_nameField, (int)1, (int)row++, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(0, 0, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)lblTS, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 0, 0, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_variablelField, (int)1, (int)row, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(5, 0, 0, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)varTB, (int)2, (int)row++, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 0, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
    }

    public void load(Entity entity) {
        this.m_entity = entity;
        if (this.m_entity == null) {
            return;
        }
        if (this.m_entity.getName() != null) {
            this.m_nameField.setText(this.m_entity.getName());
        }
        if (this.m_entity.getVariable() != null) {
            this.m_variablelField.setText(this.m_entity.getVariable());
            this.m_var = EntityVarPanel.findVariable((Scope)((BPELGraphModel)this.m_graph.getModel()).getProcess(), this.m_entity.getVariable());
        }
    }

    public boolean validateEditorChanges() {
        if (!Helper.hasValue((String)this.m_nameField.getText())) {
            GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)this), (String)BPELStringTranslator.getString("GENERAL_EDITOR_NAME_ERROR"), (String)BPELStringTranslator.getString("GENERAL_EDITOR_ERROR"), (int)2);
            return false;
        }
        return true;
    }

    public void saveChanges() {
        if (this.m_entity == null) {
            return;
        }
        this.m_entity.setName(this.m_nameField.getText());
        this.m_entity.setVariable(this.m_variablelField.getText());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_varBrowseBtn) {
            this.handleVariableBrowse();
        }
    }

    protected void handleVariableBrowse() {
        VariablesFilter filter = new VariablesFilter(){

            @Override
            public boolean canDisplayVariable(Variable var) {
                String plink = var.getPartnerlink();
                return plink != null && plink.length() > 0;
            }
        };
        VariableChooser dlg = new VariableChooser(GraphUtils.getFrame((Component)this), this.m_graph, (Activity)this.m_entity, filter);
        dlg.setTitle(BPELStringTranslator.getString("BIND_ENTITY_BROWSE_VARIABLES", "Browse Variables"));
        if (dlg.display() == 0) {
            Variable v = dlg.getSelectedVariable();
            if (v != null) {
                this.m_variablelField.setText(v.getName());
            } else {
                this.m_variablelField.setText("");
            }
            this.m_var = v;
        }
    }

    public static Variable findVariable(Scope scope, String varName) {
        Variable var;
        if (scope == null || varName == null) {
            return null;
        }
        Variables list = scope.getVariables();
        for (Variable o : list.getVariables()) {
            var = o;
            if (!var.getName().equals(varName)) continue;
            return var;
        }
        for (Activity a : scope.getActivityList()) {
            if (!(a instanceof Scope) || (var = EntityVarPanel.findVariable((Scope)a, varName)) == null) continue;
            return var;
        }
        return null;
    }
}

