/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.text.JTextComponent;
import oracle.bali.ewt.text.NumberTextField;
import oracle.ide.util.ResourceUtils;
import oracle.tip.tools.ide.common.bpelparser.BPELParser;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.Email;
import oracle.tip.tools.ide.common.bpelparser.iface.Assign;
import oracle.tip.tools.ide.common.bpelparser.iface.BPELBaseType;
import oracle.tip.tools.ide.common.bpelparser.iface.Copy;
import oracle.tip.tools.ide.common.bpelparser.iface.From;
import oracle.tip.tools.ide.common.bpelparser.iface.ParserContext;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.To;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.graph.model.Node;
import oracle.tip.tools.ide.common.graph.view.GraphPane;
import oracle.tip.tools.ide.common.ui.GlobalImageCache;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.utils.MixedXPathExpressionParser;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.EditorPageChangeListener;
import oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.editors.NotificationGenEditPage;
import oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.model.EmailNode;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.lookup.LookupDialog;
import oracle.tip.tools.ide.pm.modules.notification.NotificationWizardContext;
import oracle.tip.tools.ide.pm.modules.notification.util.NotificationsUtil;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EmailGenEditPage
extends NotificationGenEditPage
implements ActionListener {
    private JTextField m_nameField = new JTextField();
    private JLabel m_fromLabel = new JLabel();
    private JTextField m_fromText = new JTextField();
    private JLabel m_toLabel = new JLabel();
    private JTextField m_toText = new JTextField();
    private JButton m_toExpBuilderBtn;
    private JLabel m_ccLabel = new JLabel();
    private JTextField m_ccText = new JTextField();
    private JButton m_ccExpBuilderBtn;
    private JLabel m_bccLabel = new JLabel();
    private JTextField m_bccText = new JTextField();
    private JButton m_bccExpBuilderBtn;
    private JLabel m_replyToLabel = new JLabel();
    private JTextField m_replyToText = new JTextField();
    private JButton m_replyExpBuilderBtn;
    private JLabel m_subjectLabel = new JLabel();
    private JTextField m_subjectXPathBuilder = new JTextField();
    private JButton m_subjectExpBuilderBtn;
    private JLabel m_bodyLabel = new JLabel();
    private JTextArea m_bodyXPathBuilder = new JTextArea();
    private JButton m_bodyExpBuilderBtn;
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JButton toUButton = null;
    private JButton ccUButton = null;
    private JButton bccUButton = null;
    private JButton rToUButton = null;
    private JCheckBox multipartCheck = new JCheckBox();
    private NumberTextField numAttachments = new NumberTextField(4);
    private JLabel numAttacmentsLbl = new JLabel();
    private boolean m_bEditing = false;
    private boolean m_saved = false;
    private boolean isEmpty;
    private Assign assign;
    private int numberOfAttach;

    public EmailGenEditPage(GraphPane pane, Node n) {
        super((BPELGraphPane)pane);
        this.m_notificationNode = (EmailNode)n;
    }

    @Override
    public void setUserObject(Object model) {
        this.m_notificationActivity = (Email)model;
        boolean bl = this.isEmpty = this.getInvoke() == null;
        if (this.m_notificationActivity != null && !this.isEmpty) {
            this.m_nameField.setText(this.m_notificationActivity.getName());
            this.m_bEditing = true;
            this.initSequence();
        } else {
            String name = BPELModelUtil.generateUniqueName((Process)this.m_processModel, (String)"Email", Email.class);
            this.m_nameField.setText(name);
            this.createNewNotificationNode();
        }
        this.invoke = this.getInvoke();
        try {
            this.jbInit();
            if (this.m_bEditing) {
                this.loadUI();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadUI() {
        this.m_notificationNode.setUserObject(this.m_notificationActivity);
        this.assign = ((Email)this.m_notificationActivity).getNotifParamsAssign();
        if (this.assign != null) {
            this.setUIData(this.assign);
        }
        this.m_notificationNode.setName(this.m_nameField.getText());
        this.m_notificationActivity.setName(this.m_nameField.getText());
    }

    private void setUIData(Assign assign) {
        List copyRules = assign.getCopyRules();
        this.numberOfAttach = 0;
        if (copyRules != null) {
            for (int i = 0; i < copyRules.size(); ++i) {
                Copy copy = (Copy)copyRules.get(i);
                String query = copy.getTo().getQuery();
                String value = copy.getFrom().getExpression();
                if (value == null) continue;
                if (value.equalsIgnoreCase("string('')")) {
                    value = "";
                } else {
                    MixedXPathExpressionParser parser = new MixedXPathExpressionParser();
                    value = parser.convertXPathComplaintStringToMixedForm(value);
                }
                if (query.endsWith("FromAccountName")) {
                    this.m_fromText.setText(value);
                    continue;
                }
                if (query.endsWith("To")) {
                    this.m_toText.setText(value);
                    continue;
                }
                if (query.endsWith("Bcc")) {
                    this.m_bccText.setText(value);
                    continue;
                }
                if (query.endsWith("Cc")) {
                    this.m_ccText.setText(value);
                    continue;
                }
                if (query.endsWith("ReplyToAddress")) {
                    this.m_replyToText.setText(value);
                    continue;
                }
                if (query.endsWith("Subject")) {
                    this.m_subjectXPathBuilder.setText(value);
                    continue;
                }
                if (!query.endsWith("ContentBody")) continue;
                if (this.numberOfAttach == 0) {
                    this.m_bodyXPathBuilder.setText(value);
                }
                ++this.numberOfAttach;
            }
            if (this.numberOfAttach > 1) {
                this.multipartCheck.setSelected(true);
                this.numAttachments.setNumber((Number)new Integer(this.numberOfAttach - 1));
                this.numAttachments.setEnabled(true);
            }
        }
    }

    private void jbInit() {
        this.createExpBuilderBtn();
        Icon flashImage = GlobalImageCache.getIcon((String)"browse16");
        this.setLayout(this.gridBagLayout1);
        this.setSize(new Dimension(427, 305));
        ResourceUtils.resLabel((JLabel)this.m_fromLabel, (Component)this.m_fromText, (String)BPELStringTranslator.getString("FROM_ACCOUNT"));
        this.m_fromText.setToolTipText(BPELStringTranslator.getString("FROM_EMAIL_NOTIFICATION_TOOLTIP"));
        this.m_fromText.setEditable(true);
        this.m_fromText.setText(BPELStringTranslator.getString("DEFAULT"));
        ResourceUtils.resLabel((JLabel)this.m_toLabel, (Component)this.m_toText, (String)BPELStringTranslator.getString("TO_LABEL"));
        this.m_toText.setEditable(true);
        ResourceUtils.resLabel((JLabel)this.m_ccLabel, (Component)this.m_ccText, (String)BPELStringTranslator.getString("CC_LABEL"));
        this.m_ccText.setEditable(true);
        ResourceUtils.resLabel((JLabel)this.m_bccLabel, (Component)this.m_bccText, (String)BPELStringTranslator.getString("BCC_LABEL"));
        this.m_bccText.setEditable(true);
        ResourceUtils.resLabel((JLabel)this.m_replyToLabel, (Component)this.m_replyToText, (String)BPELStringTranslator.getString("REPLY_TO_LABEL"));
        this.m_replyToText.setEditable(true);
        ResourceUtils.resLabel((JLabel)this.m_subjectLabel, (Component)this.m_subjectXPathBuilder, (String)BPELStringTranslator.getString("SUBJECT_LABEL"));
        JScrollPane bodyXPathScrollPane = new JScrollPane(this.m_bodyXPathBuilder, 20, 30);
        this.m_bodyXPathBuilder.setEditable(true);
        ResourceUtils.resLabel((JLabel)this.m_bodyLabel, (Component)bodyXPathScrollPane, (String)BPELStringTranslator.getString("BODY_LABEL"));
        this.m_subjectXPathBuilder.setEditable(true);
        JToolBar tbSubject = new JToolBar();
        tbSubject.setBorderPainted(false);
        tbSubject.add(this.m_subjectExpBuilderBtn);
        JToolBar tbBody = new JToolBar();
        tbBody.setBorderPainted(false);
        tbBody.add(this.m_bodyExpBuilderBtn);
        JPanel bodyPanel = new JPanel(new GridBagLayout());
        GraphUtils.addComponent((Container)bodyPanel, (Component)bodyXPathScrollPane, (int)0, (int)0, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(3, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)bodyPanel, (Component)tbBody, (int)1, (int)0, (int)1, (int)1, (int)12, (int)0, (Insets)new Insets(3, 0, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_bodyLabel, (int)0, (int)7, (int)1, (int)1, (int)18, (int)0, (Insets)new Insets(3, 10, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)bodyPanel, (int)1, (int)7, (int)3, (int)1, (int)17, (int)1, (Insets)new Insets(3, 5, 0, 10), (int)0, (int)0, (double)1.0, (double)1.0);
        JPanel subjPanel = new JPanel(new GridBagLayout());
        GraphUtils.addComponent((Container)subjPanel, (Component)this.m_subjectXPathBuilder, (int)1, (int)0, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(3, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)subjPanel, (Component)tbSubject, (int)2, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 0, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_subjectLabel, (int)0, (int)6, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 10, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)subjPanel, (int)1, (int)6, (int)3, (int)1, (int)17, (int)2, (Insets)new Insets(3, 5, 0, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        JComponent bodyHelp = UIHelper.getMultiLineLabel((String)BPELStringTranslator.getString("EMAIL_BODY_EXPLANATION"));
        GraphUtils.addComponent((Container)this, (Component)bodyHelp, (int)1, (int)8, (int)0, (int)1, (int)17, (int)2, (Insets)new Insets(3, 5, 0, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        this.multipartCheck.setSelected(false);
        this.multipartCheck.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this.multipartCheck, (String)BPELStringTranslator.getString("MULTIPART"));
        ResourceUtils.resLabel((JLabel)this.numAttacmentsLbl, (Component)this.numAttachments, (String)BPELStringTranslator.getString("MULTIPART_ATTACHMENTS"));
        JPanel multipartPanel = new JPanel();
        multipartPanel.setLayout(new GridBagLayout());
        GraphUtils.addComponent((Container)multipartPanel, (Component)this.multipartCheck, (int)0, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)multipartPanel, (Component)this.numAttachments, (int)1, (int)0, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(0, 5, 0, 0), (int)0, (int)0, (double)2.0, (double)0.0);
        GraphUtils.addComponent((Container)multipartPanel, (Component)this.numAttacmentsLbl, (int)2, (int)0, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(0, 5, 0, 0), (int)0, (int)0, (double)4.0, (double)0.0);
        this.numAttachments.setEnabled(false);
        GraphUtils.addComponent((Container)this, (Component)this.m_replyToText, (int)1, (int)5, (int)1, (int)1, (int)13, (int)2, (Insets)new Insets(3, 5, 0, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        this.rToUButton = new JButton(flashImage);
        this.rToUButton.addActionListener(this);
        this.addLookupButtons(this.rToUButton, this.m_replyExpBuilderBtn, 2, 5);
        this.m_replyExpBuilderBtn.addActionListener(this);
        GraphUtils.addComponent((Container)this, (Component)this.m_replyToLabel, (int)0, (int)5, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 10, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_bccText, (int)1, (int)4, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(3, 5, 0, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        this.bccUButton = new JButton(flashImage);
        this.bccUButton.addActionListener(this);
        this.addLookupButtons(this.bccUButton, this.m_bccExpBuilderBtn, 2, 4);
        GraphUtils.addComponent((Container)this, (Component)this.m_bccLabel, (int)0, (int)4, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 10, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_ccText, (int)1, (int)3, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(3, 5, 0, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        this.ccUButton = new JButton(flashImage);
        this.ccUButton.addActionListener(this);
        this.addLookupButtons(this.ccUButton, this.m_ccExpBuilderBtn, 2, 3);
        GraphUtils.addComponent((Container)this, (Component)this.m_ccLabel, (int)0, (int)3, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 10, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_toText, (int)1, (int)2, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(3, 5, 0, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        this.toUButton = new JButton(flashImage);
        this.toUButton.addActionListener(this);
        this.addLookupButtons(this.toUButton, this.m_toExpBuilderBtn, 2, 2);
        GraphUtils.addComponent((Container)this, (Component)this.m_toLabel, (int)0, (int)2, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 10, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_fromText, (int)1, (int)1, (int)0, (int)1, (int)17, (int)2, (Insets)new Insets(10, 5, 0, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_fromLabel, (int)0, (int)1, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(10, 10, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)multipartPanel, (int)1, (int)9, (int)0, (int)0, (int)17, (int)1, (Insets)new Insets(3, 5, 10, 0), (int)0, (int)0, (double)4.0, (double)0.0);
    }

    private void createExpBuilderBtn() {
        this.m_toExpBuilderBtn = UIHelper.createModelerButton((Icon)ImageCache.getIcon("expressionbuilder"));
        this.m_toExpBuilderBtn.setToolTipText(BPELStringTranslator.getString("XPATH_EXPRESSSION_BUILDER", "XPath Expression Builder"));
        this.m_toExpBuilderBtn.addActionListener(this);
        this.m_ccExpBuilderBtn = UIHelper.createModelerButton((Icon)ImageCache.getIcon("expressionbuilder"));
        this.m_ccExpBuilderBtn.setToolTipText(BPELStringTranslator.getString("XPATH_EXPRESSSION_BUILDER", "XPath Expression Builder"));
        this.m_ccExpBuilderBtn.addActionListener(this);
        this.m_bccExpBuilderBtn = UIHelper.createModelerButton((Icon)ImageCache.getIcon("expressionbuilder"));
        this.m_bccExpBuilderBtn.setToolTipText(BPELStringTranslator.getString("XPATH_EXPRESSSION_BUILDER", "XPath Expression Builder"));
        this.m_bccExpBuilderBtn.addActionListener(this);
        this.m_replyExpBuilderBtn = UIHelper.createModelerButton((Icon)ImageCache.getIcon("expressionbuilder"));
        this.m_replyExpBuilderBtn.setToolTipText(BPELStringTranslator.getString("XPATH_EXPRESSSION_BUILDER", "XPath Expression Builder"));
        this.m_replyExpBuilderBtn.addActionListener(this);
        this.m_subjectExpBuilderBtn = UIHelper.createModelerButton((Icon)ImageCache.getIcon("expressionbuilder"));
        this.m_subjectExpBuilderBtn.setToolTipText(BPELStringTranslator.getString("XPATH_EXPRESSSION_BUILDER", "XPath Expression Builder"));
        this.m_subjectExpBuilderBtn.addActionListener(this);
        this.m_bodyExpBuilderBtn = UIHelper.createModelerButton((Icon)ImageCache.getIcon("expressionbuilder"));
        this.m_bodyExpBuilderBtn.setToolTipText(BPELStringTranslator.getString("XPATH_EXPRESSSION_BUILDER", "XPath Expression Builder"));
        this.m_bodyExpBuilderBtn.addActionListener(this);
    }

    public Node getNode() {
        if (!this.m_bEditing && !this.m_saved) {
            return null;
        }
        return this.m_notificationNode;
    }

    @Override
    protected void createCopyRules() {
        MixedXPathExpressionParser parser = new MixedXPathExpressionParser();
        try {
            Element processElem = this.m_processModel.getDOMElement();
            Document doc = processElem.getOwnerDocument();
            String part = "";
            String query = "";
            String prefix = NotificationsUtil.getNamespacePrefix(this.m_graphModel.getProcess());
            part = "EmailPayload";
            query = '/' + part + '/' + prefix + ':';
            if (this.assign == null) {
                this.assign = this.createAssignNode("EmailParamsAssign");
            }
            ParserContext parserContext = ((BPELBaseType)this.m_notificationActivity).getParserContext();
            ((BPELBaseType)this.assign).setParserContext(parserContext);
            int numAttach = 1;
            if (this.multipartCheck.isSelected() && !this.numAttachments.getNumber().equals("")) {
                numAttach = this.numAttachments.getNumber().intValue() + 1;
            }
            if (numAttach != this.numberOfAttach) {
                this.assign.setCopyRules(new ArrayList());
            }
            NotificationsUtil.createOrReplaceCopy(parser.convertMixedStringToXPathCompliantForm(this.convertToNotEmptyValue(this.m_fromText.getText())), part, query + "FromAccountName", doc, this.assign);
            NotificationsUtil.createOrReplaceCopy(parser.convertMixedStringToXPathCompliantForm(this.convertToNotEmptyValue(this.m_bccText.getText())), part, query + "Bcc", doc, this.assign);
            NotificationsUtil.createOrReplaceCopy(parser.convertMixedStringToXPathCompliantForm(this.convertToNotEmptyValue(this.m_ccText.getText())), part, query + "Cc", doc, this.assign);
            NotificationsUtil.createOrReplaceCopy(parser.convertMixedStringToXPathCompliantForm(this.convertToNotEmptyValue(this.m_replyToText.getText())), part, query + "ReplyToAddress", doc, this.assign);
            NotificationsUtil.createOrReplaceCopy(parser.convertMixedStringToXPathCompliantForm(this.convertToNotEmptyValue(this.m_subjectXPathBuilder.getText())), part, query + "Subject", doc, this.assign);
            NotificationsUtil.createOrReplaceCopy(parser.convertMixedStringToXPathCompliantForm(this.convertToNotEmptyValue(this.m_toText.getText())), part, query + "To", doc, this.assign);
            if (numAttach == this.numberOfAttach) {
                if (this.multipartCheck.isSelected()) {
                    this.generateAttachmentCopyRules(parser, doc, part, query, prefix, 0);
                } else {
                    this.generateBodyCopy(parser, doc, part, query, prefix);
                }
                return;
            }
            if (this.multipartCheck.isSelected()) {
                int i;
                String ContentBegin = "<Content xmlns=\"http://xmlns.oracle.com/ias/pcbpel/NotificationService\"><MimeType xmlns=\"http://xmlns.oracle.com/ias/pcbpel/NotificationService\">multipart/mixed</MimeType><ContentBody xmlns=\"http://xmlns.oracle.com/ias/pcbpel/NotificationService\"><MultiPart xmlns=\"http://xmlns.oracle.com/ias/pcbpel/NotificationService\">";
                String BodyPart = " <BodyPart xmlns=\"http://xmlns.oracle.com/ias/pcbpel/NotificationService\"><MimeType xmlns=\"http://xmlns.oracle.com/ias/pcbpel/NotificationService\"/><ContentBody xmlns=\"http://xmlns.oracle.com/ias/pcbpel/NotificationService\"/><BodyPartName xmlns=\"http://xmlns.oracle.com/ias/pcbpel/NotificationService\"/></BodyPart>";
                String ContentEnd = "</MultiPart></ContentBody></Content>";
                for (i = 0; i < numAttach; ++i) {
                    ContentBegin = ContentBegin.concat(BodyPart);
                }
                ContentBegin = ContentBegin.concat(ContentEnd);
                this.assign.addCopyRule(this.createCopyForMultipart(ContentBegin, part, query + "Content", doc));
                for (i = 0; i < numAttach; ++i) {
                    this.generateAttachmentCopyRules(parser, doc, part, query, prefix, i);
                }
            } else {
                this.generateBodyCopy(parser, doc, part, query, prefix);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void generateAttachmentCopyRules(MixedXPathExpressionParser parser, Document doc, String part, String query, String prefix, int i) {
        this.assign.addCopyRule(NotificationsUtil.createCopy("string('text/html; charset=UTF-8')", part, query + "Content" + "/" + prefix + ':' + "ContentBody" + "/" + prefix + ':' + "MultiPart" + "/" + prefix + ':' + "BodyPart" + "[" + (i + 1) + "]" + "/" + prefix + ':' + "MimeType", doc, this.assign));
        String bodyName = "";
        if (i != 0) {
            bodyName = "NotificationAttachment" + i + ".html";
        }
        this.assign.addCopyRule(NotificationsUtil.createCopy("string('" + bodyName + "')", part, query + "Content" + "/" + prefix + ':' + "ContentBody" + "/" + prefix + ':' + "MultiPart" + "/" + prefix + ':' + "BodyPart" + "[" + (i + 1) + "]" + "/" + prefix + ':' + "BodyPartName", doc, this.assign));
        if (i == 0) {
            NotificationsUtil.createOrReplaceCopy(parser.convertMixedStringToXPathCompliantForm(this.convertToNotEmptyValue(this.m_bodyXPathBuilder.getText())), part, query + "Content" + "/" + prefix + ':' + "ContentBody" + "/" + prefix + ':' + "MultiPart" + "/" + prefix + ':' + "BodyPart" + "[" + (i + 1) + "]" + "/" + prefix + ':' + "ContentBody", doc, this.assign);
        } else {
            this.assign.addCopyRule(NotificationsUtil.createCopy("string('message" + i + "')", part, query + "Content" + "/" + prefix + ':' + "ContentBody" + "/" + prefix + ':' + "MultiPart" + "/" + prefix + ':' + "BodyPart" + "[" + (i + 1) + "]" + "/" + prefix + ':' + "ContentBody", doc, this.assign));
        }
    }

    private void generateBodyCopy(MixedXPathExpressionParser parser, Document doc, String part, String query, String prefix) {
        NotificationsUtil.createOrReplaceCopy(parser.convertMixedStringToXPathCompliantForm(this.convertToNotEmptyValue(this.m_bodyXPathBuilder.getText())), part, query + "Content" + "/" + prefix + ':' + "ContentBody", doc, this.assign);
        NotificationsUtil.createOrReplaceCopy("string('text/html; charset=UTF-8')", part, query + "Content" + "/" + prefix + ':' + "MimeType", doc, this.assign);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (e.getSource().equals(this.multipartCheck)) {
            if (this.multipartCheck.isSelected()) {
                this.numAttachments.setEnabled(true);
            } else {
                this.numAttachments.setEnabled(false);
            }
        }
        int lookupType = 0;
        if (source.equals(this.toUButton)) {
            this.startLookupDialog(lookupType, this.m_toText);
        } else if (source.equals(this.ccUButton)) {
            this.startLookupDialog(lookupType, this.m_ccText);
        } else if (source.equals(this.bccUButton)) {
            this.startLookupDialog(lookupType, this.m_bccText);
        } else if (source.equals(this.rToUButton)) {
            this.startLookupDialog(lookupType, this.m_replyToText);
        } else if (source == this.m_toExpBuilderBtn) {
            this.invokeGraphicalXPathBuilder(this.m_toText);
        } else if (source == this.m_ccExpBuilderBtn) {
            this.invokeGraphicalXPathBuilder(this.m_ccText);
        } else if (source == this.m_bccExpBuilderBtn) {
            this.invokeGraphicalXPathBuilder(this.m_bccText);
        } else if (source == this.m_replyExpBuilderBtn) {
            this.invokeGraphicalXPathBuilder(this.m_replyToText);
        } else if (source == this.m_subjectExpBuilderBtn) {
            this.invokeGraphicalXPathBuilder(this.m_subjectXPathBuilder);
        } else if (source == this.m_bodyExpBuilderBtn) {
            this.invokeGraphicalXPathBuilder(this.m_bodyXPathBuilder);
        }
    }

    private Copy createCopyForMultipart(String fromExpression, String toVarPart, String toVarQuery, Document doc) {
        From fromModel = (From)BPELParser.createImplementation(From.class);
        fromModel.setDOMElement(fromModel.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true));
        To toModel = (To)BPELParser.createImplementation(To.class);
        toModel.setDOMElement(toModel.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true));
        Copy copy = (Copy)BPELParser.createImplementation(Copy.class);
        copy.setDOMElement(copy.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true));
        fromModel.setLiteral(fromExpression);
        toModel.setVariable(NotificationWizardContext.NOTIFICATION_IP_VAR_NAME);
        toModel.setPart(toVarPart);
        toModel.setQuery(toVarQuery);
        copy.setFrom(fromModel);
        copy.setTo(toModel);
        return copy;
    }

    @Override
    public Object getUserObject() {
        return this.m_notificationActivity;
    }

    @Override
    public String getTitle() {
        return BPELStringTranslator.getString("EMAIL");
    }

    @Override
    public JComponent getPagePanel() {
        return this;
    }

    @Override
    public void saveChanges() {
        this.saveChanges(this.isEmpty, this.m_bEditing, this.m_saved, "sendEmailNotification", this.m_nameField.getText());
        this.m_saved = true;
    }

    @Override
    public boolean validateEditorChanges() {
        return true;
    }

    @Override
    public void removeEditorPageChangeListener(EditorPageChangeListener l) {
    }

    @Override
    public void onSelection() {
    }

    @Override
    public void onDeselection() {
    }

    protected final void startLookupDialog(int lookupType, JTextComponent text) {
        LookupDialog dialog = new LookupDialog(lookupType, this, LookupDialog.EMAIL_LOOKUP);
        boolean success = dialog.showDialog();
        if (success) {
            text.setText(dialog.getEmailAddress());
        }
    }
}

