/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.CreateEntity;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Scope;
import oracle.tip.tools.ide.common.bpelparser.iface.Variable;
import oracle.tip.tools.ide.common.bpelparser.iface.Variables;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ui.GlobalImageCache;
import oracle.tip.tools.ide.common.xpath.editor.XPathEditorPane;
import oracle.tip.tools.ide.pm.bpelgraph.editors.BaseEditingPage;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariablesFilter;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.EditorPage;
import oracle.tip.tools.ide.pm.gui.dialogs.choosers.variable.VariableChooser;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class CreateEntityVarEditPage
extends BaseEditingPage
implements EditorPage,
ActionListener {
    protected CreateEntity m_createEntity;
    protected JTextField m_nameField;
    protected JTextField m_variablelField;
    protected JButton m_varBrowseBtn;
    protected JButton m_exprBuilderBtn;
    protected JTextField m_fromExpr;
    protected Variable m_var;

    public CreateEntityVarEditPage(BPELGraphPane graphPane) {
        super(graphPane);
        this.createControls();
        this.layoutControls();
    }

    @Override
    public void loadData() {
        this.setModified(true);
    }

    protected void createControls() {
        this.m_nameField = new JTextField();
        this.m_variablelField = new JTextField();
        this.m_variablelField.setEditable(false);
        this.m_varBrowseBtn = new JButton(GlobalImageCache.getIcon((String)"browse16"));
        this.m_varBrowseBtn.setToolTipText(BPELStringTranslator.getString("GENERAL_BROWSE_VARS"));
        this.m_varBrowseBtn.addActionListener(this);
        this.m_fromExpr = new JTextField();
        this.m_exprBuilderBtn = new JButton(ImageCache.getIcon("expressionbuilder"));
        this.m_exprBuilderBtn.setToolTipText(BPELStringTranslator.getString("BIND_EXPR_BUILDER_BTN", "Expression Builder..."));
        this.m_exprBuilderBtn.addActionListener(this);
    }

    protected void layoutControls() {
        JToolBar varTB = new JToolBar();
        varTB.setBorderPainted(false);
        varTB.add(this.m_varBrowseBtn);
        JLabel lblName = new JLabel();
        BPELStringTranslator.setLabel(lblName, this.m_nameField, BPELStringTranslator.getString("GENERAL_EDITOR_NAME"));
        JLabel lblTS = new JLabel();
        BPELStringTranslator.setLabel(lblTS, this.m_variablelField, BPELStringTranslator.getString("BIND_ENTITY_VARIABLE", "Entity &Variable:"));
        JLabel expLblName = new JLabel();
        BPELStringTranslator.setLabel(expLblName, this.m_fromExpr, BPELStringTranslator.getString("ENTITY_FROM_EXPR_NAME"));
        JToolBar exprTB = new JToolBar();
        exprTB.setBorderPainted(false);
        exprTB.add(this.m_exprBuilderBtn);
        this.setLayout(new GridBagLayout());
        int row = 0;
        GraphUtils.addComponent((Container)this, (Component)lblName, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(10, 10, 0, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_nameField, (int)1, (int)row++, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(10, 0, 0, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)lblTS, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 10, 0, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_variablelField, (int)1, (int)row, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(5, 0, 0, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)varTB, (int)2, (int)row++, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 0, 0, 10), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)expLblName, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 10, 0, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_fromExpr, (int)1, (int)row, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(5, 0, 0, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)exprTB, (int)2, (int)row++, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 0, 0, 10), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)new JPanel(), (int)0, (int)row, (int)3, (int)1, (int)18, (int)1, (Insets)new Insets(0, 10, 10, 10), (int)0, (int)0, (double)1.0, (double)1.0);
    }

    @Override
    public void setUserObject(Object model) {
        super.setUserObject(model);
        this.m_createEntity = (CreateEntity)model;
        this.loadControls();
    }

    protected void loadControls() {
        if (this.m_createEntity == null) {
            return;
        }
        if (this.m_createEntity.getName() != null) {
            this.m_nameField.setText(this.m_createEntity.getName());
        }
        if (this.m_createEntity.getVariable() != null) {
            this.m_variablelField.setText(this.m_createEntity.getVariable());
            this.m_var = CreateEntityVarEditPage.findVariable((Scope)((BPELGraphModel)this.m_graphPane.getModel()).getProcess(), this.m_createEntity.getVariable());
        }
        if (this.m_createEntity.getFromExpression() != null) {
            this.m_fromExpr.setText(this.m_createEntity.getFromExpression());
        }
    }

    @Override
    public boolean validateEditorChanges() {
        if (!Helper.hasValue((String)this.m_nameField.getText())) {
            GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)this), (String)BPELStringTranslator.getString("GENERAL_EDITOR_NAME_ERROR"), (String)BPELStringTranslator.getString("GENERAL_EDITOR_ERROR"), (int)2);
            return false;
        }
        return true;
    }

    @Override
    public void saveChanges() {
        if (this.m_createEntity == null) {
            return;
        }
        this.m_createEntity.setName(this.m_nameField.getText());
        this.m_createEntity.setVariable(this.m_variablelField.getText());
        this.m_createEntity.setFromExpression(this.m_fromExpr.getText());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_varBrowseBtn) {
            this.handleVariableBrowse();
        } else if (src == this.m_exprBuilderBtn) {
            this.handleExprBuild();
        }
    }

    protected void handleExprBuild() {
        XPathEditorPane x = new XPathEditorPane();
        String inStr = this.m_fromExpr.getText();
        if (Helper.hasValue((String)inStr)) {
            x.setText(inStr);
        }
        this.invokeGraphicalXPathBuilder(x, (Activity)this.m_createEntity);
        String s = x.getText();
        if (Helper.hasValue((String)s)) {
            this.m_fromExpr.setText(s);
        }
    }

    protected void handleVariableBrowse() {
        VariablesFilter filter = new VariablesFilter(){

            @Override
            public boolean canDisplayVariable(Variable var) {
                String plink = var.getPartnerlink();
                return plink != null && plink.length() > 0;
            }
        };
        VariableChooser dlg = new VariableChooser(GraphUtils.getFrame((Component)this), this.m_graphPane, (Activity)this.m_createEntity, filter);
        dlg.setTitle(BPELStringTranslator.getString("BIND_ENTITY_BROWSE_VARIABLES", "Browse Variables"));
        if (dlg.display() == 0) {
            Variable v = dlg.getSelectedVariable();
            if (v != null) {
                this.m_variablelField.setText(v.getName());
            } else {
                this.m_variablelField.setText("");
            }
            this.m_var = v;
        }
    }

    public static Variable findVariable(Scope scope, String varName) {
        Variable var;
        if (scope == null || varName == null) {
            return null;
        }
        Variables list = scope.getVariables();
        for (Variable o : list.getVariables()) {
            var = o;
            if (!var.getName().equals(varName)) continue;
            return var;
        }
        for (Activity a : scope.getActivityList()) {
            if (!(a instanceof Scope) || (var = CreateEntityVarEditPage.findVariable((Scope)a, varName)) == null) continue;
            return var;
        }
        return null;
    }
}

