/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.xml.namespace.QName;
import oracle.tip.tools.ide.common.bpeldesigner.models.explorer.ExplorerTreeNode;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.Bind;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.KeyValue;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Variable;
import oracle.tip.tools.ide.common.bpelparser.util.XMLHelper;
import oracle.tip.tools.ide.common.datasources.CompoundDataSource;
import oracle.tip.tools.ide.common.datasources.schema.EntityKeyExplorerTreeNode;
import oracle.tip.tools.ide.common.datasources.schema.ProjectSchemaDataSource;
import oracle.tip.tools.ide.common.datasources.wsdl.ProjectWSDLDataSource;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ide.IDEProject;
import oracle.tip.tools.ide.common.typeexplorer.TypeChooser;
import oracle.tip.tools.ide.common.typeexplorer.TypeChooserListener;
import oracle.tip.tools.ide.common.typeexplorer.TypeObject;
import oracle.tip.tools.ide.common.ui.ToolBar;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.ui.treeexplorer.DefaultTreeExplorerTreeNode;
import oracle.tip.tools.ide.common.ui.treeexplorer.TreeExplorerDataSource;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariablesFilter;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.editors.BindEditPage;
import oracle.tip.tools.ide.pm.gui.dialogs.variablexpathbuilder.VariableXPathBuilder;
import oracle.tip.tools.ide.pm.gui.dialogs.variablexpathbuilder.VariableXPathBuilderPanel;
import oracle.tip.tools.ide.pm.gui.explorer.ProcessExplorer;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;
import org.w3c.dom.Element;

public class BindKeyPanel
extends JPanel
implements ActionListener {
    public static final String NAME_CHANGED = "NAME_CHANGED";
    public static final String EXPR_CHANGED = "EXPR_CHANGED";
    protected JTextField m_exprField;
    protected JTextField m_keyField;
    protected JTextField m_nsField;
    protected JButton m_exprBuilderBtn;
    protected BPELGraphPane m_graph;
    protected KeyValue m_keyvalue;
    protected JButton m_keyBrowseBtn;
    protected JButton m_varBrowseBtn;
    protected TypeObject m_typeObj;
    protected BindEditPage m_page;
    protected Bind m_bind;
    protected Variable m_var;

    public BindKeyPanel(BPELGraphPane graph, BindEditPage page, Bind bind, Variable var) {
        this.m_graph = graph;
        this.m_page = page;
        this.m_bind = bind;
        this.m_var = var;
        this.createControls();
        this.layoutControls();
    }

    public boolean isDataValid() {
        String s = this.m_exprField.getText();
        if (s == null || s.length() == 0) {
            return false;
        }
        s = this.m_keyField.getText().trim();
        return Helper.hasValue((String)s);
    }

    public void setKeyValue(String expr, QName key) {
        if (expr != null) {
            this.m_exprField.setText(expr);
            this.m_exprField.setToolTipText(this.m_exprField.getText());
        }
        if (key != null) {
            this.m_keyField.setText(key.getLocalPart());
            this.m_nsField.setText(key.getNamespaceURI());
            this.m_nsField.setToolTipText(this.m_nsField.getText());
            this.m_keyField.setToolTipText(this.m_keyField.getText());
        }
    }

    public void setKeyValue(KeyValue keyvalue) {
        this.m_keyvalue = keyvalue;
        if (this.m_keyvalue != null) {
            this.m_exprField.setText(this.m_keyvalue.getValue());
            this.m_exprField.setToolTipText(this.m_exprField.getText());
            QName qname = this.m_keyvalue.getName();
            if (qname != null) {
                this.m_keyField.setText(qname.getLocalPart());
                this.m_nsField.setText(qname.getNamespaceURI());
                this.m_nsField.setToolTipText(this.m_nsField.getText());
                this.m_keyField.setToolTipText(this.m_keyField.getText());
            }
        }
    }

    public KeyValue getKeyValue() {
        return this.m_keyvalue;
    }

    public KeyValue saveToModel() {
        String expr;
        if (this.m_keyvalue == null) {
            this.m_keyvalue = new KeyValue();
        }
        if ((expr = this.m_exprField.getText()) != null) {
            this.m_keyvalue.setValue(expr.trim());
        }
        String key = this.m_keyField.getText().trim();
        String ns = this.m_nsField.getText().trim();
        QName qname = new QName(ns, key);
        this.m_keyvalue.setName(qname);
        return this.m_keyvalue;
    }

    protected void createControls() {
        this.m_exprField = new JTextField();
        this.m_exprField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                BindKeyPanel.this.firePropertyChange(BindKeyPanel.EXPR_CHANGED, null, BindKeyPanel.this.m_exprField.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                BindKeyPanel.this.firePropertyChange(BindKeyPanel.EXPR_CHANGED, null, BindKeyPanel.this.m_exprField.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                BindKeyPanel.this.firePropertyChange(BindKeyPanel.EXPR_CHANGED, null, BindKeyPanel.this.m_exprField.getText());
            }
        });
        this.m_keyField = new JTextField();
        this.m_keyField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                BindKeyPanel.this.firePropertyChange(BindKeyPanel.NAME_CHANGED, null, BindKeyPanel.this.m_keyField.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                BindKeyPanel.this.firePropertyChange(BindKeyPanel.NAME_CHANGED, null, BindKeyPanel.this.m_keyField.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                BindKeyPanel.this.firePropertyChange(BindKeyPanel.NAME_CHANGED, null, BindKeyPanel.this.m_keyField.getText());
            }
        });
        this.m_keyField.setEditable(true);
        this.m_exprBuilderBtn = UIHelper.createModelerButton((Icon)ImageCache.getIcon("expressionbuilder"));
        this.m_exprBuilderBtn.setToolTipText(BPELStringTranslator.getString("BIND_EXPR_BUILDER_BTN", "Expression Builder..."));
        this.m_exprBuilderBtn.addActionListener(this);
        this.m_nsField = new JTextField();
        this.m_nsField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                BindKeyPanel.this.firePropertyChange(BindKeyPanel.NAME_CHANGED, null, BindKeyPanel.this.m_nsField.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                BindKeyPanel.this.firePropertyChange(BindKeyPanel.NAME_CHANGED, null, BindKeyPanel.this.m_nsField.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                BindKeyPanel.this.firePropertyChange(BindKeyPanel.NAME_CHANGED, null, BindKeyPanel.this.m_nsField.getText());
            }
        });
        this.m_nsField.setEditable(true);
        this.m_keyBrowseBtn = UIHelper.createModelerButton((Icon)ImageCache.getIcon("application/extensions/bind_browse.png"));
        this.m_keyBrowseBtn.setToolTipText(BPELStringTranslator.getString("BIND_BROWSE_TYPE_BTN", "Entity Key By types..."));
        this.m_keyBrowseBtn.addActionListener(this);
        this.m_varBrowseBtn = UIHelper.createModelerButton((Icon)ImageCache.getIcon("variable16"));
        this.m_varBrowseBtn.setToolTipText(BPELStringTranslator.getString("BIND_BROWSE_VAR_BTN", "Browse Entity Variable..."));
        this.m_varBrowseBtn.addActionListener(this);
    }

    protected void layoutControls() {
        ToolBar browseTB = new ToolBar();
        browseTB.setBorderInsets(new Insets(0, 0, 0, 0));
        browseTB.add((Component)this.m_exprBuilderBtn);
        this.setLayout(new GridBagLayout());
        JLabel keyLbl = new JLabel();
        BPELStringTranslator.setLabel(keyLbl, this.m_keyField, BPELStringTranslator.getString("BIND_KEY_LOCAL_PART", "Local &Part:"));
        JLabel nsLbl = new JLabel();
        BPELStringTranslator.setLabel(nsLbl, this.m_nsField, BPELStringTranslator.getString("BIND_KEY_NS", "Key Namespace &URI:"));
        JLabel exprLbl = new JLabel();
        BPELStringTranslator.setLabel(exprLbl, this.m_exprField, BPELStringTranslator.getString("BIND_KEY_VALUE", "Key &Value:"));
        ToolBar tb = new ToolBar();
        tb.add((Component)this.m_varBrowseBtn);
        JPanel p = new JPanel(new GridBagLayout());
        p.setBorder(new TitledBorder(BPELStringTranslator.getString("BIND_KEY_NAME", "Key QName")));
        int row = 0;
        GraphUtils.addComponent((Container)p, (Component)keyLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 5, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)this.m_keyField, (int)1, (int)row, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(0, 5, 0, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)tb, (int)2, (int)row++, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 5, 0, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)nsLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 5, 5, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)this.m_nsField, (int)1, (int)row, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(5, 5, 5, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        row = 0;
        GraphUtils.addComponent((Container)this, (Component)p, (int)0, (int)row++, (int)3, (int)1, (int)17, (int)2, (Insets)new Insets(0, 0, 10, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)exprLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_exprField, (int)1, (int)row, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(0, 5, 0, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)browseTB, (int)2, (int)row++, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 5, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)new JPanel(), (int)0, (int)row, (int)3, (int)1, (int)18, (int)1, (Insets)new Insets(5, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)1.0);
    }

    protected void handleKeyBrows() {
        final TypeChooserForKey chooser = new TypeChooserForKey(GraphUtils.getFrame((Component)this));
        TypeChooserListener listener = new TypeChooserListener(){

            public void typeSelectionOccurred() {
                chooser.getOkButton().setEnabled(false);
                DefaultTreeExplorerTreeNode node = chooser.getTypeExplorer().getSelectedNode();
                if (node instanceof EntityKeyExplorerTreeNode) {
                    chooser.getOkButton().setEnabled(true);
                }
            }
        };
        chooser.setTypeChooserListener(listener);
        chooser.setTitle(BPELStringTranslator.getString("BIND_BROWSE_TYPE_TITLE", "Entity Key By types"));
        chooser.getTypeExplorer().setToolBarActions(new Action[0]);
        CompoundDataSource ds = new CompoundDataSource();
        ds.addDataSource((TreeExplorerDataSource)new ProjectSchemaDataSource((IDEProject)this.m_graph.getBPELProject(), false, true));
        ds.addDataSource((TreeExplorerDataSource)new ProjectWSDLDataSource(this.m_graph.getBPELProject(), false, true, false));
        if (chooser.display((TreeExplorerDataSource)ds, true) == 0) {
            this.m_typeObj = chooser.getTypeObject();
            this.m_nsField.setText(this.m_typeObj.getQName().getNamespaceURI());
            this.m_nsField.setToolTipText(this.m_nsField.getText());
            this.m_keyField.setText(this.m_typeObj.getQName().getLocalPart());
            this.m_keyField.setToolTipText(this.m_keyField.getText());
            this.firePropertyChange(EXPR_CHANGED, null, this.m_typeObj);
        }
    }

    protected void handleVariableDataBrowse() {
        KeyBuilder builder = new KeyBuilder(GraphUtils.getFrame((Component)this), this.m_graph);
        VariableXPathBuilderPanel panel = builder.getPanel();
        if (this.m_var != null) {
            panel.selectVariable(this.m_var.getName(), (Activity)this.m_bind);
        }
        builder.setTitle(BPELStringTranslator.getString("BIND_BROWSE_VAR_TITLE", "Browse Entity Variable"));
        ProcessExplorer ex = panel.getProcessExplorer();
        if (this.m_var != null) {
            VariablesFilter filter = new VariablesFilter(){

                @Override
                public boolean canDisplayVariable(Variable var) {
                    return var.getName().equals(BindKeyPanel.this.m_var.getName());
                }
            };
            ex.getExplorerTree().setVariablesFilter(filter);
        }
        if (builder.display((Activity)this.m_bind) == 0) {
            ExplorerTreeNode n = ex.getExplorerTree().getSelectedExplorerTreeNode();
            Element elem = (Element)n.m_data;
            String schemaType = elem.getAttribute("schemaType");
            if (schemaType.equalsIgnoreCase("xsd:element")) {
                String nsValue = XMLHelper.getAttribute((Element)elem, (String)"namespace");
                String local = XMLHelper.getAttribute((Element)elem, (String)"localName");
                this.m_nsField.setText(nsValue);
                this.m_keyField.setText(local);
                this.m_nsField.setToolTipText(this.m_nsField.getText());
                this.m_keyField.setToolTipText(this.m_keyField.getText());
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_exprBuilderBtn) {
            this.handleExprBuild();
        } else if (src == this.m_keyBrowseBtn) {
            this.handleKeyBrows();
        } else if (src == this.m_varBrowseBtn) {
            this.handleVariableDataBrowse();
        }
    }

    protected void handleExprBuild() {
        this.m_page.handleGraphicBuilderForTextField(this.m_exprField);
    }

    class TypeChooserForKey
    extends TypeChooser {
        TypeChooserForKey(JFrame f) {
            super(f);
        }

        public TypeObject getTypeObject() {
            DefaultTreeExplorerTreeNode node = this.getTypeExplorer().getSelectedNode();
            if (node instanceof EntityKeyExplorerTreeNode) {
                EntityKeyExplorerTreeNode keyNode = (EntityKeyExplorerTreeNode)node;
                return (TypeObject)keyNode.getDataValue("TYPE_DATA_VALUE_KEY");
            }
            return null;
        }

        public void handleOK() {
            DefaultTreeExplorerTreeNode node = this.getTypeExplorer().getSelectedNode();
            if (node instanceof EntityKeyExplorerTreeNode) {
                this.m_retVal = 0;
                this.dispose();
            }
        }
    }

    class KeyBuilder
    extends VariableXPathBuilder {
        public KeyBuilder(JFrame f, BPELGraphPane graph) {
            super(f, graph);
        }

        public VariableXPathBuilderPanel getPanel() {
            return this.m_builderPanel;
        }
    }
}

