/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.xml.namespace.QName;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.Bind;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.KeyValue;
import oracle.tip.tools.ide.common.bpelparser.iface.Variable;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.editors.BindEditPage;
import oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.editors.BindKeyPanel;
import oracle.tip.tools.ide.pm.gui.generalpurpose.BPELBaseDialog;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;

public class BindKeyDialog
extends BPELBaseDialog
implements ActionListener,
PropertyChangeListener {
    public static final int OK = 0;
    public static final int CANCEL = 1;
    private JButton m_okBtn;
    private JButton m_cancelBtn;
    protected JButton m_helpBtn;
    protected BindKeyPanel m_keyPanel;
    protected BPELGraphPane m_graph;
    protected int m_retVal = 1;
    protected boolean m_bEditing = false;
    protected BindEditPage m_page;
    protected Bind m_bind;
    protected Variable m_var;

    public BindKeyDialog(JFrame f, BPELGraphPane graph, BindEditPage page, Bind bind, Variable var) {
        super(f, BPELStringTranslator.getString("BIND_KEY_DLG", "Key"), true);
        this.m_graph = graph;
        this.m_page = page;
        this.m_bind = bind;
        this.m_var = var;
        this.createAndLayoutControls();
        this.updateButtons();
    }

    public void saveToModel() {
        this.m_keyPanel.saveToModel();
    }

    public KeyValue getKeyValue() {
        return this.m_keyPanel.getKeyValue();
    }

    public int create() {
        this.m_bEditing = false;
        this.setTitle(BPELStringTranslator.getString("BIND_CREATE_KEY_DLG", "Specify Key"));
        return this.display();
    }

    public int create(String expre, QName key) {
        this.m_bEditing = false;
        this.m_keyPanel.setKeyValue(expre, key);
        return this.display();
    }

    public int edit(KeyValue p) {
        this.m_bEditing = true;
        this.setTitle(BPELStringTranslator.getString("BIND_EDIT_KEY_DLG", "Specify Key"));
        this.m_keyPanel.setKeyValue(p);
        return this.display();
    }

    private int display() {
        this.setSize(600, 220);
        this.setVisible(true);
        return this.m_retVal;
    }

    protected void createAndLayoutControls() {
        this.m_keyPanel = new BindKeyPanel(this.m_graph, this.m_page, this.m_bind, this.m_var);
        this.m_keyPanel.addPropertyChangeListener(this);
        this.m_okBtn = new JButton();
        BPELStringTranslator.setButton(this.m_okBtn, BPELStringTranslator.getString("OK_BUTTON_TEXT_RES"));
        this.m_okBtn.addActionListener(this);
        this.m_cancelBtn = new JButton();
        BPELStringTranslator.setButton(this.m_cancelBtn, BPELStringTranslator.getString("CANCEL_BUTTON_TEXT_RES"));
        this.m_cancelBtn.addActionListener(this);
        this.m_helpBtn = new JButton();
        BPELStringTranslator.setButton(this.m_helpBtn, BPELStringTranslator.getString("HELP_BUTTON_TEXT_RES"));
        this.m_helpBtn.addActionListener(this);
        JPanel btnPnl = new JPanel(new GridLayout(1, 2, 5, 0));
        btnPnl.add(this.m_okBtn);
        btnPnl.add(this.m_cancelBtn);
        Container c = this.getContentPane();
        c.setLayout(new GridBagLayout());
        int row = 0;
        GraphUtils.addComponent((Container)c, (Component)this.m_keyPanel, (int)0, (int)row++, (int)2, (int)1, (int)18, (int)1, (Insets)new Insets(10, 10, 10, 10), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)c, (Component)this.m_helpBtn, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 10, 10, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)c, (Component)btnPnl, (int)1, (int)row++, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(0, 5, 10, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        this.setSize(350, 225);
        this.setLocationRelativeTo(this.getParent());
    }

    protected void updateButtons() {
        this.m_okBtn.setEnabled(this.m_keyPanel.isDataValid());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_okBtn) {
            String origExpr;
            if (!this.m_keyPanel.isDataValid()) {
                GraphUtils.displayMessage((Component)((Object)this), (String)BPELStringTranslator.getString("ERROR_INVALID_KEY_DATA", "Key data are not valid!"), (int)0);
                return;
            }
            String expr = this.m_keyPanel.m_exprField.getText().trim();
            if (expr == null || expr.length() == 0) {
                GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)((Object)this)), (String)BPELStringTranslator.getString("EDITOR_INVALID_NAME"));
                return;
            }
            if (this.m_bEditing ? (origExpr = this.m_keyPanel.getKeyValue().getValue()) != null && !origExpr.equals(expr) && this.doesKeyExist(expr) : this.doesKeyExist(expr)) {
                return;
            }
            this.m_keyPanel.saveToModel();
            this.m_retVal = 0;
            this.dispose();
        } else if (src == this.m_cancelBtn) {
            this.handleCancel();
        } else if (src == this.m_helpBtn) {
            this.helpInvoked();
        }
    }

    protected boolean doesKeyExist(String name) {
        return false;
    }

    protected void handleCancel() {
        this.m_retVal = 1;
        this.dispose();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object src = evt.getSource();
        if (src == this.m_keyPanel) {
            this.updateButtons();
        }
    }

    protected void helpInvoked() {
        this.handleHelp(this.m_keyPanel);
    }
}

