/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.xml.namespace.QName;
import oracle.ide.util.ModelUtil;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.Bind;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.KeyValue;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Scope;
import oracle.tip.tools.ide.common.bpelparser.iface.Variable;
import oracle.tip.tools.ide.common.bpelparser.iface.Variables;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ui.GlobalImageCache;
import oracle.tip.tools.ide.common.xpath.editor.XPathEditorPane;
import oracle.tip.tools.ide.pm.bpelgraph.editors.BaseEditingPage;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariablesFilter;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.EditorPage;
import oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.editors.KeysEditPanel;
import oracle.tip.tools.ide.pm.gui.dialogs.choosers.variable.VariableChooser;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;

public class BindEditPage
extends BaseEditingPage
implements EditorPage,
ActionListener {
    protected JTextField m_nameField;
    protected JTextField m_variablelField;
    protected JButton m_varBrowseBtn;
    protected KeysEditPanel m_panel;
    protected Variable m_var;
    protected Bind m_bind_activity;

    public BindEditPage(BPELGraphPane graphPane) {
        super(graphPane);
        this.createControls();
        this.layoutControls();
    }

    @Override
    public void loadData() {
        this.setModified(true);
    }

    protected void createControls() {
        this.m_nameField = new JTextField();
        this.m_variablelField = new JTextField();
        this.m_variablelField.setEditable(false);
        this.m_varBrowseBtn = new JButton(GlobalImageCache.getIcon((String)"browse16"));
        this.m_varBrowseBtn.setToolTipText(BPELStringTranslator.getString("GENERAL_BROWSE_VARS"));
        this.m_varBrowseBtn.addActionListener(this);
        this.m_panel = new KeysEditPanel(this.m_graphPane, this, this.m_var);
    }

    protected void layoutControls() {
        JToolBar varTB = new JToolBar();
        varTB.setBorderPainted(false);
        varTB.add(this.m_varBrowseBtn);
        JLabel lblName = new JLabel();
        BPELStringTranslator.setLabel(lblName, this.m_nameField, BPELStringTranslator.getString("GENERAL_EDITOR_NAME"));
        JLabel lblTS = new JLabel();
        BPELStringTranslator.setLabel(lblTS, this.m_variablelField, BPELStringTranslator.getString("BIND_ENTITY_VARIABLE", "Entity &Variable:"));
        this.setLayout(new GridBagLayout());
        int row = 0;
        GraphUtils.addComponent((Container)this, (Component)lblName, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(10, 10, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_nameField, (int)1, (int)row++, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(10, 0, 5, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)lblTS, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 10, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_variablelField, (int)1, (int)row, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(0, 0, 5, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)varTB, (int)2, (int)row++, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 5, 5, 10), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_panel, (int)0, (int)row++, (int)3, (int)1, (int)18, (int)1, (Insets)new Insets(0, 10, 0, 10), (int)0, (int)0, (double)1.0, (double)1.0);
    }

    @Override
    public void setUserObject(Object model) {
        super.setUserObject(model);
        this.m_bind_activity = (Bind)model;
        this.loadControls();
    }

    protected void loadControls() {
        if (this.m_bind_activity == null) {
            return;
        }
        if (this.m_bind_activity.getName() != null) {
            this.m_nameField.setText(this.m_bind_activity.getName());
        }
        if (this.m_bind_activity.getVariable() != null) {
            this.m_variablelField.setText(this.m_bind_activity.getVariable());
            this.m_var = BindEditPage.findVariable((Scope)this.m_processModel, this.m_bind_activity.getVariable());
        }
        this.m_panel.load(this.m_bind_activity);
        this.m_panel.setVariable(this.m_var);
    }

    @Override
    public boolean validateEditorChanges() {
        if (!ModelUtil.hasLength((String)this.m_nameField.getText())) {
            GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)this), (String)BPELStringTranslator.getString("GENERAL_EDITOR_NAME_ERROR"), (String)BPELStringTranslator.getString("GENERAL_EDITOR_ERROR"), (int)2);
            return false;
        }
        return true;
    }

    @Override
    public void saveChanges() {
        if (this.m_bind_activity == null) {
            return;
        }
        this.m_bind_activity.setName(this.m_nameField.getText());
        this.m_bind_activity.setVariable(this.m_variablelField.getText());
        Vector lst = this.m_panel.getKeys();
        Vector keys = this.m_bind_activity.getKeyValues();
        if (keys != null) {
            keys.clear();
        }
        for (KeyValue v : lst) {
            QName qname = v.getName();
            String prefix = this.m_graphModel.getProcess().addNamespace(qname.getNamespaceURI());
            qname = new QName(qname.getNamespaceURI(), qname.getLocalPart(), prefix);
            v.setName(qname);
            keys.add(v);
        }
        this.m_bind_activity.setKeyValues(keys);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_varBrowseBtn) {
            this.handleVariableBrowse();
        }
    }

    protected void handleVariableBrowse() {
        VariablesFilter filter = new VariablesFilter(){

            @Override
            public boolean canDisplayVariable(Variable var) {
                String plink = var.getPartnerlink();
                return plink != null && plink.length() > 0;
            }
        };
        VariableChooser dlg = new VariableChooser(GraphUtils.getFrame((Component)this), this.m_graphPane, (Activity)this.m_bind_activity, filter);
        dlg.setTitle(BPELStringTranslator.getString("BIND_ENTITY_BROWSE_VARIABLES", "Browse Variables"));
        if (dlg.display() == 0) {
            Variable v = dlg.getSelectedVariable();
            if (v != null) {
                this.m_variablelField.setText(v.getName());
            } else {
                this.m_variablelField.setText("");
            }
            this.m_var = v;
            this.m_panel.setVariable(v);
        }
    }

    public void handleGraphicBuilderForTextField(JTextField textField) {
        XPathEditorPane x = new XPathEditorPane();
        String inStr = textField.getText();
        if (inStr != null) {
            x.setText(inStr);
        }
        this.invokeGraphicalXPathBuilder(x, (Activity)this.m_bind_activity);
        String s = x.getText();
        if (Helper.hasValue((String)s)) {
            textField.setText(s);
        }
    }

    public static Variable findVariable(Scope scope, String varName) {
        Variable var;
        if (scope == null || varName == null) {
            return null;
        }
        Variables list = scope.getVariables();
        for (Variable o : list.getVariables()) {
            var = o;
            if (!var.getName().equals(varName)) continue;
            return var;
        }
        for (Activity a : scope.getActivityList()) {
            if (!(a instanceof Scope) || (var = BindEditPage.findVariable((Scope)a, varName)) == null) continue;
            return var;
        }
        return null;
    }
}

