/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.designerplugins.adapterservice.plugin.configurators;

import java.awt.Frame;
import java.net.URL;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import oracle.ide.model.Project;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.ide.bpel.BPELProject;
import oracle.tip.tools.ide.fabric.api.EndpointInfo;
import oracle.tip.tools.ide.fabric.api.InterfaceInfo;
import oracle.tip.tools.ide.fabric.api.SCAController;
import oracle.tip.tools.ide.fabric.api.SCAEndpoint;
import oracle.tip.tools.ide.fabric.api.WsdlInfo;
import oracle.tip.tools.ide.fabric.config.AdapterType;
import oracle.tip.tools.ide.fabric.config.SCAConfig;
import oracle.tip.tools.ide.fabric.resource.SCAComponentRegistry;
import oracle.tip.tools.ide.pm.addin.folders.custom.ServiceInfo;
import oracle.tip.tools.ide.pm.designerplugins.adapterservice.plugin.AbstractServiceConfigurator;
import oracle.tip.tools.ide.pm.ide.bpel.jdeveloper.JDevBPELProject;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.AdapterWsdlInfo;
import oracle.tip.tools.ide.pm.modules.sca.util.JDevSCAIntegrationUtil;
import oracle.tip.tools.ide.pm.plugin.palette.BpelPaletteItem;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class ScaAdapterServiceConfigurator
extends AbstractServiceConfigurator {
    public static final String ADF_BC_SERVICE = "ADF_BC_Service";
    public static final String EJB_SERVICE = "EJB_Service";
    public static final String SOAP_SERVICE = "Soap_Service";
    public static final String ADF_BC_TYPE = "adf";
    public static final String EJB_TYPE = "ejb";
    public static final String SOAP_TYPE = "ws";
    public static List<String> TYPES = Arrays.asList("adf", "ejb", "ws");
    private static Hashtable<String, String> BINDING_TYPE_MAP = new Hashtable();
    private static Hashtable<String, String> ICON_MAP = new Hashtable();
    private static Hashtable<String, String> DESC_MAP = new Hashtable();
    SCAEndpoint m_scaEndpoint = null;
    WsdlInfo m_wsdlInfo = null;
    EndpointInfo m_endpointInfo;
    String m_service_name = null;
    String m_scaName = null;
    boolean m_isRef = true;

    public ScaAdapterServiceConfigurator(String name) {
        this.m_scaName = name;
    }

    public ScaAdapterServiceConfigurator(BpelPaletteItem item) {
        this.m_scaName = item.getName();
        this.m_name = item.getName();
        this.m_type = item.getName();
        this.m_icon = ImageCache.getIcon(item.getIcon());
        this.m_desc = item.getDescription();
    }

    @Override
    public void display(Frame frame, String updateWSDL, BPELProject proj) {
        try {
            if (this.m_scaEndpoint == null) {
                this.m_scaEndpoint = SCAComponentRegistry.getInstance().getSCAAdapterInstance(this.m_scaName, null);
            }
            SCAController controller = JDevSCAIntegrationUtil.getSCAController(proj);
            Project pro = (Project)proj.getProjectContext();
            if (updateWSDL == null) {
                boolean isExternalReference = true;
                if (this.m_scaName.equalsIgnoreCase("Direct Binding Service")) {
                    isExternalReference = false;
                }
                this.m_endpointInfo = this.m_scaEndpoint.createImplementation(pro, controller, isExternalReference);
            } else {
                this.m_scaEndpoint.setInterfaceInfo(pro, controller, this.m_service_name, (InterfaceInfo)this.m_wsdlInfo, this.m_isRef);
                this.m_endpointInfo = this.m_scaEndpoint.displayServiceEditor();
            }
            if (this.m_endpointInfo == null) {
                this.m_serviceInfo = null;
                return;
            }
            this.m_service_name = this.m_endpointInfo.getServiceName();
            this.m_isRef = !this.m_endpointInfo.isInboundService();
            WsdlInfo wsdlInfo = this.m_endpointInfo.getWsdlInfo();
            if (wsdlInfo != null) {
                this.m_serviceInfo = new ServiceInfo(wsdlInfo.getWsdlURL(pro), this.m_service_name, false);
                AdapterWsdlInfo awc = null;
                if (!(this.m_endpointInfo instanceof AdapterWsdlInfo)) {
                    PartnerLink p = JDevSCAIntegrationUtil.getPartnerlinkFromWSDLInfo(wsdlInfo, this.m_service_name, (JDevBPELProject)proj, null, null, null);
                    wsdlInfo.setWsdlLocation(p.getWSDLLocation());
                    awc = new AdapterWsdlInfo(pro, this.m_service_name, !this.m_isRef, wsdlInfo, this.m_endpointInfo.getServiceType(), this.m_endpointInfo.getAdapterSubType());
                    awc._service_name = this.m_service_name;
                    if (this.m_isRef) {
                        awc._partner_portType_name = wsdlInfo.getRequestPorttype().getLocalPart();
                        awc._partner_role_name = p.getPartnerRole();
                        if (wsdlInfo.getReplyPorttype() != null) {
                            awc._my_portType_name = wsdlInfo.getReplyPorttype().getLocalPart();
                            awc._my_role_name = p.getMyRole();
                        }
                    } else {
                        awc._my_portType_name = wsdlInfo.getRequestPorttype().getLocalPart();
                        awc._my_role_name = p.getPartnerRole();
                        if (wsdlInfo.getReplyPorttype() != null) {
                            awc._partner_portType_name = wsdlInfo.getReplyPorttype().getLocalPart();
                            awc._partner_role_name = p.getMyRole();
                        }
                    }
                } else {
                    awc = (AdapterWsdlInfo)this.m_endpointInfo;
                }
                this.m_serviceInfo.setParameter((Object)awc);
                awc._adapter_type_icon = this.m_icon;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean typeMatchs(Object ctx, URL wsdlURL, String procName, String plName) {
        try {
            List list;
            Project pro = (Project)ctx;
            SCAController controller = JDevSCAIntegrationUtil.getSCAController(pro);
            this.m_isRef = !JDevSCAIntegrationUtil.isService(pro, procName, plName);
            List list2 = list = this.m_isRef ? controller.getComponentReferenceTarget(procName, plName) : controller.getComponentServiceSources(procName, plName);
            if (list != null) {
                for (String name : list) {
                    EndpointInfo endPoint = controller.getEndpointInfo(name);
                    if (endPoint == null) continue;
                    String type = controller.getEndpointBindingType(name);
                    AdapterType a = SCAConfig.getSCAConfig().getAdapterTypeByBindingType(type);
                    if (a != null && !this.m_type.equals(a.getName())) continue;
                    this.m_service_name = name;
                    this.m_wsdlInfo = endPoint.getWsdlInfo();
                    return true;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean typeMatchs(String type) {
        return this.m_type.toLowerCase().contains(type.toLowerCase());
    }

    static {
        BINDING_TYPE_MAP.put(ADF_BC_SERVICE, ADF_BC_TYPE);
        ICON_MAP.put(ADF_BC_SERVICE, "palette/adapterservice/adf_bc_palette.png");
        DESC_MAP.put(ADF_BC_SERVICE, ADF_BC_SERVICE);
        BINDING_TYPE_MAP.put(EJB_SERVICE, EJB_TYPE);
        ICON_MAP.put(EJB_SERVICE, "palette/adapterservice/ejb_palette.png");
        DESC_MAP.put(EJB_SERVICE, EJB_SERVICE);
    }
}

