/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.designerplugins.adapterservice.plugin;

import java.awt.Component;
import java.awt.Point;
import java.awt.dnd.DropTargetDropEvent;
import java.net.URL;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.ide.palette2.PaletteItem;
import oracle.jdevimpl.webservices.wizard.jaxrpc.BottomUpWizard;
import oracle.jdevimpl.webservices.wizard.jaxrpc.PLSQLWizard;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.Scope;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.graph.view.DNDDropHandler;
import oracle.tip.tools.ide.common.graph.view.GraphPane;
import oracle.tip.tools.ide.common.graph.view.NodeRenderer;
import oracle.tip.tools.ide.common.jdev.JDevHelper;
import oracle.tip.tools.ide.pm.addin.folders.custom.ServiceInfo;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELDNDDropHandler;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.SwimLaneView;
import oracle.tip.tools.ide.pm.designerplugins.adapterservice.plugin.AdapterServiceConstants;
import oracle.tip.tools.ide.pm.designerplugins.adapterservice.plugin.ScaAdapterPaletteItem;
import oracle.tip.tools.ide.pm.designerplugins.adapterservice.plugin.ScaAdapterPalettePlugin;
import oracle.tip.tools.ide.pm.designerplugins.adapterservice.plugin.configurators.ScaAdapterServiceConfigurator;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.techAdapterWizard;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.AdapterWsdlInfo;
import oracle.tip.tools.ide.pm.plugin.palette.BpelPaletteItem;

public class AdapterDNDDropHandler
implements DNDDropHandler {
    BPELGraphPane m_graphPane_;

    public boolean handleDrop(DropTargetDropEvent e, Object data, GraphPane pane) {
        this.m_graphPane_ = (BPELGraphPane)pane;
        BPELGraphModel model = (BPELGraphModel)this.m_graphPane_.getModel();
        Process process = model.getProcess();
        String taskName = BPELDNDDropHandler.getTaskNameFromDropData(data);
        Point pt = this.m_graphPane_.inDrillDownMode() ? e.getLocation() : pane.convertToNonScaledTranslatedCoordinates(e.getLocation());
        int x = pt.x;
        int y = pt.y;
        NodeRenderer r = pane.getNodeRendererAtPosition(x, y);
        if (r instanceof SwimLaneView && (AdapterServiceConstants.validTaskName(taskName) || ScaAdapterPaletteItem.isInAdapterPaletteSection(data))) {
            ServiceInfo info = null;
            if (taskName.equalsIgnoreCase("Java Web Service") || taskName.equalsIgnoreCase("EJB Web Service")) {
                info = this.handleJDevJavaWebSvc();
            } else if (taskName.equalsIgnoreCase("PL SQL Web Service")) {
                info = this.handlePLSQLWebSvc();
            } else if (ScaAdapterPaletteItem.isInAdapterPaletteSection(data)) {
                info = this.handleScaEndpoint(this.m_graphPane_, (PaletteItem)data);
            } else {
                String adapterType = AdapterServiceConstants.getAdapterTypeName(taskName);
                if (adapterType != null) {
                    info = this.handleAdapterWebSvc(this.m_graphPane_, adapterType, taskName);
                } else {
                    GraphUtils.displayMessage((Component)((Object)this.m_graphPane_), (String)"Invalid Adapter Type", (int)0);
                }
            }
            if (info != null && info.getWSDLURL() != null && URLFileSystem.exists((URL)info.getWSDLURL())) {
                String iconName = AdapterDNDDropHandler.getIconNameOnly(taskName);
                PartnerLink pl = this.m_graphPane_.createPartnerLink((SwimLaneView)r, pt, (Scope)process, info.getWSDLURL().toString(), iconName, info.getParameter());
                if (pl != null) {
                    String wsdlLoc = pl.getWSDLLocation();
                    try {
                        URL url = new URL(wsdlLoc);
                        if (!info.getWSDLURL().equals(url)) {
                            info.addServiceFile(url);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
            return true;
        }
        return false;
    }

    protected ServiceInfo handleJDevJavaWebSvc() {
        ServiceInfo info = null;
        BottomUpWizard wz = new BottomUpWizard();
        wz.runWizard(false, false);
        if (wz.getModel() != null) {
            URL wsdlURL = wz.getModel().getLocalWSDL();
            String serviceName = this.extractWSDLName(wsdlURL);
            info = new ServiceInfo(wsdlURL, serviceName);
            info.setIconName("webservice_palette.png");
            List list = wz.getModel().getWsdlDependentFiles();
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    System.out.println("Dependency=" + list.get(i));
                }
            }
        }
        return info;
    }

    protected ServiceInfo handlePLSQLWebSvc() {
        ServiceInfo info = null;
        PLSQLWizard wz = new PLSQLWizard(false);
        Context context = JDevHelper.getContext((Project)((Project)this.m_graphPane_.getBPELProject().getProjectContext()));
        wz.runWizard(context, false, false);
        if (wz.getModel() != null) {
            URL wsdlURL = wz.getModel().getWSDLFile();
            String serviceName = this.extractWSDLName(wsdlURL);
            info = new ServiceInfo(wsdlURL, serviceName);
            info.setIconName("PLSQLWebService_palette.png");
        }
        return info;
    }

    protected ServiceInfo handleAdapterWebSvc(BPELGraphPane graph, String adapterType, String taskName) {
        ServiceInfo info = null;
        try {
            techAdapterWizard wizard = new techAdapterWizard(GraphUtils.getFrame((Component)((Object)graph)), null, adapterType);
            wizard.display();
            AdapterWsdlInfo awc = wizard.getAdapterWsdlInfo();
            if (awc != null) {
                info = new ServiceInfo(awc._wsdlFileURL, awc._service_name, false);
                info.setIconName(AdapterDNDDropHandler.getIconName(taskName));
                info.setParameter((Object)awc);
                List list = wizard.getURLs();
                if (list != null) {
                    for (int i = 0; i < list.size(); ++i) {
                        info.addServiceFile((URL)list.get(i));
                    }
                }
            }
        }
        catch (Exception ex) {
            GraphUtils.displayMessage((Component)((Object)graph), (String)BPELStringTranslator.formatString("EDITOR_PLE_WSDL_EXCEPTION", new Object[]{ex.getMessage()}), (int)0);
        }
        return info;
    }

    public static String getIconName(String s) {
        if (ScaAdapterPalettePlugin.isScaAdapterPaletteItem(s)) {
            String iconName = ScaAdapterPalettePlugin.getScaAdapterPaletteItem(s).getIcon();
            return iconName;
        }
        if (s.equalsIgnoreCase("File_Adapter")) {
            return "palette/adapterservice/file_adapter_palette.png";
        }
        if (s.equalsIgnoreCase("FTP_Adapter")) {
            return "palette/adapterservice/ftp_adapter_palette.png";
        }
        if (s.equalsIgnoreCase("Database_Adapter")) {
            return "palette/adapterservice/db_adapter_palette.png";
        }
        if (s.equalsIgnoreCase("AQ_Adapter")) {
            return "palette/adapterservice/aq_adapter_palette.png";
        }
        if (s.equalsIgnoreCase("Oracle_Applications")) {
            return "palette/adapterservice/oracle_applications_palette.png";
        }
        if (s.equalsIgnoreCase("JMS_Adapter")) {
            return "palette/adapterservice/jms_adapter_palette.png";
        }
        if (s.equalsIgnoreCase("MQ_Adapter")) {
            return "palette/adapterservice/mq_adapter_palette.png";
        }
        if (s.equalsIgnoreCase("Socket_Adapter")) {
            return "palette/adapterservice/socket_adapter_palette.png";
        }
        if (s.equalsIgnoreCase("BAM_Adapter")) {
            return "palette/adapterservice/mq_adapter_palette.png";
        }
        if (s.equalsIgnoreCase("Java Web Service") || s.equalsIgnoreCase("EJB Web Service")) {
            return "palette/adapterservice/webservice_palette.png";
        }
        if (s.equalsIgnoreCase("PL SQL Web Service")) {
            return "palette/adapterservice/PLSQLWebService_palette.png";
        }
        if (s.equalsIgnoreCase("B2B")) {
            return "palette/adapterservice/b2b_palette.png";
        }
        return null;
    }

    private static String getIconNameOnly(String s) {
        if (ScaAdapterPalettePlugin.isScaAdapterPaletteItem(s)) {
            String iconName = ScaAdapterPalettePlugin.getScaAdapterPaletteItem(s).getIcon();
            return iconName;
        }
        if (s.equalsIgnoreCase("File_Adapter")) {
            return "file_adapter_palette.png";
        }
        if (s.equalsIgnoreCase("FTP_Adapter")) {
            return "ftp_adapter_palette.png";
        }
        if (s.equalsIgnoreCase("Database_Adapter")) {
            return "db_adapter_palette.png";
        }
        if (s.equalsIgnoreCase("AQ_Adapter")) {
            return "aq_adapter_palette.png";
        }
        if (s.equalsIgnoreCase("Oracle_Applications")) {
            return "oracle_applications_palette.png";
        }
        if (s.equalsIgnoreCase("JMS_Adapter")) {
            return "jms_adapter_palette.png";
        }
        if (s.equalsIgnoreCase("MQ_Adapter")) {
            return "mq_adapter_palette.png";
        }
        if (s.equalsIgnoreCase("Socket_Adapter")) {
            return "socket_adapter_palette.png";
        }
        if (s.equalsIgnoreCase("BAM_Adapter")) {
            return "mq_adapter_palette.png";
        }
        if (s.equalsIgnoreCase("B2B")) {
            return "b2b_palette.png";
        }
        if (s.equalsIgnoreCase("Java Web Service") || s.equalsIgnoreCase("EJB Web Service")) {
            return "webservice_palette.png";
        }
        if (s.equalsIgnoreCase("PL SQL Web Service")) {
            return "PLSQLWebService_palette.png";
        }
        return null;
    }

    private String extractWSDLName(URL wsdlURL) {
        String wsdlStr = URLFileSystem.getFileName((URL)wsdlURL);
        if (wsdlStr != null && wsdlStr.endsWith(".wsdl")) {
            wsdlStr = wsdlStr.substring(0, wsdlStr.length() - 5);
        }
        return wsdlStr;
    }

    protected ServiceInfo handleScaEndpoint(BPELGraphPane graph, PaletteItem item) {
        ServiceInfo info = null;
        try {
            BpelPaletteItem bItem = ScaAdapterPalettePlugin.getScaAdapterPaletteItem(item.getName());
            ScaAdapterServiceConfigurator c = new ScaAdapterServiceConfigurator(bItem);
            c.display(GraphUtils.getFrame((Component)((Object)graph)), null, graph.getBPELProject());
            info = c.getServiceInfo();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return info;
    }
}

