/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.designerplugins.adapterservice.plugin;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import oracle.bali.xml.metadata.standalone.OracleStandaloneMetadataFactory;
import oracle.bali.xml.metadata.standalone.StandaloneMetadataFile;
import oracle.bali.xml.metadata.standalone.StandaloneMetadataFileException;
import oracle.bali.xml.metadata.standalone.StandaloneMetadataFileRegistry;
import oracle.bali.xml.model.datatransfer.XmlTransferUtils;
import oracle.ide.palette2.PaletteItem;
import oracle.tip.tools.ide.pm.addin.BPELAddin;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPaneDropTargetListener;
import oracle.tip.tools.ide.pm.designerplugins.adapterservice.plugin.AdapterDNDDropHandler;
import oracle.tip.tools.ide.pm.designerplugins.adapterservice.plugin.AdapterDragListener;
import oracle.tip.tools.ide.pm.designerplugins.adapterservice.plugin.ScaAdapterPalettePlugin;
import oracle.tip.tools.ide.pm.designerplugins.adapterservice.plugin.configurators.ScaAdapterServiceConfigurator;
import oracle.tip.tools.ide.pm.plugin.AbstractBPELModelerPlugin;
import oracle.tip.tools.ide.pm.plugin.ServiceConfigurator;
import oracle.tip.tools.ide.pm.plugin.palette.BpelPaletteItem;
import oracle.tip.tools.ide.pm.plugin.palette.PalettePlugin;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class AdapterBPELModelerPlugin
extends AbstractBPELModelerPlugin {
    private static final String ADAPTER_PALETTE_SCHEMA = "documents/adapterservice/adapterservice.xsd";

    @Override
    public void registerMetaDataFiles(Object obj) {
        try {
            StandaloneMetadataFileRegistry registry = (StandaloneMetadataFileRegistry)obj;
            URL url = BPELAddin.class.getResource("documents/adapterservice/adapterservice_metadata.xml");
            StandaloneMetadataFile file = OracleStandaloneMetadataFactory.createStandaloneMetadataFile((URL)url);
            registry.addStandaloneMetadataFile(file);
        }
        catch (StandaloneMetadataFileException e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<URL> getSchemaGrammers() {
        ArrayList<URL> schemas = new ArrayList<URL>();
        schemas.add(BPELAddin.class.getResource(ADAPTER_PALETTE_SCHEMA));
        return schemas;
    }

    @Override
    public void registerDNDHandler(BPELGraphPaneDropTargetListener dropTargetListener, BPELGraphPane graph) {
        dropTargetListener.registerDNDHandler(new AdapterDNDDropHandler(), XmlTransferUtils.FLAVOR_XMLKEY);
        dropTargetListener.registerDNDHandler(new AdapterDNDDropHandler(), PaletteItem.PALETTE_ITEM_FLAVOR);
        dropTargetListener.addDragListener(new AdapterDragListener());
    }

    @Override
    public List<ServiceConfigurator> getServiceConfigurators() {
        ArrayList<ServiceConfigurator> list = new ArrayList<ServiceConfigurator>();
        for (BpelPaletteItem item : ScaAdapterPalettePlugin.getItems(null)) {
            ScaAdapterServiceConfigurator s = new ScaAdapterServiceConfigurator(item);
            list.add(s);
        }
        return list;
    }

    @Override
    public Icon getDragIconForActivity(String name) {
        if (ScaAdapterPalettePlugin.isScaAdapterPaletteItem(name)) {
            String iconName = ScaAdapterPalettePlugin.getScaAdapterPaletteItem(name).getIcon();
            return ImageCache.getIcon(iconName);
        }
        if (name.equalsIgnoreCase("AQ_Adapter")) {
            return ImageCache.getIcon("palette/adapterservice/aq_adapter_palette.png");
        }
        if (name.equalsIgnoreCase("B2B")) {
            return ImageCache.getIcon("palette/adapterservice/b2b_palette.png");
        }
        if (name.equalsIgnoreCase("BAM_Adapter")) {
            return ImageCache.getIcon("palette/adapterservice/mq_adapter_palette.png");
        }
        if (name.equalsIgnoreCase("Database_Adapter")) {
            return ImageCache.getIcon("palette/adapterservice/db_adapter_palette.png");
        }
        if (name.equalsIgnoreCase("File_Adapter")) {
            return ImageCache.getIcon("palette/adapterservice/file_adapter_palette.png");
        }
        if (name.equalsIgnoreCase("FTP_Adapter")) {
            return ImageCache.getIcon("palette/adapterservice/ftp_adapter_palette.png");
        }
        if (name.equalsIgnoreCase("JMS_Adapter")) {
            return ImageCache.getIcon("palette/adapterservice/jms_adapter_palette.png");
        }
        if (name.equalsIgnoreCase("MQ_Adapter")) {
            return ImageCache.getIcon("palette/adapterservice/mq_adapter_palette.png");
        }
        if (name.equalsIgnoreCase("Socket_Adapter")) {
            return ImageCache.getIcon("palette/adapterservice/socket_adapter_palette.png");
        }
        if (name.equalsIgnoreCase("Oracle_Applications")) {
            return ImageCache.getIcon("palette/adapterservice/oracle_applications_palette.png");
        }
        return null;
    }

    @Override
    public PalettePlugin getPalettePalettePlugin() {
        return new ScaAdapterPalettePlugin();
    }
}

