/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.designerplugins.activityguide.plugin;

import oracle.tip.tools.ide.common.bpelparser.extension.activityguide.ActivityGuide;
import oracle.tip.tools.ide.common.bpelparser.extension.activityguide.ActivityGuideProcess;
import oracle.tip.tools.ide.common.bpelparser.extension.activityguide.impl.ActivityGuideProcessImpl;
import oracle.tip.tools.ide.common.bpelparser.extension.plugin.BPELParserExtensionConstants;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.BPELParserConstants;
import oracle.tip.tools.ide.common.bpelparser.iface.ParserContext;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.plugin.BPELParserPlugin;
import oracle.tip.tools.ide.common.bpelparser.util.XMLHelper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ActivityGuideParserExtensionsPlugin
implements BPELParserPlugin,
BPELParserConstants,
BPELParserExtensionConstants {
    public String getActivityXPathName(Activity a) {
        switch (a.getTypeID()) {
            case 310: {
                return "activityguide";
            }
        }
        return null;
    }

    public String getActivityTypeName(Activity a) {
        switch (a.getTypeID()) {
            case 310: {
                return "ActivityGuide";
            }
        }
        return null;
    }

    public Activity getActivityForDOMElement(Element e, ParserContext ct) {
        ActivityGuide activity = null;
        Process process = ct.getProcess();
        String tagName = XMLHelper.getTagLocalName((Element)e);
        if (tagName.equalsIgnoreCase("scope") && ActivityGuideParserExtensionsPlugin.isActivity(e, "bpelx:milestone")) {
            ActivityGuideProcess agp = (ActivityGuideProcess)process.getData("ActivityGuideProcess.NAME");
            if (agp == null) {
                agp = new ActivityGuideProcessImpl(process, null);
                process.storeData("ActivityGuideProcess.NAME", (Object)agp);
            }
            activity = agp.createActivityGuide();
        }
        if (activity != null) {
            activity.readFromElement(e, ct, true);
        }
        return activity;
    }

    private static boolean isActivity(Element e, String annotText) {
        NodeList nl = e.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            String nodeName = ((Element)n).getTagName();
            String nsURI = n.getNamespaceURI();
            if (nodeName == null || nsURI == null || !"http://schemas.oracle.com/bpel/extension".equals(nsURI) || !nodeName.endsWith("annotation")) continue;
            NodeList l = n.getChildNodes();
            for (int j = 0; j < l.getLength(); ++j) {
                String aName;
                Node aNode = l.item(j);
                if (aNode.getNodeType() != 1 || (aName = ((Element)aNode).getTagName()) == null || !aName.endsWith("pattern")) continue;
                String attr = ((Element)aNode).getAttribute("patternName");
                return attr.equals(annotText);
            }
        }
        return false;
    }
}

