/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.designerplugins.activityguide.plugin;

import java.awt.Point;
import java.awt.dnd.DropTargetDropEvent;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.xml.namespace.QName;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.tip.tools.ide.common.bpelparser.BPELParser;
import oracle.tip.tools.ide.common.bpelparser.extension.activityguide.ActivityGuide;
import oracle.tip.tools.ide.common.bpelparser.extension.activityguide.ActivityGuideConstants;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.ContainerActivity;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLinks;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.graph.event.GraphPaneStatusEvent;
import oracle.tip.tools.ide.common.graph.event.GraphPaneStatusListener;
import oracle.tip.tools.ide.common.graph.model.GraphModel;
import oracle.tip.tools.ide.common.graph.model.GraphNode;
import oracle.tip.tools.ide.common.graph.model.Node;
import oracle.tip.tools.ide.common.graph.view.DNDDropHandler;
import oracle.tip.tools.ide.common.graph.view.DropZone;
import oracle.tip.tools.ide.common.graph.view.GraphPane;
import oracle.tip.tools.ide.common.graph.view.NodeRenderer;
import oracle.tip.tools.ide.common.ide.bpel.BPELProject;
import oracle.tip.tools.ide.fabric.api.InterfaceInfo;
import oracle.tip.tools.ide.fabric.api.SCAController;
import oracle.tip.tools.ide.fabric.api.WsdlInfo;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.model.ModelBuilder;
import oracle.tip.tools.ide.pm.bpelgraph.model.PartnerLinkNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.SwimLaneNode;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELDNDDropHandler;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.SwimLaneView;
import oracle.tip.tools.ide.pm.modules.sca.util.JDevSCAIntegrationUtil;

public class ActivityGuideDNDDropHandler
implements DNDDropHandler {
    private static final String PL_NAME = "AGAdminService";
    private static final String PL_TYPE = "AGAdminServicePortType_PL";
    private static final String PL_ROLE = "AGAdminServicePortType_Role";
    private static final String AG_ADMIN_SERVICE_NS = "http://xmlns.oracle.com/bpel/workflow/AGAdminService";
    private static final String AG_ADMINSERVICE = "AGAdminService";

    public boolean handleDrop(DropTargetDropEvent e, Object data, GraphPane pane) {
        BPELGraphPane graph = (BPELGraphPane)pane;
        BPELGraphModel model = (BPELGraphModel)graph.getModel();
        Process process = model.getProcess();
        boolean validate = graph.getValidateOnLoad();
        boolean newPL = false;
        Point pt = graph.inDrillDownMode() ? e.getLocation() : pane.convertToNonScaledTranslatedCoordinates(e.getLocation());
        int x = pt.x;
        int y = pt.y;
        NodeRenderer r = pane.getNodeRendererAtPosition(x, y);
        String taskName = BPELDNDDropHandler.getTaskNameFromDropData(data);
        if (!(r instanceof DropZone)) {
            return false;
        }
        DropZone dropView = (DropZone)r;
        if (!dropView.isDropAllowed()) {
            return false;
        }
        dropView.setHighLightOn(false);
        Node dropNode = r.getNode();
        boolean editOnDrop = false;
        boolean rebuildPartnerLinks = false;
        GraphNode newNode = null;
        PartnerLink pl = null;
        if (taskName.equalsIgnoreCase("activity_guide_scope")) {
            PartnerLinks l = process.getPartnerLinks();
            if (l != null) {
                List partnerLinkList = l.getPartnerLinks();
                for (PartnerLink _pl : partnerLinkList) {
                    if (!"AGAdminService".equals(_pl.getName())) continue;
                    pl = _pl;
                    break;
                }
            }
            if (pl == null) {
                String prefix = process.addNamespace(AG_ADMIN_SERVICE_NS);
                pl = (PartnerLink)BPELParser.createImplementation(PartnerLink.class);
                pl.setName("AGAdminService");
                pl.setPartnerLinkType(new QName(AG_ADMIN_SERVICE_NS, PL_TYPE, prefix));
                pl.setPartnerRole(PL_ROLE);
                pl.setWSDLLocation("oramds:/soa/shared/activityguide/AGAdminService.wsdl");
                process.addPartnerLink(pl);
                URL wsdlURL = URLFactory.newURL((String)"oramds:/soa/shared/activityguide/AGAdminService.wsdl");
                PartnerLinkNode partnerLinkNode = new PartnerLinkNode();
                partnerLinkNode.setUserObject(pl);
                if (URLFileSystem.exists((URL)wsdlURL)) {
                    partnerLinkNode.setIconName("AGAdminService");
                }
                SwimLaneView swimLaneView = graph.getLeftSwimLaneView();
                SwimLaneNode swimLaneNode = (SwimLaneNode)swimLaneView.getNode();
                model.addChildNode((Node)swimLaneNode, (Node)partnerLinkNode);
                newPL = true;
            }
            newNode = ModelBuilder.createGraphNode(218, process, validate);
            editOnDrop = true;
        }
        if (newNode != null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("OutboundPartnerLink", true);
            map.put("CompSvcName", "AGAdminService");
            if (newPL) {
                process.fireModelChanged((Object)process, 5, (Object)pl, map);
            }
            Activity activity = (Activity)newNode.getUserObject();
            this.updateComposite(process, graph.getBPELProject(), (ActivityGuide)activity, pl);
            Node parentNode = r.getParent().getNode();
            ContainerActivity parentActivity = (ContainerActivity)parentNode.getUserObject();
            if (BPELDNDDropHandler.checkForSequenceInsertion(parentNode, (Node)newNode, graph, dropNode, process)) {
                return true;
            }
            int index = parentNode.indexOf(dropNode);
            if (parentActivity != null && activity != null) {
                try {
                    parentActivity.insertActivity(index / 2, activity);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
            if (editOnDrop) {
                this.setupDelayedEditing((Node)newNode, graph);
            }
            model.insertChildNode(parentNode, (Node)newNode, index);
            model.buildPartnerLinkConnections();
        }
        return newNode != null;
    }

    private void setupDelayedEditing(final Node n, final BPELGraphPane graph) {
        GraphPaneStatusListener lst = new GraphPaneStatusListener(){

            public void modelLoaded(GraphModel model) {
            }

            public void statusChanged(GraphPaneStatusEvent evt) {
                if (evt.getId() == 2) {
                    ActivityGuideDNDDropHandler.this.startEditingNode(n, graph);
                    graph.removeGraphPaneStatusListener(this);
                }
            }
        };
        graph.addGraphPaneStatusListener(lst);
    }

    private void startEditingNode(Node n, final BPELGraphPane graph) {
        final NodeRenderer r = graph.getNodeRendererForNode(n);
        if (r != null) {
            if (SwingUtilities.isEventDispatchThread()) {
                graph.startEditing(r);
            } else {
                Runnable runner = new Runnable(){

                    @Override
                    public void run() {
                        graph.startEditing(r);
                    }
                };
                SwingUtilities.invokeLater(runner);
            }
        }
    }

    private void updateComposite(Process process, BPELProject project, ActivityGuide pMilestone, PartnerLink pLink) {
        boolean newReferenceCreated = this.createReference(pLink, project);
        if (newReferenceCreated) {
            this.addWire(pLink, project);
        }
    }

    private void addWire(PartnerLink pl, BPELProject project) {
        SCAController c = JDevSCAIntegrationUtil.getSCAController(project);
        c.addWire(project.getProcessName(), pl.getName(), "AGAdminService", null);
    }

    private boolean createReference(PartnerLink pl, BPELProject project) {
        boolean newReferenceCreated = false;
        SCAController c = JDevSCAIntegrationUtil.getSCAController(project);
        WsdlInfo wsdlInfo = null;
        try {
            wsdlInfo = new WsdlInfo(pl.getWSDLLocation(), ActivityGuideConstants.REQUEST_PORTTYPE, ActivityGuideConstants.RESPONSE_PORTTYPE);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (c.isNameUniqueWithinComponent(project.getProcessName(), pl.getName())) {
            c.addExternalReference(pl.getName(), (InterfaceInfo)wsdlInfo);
            newReferenceCreated = true;
        }
        return newReferenceCreated;
    }
}

