/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.designerplugins.activityguide.plugin;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.xml.namespace.QName;
import oracle.bali.xml.metadata.standalone.OracleStandaloneMetadataFactory;
import oracle.bali.xml.metadata.standalone.StandaloneMetadataFile;
import oracle.bali.xml.metadata.standalone.StandaloneMetadataFileException;
import oracle.bali.xml.metadata.standalone.StandaloneMetadataFileRegistry;
import oracle.bali.xml.model.datatransfer.XmlTransferUtils;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.palette2.PaletteItem;
import oracle.tip.tools.ide.common.bpelparser.extension.activityguide.ActivityGuide;
import oracle.tip.tools.ide.common.bpelparser.extension.activityguide.ActivityGuideProcess;
import oracle.tip.tools.ide.common.bpelparser.extension.activityguide.event.ActivityGuideProcessEvent;
import oracle.tip.tools.ide.common.bpelparser.extension.activityguide.event.ActivityGuideProcessEventListener;
import oracle.tip.tools.ide.common.bpelparser.extension.activityguide.impl.ActivityGuideProcessImpl;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.plugin.BPELParserPlugin;
import oracle.tip.tools.ide.common.graph.model.GraphElement;
import oracle.tip.tools.ide.common.graph.view.NodeRenderer;
import oracle.tip.tools.ide.common.graph.view.NodeRendererFactory;
import oracle.tip.tools.ide.common.ide.IDEProject;
import oracle.tip.tools.ide.common.ide.bpel.BPELProject;
import oracle.tip.tools.ide.fabric.api.PropertyInfo;
import oracle.tip.tools.ide.fabric.api.SCAControllerImpl;
import oracle.tip.tools.ide.pm.addin.BPELAddin;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.model.ModelBuilderPlugin;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPaneDropTargetListener;
import oracle.tip.tools.ide.pm.bpelgraph.views.NodeEditorSource;
import oracle.tip.tools.ide.pm.designerplugins.activityguide.bpelgraph.editors.ActivityGuideProcessPropertiesAction;
import oracle.tip.tools.ide.pm.designerplugins.activityguide.bpelgraph.model.ActivityGuideNode;
import oracle.tip.tools.ide.pm.designerplugins.activityguide.bpelgraph.views.ActivityGuideView;
import oracle.tip.tools.ide.pm.designerplugins.activityguide.plugin.ActivityGuideDNDDropHandler;
import oracle.tip.tools.ide.pm.designerplugins.activityguide.plugin.ActivityGuideDragListener;
import oracle.tip.tools.ide.pm.designerplugins.activityguide.plugin.ActivityGuideFeatureDetector;
import oracle.tip.tools.ide.pm.designerplugins.activityguide.plugin.ActivityGuideModelBuilderPlugin;
import oracle.tip.tools.ide.pm.designerplugins.activityguide.plugin.ActivityGuideNodeEditorSource;
import oracle.tip.tools.ide.pm.designerplugins.activityguide.plugin.ActivityGuideNodeRendererFactory;
import oracle.tip.tools.ide.pm.designerplugins.activityguide.plugin.ActivityGuideParserExtensionsPlugin;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.plugin.AbstractBPELModelerPlugin;
import oracle.tip.tools.ide.pm.plugin.BPELModelerPlugin;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class ActivityGuideBPELModelerPlugin
extends AbstractBPELModelerPlugin {
    public static final String ACTIVITY_GUIDE_PALETTE_ID = "activity_guide_scope";
    private static final String ACTIVITY_GUIDE_PROCESS_PROPERTIES = BPELStringTranslator.getString("AG_PROPERTIES");
    private static final String ACTIVITYGUIDE_PALETTE_SCHEMA = "documents/activityguide/activityguide_activity.xsd";
    private static final String AGENABLED = "configuration.AGEnabled";
    private static final String AGLOCATION = "configuration.agLocation";
    private static final String XSD = "http://www.w3.org/2001/XMLSchema";
    private static final String TRUE = "true";
    private static final String FALSE = "false";

    private ActivityGuideBPELModelerPlugin() {
    }

    @Override
    public void registerMetaDataFiles(Object obj) {
        try {
            StandaloneMetadataFileRegistry registry = (StandaloneMetadataFileRegistry)obj;
            URL url = BPELAddin.class.getResource("documents/activityguide/activityguide_activity_metadata.xml");
            StandaloneMetadataFile file = OracleStandaloneMetadataFactory.createStandaloneMetadataFile((URL)url);
            registry.addStandaloneMetadataFile(file);
        }
        catch (StandaloneMetadataFileException e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<URL> getSchemaGrammers() {
        ArrayList<URL> schemas = new ArrayList<URL>();
        URL url = BPELAddin.class.getResource(ACTIVITYGUIDE_PALETTE_SCHEMA);
        schemas.add(url);
        return schemas;
    }

    @Override
    public ModelBuilderPlugin getModelBuilderPlugin() {
        return new ActivityGuideModelBuilderPlugin();
    }

    @Override
    public BPELParserPlugin getBPELParserPlugin() {
        return new ActivityGuideParserExtensionsPlugin();
    }

    @Override
    public NodeRendererFactory getNodeRendererFactory() {
        return new ActivityGuideNodeRendererFactory();
    }

    @Override
    public NodeEditorSource getNodeEditorSource() {
        return new ActivityGuideNodeEditorSource();
    }

    @Override
    public void registerDNDHandler(BPELGraphPaneDropTargetListener dropTargetListener, BPELGraphPane graph) {
        ActivityGuideDNDDropHandler dropHandler = new ActivityGuideDNDDropHandler();
        dropTargetListener.registerDNDHandler(dropHandler, PaletteItem.PALETTE_ITEM_FLAVOR);
        dropTargetListener.registerDNDHandler(dropHandler, XmlTransferUtils.FLAVOR_XMLKEY);
        dropTargetListener.addDragListener(new ActivityGuideDragListener());
    }

    @Override
    public boolean handleDeleteGraphElement(BPELGraphPane graph, GraphElement elem) {
        if (elem instanceof ActivityGuideView) {
            return this.handleDeleteAG(graph, (ActivityGuideView)elem);
        }
        return false;
    }

    private boolean handleDeleteAG(BPELGraphPane graph, ActivityGuideView view) {
        BPELGraphModel model = (BPELGraphModel)graph.getModel();
        Process process = model.getProcess();
        ActivityGuideNode node = (ActivityGuideNode)view.getNode();
        ActivityGuide ag = (ActivityGuide)node.getUserObject();
        this.removePartnerLinks(process, graph, ag);
        graph.deleteNodeRenderer((NodeRenderer)view);
        try {
            ag.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    private void removePartnerLinks(Process process, BPELGraphPane graph, ActivityGuide pGuide) {
    }

    @Override
    public Icon getDragIconForActivity(String name) {
        if (name.equalsIgnoreCase(ACTIVITY_GUIDE_PALETTE_ID)) {
            return ImageCache.getIcon("graph/extensions/phase_40x40.png");
        }
        return null;
    }

    @Override
    public void installListeners(BPELGraphPane graph, BPELGraphModel graphModel) {
        Process p = graphModel.getProcess();
        BPELProject bp = graph.getBPELProject();
        ActivityGuideProcessImpl agp = (ActivityGuideProcessImpl)p.getData("ActivityGuideProcess.NAME");
        if (agp == null) {
            agp = new ActivityGuideProcessImpl(p, bp);
            p.storeData("ActivityGuideProcess.NAME", (Object)agp);
        } else {
            agp.setProject(bp);
        }
        this.setProcessFlag(bp, p, (ActivityGuideProcess)agp);
        agp.addActivityGuideProcessListener((ActivityGuideProcessEventListener)new LocalActivityGuideProcessListener());
    }

    @Override
    public void save(Process process, BPELProject project) {
        ActivityGuideProcess agp = (ActivityGuideProcess)process.getData("ActivityGuideProcess.NAME");
        if (agp != null) {
            agp.save();
        }
    }

    public static synchronized BPELModelerPlugin createPlugin() {
        return ActivityGuideFeatureDetector.getFeatureDetector().getIsAGFeatureOn() ? new ActivityGuideBPELModelerPlugin() : null;
    }

    private void handleProcessEvent(ActivityGuideProcessEvent pEvent) {
        int state = pEvent.getState();
        Process process = pEvent.getProcess();
        IDEProject project = pEvent.getProject();
        ActivityGuideProcess agp = pEvent.getActivityGuideProcess();
        if (2 == state) {
            this.fireProcessIsMarked(false, process, project, agp);
        } else if (1 == state) {
            this.fireProcessIsMarked(true, process, project, agp);
        }
    }

    private void fireProcessIsMarked(boolean isAGProcess, Process process, IDEProject project, ActivityGuideProcess agp) {
        Object object = project.getProjectContext();
        if (object instanceof Project) {
            Project p = (Project)object;
            SCAControllerImpl controller = new SCAControllerImpl(p);
            PropertyInfo o = controller.getCompositePropertyInfo(process.getName(), AGENABLED);
            if (o == null && !isAGProcess) {
                return;
            }
            PropertyInfo propInfo = new PropertyInfo();
            propInfo.setType(new QName(XSD, "boolean"));
            propInfo.setName(AGENABLED);
            propInfo.setValue(isAGProcess ? TRUE : FALSE);
            controller.addComponentProperty(process.getName(), propInfo);
            PropertyInfo loc = controller.getCompositePropertyInfo(process.getName(), AGLOCATION);
            if (loc == null && isAGProcess) {
                PropertyInfo pi = new PropertyInfo();
                pi.setType(new QName(XSD, "string"));
                pi.setName(AGLOCATION);
                pi.setValue(agp.getStoreName());
                controller.addComponentProperty(process.getName(), pi);
            }
        }
    }

    private void setProcessFlag(BPELProject bProject, Process process, ActivityGuideProcess agp) {
        PropertyInfo pi;
        Project project;
        SCAControllerImpl controller;
        PropertyInfo o;
        Object object = bProject.getProjectContext();
        if (object instanceof Project && (o = (controller = new SCAControllerImpl(project = (Project)object)).getCompositePropertyInfo(process.getName(), AGENABLED)) instanceof PropertyInfo && AGENABLED.equals((pi = o).getName())) {
            String value = pi.getValue();
            Boolean bool = new Boolean(value);
            agp.setActivityGuide(bool.booleanValue());
        }
    }

    @Override
    public List<JComponent> getStandardPerspectiveToolBarComponents(BPELGraphPane graph) {
        ActivityGuideProcessPropertiesAction action = new ActivityGuideProcessPropertiesAction(graph);
        JButton btn = new JButton(action);
        btn.setToolTipText(ACTIVITY_GUIDE_PROCESS_PROPERTIES);
        ArrayList<JComponent> lst = new ArrayList<JComponent>();
        lst.add(btn);
        return lst;
    }

    @Override
    public void resourceWasDeleted(URL resourceURL, String resourceDescription) {
        if (resourceURL == null) {
            return;
        }
        String name = URLFileSystem.getFileName((URL)resourceURL);
        if (name == null || !name.endsWith(".bpel")) {
            return;
        }
        int start = name.indexOf(".bpel");
        String bpel_name = name.substring(0, start);
        String ag = bpel_name + ".ag";
        URL u = URLFileSystem.getParent((URL)resourceURL);
        URL ag_url = URLFactory.newURL((URL)u, (String)ag);
        if (ag_url == null || !URLFileSystem.exists((URL)ag_url)) {
            return;
        }
        URLFileSystem.delete((URL)ag_url);
    }

    class LocalActivityGuideProcessListener
    implements ActivityGuideProcessEventListener {
        LocalActivityGuideProcessListener() {
        }

        public void processEventPerformed(ActivityGuideProcessEvent pEvent) {
            ActivityGuideBPELModelerPlugin.this.handleProcessEvent(pEvent);
        }
    }
}

