/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.designerplugins.activityguide.bpelgraph.editors;

import java.awt.Component;
import java.util.Map;
import javax.swing.text.JTextComponent;
import oracle.tip.tools.ide.common.bpeldesigner.models.schema.PMNamespaceResolver;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.expressionbuilder.ExpressionBuilder;
import oracle.tip.tools.ide.common.expressionbuilder.ExpressionBuilderPicker;
import oracle.tip.tools.ide.common.expressionbuilders.FunctionsExpressionBuilderPicker;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.services.translation.IXPathBrowser;
import oracle.tip.tools.ide.common.utils.NamespaceResolver;
import oracle.tip.tools.ide.common.xpath.editor.XPathEditorPane;
import oracle.tip.tools.ide.common.xpath.editor.util.VariableDataCallBack;
import oracle.tip.tools.ide.pm.addin.model.BPELXmlModel;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariableDataCallBackImpl;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariableExpressionBuilderPicker;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariablePickerPanel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.designerplugins.activityguide.bpelgraph.editors.ActivityGuideContext;

public class XPathBrowser
implements IXPathBrowser {
    private Activity mActivity = null;
    private Process mProcess = null;
    private BPELGraphPane mPane = null;

    public XPathBrowser(ActivityGuideContext pContext) {
        if (pContext == null) {
            throw new IllegalArgumentException("input context cannot be null");
        }
        this.setContext(pContext.getActivity(), pContext.getProcess(), pContext.getPane());
    }

    public void setContext(Activity pActivity, Process process, BPELGraphPane pane) {
        this.mActivity = pActivity;
        this.mProcess = process;
        this.mPane = pane;
    }

    protected Result handleGraphicBuilderForTextField(String previousValue) {
        XPathEditorPane x = new XPathEditorPane();
        x.setText(previousValue);
        return this.invokeGraphicalXPathBuilder(x);
    }

    protected Result invokeGraphicalXPathBuilder(XPathEditorPane editorPane) {
        Result result = new Result();
        NamespaceResolver nsr = XPathBrowser.getNSResolver(this.mActivity, this.mProcess);
        if (nsr == null) {
            return result;
        }
        BPELXmlModel mainModel = this.mPane.getBPELXmlModel();
        VariableDataCallBackImpl dataCallBack = new VariableDataCallBackImpl(mainModel, this.mActivity);
        VariablePickerPanel p = new VariablePickerPanel(this.mPane, dataCallBack, nsr);
        VariableExpressionBuilderPicker picker = new VariableExpressionBuilderPicker(p, this.mActivity);
        ExpressionBuilderPicker[] pickers = new ExpressionBuilderPicker[]{picker, new FunctionsExpressionBuilderPicker(nsr)};
        XPathEditorPane xpane = new XPathEditorPane();
        xpane.initializeDocument();
        xpane.initializeEditorPane((VariableDataCallBack)dataCallBack, editorPane.getText(), nsr, false);
        ExpressionBuilder dlg = new ExpressionBuilder(GraphUtils.getFrame((Component)((Object)this.mPane)), (JTextComponent)xpane, pickers);
        if (dlg.display() == 0) {
            String value = dlg.getExpressionText();
            editorPane.setText(value);
            result.setOK(true);
            result.setValue(value);
        }
        return result;
    }

    public static final NamespaceResolver getNSResolver(Activity activity, Process process) {
        PMNamespaceResolver nsResolver = new PMNamespaceResolver(process);
        Map map = process.getNamespaceAliases();
        Object[] values = map.keySet().toArray();
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                nsResolver.addNSEntry((String)values[i], (String)map.get(values[i]));
            }
        }
        for (Activity curAct = activity; curAct != null && !(curAct instanceof Process); curAct = curAct.getParentActivity()) {
            Map attrMap;
            if (!(curAct instanceof Activity) || (attrMap = curAct.getAttributesMap()) == null) continue;
            for (String attName : attrMap.keySet()) {
                String prefix;
                if (!attName.startsWith("xmlns:") || (prefix = attName.substring(6, attName.length())).equals("")) continue;
                nsResolver.addNSEntry(prefix, (String)attrMap.get(attName));
            }
        }
        return nsResolver;
    }

    public String getXPath(String pCurrentValue, Component pComponent) {
        Result r = this.handleGraphicBuilderForTextField(pCurrentValue);
        if (r.isOK()) {
            return r.getValue();
        }
        return pCurrentValue;
    }

    class Result {
        boolean ok = false;
        String value = null;

        Result() {
        }

        public boolean isOK() {
            return this.ok;
        }

        public void setOK(boolean pOK) {
            this.ok = pOK;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String pValue) {
            this.value = pValue;
        }
    }
}

