/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.designerplugins.activityguide.bpelgraph.editors;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.text.JTextComponent;
import oracle.tip.tools.ide.common.bpeldesigner.models.schema.PMNamespaceResolver;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.expressionbuilder.ExpressionBuilder;
import oracle.tip.tools.ide.common.expressionbuilder.ExpressionBuilderPicker;
import oracle.tip.tools.ide.common.expressionbuilders.FunctionsExpressionBuilderPicker;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.utils.NamespaceResolver;
import oracle.tip.tools.ide.common.utils.TextManipulator;
import oracle.tip.tools.ide.common.xpath.editor.XPathEditorPane;
import oracle.tip.tools.ide.common.xpath.editor.util.VariableDataCallBack;
import oracle.tip.tools.ide.pm.addin.model.BPELXmlModel;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariableDataCallBackImpl;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariableExpressionBuilderPicker;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariablePickerPanel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class MixedXPathAction
extends AbstractAction {
    private JTextComponent mComponent = null;
    private Activity mActivity = null;
    private Process mProcess = null;
    private BPELGraphPane mPane = null;
    private TextManipulator mTextManipulator = null;

    public MixedXPathAction(JTextComponent pComponent, Activity pActivity, Process process, BPELGraphPane pane) {
        this.setContext(pActivity, process, pane);
        this.mComponent = pComponent;
        this.putValue("SmallIcon", ImageCache.getIcon("expressionbuilder"));
        this.putValue("ShortDescription", BPELStringTranslator.getString("XPATH_EXPRESSSION_BUILDER", "XPath Expression Builder"));
    }

    public void setContext(Activity pActivity, Process process, BPELGraphPane pane) {
        this.mActivity = pActivity;
        this.mProcess = process;
        this.mPane = pane;
    }

    @Override
    public void actionPerformed(ActionEvent pEvent) {
        if (this.mComponent == null || this.mActivity == null || this.mPane == null) {
            return;
        }
        this.mTextManipulator = new TextManipulator(this.mComponent);
        this.handleXPath();
    }

    private void handleXPath() {
        this.handleGraphicBuilderForTextField();
    }

    protected void handleGraphicBuilderForTextField() {
        XPathEditorPane x = new XPathEditorPane();
        x.setText(this.mTextManipulator.getExpression());
        this.invokeGraphicalXPathBuilder(x);
        String s = x.getText();
        if (Helper.hasValue((String)s)) {
            this.mTextManipulator.setExpression(s);
        }
    }

    protected void invokeGraphicalXPathBuilder(XPathEditorPane editorPane) {
        NamespaceResolver nsr = MixedXPathAction.getNSResolver(this.mActivity, this.mProcess);
        if (nsr == null) {
            return;
        }
        BPELXmlModel mainModel = this.mPane.getBPELXmlModel();
        VariableDataCallBackImpl dataCallBack = new VariableDataCallBackImpl(mainModel, this.mActivity);
        VariablePickerPanel p = new VariablePickerPanel(this.mPane, dataCallBack, nsr);
        VariableExpressionBuilderPicker picker = new VariableExpressionBuilderPicker(p, this.mActivity);
        ExpressionBuilderPicker[] pickers = new ExpressionBuilderPicker[]{picker, new FunctionsExpressionBuilderPicker(nsr)};
        XPathEditorPane xpane = new XPathEditorPane();
        xpane.initializeDocument();
        xpane.initializeEditorPane((VariableDataCallBack)dataCallBack, editorPane.getText(), nsr, false);
        ExpressionBuilder dlg = new ExpressionBuilder(GraphUtils.getFrame((Component)((Object)this.mPane)), (JTextComponent)xpane, pickers);
        if (dlg.display() == 0) {
            editorPane.setText(dlg.getExpressionText());
        }
    }

    public static final NamespaceResolver getNSResolver(Activity activity, Process process) {
        PMNamespaceResolver nsResolver = new PMNamespaceResolver(process);
        Map map = process.getNamespaceAliases();
        Object[] values = map.keySet().toArray();
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                nsResolver.addNSEntry((String)values[i], (String)map.get(values[i]));
            }
        }
        for (Activity curAct = activity; curAct != null && !(curAct instanceof Process); curAct = curAct.getParentActivity()) {
            Map attrMap;
            if (!(curAct instanceof Activity) || (attrMap = curAct.getAttributesMap()) == null) continue;
            for (String attName : attrMap.keySet()) {
                String prefix;
                if (!attName.startsWith("xmlns:") || (prefix = attName.substring(6, attName.length())).equals("")) continue;
                nsResolver.addNSEntry(prefix, (String)attrMap.get(attName));
            }
        }
        return nsResolver;
    }
}

