/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.designerplugins.activityguide.bpelgraph.editors;

import java.util.ArrayList;
import java.util.Collection;
import oracle.tip.tools.ide.common.bpelparser.extension.activityguide.I18NData;

public class GlobalizationData {
    private String mKey = null;
    private Collection<String> mValues = new ArrayList<String>();
    private boolean mResource = false;
    private String mText = null;

    public GlobalizationData() {
        this.init();
    }

    public GlobalizationData(I18NData pData) {
        this.copyFromI18N(pData);
    }

    private void init() {
        this.mKey = null;
        this.mText = null;
        this.mValues.clear();
        this.mResource = false;
    }

    private void copyToI18N(I18NData pData) {
        if (pData == null) {
            return;
        }
        pData.setKey(this.mKey);
        pData.setIsResource(this.mResource);
        pData.setText(this.mText);
        pData.setValues(this.mValues);
    }

    private void copyFromI18N(I18NData pData) {
        if (pData == null) {
            return;
        }
        this.mKey = pData.getKey();
        Collection c = pData.getValues();
        if (c != null) {
            this.mValues.addAll(c);
        }
        this.mText = pData.getText();
        this.mResource = pData.isResource();
    }

    public I18NData toI18N() {
        I18NData i18 = new I18NData();
        this.copyToI18N(i18);
        return i18;
    }

    public void setText(String pText) {
        this.mText = pText;
    }

    public String getText() {
        return this.mText;
    }

    public void setKey(String pKey) {
        this.mKey = pKey;
    }

    public String getKey() {
        return this.mKey;
    }

    public Collection<String> getValues() {
        return this.mValues;
    }

    public void setValues(Collection<String> pValues) {
        if (this.mValues == pValues) {
            return;
        }
        this.mValues.clear();
        if (pValues != null) {
            this.mValues.addAll(pValues);
        }
    }

    public boolean isResource() {
        return this.mResource;
    }

    public void setIsResource(boolean resource) {
        this.mResource = resource;
    }
}

