/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.designerplugins.activityguide.bpelgraph.editors;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import oracle.tip.tools.ide.common.services.translation.IKeyRepository;
import oracle.tip.tools.ide.common.services.translation.IRepositoryManager;
import oracle.tip.tools.ide.common.services.translation.IXPathBrowser;
import oracle.tip.tools.ide.common.services.translation.TranslationBrowser;
import oracle.tip.tools.ide.common.services.translation.TranslationContext;
import oracle.tip.tools.ide.pm.designerplugins.activityguide.bpelgraph.editors.ActivityGuideContext;
import oracle.tip.tools.ide.pm.designerplugins.activityguide.bpelgraph.editors.GlobalizationData;
import oracle.tip.tools.ide.pm.designerplugins.activityguide.bpelgraph.editors.XPathBrowser;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

class GlobalizationAction
extends AbstractAction {
    public static final String VALUE_UPDATED = "value has been updated";
    private GlobalizationData mData = null;
    private IXPathBrowser mBrowser = null;
    private IRepositoryManager mRepo;

    public void setData(GlobalizationData pData) {
        this.mData = pData;
    }

    public GlobalizationData getData() {
        return this.mData;
    }

    public void setContext(ActivityGuideContext pContext) {
        this.mRepo = pContext.getRepositoryManager();
        this.mBrowser = new XPathBrowser(pContext);
    }

    public GlobalizationAction() {
        this.putValue("SmallIcon", ImageCache.getIcon("application/extensions/globe.png"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        TranslationContext context = new TranslationContext();
        if (this.mData == null) {
            this.mData = new GlobalizationData();
            this.mData.setIsResource(true);
        }
        context.setCurrentKey(this.mData.getKey());
        context.setValues(this.mData.getValues());
        context.setXPathBrowser(this.mBrowser);
        context.setRepository(this.mRepo.getRepository());
        TranslationBrowser tb = new TranslationBrowser();
        context = tb.browse((Component)e.getSource(), context);
        if (context == null) {
            return;
        }
        this.mData.setKey(context.getCurrentKey());
        this.mData.setValues(context.getValues());
        this.mData.setIsResource(true);
        IKeyRepository ikr = this.mRepo.getRepository();
        this.mRepo.fireRepositoryChanged((Object)this, ikr.getResourceBundleName(), ikr.getResourceLocation());
        this.firePropertyChange(VALUE_UPDATED, false, true);
    }
}

