/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.designerplugins.activityguide.bpelgraph.editors;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import oracle.tip.tools.ide.common.services.translation.IRepositoryManager;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.pm.designerplugins.activityguide.bpelgraph.editors.ActivityGuideContext;
import oracle.tip.tools.ide.pm.designerplugins.activityguide.bpelgraph.editors.GlobalizationAction;
import oracle.tip.tools.ide.pm.designerplugins.activityguide.bpelgraph.editors.GlobalizationData;

public class GlobalizableComponent
extends JPanel {
    private static final String STATIC_DISPLAY = "STATIC";
    private static final String RESOURCE_DISPLAY = "RESOURCE";
    private static final Integer STATIC = 0;
    private static final Integer RESOURCE = 1;
    private JTextComponent mComponent;
    private JComboBox mChoices;
    private GlobalizationAction mAction = null;
    private IRepositoryManager mRepoManager = null;
    private boolean mWrapInScroll = false;
    private JScrollPane mScrollPane = null;

    public GlobalizableComponent(JTextComponent pComponent, boolean pWrapInScroll) {
        if (pComponent == null) {
            throw new IllegalArgumentException("component cannot be null");
        }
        this.mComponent = pComponent;
        this.setWrapInScroll(pWrapInScroll);
        this.mAction = new GlobalizationAction();
        this.mAction.addPropertyChangeListener(new LocalPropertyChangeListener());
        this.initialize();
        this.layoutComponents();
        this.setMode();
    }

    public JScrollPane getScrollPane() {
        return this.mScrollPane;
    }

    private void setWrapInScroll(boolean pWrapInScroll) {
        this.mWrapInScroll = pWrapInScroll;
    }

    public boolean isWrapInScroll() {
        return this.mWrapInScroll;
    }

    public GlobalizableComponent(JTextComponent pComponent) {
        this(pComponent, false);
    }

    public void setContext(ActivityGuideContext pContext) {
        if (pContext == null) {
            throw new IllegalArgumentException("context cannot be null");
        }
        this.mAction.setContext(pContext);
        this.mRepoManager = pContext.getRepositoryManager();
    }

    private void setValueIntoComponent(GlobalizationData pData) {
        if (pData == null) {
            return;
        }
        boolean isResource = pData.isResource();
        String text = pData.getText();
        if (isResource && this.mRepoManager != null) {
            text = this.mRepoManager.format(pData.getKey(), pData.getValues());
        }
        this.mComponent.setText(text);
    }

    public void setData(GlobalizationData pData) {
        this.fillUI(pData);
    }

    private void fillUI(final GlobalizationData pData) {
        if (pData == null) {
            return;
        }
        final int value = pData.isResource() ? RESOURCE : STATIC;
        Runnable r = new Runnable(){

            @Override
            public void run() {
                GlobalizableComponent.this.mChoices.setSelectedItem(value);
                GlobalizableComponent.this.setValueIntoComponent(pData);
                GlobalizableComponent.this.mAction.setEnabled(RESOURCE == value);
                GlobalizableComponent.this.mAction.setData(pData);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    public GlobalizationData getData() {
        GlobalizationData d = new GlobalizationData();
        if (STATIC.equals(this.mChoices.getSelectedItem())) {
            d.setIsResource(false);
            d.setText(this.mComponent.getText());
        } else {
            d = this.mAction.getData();
        }
        return d;
    }

    private void initialize() {
        this.mChoices = new JComboBox<Integer>(new Integer[]{STATIC, RESOURCE});
        this.mChoices.setRenderer(new ChoicesRenderer());
        this.mChoices.addItemListener(new LocalChoicesListener());
    }

    private void layoutComponents() {
        int x = 0;
        int y = 0;
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        JComponent jc = this.mComponent;
        if (this.mWrapInScroll) {
            this.mScrollPane = new JScrollPane(this.mComponent);
            jc = this.mScrollPane;
        }
        gbl.setConstraints(jc, new GridBagConstraints(x, y, 1, 1, 1.0, 1.0, 21, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(jc);
        JComponent choices = this.prepareChoices();
        gbl.setConstraints(choices, new GridBagConstraints(++x, y, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.add(choices);
    }

    private JComponent prepareChoices() {
        JPanel panel = new JPanel();
        BoxLayout bl = new BoxLayout(panel, 2);
        panel.setLayout(bl);
        this.mChoices.setMaximumSize(this.mChoices.getPreferredSize());
        panel.add(this.mChoices);
        Component strut = Box.createHorizontalStrut(5);
        panel.add(strut);
        JButton b = new JButton(this.mAction);
        UIHelper.setupButton((JButton)b);
        panel.add(b);
        Component glue = Box.createHorizontalGlue();
        panel.add(glue);
        return panel;
    }

    private void updateTextComponent() {
        if (this.mComponent == null) {
            return;
        }
        GlobalizationData d = this.mAction.getData();
        this.mComponent.setText(this.mRepoManager.format(d.getKey(), d.getValues()));
    }

    private void setMode() {
        Object choice = this.mChoices.getSelectedItem();
        boolean enable = false;
        if (STATIC.equals(choice)) {
            enable = true;
        }
        this.enableTextComponent(enable);
        this.mAction.setEnabled(!enable);
    }

    private void enableTextComponent(boolean pEnable) {
        if (this.mComponent != null) {
            this.mComponent.setEditable(pEnable);
        }
    }

    class ChoicesRenderer
    extends DefaultListCellRenderer {
        private Map<Integer, String> map = new HashMap<Integer, String>();

        ChoicesRenderer() {
            this.map.put(STATIC, GlobalizableComponent.STATIC_DISPLAY);
            this.map.put(RESOURCE, GlobalizableComponent.RESOURCE_DISPLAY);
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            String string = this.map.get(value);
            this.setText(string);
            return this;
        }
    }

    class LocalChoicesListener
    implements ItemListener {
        LocalChoicesListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            GlobalizableComponent.this.setMode();
        }
    }

    class LocalPropertyChangeListener
    implements PropertyChangeListener {
        LocalPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("value has been updated".equals(evt.getPropertyName())) {
                GlobalizableComponent.this.updateTextComponent();
            }
        }
    }
}

