/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.designerplugins.activityguide.bpelgraph.editors;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.SwingUtilities;
import oracle.ide.util.ResourceUtils;
import oracle.tip.tools.ide.common.bpeldesigner.models.bpel.Duration;
import oracle.tip.tools.ide.common.bpeldesigner.util.DurationExpressionUtil;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ui.CardPanel;
import oracle.tip.tools.ide.common.ui.DurationSpinner;
import oracle.tip.tools.ide.common.ui.DurationSpinnerModel;
import oracle.tip.tools.ide.pm.designerplugins.activityguide.bpelgraph.editors.ExpirationData;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;

public class ExpirationComponent
extends JPanel {
    protected static int MAX_YEARS_ALLOWED = 100;
    protected static int MAX_MONTHS_ALLOWED = 1200;
    protected static int MAX_DAYS_ALLOWED = 36500;
    private static final String EXPIRATION = BPELStringTranslator.getString("AG_EXPIRATION");
    private static final String ABORT = BPELStringTranslator.getString("AG_ABORT");
    private static final String FOR = BPELStringTranslator.getString("AG_FOR");
    private static final String UNTIL = BPELStringTranslator.getString("AG_UNTIL");
    private JCheckBox mExpire = null;
    private DurationSpinner mDuration = null;
    private JSpinner mUntil = null;
    private JCheckBox mAbort = null;
    private JComponent mDetails = null;
    private ExpirationData mData = null;
    private JComboBox mChoices = null;
    private CardPanel mCardPanel = null;
    private JRadioButton mDB = null;
    private JRadioButton mUB = null;
    private ButtonGroup mBG = null;
    private Collection<JComponent> mComponents = new ArrayList<JComponent>();

    public ExpirationComponent() {
        this.initialize();
        this.layoutComponents();
        this.setData(null);
    }

    private JSpinner createDateTimeSpinner() {
        Calendar calTime = Calendar.getInstance();
        calTime.add(13, 2);
        Date initDate = calTime.getTime();
        calTime.add(1, MAX_YEARS_ALLOWED);
        Date endDate = calTime.getTime();
        SpinnerDateModel timeModel = new SpinnerDateModel(initDate, null, endDate, 13);
        JSpinner spinner = new JSpinner(timeModel);
        JSpinner.DateEditor dateEditor = new JSpinner.DateEditor(spinner, "MM/dd/yyyy HH:mm:ss");
        spinner.setEditor(dateEditor);
        JFormattedTextField ftf = dateEditor.getTextField();
        ftf.setHorizontalAlignment(4);
        ftf.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 3));
        return spinner;
    }

    private void initialize() {
        this.mCardPanel = new CardPanel();
        this.mUntil = this.createDateTimeSpinner();
        this.mExpire = new JCheckBox(new ExpirationAction());
        ResourceUtils.resButton((AbstractButton)this.mExpire, (String)EXPIRATION);
        this.mDuration = new DurationSpinner();
        this.mAbort = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.mAbort, (String)ABORT);
        this.mBG = new ButtonGroup();
        LocalChoiceListener lcl = new LocalChoiceListener();
        this.mDB = new JRadioButton();
        this.mUB = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)this.mDB, (String)FOR);
        ResourceUtils.resButton((AbstractButton)this.mUB, (String)UNTIL);
        this.mBG.add(this.mDB);
        this.mBG.add(this.mUB);
        this.mDB.setActionCommand(FOR);
        this.mUB.setActionCommand(UNTIL);
        this.mDB.addItemListener(lcl);
        this.mUB.addItemListener(lcl);
        this.mDetails = this.prepareDetails();
        this.mComponents.add(this.mAbort);
        this.mComponents.add((JComponent)this.mCardPanel);
        this.mComponents.add(this.mDB);
        this.mComponents.add((JComponent)this.mDuration);
        this.mComponents.add(this.mDetails);
        this.mComponents.add(this.mUB);
        this.mComponents.add(this.mUntil);
    }

    private void layoutComponents() {
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        int x = 0;
        int y = 0;
        gbl.setConstraints(this.mExpire, new GridBagConstraints(x, y, 0, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.mExpire);
        gbl.setConstraints(this.mDetails, new GridBagConstraints(x, ++y, 0, -1, 1.0, 0.0, 21, 1, new Insets(10, 40, 0, 0), 0, 0));
        this.add(this.mDetails);
        Component c = Box.createVerticalStrut(1);
        gbl.setConstraints(c, new GridBagConstraints(x, ++y, 0, 0, 0.0, 1.0, 21, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.add(c);
    }

    private void enabledDetails(boolean open) {
        for (JComponent c : this.mComponents) {
            c.setEnabled(open);
        }
    }

    private void showDetails() {
        boolean open = this.mExpire.isSelected();
        this.enabledDetails(open);
    }

    private JPanel prepareChoices() {
        JPanel p = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        p.setLayout(gbl);
        int x = 0;
        int y = 0;
        gbl.setConstraints(this.mDB, new GridBagConstraints(x, y, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        p.add(this.mDB);
        gbl.setConstraints(this.mUB, new GridBagConstraints(++x, y, 1, 1, 1.0, 1.0, 21, 2, new Insets(0, 10, 0, 0), 0, 0));
        p.add(this.mUB);
        return p;
    }

    private JComponent prepareDetails() {
        this.prepareCardPanel();
        JPanel panel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        panel.setLayout(gbl);
        int x = 0;
        int y = 0;
        JPanel choices = this.prepareChoices();
        gbl.setConstraints(choices, new GridBagConstraints(x, y, 0, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add(choices);
        gbl.setConstraints((Component)this.mCardPanel, new GridBagConstraints(x, ++y, 0, 1, 1.0, 0.0, 21, 2, new Insets(12, 0, 0, 0), 0, 0));
        panel.add((Component)this.mCardPanel);
        gbl.setConstraints(this.mAbort, new GridBagConstraints(x, ++y, 0, 1, 1.0, 0.0, 21, 2, new Insets(12, 0, 0, 0), 0, 0));
        panel.add(this.mAbort);
        return panel;
    }

    private void prepareCardPanel() {
        this.mCardPanel.add(FOR, (Component)this.mDuration);
        this.mCardPanel.add(UNTIL, (Component)this.mUntil);
    }

    public void setData(ExpirationData pData) {
        this.mData = pData;
        if (this.mData != null) {
            this.fillUI();
        }
    }

    private void fillUI() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                String choice;
                String duration;
                ExpirationComponent.this.mAbort.setSelected(ExpirationComponent.this.mData.isAbort());
                Calendar until = ExpirationComponent.this.mData.getUntil();
                if (until != null && until.getTime() != null) {
                    ExpirationComponent.this.mUntil.setValue(until.getTime());
                }
                if ((duration = ExpirationComponent.this.mData.getDuration()) != null) {
                    if (duration.startsWith("'") && duration.endsWith("'")) {
                        duration = duration.substring(1, duration.length() - 1);
                    }
                    Duration dur = null;
                    try {
                        dur = DurationExpressionUtil.parseDurationExpression((String)duration);
                    }
                    catch (IllegalArgumentException ile) {
                        // empty catch block
                    }
                    if (dur != null) {
                        DurationSpinnerModel model = (DurationSpinnerModel)ExpirationComponent.this.mDuration.getModel();
                        model.setDuration(dur);
                    }
                }
                ExpirationComponent.this.mExpire.setSelected(ExpirationComponent.this.mData.isExpire());
                String string = choice = ExpirationComponent.this.mData.getDuration() == null ? UNTIL : FOR;
                if (UNTIL.equals(choice)) {
                    ExpirationComponent.this.mUB.setSelected(true);
                } else {
                    ExpirationComponent.this.mDB.setSelected(true);
                }
                ExpirationComponent.this.showChoice();
                ExpirationComponent.this.showDetails();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    public ExpirationData getData() {
        this.mData.setAbort(this.mAbort.isSelected());
        this.mData.setExpire(this.mExpire.isSelected());
        this.mData.setDuration(null);
        this.mData.setUntil(null);
        String command = this.mBG.getSelection().getActionCommand();
        if (FOR.equals(command)) {
            String duration = "'" + this.mDuration.getDurationExpression() + "'";
            this.mData.setDuration(duration);
        } else {
            Calendar cal = GregorianCalendar.getInstance();
            cal.setTime((Date)this.mUntil.getValue());
            this.mData.setUntil(cal);
        }
        return this.mData;
    }

    private void showChoice() {
        ButtonModel bm = this.mBG.getSelection();
        final String choice = bm.getActionCommand();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                ExpirationComponent.this.mCardPanel.show(choice);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    public static void main(String[] argv) {
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        f.setContentPane(new ExpirationComponent());
        f.setSize(500, 100);
        f.setVisible(true);
    }

    public boolean validateChanges() {
        boolean ready = true;
        if (this.mExpire.isSelected()) {
            if (this.mUB.isSelected()) {
                if (this.mUntil.getValue() == null) {
                    ready = false;
                } else {
                    Date now = new Date();
                    Date date = (Date)this.mUntil.getValue();
                    if (now.compareTo(date) > 0) {
                        GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)this), (String)BPELStringTranslator.getString("DATE_MUST_BE_GREATER_THAN_NOW"), (String)BPELStringTranslator.getString("GENERAL_EDITOR_ERROR"), (int)2);
                        return false;
                    }
                }
            } else {
                String d = this.mDuration.getDurationExpression();
                if (d != null && d.startsWith("'") && d.endsWith("'")) {
                    d = d.substring(1, d.length() - 1);
                }
                if (d == null) {
                    ready = false;
                } else {
                    Duration dur = DurationExpressionUtil.parseDurationExpression((String)d);
                    if (dur.getDay() == 0 && dur.getMonth() == 0 && dur.getYear() == 0 && dur.getHour() == 0 && dur.getMinute() < 10) {
                        ready = false;
                    }
                }
            }
        }
        if (!ready) {
            GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)this), (String)BPELStringTranslator.getString("FOR_OR_UNTIL_NEEDED_IF_USED"), (String)BPELStringTranslator.getString("GENERAL_EDITOR_ERROR"), (int)2);
            return false;
        }
        return true;
    }

    class LocalChoiceListener
    implements ItemListener {
        LocalChoiceListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                ExpirationComponent.this.showChoice();
            }
        }
    }

    class ExpirationAction
    extends AbstractAction {
        ExpirationAction() {
        }

        @Override
        public void actionPerformed(ActionEvent pEvent) {
            ExpirationComponent.this.showDetails();
        }
    }
}

