/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.designerplugins.activityguide.bpelgraph.editors;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import oracle.tip.tools.ide.common.bpelparser.extension.activityguide.ActivityGuideProcess;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.ui.GenericDialog;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.utils.MixedXPathExpressionParser;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.designerplugins.activityguide.bpelgraph.editors.ActivityGuideProcessComponent;
import oracle.tip.tools.ide.pm.designerplugins.activityguide.bpelgraph.editors.ActivityGuideProcessData;
import oracle.tip.tools.ide.pm.designerplugins.activityguide.bpelgraph.editors.GlobalizationData;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class ActivityGuideProcessPropertiesAction
extends AbstractAction {
    private static final String EDIT = BPELStringTranslator.getString("AG_EDIT_ACTIVITY_GUIDE");
    private BPELGraphPane mGraph = null;

    public ActivityGuideProcessPropertiesAction(BPELGraphPane pGraph) {
        if (pGraph == null) {
            throw new IllegalArgumentException("caller must provide a BPELGraphPane object. Got null.");
        }
        this.mGraph = pGraph;
        this.putValue("SmallIcon", ImageCache.getIcon("application/extensions/milestone_16x16.png"));
    }

    @Override
    public void actionPerformed(ActionEvent pEvent) {
        Component c = (Component)pEvent.getSource();
        Process process = ((BPELGraphModel)this.mGraph.getModel()).getProcess();
        ActivityGuideProcess agp = (ActivityGuideProcess)process.getData("ActivityGuideProcess.NAME");
        ActivityGuideProcessComponent panel = new ActivityGuideProcessComponent(this.mGraph, agp.getRepositoryManager());
        panel.setData(this.convertProcessToData(agp));
        GenericDialog dialog = new GenericDialog((Frame)UIHelper.getFrame((Component)c), EDIT, true);
        dialog.setContent((JComponent)panel);
        dialog.setButtons(28);
        dialog.setSize(600, 500);
        dialog.setLocationRelativeTo((Component)dialog.getParent());
        if (dialog.showDialog(false, false) == 200) {
            this.convertDataToProcess(panel.getData(), agp);
            process.fireModelChanged((Object)this, 28, (Object)agp);
        }
    }

    private ActivityGuideProcessData convertProcessToData(ActivityGuideProcess agp) {
        MixedXPathExpressionParser parser = new MixedXPathExpressionParser();
        ActivityGuideProcessData data = new ActivityGuideProcessData();
        data.setActivityGuide(agp.isAnActivityGuide());
        data.setDescription(new GlobalizationData(agp.getDescription()));
        data.setDisplayMode(agp.getDisplayMode());
        String initiator = agp.getInitiator();
        data.setInitiator(parser.convertXPathComplaintStringToMixedForm(initiator));
        data.setKey(parser.convertXPathComplaintStringToMixedForm(agp.getIdentificationKey()));
        data.setTitle(new GlobalizationData(agp.getTitle()));
        return data;
    }

    private void convertDataToProcess(ActivityGuideProcessData pData, ActivityGuideProcess process) {
        MixedXPathExpressionParser parser = new MixedXPathExpressionParser();
        process.setActivityGuide(pData.isActivityGuide());
        process.setDescription(pData.getDescription().toI18N());
        process.setDisplayMode(pData.getDisplayMode());
        process.setIdentificationKey(parser.convertMixedStringToXPathCompliantForm(pData.getKey()));
        process.setInitiator(parser.convertMixedStringToXPathCompliantForm(pData.getInitiator()));
        process.setTitle(pData.getTitle().toI18N());
    }
}

