/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.designerplugins.activityguide.bpelgraph.editors;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.ResourceUtils;
import oracle.tip.tools.ide.common.bpelparser.extension.activityguide.ActivityGuideProcess;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.resource.MessageBundleUtil;
import oracle.tip.tools.ide.common.services.translation.IRepositoryManager;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.utils.UIUtil;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.designerplugins.activityguide.bpelgraph.editors.ActivityGuideContext;
import oracle.tip.tools.ide.pm.designerplugins.activityguide.bpelgraph.editors.ActivityGuideProcessData;
import oracle.tip.tools.ide.pm.designerplugins.activityguide.bpelgraph.editors.GlobalizableComponent;
import oracle.tip.tools.ide.pm.designerplugins.activityguide.bpelgraph.editors.MixedXPathAction;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;

public class ActivityGuideProcessComponent
extends JPanel {
    private static final String SHOW_ALL = BPELStringTranslator.getString("AG_SHOW_ALL");
    private static final String SHOW_CURRENT = BPELStringTranslator.getString("AG_SHOW_CURRENT");
    private static final String EXPOSE = BPELStringTranslator.getString("AG_EXPOSE");
    private static final String INITIATOR = BPELStringTranslator.getString("AG_INITIATOR");
    private static final String DISPLAY_TITLE = BPELStringTranslator.getString("AG_DISPLAY_TITLE");
    private static final String DESCRIPTION = BPELStringTranslator.getString("AG_DESCRIPTION");
    private static final String IDENTIFICATION = BPELStringTranslator.getString("AG_IDENTIFICATION");
    private static final String RESOURCE_LOCATION = BPELStringTranslator.getString("AG_RESOURCE_LOCATION");
    private static final String RESOURCE_NAME = BPELStringTranslator.getString("AG_RESOURCE_NAME");
    private static final String MILESTONE_DISPLAY_MODE = BPELStringTranslator.getString("AG_MILESTONE_DISPLAY_MODE");
    private static final String MESSAGE = BPELStringTranslator.getString("AG_MESSAGE");
    private static final String BROWSE = BPELStringTranslator.getString("AG_BROWSE");
    private static final ActivityGuideProcess.DisplayMode[] MODES = new ActivityGuideProcess.DisplayMode[]{ActivityGuideProcess.SHOW_ALL, ActivityGuideProcess.SHOW_CURRENT};
    private JCheckBox mExpose;
    private JTextField mInitiator;
    private JTextField mTitle;
    private GlobalizableComponent mTitleComponent;
    private JTextArea mDescription;
    private GlobalizableComponent mDescriptionComponent;
    private JTextField mKey;
    private JTextField mResourceLocation;
    private JTextField mResourceName;
    private JComboBox mode;
    private ActivityGuideProcessData mData = null;
    private Collection<JComponent> mLabelCollection = new ArrayList<JComponent>();
    private Collection<JComponent> mComponentCollection = new ArrayList<JComponent>();
    private JButton mTitleButton;
    private JButton mInitiatorButton;
    private JButton mKeyButton;
    private JButton mResourceButton;
    private MixedXPathAction mTitleAction;
    private MixedXPathAction mInitiatorAction;
    private MixedXPathAction mKeyAction;
    private URL mProjectURL;
    private IRepositoryManager mRepositoryManager;

    public ActivityGuideProcessComponent(BPELGraphPane pane, IRepositoryManager pRepoManager) {
        this.mRepositoryManager = pRepoManager;
        this.mProjectURL = pane.getBPELProject().getProjectURL();
        this.initialize(pane);
        this.layoutComponents();
    }

    private void initialize(BPELGraphPane pane) {
        Process process = ((BPELGraphModel)pane.getModel()).getProcess();
        this.mExpose = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.mExpose, (String)EXPOSE);
        this.mTitle = new JTextField();
        this.mTitleComponent = new GlobalizableComponent(this.mTitle);
        this.mInitiator = new JTextField();
        this.mDescription = new JTextArea(5, 20);
        this.mDescriptionComponent = new GlobalizableComponent(this.mDescription, true);
        this.mKey = new JTextField();
        this.mResourceLocation = new JTextField();
        this.mResourceName = new JTextField();
        this.mode = new JComboBox<ActivityGuideProcess.DisplayMode>(MODES);
        this.mode.setRenderer(new LocalModeRenderer());
        this.mTitleAction = new MixedXPathAction(this.mTitle, (Activity)process, process, pane);
        this.mTitleButton = new JButton(this.mTitleAction);
        UIHelper.setupButton((JButton)this.mTitleButton);
        this.mInitiatorAction = new MixedXPathAction(this.mInitiator, (Activity)process, process, pane);
        this.mInitiatorButton = new JButton(this.mInitiatorAction);
        UIHelper.setupButton((JButton)this.mInitiatorButton);
        this.mKeyAction = new MixedXPathAction(this.mKey, (Activity)process, process, pane);
        this.mKeyButton = new JButton(this.mKeyAction);
        UIHelper.setupButton((JButton)this.mKeyButton);
        this.mResourceButton = UIHelper.createBrowseButton((String)BROWSE);
        this.mResourceButton.addActionListener(new BundleLookupAction(this.mResourceLocation));
        UIHelper.setupButton((JButton)this.mResourceButton);
        ActivityGuideContext context = new ActivityGuideContext((Activity)process, process, pane, this.mRepositoryManager);
        this.mTitleComponent.setContext(context);
        this.mDescriptionComponent.setContext(context);
    }

    private void layoutComponents() {
        BoxLayout bl = new BoxLayout(this, 3);
        this.setLayout(bl);
        JPanel expose = this.prepareExposePanel();
        JPanel initiator = this.prepareActionPanel(INITIATOR, this.mInitiator, this.mInitiatorButton, this.mLabelCollection, this.mComponentCollection);
        JPanel title = this.prepareTitlePanel(DISPLAY_TITLE, this.mTitleComponent, this.mTitleButton, this.mLabelCollection, this.mComponentCollection);
        JPanel description = this.prepareDescriptionPanel();
        JPanel id = this.prepareActionPanel(IDENTIFICATION, this.mKey, this.mKeyButton, this.mLabelCollection, this.mComponentCollection);
        JPanel resourceBundleLocation = this.prepareResourcePanel();
        JPanel resourceBundleName = this.preparePanel(RESOURCE_NAME, this.mResourceName, this.mLabelCollection, this.mComponentCollection);
        JPanel display = this.preparePanel(MILESTONE_DISPLAY_MODE, this.mode, this.mLabelCollection, this.mComponentCollection);
        JComponent[] components = new JComponent[]{expose, initiator, title, description, id, display};
        for (int i = 0; i < components.length; ++i) {
            Dimension d = components[i].getPreferredSize();
            d.width = Short.MAX_VALUE;
            components[i].setMaximumSize(d);
            this.add(components[i]);
            this.add(Box.createVerticalStrut(5));
        }
        UIUtil.equatePreferredWidths(this.mLabelCollection);
        UIUtil.equatePreferredWidths(this.mComponentCollection);
        this.setBorder(BorderFactory.createEmptyBorder(20, 15, 0, 10));
    }

    private JPanel prepareResourcePanel() {
        GridBagLayout gbl = new GridBagLayout();
        JPanel panel = new JPanel(gbl);
        int x = 0;
        int y = 0;
        JLabel label = new JLabel();
        ResourceUtils.resLabel((JLabel)label, (Component)this.mResourceLocation, (String)RESOURCE_LOCATION);
        gbl.setConstraints(label, new GridBagConstraints(x, y, 1, 1, 0.0, 1.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add(label);
        this.mLabelCollection.add(label);
        gbl.setConstraints(this.mResourceLocation, new GridBagConstraints(++x, y, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 10, 0, 0), 0, 0));
        panel.add(this.mResourceLocation);
        this.mComponentCollection.add(this.mResourceLocation);
        gbl.setConstraints(this.mResourceButton, new GridBagConstraints(++x, y, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add(this.mResourceButton);
        return panel;
    }

    private JPanel prepareTitlePanel(String pName, JComponent pField, JComponent pActionButton, Collection<JComponent> pLabelCollection, Collection<JComponent> pComponentCollection) {
        GridBagLayout gbl = new GridBagLayout();
        JPanel panel = new JPanel(gbl);
        int x = 0;
        int y = 0;
        JLabel label = new JLabel();
        ResourceUtils.resLabel((JLabel)label, (Component)pField, (String)pName);
        gbl.setConstraints(label, new GridBagConstraints(x, y, 1, 1, 0.0, 1.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add(label);
        gbl.setConstraints(pField, new GridBagConstraints(++x, y, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 10, 0, 0), 0, 0));
        panel.add(pField);
        pLabelCollection.add(label);
        pComponentCollection.add(pField);
        return panel;
    }

    private JPanel prepareActionPanel(String pName, JComponent pField, JComponent pActionButton, Collection<JComponent> pLabelCollection, Collection<JComponent> pComponentCollection) {
        GridBagLayout gbl = new GridBagLayout();
        JPanel panel = new JPanel(gbl);
        int x = 0;
        int y = 0;
        JLabel label = new JLabel();
        ResourceUtils.resLabel((JLabel)label, (Component)pField, (String)pName);
        gbl.setConstraints(label, new GridBagConstraints(x, y, 1, 1, 0.0, 1.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add(label);
        gbl.setConstraints(pField, new GridBagConstraints(++x, y, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 10, 0, 0), 0, 0));
        panel.add(pField);
        gbl.setConstraints(pActionButton, new GridBagConstraints(++x, y, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add(pActionButton);
        pLabelCollection.add(label);
        pComponentCollection.add(pField);
        return panel;
    }

    public void setContext(ActivityGuideContext pContext) {
        this.mTitleComponent.setContext(pContext);
        this.mDescriptionComponent.setContext(pContext);
    }

    private JPanel prepareDescriptionPanel() {
        JPanel panel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        panel.setLayout(gbl);
        int x = 0;
        int y = 0;
        JLabel label = new JLabel();
        ResourceUtils.resLabel((JLabel)label, (Component)this.mDescription, (String)DESCRIPTION);
        gbl.setConstraints(label, new GridBagConstraints(x, y, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add(label);
        JScrollPane jsp = this.mDescriptionComponent.getScrollPane();
        gbl.setConstraints(this.mDescriptionComponent, new GridBagConstraints(++x, y, 1, 3, 1.0, 1.0, 21, 1, new Insets(0, 10, 0, 0), 0, 0));
        panel.add(this.mDescriptionComponent);
        this.mLabelCollection.add(label);
        this.mComponentCollection.add(jsp);
        return panel;
    }

    private JPanel prepareExposePanel() {
        GridBagLayout gbl = new GridBagLayout();
        JPanel panel = new JPanel(gbl);
        int x = 0;
        int y = 0;
        gbl.setConstraints(this.mExpose, new GridBagConstraints(x, y, 0, 1, 1.0, 1.0, 21, 0, new Insets(0, 0, 30, 0), 0, 0));
        panel.add(this.mExpose);
        return panel;
    }

    private JPanel prepareNVPairComponent(JLabel pLabel, JComponent pComponent) {
        JPanel panel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        panel.setLayout(gbl);
        int x = 0;
        int y = 0;
        gbl.setConstraints(pLabel, new GridBagConstraints(x, y, 1, 1, 0.0, 1.0, 21, 0, new Insets(0, 0, 0, 10), 0, 0));
        panel.add(pLabel);
        gbl.setConstraints(pComponent, new GridBagConstraints(++x, y, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add(pComponent);
        return panel;
    }

    private JPanel preparePanel(String pName, JComponent pComponent, Collection<JComponent> pLabelCollection, Collection<JComponent> pComponentCollection) {
        JLabel l = new JLabel();
        ResourceUtils.resLabel((JLabel)l, (Component)pComponent, (String)pName);
        pLabelCollection.add(l);
        pComponentCollection.add(pComponent);
        return this.prepareNVPairComponent(l, pComponent);
    }

    public void setData(ActivityGuideProcessData pData) {
        if (pData == null) {
            throw new IllegalArgumentException("input activity process cannot be null");
        }
        this.mData = pData;
        this.fillUI();
    }

    private void fillUI() {
        this.mExpose.setSelected(this.mData.isActivityGuide());
        this.mInitiator.setText(this.mData.getInitiator());
        this.mTitleComponent.setData(this.mData.getTitle());
        this.mDescriptionComponent.setData(this.mData.getDescription());
        this.mKey.setText(this.mData.getKey());
        this.mResourceLocation.setText(this.mData.getResourceLocation());
        this.mResourceName.setText(this.mData.getResourceName());
        this.mode.setSelectedItem(this.mData.getDisplayMode());
    }

    public ActivityGuideProcessData getData() {
        ActivityGuideProcessData data = new ActivityGuideProcessData();
        data.setActivityGuide(this.mExpose.isSelected());
        data.setDescription(this.mDescriptionComponent.getData());
        data.setDisplayMode((ActivityGuideProcess.DisplayMode)this.mode.getSelectedItem());
        data.setInitiator(this.mInitiator.getText());
        data.setKey(this.mKey.getText());
        data.setResourceLocation(this.mResourceLocation.getText());
        data.setResourceName(this.mResourceName.getText());
        data.setTitle(this.mTitleComponent.getData());
        return data;
    }

    private String copyIfNecessary(URL pURL) {
        if (pURL == null) {
            return null;
        }
        URL result = null;
        boolean isInsideProject = URLFileSystem.isBaseURLFor((URL)this.mProjectURL, (URL)pURL);
        if (!isInsideProject) {
            int value = GraphUtils.showConfirmDialog((Component)GraphUtils.getFrame((Component)this), (String)MESSAGE, (String)MessageBundleUtil.getCommonString((String)"EDITOR_PLE_COPY_FILE_TITLE"));
            if (value == 0) {
                String file = URLFileSystem.getFileName((URL)pURL);
                URL to = this.getURLToImport(this.mProjectURL, file);
                try {
                    URLFileSystem.copy((URL)pURL, (URL)to);
                    result = to;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            result = pURL;
        }
        String str = URLFileSystem.toRelativeSpec((URL)result, (URL)this.mProjectURL);
        return str;
    }

    protected URL getURLToImport(URL projDirURL, String fileName) {
        URL url = URLFactory.newDirURL((URL)projDirURL, (String)"resources");
        url = URLFactory.newDirURL((URL)url, (String)"bundles");
        URLFileSystem.mkdirs((URL)url);
        return URLFactory.newURL((URL)url, (String)fileName);
    }

    private class BundleLookupAction
    extends AbstractAction {
        private JTextField mComponent = null;

        public BundleLookupAction(JTextField pField) {
            this.mComponent = pField;
        }

        @Override
        public void actionPerformed(ActionEvent pEvent) {
            URL selectedURL;
            String newURL;
            if (this.mComponent == null) {
                return;
            }
            String string = this.mComponent.getText();
            URL url = URLFactory.newURL((String)string);
            URLChooser chooser = DialogUtil.newURLChooser((URL)url);
            chooser.setSelectionMode(0);
            chooser.setShowJarsAsDirs(true);
            Component component = (Component)pEvent.getSource();
            if (chooser.showOpenDialog(component) == 0 && (newURL = ActivityGuideProcessComponent.this.copyIfNecessary(selectedURL = chooser.getSelectedURL())) != null) {
                this.mComponent.setText(newURL);
            }
        }
    }

    class LocalModeRenderer
    extends DefaultListCellRenderer {
        LocalModeRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof ActivityGuideProcess.DisplayMode) {
                ActivityGuideProcess.DisplayMode mode = (ActivityGuideProcess.DisplayMode)value;
                if (ActivityGuideProcess.SHOW_ALL.equals((Object)mode)) {
                    this.setText(SHOW_ALL);
                } else {
                    this.setText(SHOW_CURRENT);
                }
            }
            return this;
        }
    }
}

