/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.designerplugins.activityguide.bpelgraph.editors;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.event.ChangeListener;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.util.ResourceUtils;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.resource.MessageBundleUtil;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.utils.UIUtil;
import oracle.tip.tools.ide.pm.designerplugins.activityguide.bpelgraph.editors.ActivityGuideContext;
import oracle.tip.tools.ide.pm.designerplugins.activityguide.bpelgraph.editors.ActivityGuideGeneralData;
import oracle.tip.tools.ide.pm.designerplugins.activityguide.bpelgraph.editors.ExpirationComponent;
import oracle.tip.tools.ide.pm.designerplugins.activityguide.bpelgraph.editors.ExpirationData;
import oracle.tip.tools.ide.pm.designerplugins.activityguide.bpelgraph.editors.GlobalizableComponent;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;

public class ActivityGuideGeneralComponent
extends JPanel {
    private static final String NAME = BPELStringTranslator.getString("AG_NAME");
    private static final String DISPLAY_SEQUENCE = BPELStringTranslator.getString("AG_DISPLAY_SEQUENCE");
    private static final String PERCENT_OF_PROCESS = BPELStringTranslator.getString("AG_PERCENT");
    private static final String DISPLAY_TITLE = BPELStringTranslator.getString("AG_GENERAL_DISPLAY_TITLE");
    private static final String DESCRIPTION = BPELStringTranslator.getString("AG_GENERAL_DESCRIPTION");
    private static final String IMAGE = BPELStringTranslator.getString("AG_IMAGE");
    private static final String IMAGE_HELP = BPELStringTranslator.getString("AG_IMAGE_HELP");
    private static final String BROWSE = BPELStringTranslator.getString("AG_BROWSE");
    private static final String IMAGES_ONLY = BPELStringTranslator.getString("AG_IMAGES_ONLY");
    private static final String MESSAGE = BPELStringTranslator.getString("AG_MESSAGE");
    private static final int MIN = 0;
    private static final int MAX = 100;
    private JTextField mName;
    private JSpinner mSequence;
    private JSpinner mPercent;
    private JTextField mTitle;
    private JTextArea mDescription;
    private JTextField mImage;
    private JButton mImageLookup;
    private ActivityGuideGeneralData mData = null;
    private boolean mListen = true;
    private URL mProjectURL = null;
    private ExpirationComponent mExpiration = null;
    private ActivityGuideContext mContext = null;
    private GlobalizableComponent mTitleComponent = null;
    private GlobalizableComponent mDescriptionComponent = null;
    private Collection<JComponent> mLabels = new ArrayList<JComponent>();
    private Collection<JComponent> mFields = new ArrayList<JComponent>();
    private Collection<ChangeListener> mChangeListeners = new ArrayList<ChangeListener>();

    public ActivityGuideGeneralComponent(URL projectURL) {
        this.mProjectURL = projectURL;
        this.initialize();
        this.layoutComponents();
        this.setData(null);
    }

    public void setContext(ActivityGuideContext pContext) {
        this.mTitleComponent.setContext(pContext);
        this.mDescriptionComponent.setContext(pContext);
    }

    private void initialize() {
        this.mName = new JTextField(10);
        this.mSequence = new JSpinner(new SpinnerNumberModel(0, 0, 100, 1));
        this.mPercent = new JSpinner(new SpinnerNumberModel(0, 0, 100, 1));
        this.mTitle = new JTextField(10);
        this.mDescription = new JTextArea();
        this.mImage = new JTextField();
        this.mImage.setColumns(10);
        this.mImageLookup = UIHelper.createBrowseButton((String)BROWSE);
        this.mImageLookup.addActionListener(new ImageLookupAction(this.mImage));
        this.mExpiration = new ExpirationComponent();
        this.mTitleComponent = new GlobalizableComponent(this.mTitle);
        this.mDescriptionComponent = new GlobalizableComponent(this.mDescription, true);
        this.mFields.add(this.mName);
        this.mFields.add(this.mTitle);
        this.mFields.add(this.mExpiration);
    }

    private void layoutComponents() {
        ArrayList<JPanel> c = new ArrayList<JPanel>();
        BoxLayout bl = new BoxLayout(this, 3);
        this.setLayout(bl);
        JPanel namePanel = this.prepareNamePanel();
        JPanel percentPanel = this.preparePercentPanel();
        JPanel titlePanel = this.prepareTitlePanel();
        JPanel descriptionPanel = this.prepareDescriptionPanel();
        JPanel imagePanel = this.prepareImagePanel();
        c.add(namePanel);
        c.add(percentPanel);
        c.add(titlePanel);
        c.add(descriptionPanel);
        c.add(imagePanel);
        c.add(this.mExpiration);
        Border border = BorderFactory.createEmptyBorder(15, 0, 0, 0);
        for (JComponent jComponent : c) {
            Dimension d = jComponent.getPreferredSize();
            d.width = Integer.MAX_VALUE;
            jComponent.setMaximumSize(d);
            jComponent.setBorder(border);
            this.add(jComponent);
        }
        this.add(Box.createVerticalGlue());
        UIUtil.equatePreferredWidths(this.mLabels);
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
    }

    private JPanel prepareImagePanel() {
        GridBagLayout gbl = new GridBagLayout();
        JPanel panel = new JPanel(gbl);
        int x = 0;
        int y = 0;
        JLabel image = new JLabel();
        ResourceUtils.resLabel((JLabel)image, (Component)this.mImage, (String)IMAGE);
        this.mLabels.add(image);
        gbl.setConstraints(image, new GridBagConstraints(x, y, 1, 1, 0.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add(image);
        gbl.setConstraints(this.mImage, new GridBagConstraints(++x, y, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 10, 0, 0), 0, 0));
        panel.add(this.mImage);
        gbl.setConstraints(this.mImageLookup, new GridBagConstraints(++x, y, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 10, 0, 0), 0, 0));
        panel.add(this.mImageLookup);
        x = 0;
        JLabel help = new JLabel(IMAGE_HELP);
        gbl.setConstraints(help, new GridBagConstraints(++x, ++y, 0, 1, 1.0, 0.0, 21, 2, new Insets(0, 10, 0, 0), 0, 0));
        panel.add(help);
        help.setEnabled(false);
        return panel;
    }

    private JPanel prepareDescriptionPanel() {
        GridBagLayout gbl = new GridBagLayout();
        JPanel panel = new JPanel(gbl);
        int x = 0;
        int y = 0;
        JLabel description = new JLabel();
        ResourceUtils.resLabel((JLabel)description, (Component)this.mDescription, (String)DESCRIPTION);
        gbl.setConstraints(description, new GridBagConstraints(x, y, 1, 1, 0.0, 1.0, 18, 3, new Insets(0, 0, 0, 0), 0, 0));
        panel.add(description);
        this.mLabels.add(description);
        this.mDescription.setRows(3);
        this.mDescription.setColumns(10);
        gbl.setConstraints(this.mDescriptionComponent, new GridBagConstraints(++x, y, 0, 0, 1.0, 1.0, 21, 1, new Insets(0, 10, 0, 0), 0, 0));
        panel.add(this.mDescriptionComponent);
        this.mDescription.setLineWrap(true);
        JScrollPane jsp = this.mDescriptionComponent.getScrollPane();
        jsp.setPreferredSize(new Dimension(this.mTitle.getPreferredSize().width, jsp.getPreferredSize().height));
        return panel;
    }

    private JPanel prepareTitlePanel() {
        GridBagLayout gbl = new GridBagLayout();
        JPanel panel = new JPanel(gbl);
        int x = 0;
        int y = 0;
        JLabel title = new JLabel();
        ResourceUtils.resLabel((JLabel)title, (Component)this.mTitle, (String)DISPLAY_TITLE);
        gbl.setConstraints(title, new GridBagConstraints(x, y, -1, 0, 0.0, 1.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add(title);
        this.mLabels.add(title);
        gbl.setConstraints(this.mTitleComponent, new GridBagConstraints(++x, y, 0, 0, 1.0, 0.0, 21, 2, new Insets(0, 10, 0, 0), 0, 0));
        panel.add(this.mTitleComponent);
        return panel;
    }

    private JPanel preparePercentPanel() {
        GridBagLayout gbl = new GridBagLayout();
        JPanel panel = new JPanel(gbl);
        int x = 0;
        int y = 0;
        JLabel percent = new JLabel();
        ResourceUtils.resLabel((JLabel)percent, (Component)this.mPercent, (String)PERCENT_OF_PROCESS);
        gbl.setConstraints(percent, new GridBagConstraints(x, y, 1, 1, 0.0, 1.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add(percent);
        this.mLabels.add(percent);
        gbl.setConstraints(this.mPercent, new GridBagConstraints(++x, y, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 10, 0, 0), 0, 0));
        panel.add(this.mPercent);
        Component glue = Box.createHorizontalGlue();
        gbl.setConstraints(glue, new GridBagConstraints(x, y, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add(glue);
        return panel;
    }

    private JPanel prepareDisplayPanel() {
        GridBagLayout gbl = new GridBagLayout();
        JPanel panel = new JPanel(gbl);
        int x = 0;
        int y = 0;
        JLabel display = new JLabel();
        ResourceUtils.resLabel((JLabel)display, (Component)this.mSequence, (String)DISPLAY_SEQUENCE);
        gbl.setConstraints(display, new GridBagConstraints(x, y, 1, 1, 0.0, 1.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add(display);
        this.mLabels.add(display);
        gbl.setConstraints(this.mSequence, new GridBagConstraints(++x, y, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 10, 0, 0), 0, 0));
        panel.add(this.mSequence);
        Component glue = Box.createHorizontalGlue();
        gbl.setConstraints(glue, new GridBagConstraints(++x, y, 0, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add(glue);
        return panel;
    }

    private JPanel prepareNamePanel() {
        GridBagLayout gbl = new GridBagLayout();
        JPanel panel = new JPanel(gbl);
        int x = 0;
        int y = 0;
        JLabel name = new JLabel();
        ResourceUtils.resLabel((JLabel)name, (Component)this.mName, (String)NAME);
        gbl.setConstraints(name, new GridBagConstraints(x, y, -1, 0, 0.0, 1.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add(name);
        this.mLabels.add(name);
        gbl.setConstraints(this.mName, new GridBagConstraints(++x, y, 0, 0, 1.0, 0.0, 21, 2, new Insets(0, 10, 0, 0), 0, 0));
        panel.add(this.mName);
        return panel;
    }

    private String copyIfNecessary(URL pURL) {
        if (pURL == null) {
            return null;
        }
        URL result = null;
        boolean isInsideProject = URLFileSystem.isBaseURLFor((URL)this.mProjectURL, (URL)pURL);
        if (!isInsideProject) {
            int value = GraphUtils.showConfirmDialog((Component)GraphUtils.getFrame((Component)this), (String)MESSAGE, (String)MessageBundleUtil.getCommonString((String)"EDITOR_PLE_COPY_FILE_TITLE"));
            if (value == 0) {
                String file = URLFileSystem.getFileName((URL)pURL);
                URL to = this.getURLToImport(this.mProjectURL, file);
                try {
                    URLFileSystem.copy((URL)pURL, (URL)to);
                    result = to;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            result = pURL;
        }
        String str = URLFileSystem.toRelativeSpec((URL)result, (URL)this.mProjectURL);
        return str;
    }

    protected URL getURLToImport(URL projDirURL, String fileName) {
        URL url = URLFactory.newDirURL((URL)projDirURL, (String)"resources");
        url = URLFactory.newDirURL((URL)url, (String)"images");
        URLFileSystem.mkdirs((URL)url);
        return URLFactory.newURL((URL)url, (String)fileName);
    }

    public void setData(ActivityGuideGeneralData pData) {
        this.mData = pData == null ? new ActivityGuideGeneralData() : pData;
        this.fillUI();
    }

    private void fillUI() {
        this.removeListeners();
        this.mName.setText(this.mData.getName());
        this.mTitleComponent.setData(this.mData.getTitle());
        this.mPercent.setValue(this.mData.getPercent());
        this.mDescriptionComponent.setData(this.mData.getDescription());
        this.mImage.setText(this.mData.getImage());
        ExpirationData ed = this.mData.getExpirationData();
        if (!ed.isInUse()) {
            this.mExpiration.setVisible(false);
        } else {
            this.mExpiration.setVisible(true);
            this.mExpiration.setData(ed);
        }
        this.addListeners();
    }

    public ActivityGuideGeneralData getData() {
        this.mData.setImage(this.mImage.getText());
        this.mData.setName(this.mName.getText());
        this.mData.setPercent((Integer)this.mPercent.getValue());
        this.mData.setDescription(this.mDescriptionComponent.getData());
        this.mData.setTitle(this.mTitleComponent.getData());
        if (this.mExpiration.isVisible()) {
            this.mData.setExpirationData(this.mExpiration.getData());
        } else {
            this.mData.setExpirationData(null);
        }
        return this.mData;
    }

    private synchronized void removeListeners() {
        this.mListen = false;
    }

    private synchronized void addListeners() {
        this.mListen = true;
    }

    public void addChangeListener(ChangeListener pListener) {
        if (pListener == null) {
            return;
        }
        this.mChangeListeners.add(pListener);
    }

    public void removeChangeListener(ChangeListener pListener) {
        this.mChangeListeners.remove(pListener);
    }

    public boolean validateChanges() {
        return this.mExpiration.validateChanges();
    }

    private class ImageLookupAction
    extends AbstractAction {
        private final String[] FORMATS = new String[]{".png", ".gif", ".jpg", ".jpeg"};
        private JTextField mComponent = null;

        public ImageLookupAction(JTextField pField) {
            this.mComponent = pField;
        }

        @Override
        public void actionPerformed(ActionEvent pEvent) {
            URL selectedURL;
            String newURL;
            if (this.mComponent == null) {
                return;
            }
            String string = this.mComponent.getText();
            URL url = URLFactory.newURL((String)string);
            URLChooser chooser = DialogUtil.newURLChooser((URL)url);
            chooser.setURLFilter(new URLFilter(){

                public String toString() {
                    return IMAGES_ONLY;
                }

                public boolean accept(URL pURL) {
                    if (pURL == null) {
                        return true;
                    }
                    if (URLFileSystem.isDirectory((URL)pURL)) {
                        return true;
                    }
                    String file = URLFileSystem.getFileName((URL)pURL);
                    if (file != null) {
                        String fileInLowerCase = file.toLowerCase();
                        for (int i = 0; i < ImageLookupAction.this.FORMATS.length; ++i) {
                            String f = ImageLookupAction.this.FORMATS[i];
                            if (!fileInLowerCase.endsWith(f)) continue;
                            return true;
                        }
                    }
                    return false;
                }
            });
            chooser.setSelectionMode(0);
            chooser.setShowJarsAsDirs(true);
            Component component = (Component)pEvent.getSource();
            if (chooser.showOpenDialog(component) == 0 && (newURL = ActivityGuideGeneralComponent.this.copyIfNecessary(selectedURL = chooser.getSelectedURL())) != null) {
                this.mComponent.setText(newURL);
            }
        }
    }
}

