/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.designerplugins.activityguide.bpelgraph.editors;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.URL;
import oracle.tip.tools.ide.common.bpelparser.extension.activityguide.ActivityGuide;
import oracle.tip.tools.ide.common.graph.model.Node;
import oracle.tip.tools.ide.common.graph.view.GraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.editors.BaseEditingPage;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.designerplugins.activityguide.bpelgraph.editors.ActivityGuideContext;
import oracle.tip.tools.ide.pm.designerplugins.activityguide.bpelgraph.editors.ActivityGuideGeneralComponent;
import oracle.tip.tools.ide.pm.designerplugins.activityguide.bpelgraph.editors.ActivityGuideGeneralData;
import oracle.tip.tools.ide.pm.designerplugins.activityguide.bpelgraph.editors.ExpirationData;
import oracle.tip.tools.ide.pm.designerplugins.activityguide.bpelgraph.editors.GlobalizationData;
import oracle.tip.tools.ide.pm.designerplugins.activityguide.bpelgraph.model.ActivityGuideNode;

public class ActivityGuideEditPage
extends BaseEditingPage {
    private ActivityGuideGeneralComponent mComponent = null;
    private ActivityGuideNode mNode = null;
    private ActivityGuide mActivity = null;

    public ActivityGuideEditPage(GraphPane pane, Node n) throws Exception {
        super((BPELGraphPane)pane);
        URL url = this.getProjectURL();
        this.mComponent = new ActivityGuideGeneralComponent(url);
        this.mNode = (ActivityGuideNode)n;
        this.layoutComponents();
    }

    private ActivityGuideContext prepareContext() {
        return new ActivityGuideContext(this.mNode.getActivity(), this.m_processModel, this.m_graphPane, this.mActivity.getActivityGuideProcess().getRepositoryManager());
    }

    private void layoutComponents() {
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        int x = 0;
        int y = 0;
        gbl.setConstraints(this.mComponent, new GridBagConstraints(x, y, 0, 0, 1.0, 1.0, 21, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.mComponent);
    }

    @Override
    public void setUserObject(Object pObject) {
        this.mActivity = (ActivityGuide)pObject;
        this.mComponent.setContext(this.prepareContext());
        ActivityGuideGeneralData data = new ActivityGuideGeneralData();
        data.setName(this.mActivity.getName());
        data.setDescription(new GlobalizationData(this.mActivity.getDescription()));
        data.setImage(this.mActivity.getImage());
        data.setPercent(this.mActivity.getPercent());
        data.setTitle(new GlobalizationData(this.mActivity.getTitle()));
        data.setExpirationData(new ExpirationData(this.mActivity.getExpirationData()));
        this.mComponent.setData(data);
    }

    @Override
    public void saveChanges() {
        ActivityGuideGeneralData data = this.mComponent.getData();
        this.updateActivity(data);
    }

    private void updateActivity(ActivityGuideGeneralData pData) {
        this.mActivity.setName(pData.getName());
        this.mActivity.setDescription(pData.getDescription().toI18N());
        this.mActivity.setImage(pData.getImage());
        this.mActivity.setPercent(Integer.valueOf(pData.getPercent()));
        this.mActivity.setTitle(pData.getTitle().toI18N());
        ActivityGuide.ExpirationData aed = this.mActivity.getExpirationData();
        pData.getExpirationData().populateExpirationData(aed);
        this.fireProcessChangedEvent(28);
    }

    @Override
    public boolean validateEditorChanges() {
        return this.mComponent.validateChanges();
    }
}

