/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import oracle.javatools.editor.BasicEditorPane;
import oracle.tip.tools.ide.common.bpelparser.BPELParser;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.ParserContext;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.bpelparser.util.XMLHelper;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.gui.generalpurpose.BPELBaseDialog;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SourceDialog
extends BPELBaseDialog
implements ActionListener {
    public static final int OK = 0;
    public static final int CANCEL = 1;
    protected JButton m_okBtn;
    protected JButton m_cancelBtn;
    protected BasicEditorPane m_sourcePane;
    protected BPELGraphPane m_graph;
    protected int m_retVal = 1;
    protected Activity m_activity;

    public SourceDialog(JFrame f, BPELGraphPane graph) {
        super(f, "Source", true);
        this.m_graph = graph;
        this.createControls();
        this.layoutControls();
    }

    public int display(final PartnerLink link) {
        this.setTitle("Source Code - Partner Link");
        this.enableUserInput(false);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                SourceDialog.this.load(link);
            }
        };
        new Thread(r).start();
        this.setVisible(true);
        return this.m_retVal;
    }

    protected void load(PartnerLink link) {
        Document doc = link.getDOMElement().getOwnerDocument();
        final String code = link.getSourceCode(doc);
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    SourceDialog.this.m_sourcePane.setText(code);
                    SourceDialog.this.m_sourcePane.setCaretPosition(0);
                }
                finally {
                    SourceDialog.this.enableUserInput(true);
                }
            }
        };
        SwingUtilities.invokeLater(r);
    }

    public int display(final Activity a) {
        this.m_activity = a;
        String type = BPELParser.getActivityTypeName((Activity)a);
        this.setTitle("Source Code - " + type);
        this.enableUserInput(false);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                SourceDialog.this.load(a);
            }
        };
        new Thread(r).start();
        this.setVisible(true);
        return this.m_retVal;
    }

    protected void load(Activity a) {
        Document doc = a.getDOMElement().getOwnerDocument();
        final String code = a.getSourceCode(doc);
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    SourceDialog.this.m_sourcePane.setText(code);
                }
                finally {
                    SourceDialog.this.enableUserInput(true);
                }
            }
        };
        SwingUtilities.invokeLater(r);
    }

    protected void createControls() {
        this.m_sourcePane = new BasicEditorPane();
        this.m_sourcePane.setLanguageSupport("Temp.xml");
        this.m_sourcePane.setEditable(false);
        this.m_okBtn = new JButton();
        BPELStringTranslator.setButton(this.m_okBtn, BPELStringTranslator.getString("OK_BUTTON_TEXT_RES"));
        this.m_okBtn.addActionListener(this);
        this.m_cancelBtn = new JButton();
        BPELStringTranslator.setButton(this.m_cancelBtn, BPELStringTranslator.getString("CANCEL_BUTTON_TEXT_RES"));
        this.m_cancelBtn.addActionListener(this);
    }

    protected void layoutControls() {
        JPanel btnPnl = new JPanel(new GridLayout(1, 2, 5, 0));
        btnPnl.add(this.m_cancelBtn);
        this.setLayout(new GridBagLayout());
        Container c = this.getContentPane();
        c.setLayout(new GridBagLayout());
        int row = 0;
        GraphUtils.addComponent((Container)c, (Component)new JScrollPane((Component)this.m_sourcePane), (int)0, (int)row++, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(10, 10, 0, 10), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)c, (Component)btnPnl, (int)1, (int)row, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(5, 5, 10, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        this.setSize(600, 400);
        GraphUtils.centerInScreen((Component)((Object)this));
    }

    protected void handleCancel() {
        this.m_retVal = 1;
        this.dispose();
    }

    protected void handleOK() {
        String code = this.m_sourcePane.getText();
        String xml = "<?xml version = '1.0' encoding = 'UTF-8'?>\n" + code;
        if (XMLHelper.isValidXMLSegment((String)xml)) {
            ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes());
            try {
                Document doc = XMLHelper.loadDocument((InputStream)is);
                Element e = doc.getDocumentElement();
                if (this.m_activity != null) {
                    String tagName = BPELParser.getActivityXPathName((Activity)this.m_activity);
                    if (tagName == null || !tagName.equalsIgnoreCase(e.getTagName())) {
                        GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)((Object)this)), (String)"Invalid tag name for the activity!", (int)0);
                        return;
                    }
                    ParserContext ct = new ParserContext();
                    BPELGraphModel model = (BPELGraphModel)this.m_graph.getModel();
                    ct.setProcess(model.getProcess());
                    this.m_activity.readFromElement(e, ct, false);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)((Object)this)), (String)"Invalid XML segment!", (int)0);
            return;
        }
        this.m_retVal = 0;
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_okBtn) {
            this.handleOK();
        } else if (src == this.m_cancelBtn) {
            this.handleCancel();
        }
    }
}

