/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.bpelparser.validation.Validatable;
import oracle.tip.tools.ide.common.bpelparser.validation.ValidationContext;
import oracle.tip.tools.ide.common.bpelparser.validation.ValidationReport;
import oracle.tip.tools.ide.common.bpelparser.validation.ValidationReportItem;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.graph.view.AbstractNodeEditor;
import oracle.tip.tools.ide.common.graph.view.NodeRenderer;
import oracle.tip.tools.ide.common.ui.ToolBar;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.ValidatableView;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.EditorPage;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.EditorPageChangeListener;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.EditorPageManager;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.SourceDialog;
import oracle.tip.tools.ide.pm.gui.dialogs.validationbrowser.ValidationBrowser;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class ApplyCancelPanel
extends JPanel
implements ActionListener,
EditorPageChangeListener,
ChangeListener {
    public static int TAB_PLACEMENT = 1;
    protected JButton m_okBtn;
    protected JButton m_applyBtn;
    protected JButton m_cancelBtn;
    protected JButton m_helpBtn;
    protected JButton m_sourceBtn;
    protected JTabbedPane m_tab;
    protected JButton m_validationBrowserBtn;
    protected JLabel m_statusLbl;
    protected AbstractNodeEditor m_nodeEditor;
    protected EditorPageManager m_editorPageManager;
    protected Dimension m_prefDim = new Dimension(400, 300);
    protected Validatable m_validatable;
    protected BPELGraphPane m_graph;
    protected int m_selectedTabIndex = -1;

    public ApplyCancelPanel(AbstractNodeEditor nodeEditor, EditorPageManager pageManager, BPELGraphPane graph) {
        EditorPage[] pages;
        this.m_graph = graph;
        this.m_tab = new JTabbedPane(TAB_PLACEMENT);
        this.m_tab.addChangeListener(this);
        this.m_editorPageManager = pageManager;
        for (EditorPage page : pages = pageManager.getEditorPages()) {
            page.addEditorPageChangeListener(this);
            this.m_tab.addTab(page.getTitle(), page.getPagePanel());
        }
        this.m_nodeEditor = nodeEditor;
        this.createControls();
        this.layoutControls();
    }

    public JButton getOKButton() {
        return this.m_okBtn;
    }

    public Validatable getValidatable() {
        return this.m_validatable;
    }

    public void setValidatable(Validatable validatable) {
        this.m_validatable = validatable;
    }

    void setValidatableStatus(Validatable obj) {
        List lst;
        this.setErrorCount(0);
        this.setWarningCount(0);
        this.m_statusLbl.setVisible(false);
        if (obj == null) {
            return;
        }
        int errors = 0;
        int warnings = 0;
        ValidationReport report = obj.getValidationReport(null, false);
        if (report != null && (lst = report.getReportDetails()) != null) {
            for (ValidationReportItem item : lst) {
                if (item.getType() == 0) {
                    ++errors;
                    continue;
                }
                if (item.getType() != 1) continue;
                ++warnings;
            }
        }
        this.setWarningCount(warnings);
        this.setErrorCount(errors);
        this.m_statusLbl.setVisible(errors > 0);
        this.m_validationBrowserBtn.setVisible(errors > 0 || warnings > 0);
    }

    public void setErrorCount(int cnt) {
        this.m_statusLbl.setText(BPELStringTranslator.formatString("EDITOR_VALID_EXP_ERRORS", "" + cnt));
    }

    public void setWarningCount(int cnt) {
        this.m_statusLbl.setText(BPELStringTranslator.formatString("EDITOR_VALID_EXP_WARNS", "" + cnt));
    }

    public EditorPageManager getEditorPageManager() {
        return this.m_editorPageManager;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.m_prefDim;
    }

    public void setSelectedIndex(int i) {
        this.m_tab.setSelectedIndex(i);
    }

    protected void createControls() {
        this.m_statusLbl = new JLabel(BPELStringTranslator.getString("INVALID_SETTINGS"), ImageCache.getIcon("warning16"), 2);
        this.m_validationBrowserBtn = UIHelper.createModelerButton((Icon)ImageCache.getIcon("wrench16"));
        this.m_validationBrowserBtn.addActionListener(this);
        this.m_validationBrowserBtn.setToolTipText(BPELStringTranslator.getString("VIEW_VALIDATION_REPORT"));
        this.m_okBtn = new JButton(BPELStringTranslator.getString("OK_BUTTON_TEXT"));
        BPELStringTranslator.setButton(this.m_okBtn, BPELStringTranslator.getString("OK_BUTTON_TEXT_RES"));
        this.m_okBtn.setEnabled(false);
        this.m_okBtn.addActionListener(this);
        this.m_applyBtn = new JButton(BPELStringTranslator.getString("APPLY_BUTTON_TEXT"));
        BPELStringTranslator.setButton(this.m_applyBtn, BPELStringTranslator.getString("APPLY_BUTTON_TEXT_RES_A"));
        this.m_applyBtn.setEnabled(false);
        this.m_applyBtn.addActionListener(this);
        this.m_cancelBtn = new JButton(BPELStringTranslator.getString("CANCEL_BUTTON_TEXT"));
        this.m_cancelBtn.addActionListener(this);
        BPELStringTranslator.setButton(this.m_cancelBtn, BPELStringTranslator.getString("CANCEL_BUTTON_TEXT_RES"));
        this.m_sourceBtn = new JButton();
        this.m_sourceBtn.addActionListener(this);
        BPELStringTranslator.setButton(this.m_sourceBtn, "&Source");
        this.m_helpBtn = new JButton(BPELStringTranslator.getString("HELP_BUTTON_TEXT"));
        this.m_helpBtn.addActionListener(this);
        BPELStringTranslator.setButton(this.m_helpBtn, BPELStringTranslator.getString("HELP_BUTTON_TEXT_RES"));
    }

    protected void layoutControls() {
        JPanel btnPnl = new JPanel(new GridLayout(1, 2, 5, 0));
        btnPnl.add(this.m_applyBtn);
        btnPnl.add(this.m_okBtn);
        btnPnl.add(this.m_cancelBtn);
        JPanel botPnl = new JPanel(new GridBagLayout());
        GraphUtils.addComponent((Container)botPnl, (Component)this.m_helpBtn, (int)0, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)botPnl, (Component)btnPnl, (int)1, (int)0, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        ToolBar tb = new ToolBar();
        tb.setBorderInsets(new Insets(0, 0, 0, 0));
        tb.add((Component)this.m_validationBrowserBtn);
        this.setLayout(new GridBagLayout());
        GraphUtils.addComponent((Container)this, (Component)this.m_statusLbl, (int)0, (int)0, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(0, 0, 0, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)tb, (int)3, (int)0, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(0, 5, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_tab, (int)0, (int)1, (int)4, (int)1, (int)18, (int)1, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)this, (Component)botPnl, (int)0, (int)2, (int)4, (int)1, (int)17, (int)2, (Insets)new Insets(10, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)0.0);
    }

    protected void handleApply() {
        if (!this.m_editorPageManager.validateEditorChanges()) {
            return;
        }
        this.m_editorPageManager.saveChanges();
        NodeRenderer r = this.m_nodeEditor.getNodeRenderer();
        if (r instanceof ValidatableView) {
            ValidatableView v = (ValidatableView)r;
            BPELGraphModel graphModel = (BPELGraphModel)v.getBPELGraphPane().getModel();
            ValidationContext ct = new ValidationContext(graphModel.getProcess());
            v.getValidatableObject().getValidationReport(ct, true);
            this.setValidatableStatus(v.getValidatableObject());
        } else if (this.m_validatable != null) {
            BPELGraphModel graphModel = (BPELGraphModel)this.m_graph.getModel();
            ValidationContext ct = new ValidationContext(graphModel.getProcess());
            this.m_validatable.getValidationReport(ct, true);
            this.setValidatableStatus(this.m_validatable);
        }
    }

    public void handleOK() {
        if (!this.m_editorPageManager.validateEditorChanges()) {
            return;
        }
        this.m_editorPageManager.saveChanges();
        this.m_nodeEditor.stopNodeEditing();
        this.m_graph.grabFocus();
        if (this.m_nodeEditor.refreshGraphOnEdit()) {
            this.m_graph.reloadBPELEditor();
        }
    }

    public void handleCancel() {
        EditorPage[] pages;
        this.m_nodeEditor.cancelNodeEditing();
        for (EditorPage page : pages = this.m_editorPageManager.getEditorPages()) {
            page.onCancel();
        }
        this.m_graph.grabFocus();
    }

    public void handleHelp() {
        EditorPage[] pages = this.m_editorPageManager.getEditorPages();
        int sel = this.m_tab.getSelectedIndex();
        pages[sel].showHelp();
    }

    protected void handleSource() {
        int sel;
        EditorPage[] pages = this.m_editorPageManager.getEditorPages();
        Object obj = pages[sel = this.m_tab.getSelectedIndex()].getUserObject();
        if (obj instanceof Activity) {
            Activity a = (Activity)obj;
            SourceDialog dlg = new SourceDialog(GraphUtils.getFrame((Component)this), this.m_graph);
            if (dlg.display(a) == 0) {
                this.refreshPages();
            }
        } else if (obj instanceof PartnerLink) {
            PartnerLink pl = (PartnerLink)obj;
            SourceDialog dlg = new SourceDialog(GraphUtils.getFrame((Component)this), this.m_graph);
            if (dlg.display(pl) == 0) {
                this.refreshPages();
            }
        }
    }

    protected void refreshPages() {
        EditorPage[] pages;
        for (EditorPage page : pages = this.m_editorPageManager.getEditorPages()) {
            page.loadData();
        }
    }

    protected void handleValidateBrowse() {
        NodeRenderer r = this.m_nodeEditor.getNodeRenderer();
        if (r instanceof ValidatableView) {
            ValidatableView v = (ValidatableView)r;
            ValidationBrowser browser = new ValidationBrowser(GraphUtils.getFrame((Component)((Object)this.m_graph)), v.getBPELGraphPane(), v.getValidatableObject());
            browser.display();
        } else if (this.m_validatable != null) {
            ValidationBrowser browser = new ValidationBrowser(GraphUtils.getFrame((Component)((Object)this.m_graph)), this.m_graph, this.m_validatable);
            browser.display();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_applyBtn) {
            this.handleApply();
        } else if (src == this.m_okBtn) {
            this.handleOK();
        } else if (src == this.m_cancelBtn) {
            this.handleCancel();
        } else if (src == this.m_helpBtn) {
            this.handleHelp();
        } else if (src == this.m_validationBrowserBtn) {
            this.handleValidateBrowse();
        } else if (src == this.m_sourceBtn) {
            this.handleSource();
        }
    }

    @Override
    public void pageChanged(EditorPage page) {
        this.m_okBtn.setEnabled(true);
        this.m_applyBtn.setEnabled(true);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object src = e.getSource();
        if (src == this.m_tab) {
            EditorPage page;
            EditorPage[] pages = this.m_editorPageManager.getEditorPages();
            if (this.m_selectedTabIndex >= 0 && this.m_selectedTabIndex < pages.length) {
                page = pages[this.m_selectedTabIndex];
                page.onDeselection();
            }
            this.m_selectedTabIndex = this.m_tab.getSelectedIndex();
            if (this.m_selectedTabIndex >= 0 && this.m_selectedTabIndex < pages.length) {
                page = pages[this.m_selectedTabIndex];
                page.onSelection();
            }
        }
    }
}

