/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.validation.Validatable;
import oracle.tip.tools.ide.common.bpelparser.validation.ValidationContext;
import oracle.tip.tools.ide.common.graph.model.Node;
import oracle.tip.tools.ide.common.graph.view.AbstractNodeEditor;
import oracle.tip.tools.ide.common.graph.view.GraphPane;
import oracle.tip.tools.ide.common.graph.view.NodeRenderer;
import oracle.tip.tools.ide.common.graph.view.View;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.ValidatableView;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.ApplyCancelPanel;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.EditorPage;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.EditorPageManager;

public abstract class AbstractActivityNodeEditor
extends AbstractNodeEditor {
    public static final Dimension PREF_DIM = new Dimension(420, 390);
    protected ApplyCancelPanel m_editingPanel;
    protected PanelManager m_panelManager;
    protected Node m_node;

    public void helpInvoked() {
        if (this.m_editingPanel != null) {
            this.m_editingPanel.handleHelp();
        }
    }

    public Dimension getPreferredEditorSize() {
        return PREF_DIM;
    }

    public void cancelNodeEditing() {
        super.cancelNodeEditing();
        this.m_editingPanel = null;
    }

    public boolean stopNodeEditing() {
        this.fireEditingStopped();
        final NodeRenderer r = this.getNodeRenderer();
        if (r != null) {
            r.editingStopped();
        }
        this.m_editingPanel = null;
        if (r instanceof ValidatableView) {
            final ValidatableView view = (ValidatableView)r;
            final Validatable validator = view.getValidatableObject();
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    BPELGraphModel model = (BPELGraphModel)r.getGraphPane().getModel();
                    validator.getValidationReport(new ValidationContext(model.getProcess()), true);
                    view.updateStatusButtons();
                }
            };
            new Thread(runner).start();
        }
        return true;
    }

    public Validatable getValidatable() {
        Object userObj;
        if (this.m_node != null && (userObj = this.m_node.getUserObject()) instanceof Validatable) {
            return (Validatable)userObj;
        }
        return null;
    }

    public Activity getActivity() {
        Object userObj;
        if (this.m_node != null && (userObj = this.m_node.getUserObject()) instanceof Activity) {
            return (Activity)userObj;
        }
        return null;
    }

    public void loadData() {
        EditorPage[] pages = this.m_panelManager.m_pages;
        if (pages != null) {
            for (EditorPage page : pages) {
                page.loadData();
            }
        }
    }

    public Component getNodeEditorComponent(GraphPane pane, Activity a) {
        if (this.m_panelManager == null) {
            this.m_panelManager = new PanelManager();
        }
        this.m_panelManager.m_pages = this.getEditorPages(pane, null);
        if (this.m_panelManager.m_pages != null) {
            for (EditorPage p : this.m_panelManager.m_pages) {
                p.setUserObject(a);
            }
        }
        this.m_editingPanel = new ApplyCancelPanel(this, this.m_panelManager, (BPELGraphPane)pane);
        this.m_editingPanel.setValidatable(this.getValidatable());
        this.m_editingPanel.setValidatableStatus(this.getValidatable());
        this.m_editingPanel.setSelectedIndex(this.getSelectedIndex());
        return this.m_editingPanel;
    }

    public Component getNodeEditorComponent(GraphPane pane, Node n) {
        this.m_node = n;
        if (this.m_panelManager == null) {
            this.m_panelManager = new PanelManager();
        }
        Object userObj = null;
        if (n != null) {
            userObj = n.getUserObject();
        }
        this.m_panelManager.m_pages = this.getEditorPages(pane, n);
        if (this.m_panelManager.m_pages != null) {
            for (EditorPage p : this.m_panelManager.m_pages) {
                p.setUserObject(userObj);
            }
        }
        this.m_editingPanel = new ApplyCancelPanel(this, this.m_panelManager, (BPELGraphPane)pane);
        this.m_editingPanel.setValidatable(this.getValidatable());
        this.m_editingPanel.setValidatableStatus(this.getValidatable());
        this.m_editingPanel.setSelectedIndex(this.getSelectedIndex());
        return this.m_editingPanel;
    }

    public EditorPage[] getEditorPages(GraphPane pane, Node n) {
        return null;
    }

    public int getSelectedIndex() {
        return 0;
    }

    public Object getNodeEditorValue() {
        return this.m_node != null ? this.m_node.getUserObject() : null;
    }

    public boolean getRequiresFrame() {
        return true;
    }

    public boolean isInlineEditor() {
        NodeRenderer r = this.getNodeRenderer();
        if (r instanceof View) {
            View v = (View)r;
            Boolean b = (Boolean)v.getGraphPane().getProperty((Object)"USE_POPUP_NODE_EDITORS");
            return b == false;
        }
        return true;
    }

    public void setFocus() {
        if (this.m_editingPanel == null) {
            return;
        }
        JRootPane p = (JRootPane)SwingUtilities.getAncestorOfClass(JRootPane.class, this.m_editingPanel);
        if (p != null) {
            p.setDefaultButton(this.m_editingPanel.m_okBtn);
        }
    }

    public static class PanelManager
    implements EditorPageManager {
        protected EditorPage[] m_pages;

        @Override
        public EditorPage[] getEditorPages() {
            return this.m_pages;
        }

        @Override
        public boolean validateEditorChanges() {
            if (this.m_pages != null) {
                for (EditorPage p : this.m_pages) {
                    if (p.validateEditorChanges()) continue;
                    return false;
                }
            }
            return true;
        }

        @Override
        public void saveChanges() {
            if (this.m_pages != null) {
                for (EditorPage p : this.m_pages) {
                    p.saveChanges();
                }
            }
        }
    }
}

