/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.views;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import oracle.tip.tools.ide.common.bpeldesigner.models.schema.NSResolverFactory;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.While;
import oracle.tip.tools.ide.common.expressionbuilder.BpelExpressionBuilder;
import oracle.tip.tools.ide.common.expressionbuilder.ExpressionBuilderPicker;
import oracle.tip.tools.ide.common.expressionbuilders.FunctionsExpressionBuilderPicker;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.graph.actions.GraphAction;
import oracle.tip.tools.ide.common.graph.model.DroppableBranchNode;
import oracle.tip.tools.ide.common.graph.view.ActionInfo;
import oracle.tip.tools.ide.common.graph.view.CollapseExpandViewAction;
import oracle.tip.tools.ide.common.graph.view.GraphImageResource;
import oracle.tip.tools.ide.common.graph.view.GraphPane;
import oracle.tip.tools.ide.common.graph.view.NodeRenderer;
import oracle.tip.tools.ide.common.graph.view.Tabable;
import oracle.tip.tools.ide.common.graph.view.View;
import oracle.tip.tools.ide.common.graph.view.VoiceAccessible;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.ui.imagecache.BasicImageCache;
import oracle.tip.tools.ide.common.ui.rezpopup.RezPopup;
import oracle.tip.tools.ide.common.utils.NamespaceResolver;
import oracle.tip.tools.ide.common.xpath.editor.XPathEditorPane;
import oracle.tip.tools.ide.common.xpath.editor.util.VariableDataCallBack;
import oracle.tip.tools.ide.pm.addin.model.BPELXmlModel;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariableDataCallBackImpl;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariableExpressionBuilderPicker;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariablePickerPanel;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.BasicVerticalBranchView;
import oracle.tip.tools.ide.pm.bpelgraph.views.StateSaveableView;
import oracle.tip.tools.ide.pm.bpelgraph.views.StatusBoxButton;
import oracle.tip.tools.ide.pm.bpelgraph.views.ValidationStatusBoxButton;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class WhileView2
extends BasicVerticalBranchView
implements StateSaveableView,
Tabable,
VoiceAccessible {
    public static String LABEL_PLACE_HOLDER = "<label>";
    private static Image m_image = ImageCache.getImage("graph/bpel/while_47x47.png");
    private static Image m_disabledImage = BasicImageCache.createDisabledImage((Image)m_image);
    private boolean m_bNameHover = false;

    public WhileView2(GraphPane pane, View parent, DroppableBranchNode n) {
        super(pane, parent, n);
        this.m_topToBranch = 4;
        this.setCollapsable(true);
        Boolean val = (Boolean)n.getData((Object)"collapsed");
        if (val != null) {
            this.setCollapsed(val);
        } else {
            this.setCollapsed(true);
        }
    }

    @Override
    public void setHovered(boolean bHovered, MouseEvent evt) {
        boolean bRepaint = false;
        boolean bOldValue = this.m_bNameHover;
        this.m_bNameHover = this.m_nameBox.contains(evt.getX(), evt.getY());
        if (bOldValue != this.m_bNameHover) {
            bRepaint = true;
        }
        BPELGraphPane graph = (BPELGraphPane)this.getGraphPane();
        if (this.isMinimized()) {
            boolean bHitImage = this.m_imageBounds.contains(evt.getX(), evt.getY());
            if (bHovered && bHitImage) {
                this.m_bMagnified = true;
                graph.addMagnifyView((NodeRenderer)this);
            } else {
                this.m_bMagnified = false;
                graph.removeMagnifyView((NodeRenderer)this);
            }
        }
        this.m_viewStatusBox.clearHighlights();
        StatusBoxButton btn = this.m_viewStatusBox.hitTest(evt.getX(), evt.getY());
        if (btn != null) {
            btn.setHighLightOn(true);
        }
        this.m_configBox.clearHighlights();
        this.m_collapsedConfigBox.clearHighlights();
        ActionInfo info = this.hitActionArea(evt.getX(), evt.getY());
        if (info != null) {
            info.setHighlighted(bHovered);
        }
        if (bRepaint) {
            graph.repaint();
        }
    }

    @Override
    public Cursor getCursor(int x, int y) {
        if (this.m_nameBox.contains(x, y)) {
            return Cursor.getPredefinedCursor(12);
        }
        Cursor c = super.getCursor(x, y);
        if (c != null) {
            return c;
        }
        if (this.isSelected() && this.isDraggable()) {
            return Cursor.getPredefinedCursor(13);
        }
        return null;
    }

    @Override
    protected Icon getMinimizedIcon() {
        return ImageCache.getIcon("application/bpel/while_16x16.png");
    }

    @Override
    protected String getText() {
        While n = (While)this.getNode().getUserObject();
        String lbl = n.getUserLabel();
        if (lbl == null || lbl.trim().length() == 0) {
            return LABEL_PLACE_HOLDER;
        }
        return lbl;
    }

    @Override
    protected Image getImage() {
        return this.isEditable() ? m_image : m_disabledImage;
    }

    @Override
    protected boolean requiresSequence() {
        return true;
    }

    @Override
    protected StatusBoxButton[] getStatusButtons() {
        this.m_statusButtons.clear();
        this.m_statusButtons.add(new ValidationStatusBoxButton(this));
        return this.m_statusButtons.toArray(new StatusBoxButton[this.m_statusButtons.size()]);
    }

    @Override
    protected void paintText(Graphics g) {
        GraphUtils.drawRoundRect((Graphics)g, (int)this.m_nameBox.x, (int)this.m_nameBox.y, (int)this.m_nameBox.width, (int)this.m_nameBox.height, (float)1.0f, (Color)Color.lightGray);
        if (this.m_bNameHover) {
            g.setColor(Color.cyan);
            g.fillRoundRect(this.m_nameBox.x, this.m_nameBox.y, this.m_nameBox.width, this.m_nameBox.height, 10, 10);
            GraphUtils.drawRoundRect((Graphics)g, (int)this.m_nameBox.x, (int)this.m_nameBox.y, (int)this.m_nameBox.width, (int)this.m_nameBox.height, (float)1.0f, (Color)Color.black);
        }
        if (this.m_displayText != null) {
            Font oldFont = g.getFont();
            g.setFont(TEXT_FONT);
            int ascent = GraphUtils.getFontAscent((Font)TEXT_FONT);
            Color c = this.m_displayText.equals(LABEL_PLACE_HOLDER) ? Color.LIGHT_GRAY : Color.BLACK;
            g.setColor(c);
            g.drawString(this.m_displayText, this.m_nameBounds.x, this.m_nameBounds.y + ascent);
            g.setFont(oldFont);
        }
    }

    public String getToolTipText() {
        While activity = (While)this.getNode().getUserObject();
        String settingsText = BPELStringTranslator.getString("COLLAXALAF_SETTINGS");
        String text = "<html><body><table><tr><td colspan=2 align=center bgcolor=cyan><b>While " + settingsText + "</b></td></tr>";
        text = text + WhileView2.getRowHTML("Name", activity.getName());
        text = text + WhileView2.getRowHTML("Condition", activity.getCondition());
        text = text + "</table></body></html>";
        return text;
    }

    protected static String getRowHTML(String name, String value) {
        if (value == null) {
            value = "";
        }
        return "<tr><td><b>" + name + ":</b></td><td>" + value + "</td></tr>";
    }

    public boolean getAcceptsArrow() {
        return true;
    }

    @Override
    public List<GraphAction> createActions() {
        ArrayList<GraphAction> actions = new ArrayList<GraphAction>();
        this.m_collapseAction = new CollapseExpandViewAction((View)this, (Icon)new ImageIcon(GraphImageResource.COLLAPSE_ICON), (Icon)new ImageIcon(GraphImageResource.EXPAND_ICON));
        actions.add((GraphAction)this.m_collapseAction);
        return actions;
    }

    @Override
    public boolean handleMousePressed(MouseEvent evt) {
        if (this.m_nameBounds.contains(evt.getX(), evt.getY())) {
            this.editCondition();
            return true;
        }
        StatusBoxButton btn = this.m_viewStatusBox.hitTest(evt.getX(), evt.getY());
        if (btn != null && btn.isVisible()) {
            btn.mouseClicked(evt);
            return true;
        }
        return false;
    }

    private void editCondition() {
        RezPopup popup = new RezPopup();
        JPanel p = this.createConditionPanel((JPopupMenu)popup);
        popup.addPopupComponent((Component)p);
        popup.show((Component)((Object)this.getBPELGraphPane()), this.m_nameBounds.x, this.m_nameBounds.y + this.m_nameBounds.height);
    }

    protected final NamespaceResolver getNSResolver(Activity activity) {
        GraphPane graphPane = this.getGraphPane();
        BPELGraphModel graphModel = (BPELGraphModel)graphPane.getModel();
        Process processModel = graphModel.getProcess();
        return NSResolverFactory.getNSResolver((Activity)activity, (Process)processModel);
    }

    protected JPanel createConditionPanel(final JPopupMenu popup) {
        final BPELGraphPane graphPane = (BPELGraphPane)this.getGraphPane();
        final While whileLoop = (While)this.getNode().getUserObject();
        String condition = whileLoop.getCondition();
        String label = whileLoop.getUserLabel();
        String name = whileLoop.getName();
        final JButton expressionBtn = new JButton(ImageCache.getIcon("edit_expression16"));
        expressionBtn.setToolTipText(BPELStringTranslator.getString("LAUNCH_EXPRESSION_BUILDER_TIP"));
        final JTextArea conditionArea = new JTextArea(condition);
        conditionArea.setWrapStyleWord(true);
        conditionArea.setLineWrap(true);
        final JButton okBtn = new JButton("OK");
        final JButton cancelBtn = new JButton("Cancel");
        JPanel btnPnl = new JPanel(new GridLayout(1, 2, 5, 0));
        btnPnl.setOpaque(false);
        btnPnl.add(okBtn);
        btnPnl.add(cancelBtn);
        final JTextField labelField = new JTextField(label);
        PopupMenuListener l = new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                labelField.requestFocusInWindow();
            }
        };
        popup.addPopupMenuListener(l);
        final JTextField nameField = new JTextField(name);
        nameField.setEditable(false);
        labelField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.syncField(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.syncField(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.syncField(e);
            }

            private void syncField(DocumentEvent e) {
                try {
                    Document doc = e.getDocument();
                    String text = doc.getText(0, doc.getLength());
                    StringBuffer sb = new StringBuffer();
                    for (int i = 0; i < text.length(); ++i) {
                        char ch = text.charAt(i);
                        if (i == 0) {
                            if (!Character.isJavaIdentifierStart(ch)) {
                                sb.append('$');
                                continue;
                            }
                            sb.append(ch);
                            continue;
                        }
                        if (!Character.isJavaIdentifierPart(ch)) {
                            sb.append('_');
                            continue;
                        }
                        sb.append(ch);
                    }
                    nameField.setText(sb.toString());
                }
                catch (BadLocationException e1) {
                    e1.printStackTrace();
                }
            }
        });
        JLabel lbl = new JLabel();
        BPELStringTranslator.setLabel(lbl, labelField, BPELStringTranslator.getString("LABEL_LBL"));
        JLabel nameLbl = new JLabel();
        BPELStringTranslator.setLabel(nameLbl, nameField, BPELStringTranslator.getString("NAME_LBL"));
        JLabel condLbl = new JLabel();
        BPELStringTranslator.setLabel(condLbl, conditionArea, BPELStringTranslator.getString("CONDITION_LBL"));
        JToolBar tb = UIHelper.createToolBar();
        tb.add(expressionBtn);
        ActionListener lst = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object src = e.getSource();
                if (src == expressionBtn) {
                    NamespaceResolver nsResolver = WhileView2.this.getNSResolver((Activity)whileLoop);
                    BPELXmlModel mainModel = graphPane.getBPELXmlModel();
                    VariableDataCallBackImpl dataCallBack = new VariableDataCallBackImpl(mainModel, (Activity)whileLoop, nsResolver);
                    VariablePickerPanel p = new VariablePickerPanel(graphPane, dataCallBack, nsResolver);
                    VariableExpressionBuilderPicker picker = new VariableExpressionBuilderPicker(p, (Activity)whileLoop);
                    ExpressionBuilderPicker[] pickers = new ExpressionBuilderPicker[]{picker, new FunctionsExpressionBuilderPicker(nsResolver)};
                    XPathEditorPane editorPane = new XPathEditorPane();
                    editorPane.initializeDocument();
                    editorPane.initializeEditorPane((VariableDataCallBack)dataCallBack, conditionArea.getText(), nsResolver, false);
                    popup.setVisible(false);
                    BpelExpressionBuilder dlg = new BpelExpressionBuilder(GraphUtils.getFrame((Component)((Object)graphPane)), (JTextComponent)editorPane, pickers);
                    if (dlg.display() == 0) {
                        conditionArea.setText(dlg.getExpressionText());
                    }
                    popup.setVisible(true);
                } else if (src == okBtn) {
                    popup.setVisible(false);
                    String label = labelField.getText();
                    whileLoop.setUserLabel(label);
                    whileLoop.setCondition(conditionArea.getText());
                    whileLoop.setName(nameField.getText());
                    graphPane.forceImmediateLayout(false);
                } else if (src == cancelBtn) {
                    popup.setVisible(false);
                }
            }
        };
        expressionBtn.addActionListener(lst);
        okBtn.addActionListener(lst);
        cancelBtn.addActionListener(lst);
        JPanel topPnl = new JPanel(new GridBagLayout());
        topPnl.setOpaque(false);
        GraphUtils.addComponent((Container)topPnl, (Component)lbl, (int)0, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)topPnl, (Component)labelField, (int)1, (int)0, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(0, 5, 0, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)topPnl, (Component)nameLbl, (int)0, (int)1, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 0, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)topPnl, (Component)nameField, (int)1, (int)1, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(5, 5, 0, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        JPanel p = new JPanel(new GridBagLayout());
        p.setBackground(Color.white);
        GraphUtils.addComponent((Container)p, (Component)topPnl, (int)0, (int)0, (int)2, (int)1, (int)17, (int)2, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)condLbl, (int)0, (int)1, (int)1, (int)1, (int)16, (int)0, (Insets)new Insets(5, 5, 2, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)tb, (int)0, (int)1, (int)1, (int)1, (int)14, (int)0, (Insets)new Insets(5, 5, 0, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)new JScrollPane(conditionArea), (int)0, (int)2, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)p, (Component)btnPnl, (int)0, (int)3, (int)2, (int)1, (int)13, (int)0, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        p.setPreferredSize(new Dimension(300, 200));
        return p;
    }

    public String getVoiceAccessibleText() {
        return "While ";
    }
}

