/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.views;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.bpelparser.iface.While;
import oracle.tip.tools.ide.common.bpelparser.validation.Validatable;
import oracle.tip.tools.ide.common.bpelparser.validation.ValidationReport;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.graph.actions.GraphAction;
import oracle.tip.tools.ide.common.graph.model.Node;
import oracle.tip.tools.ide.common.graph.view.ActionInfo;
import oracle.tip.tools.ide.common.graph.view.BaseView;
import oracle.tip.tools.ide.common.graph.view.CollapseExpandViewAction;
import oracle.tip.tools.ide.common.graph.view.GraphImageResource;
import oracle.tip.tools.ide.common.graph.view.GraphPane;
import oracle.tip.tools.ide.common.graph.view.LayoutInfo;
import oracle.tip.tools.ide.common.graph.view.NodeRenderer;
import oracle.tip.tools.ide.common.graph.view.Tabable;
import oracle.tip.tools.ide.common.graph.view.ToolTipable;
import oracle.tip.tools.ide.common.graph.view.View;
import oracle.tip.tools.ide.common.graph.view.VoiceAccessible;
import oracle.tip.tools.ide.common.ui.imagecache.BasicImageCache;
import oracle.tip.tools.ide.pm.bpelgraph.actions.EditExpressionAction;
import oracle.tip.tools.ide.pm.bpelgraph.model.WhileNode;
import oracle.tip.tools.ide.pm.bpelgraph.settings.BPELSettings;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELVerticalDropBranchView;
import oracle.tip.tools.ide.pm.bpelgraph.views.CollaxaDropView;
import oracle.tip.tools.ide.pm.bpelgraph.views.ConfigBox;
import oracle.tip.tools.ide.pm.bpelgraph.views.Magnifiable;
import oracle.tip.tools.ide.pm.bpelgraph.views.StateSaveableView;
import oracle.tip.tools.ide.pm.bpelgraph.views.StatusBoxButton;
import oracle.tip.tools.ide.pm.bpelgraph.views.ValidatableView;
import oracle.tip.tools.ide.pm.bpelgraph.views.ValidationStatusBoxButton;
import oracle.tip.tools.ide.pm.bpelgraph.views.ViewStatusBox;
import oracle.tip.tools.ide.pm.plugin.BPELModelerPlugin;
import oracle.tip.tools.ide.pm.plugin.BPELPlugInManager;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class WhileView
extends BPELVerticalDropBranchView
implements ValidatableView,
Magnifiable,
StateSaveableView,
Tabable,
VoiceAccessible {
    protected static Font TEXT_FONT = new Font(UIManager.getFont("Label.font").getFontName(), 0, 11);
    protected Image m_image = ImageCache.getImage("graph/bpel/while_47x47.png");
    protected Image m_disabledImage = BasicImageCache.createDisabledImage((Image)this.m_image);
    protected Image m_minimizedImage = ImageCache.getImage("application/bpel/while_16x16.png");
    protected int m_borderWidth = 2;
    protected int m_borderToImage = 1;
    protected int m_imageToBranch = 2;
    protected int m_branchToBottom = 10;
    protected int m_minWidth = 100;
    protected int m_minHeight = 100;
    protected int m_minimizedMinWidth = 35;
    protected int m_minimizedMinHeight = 35;
    protected int m_sidePadding = 5;
    protected int m_imageToConfigTab = 3;
    protected int m_minimizedBorderWidth = 2;
    protected static Color m_branchBorderClr = new Color(218, 218, 218);
    protected ConfigBox m_configBox;
    protected ConfigBox m_collapsedConfigBox;
    protected CollapseExpandViewAction m_collapseAction;
    protected ConfigBox m_minimizedConfigBox;
    protected ViewStatusBox m_viewStatusBox;
    protected List<StatusBoxButton> m_statusButtons = new ArrayList<StatusBoxButton>();
    protected boolean m_bMagnified = false;
    protected int m_magnifiedVertPadding = 5;
    protected int m_magnifiedHorzPadding = 5;

    public WhileView(GraphPane pane, View parent, WhileNode n) {
        super(pane, parent, n);
        this.m_viewStatusBox = new ViewStatusBox((View)this, 0);
        this.m_viewStatusBox.addStatusBoxButtons(this.getStatusButtons());
        this.setAcceptsArrow(true);
        this.setCanSelect(true);
        this.setCollapsable(true);
        this.m_configBox = new ConfigBox((View)this, this.getActions(), 0);
        this.m_configBox.setInsets(0, 0, 0, 0);
        this.m_collapsedConfigBox = new ConfigBox((View)this, this.getCollapsedActions(), 0);
        this.m_collapsedConfigBox.setInsets(0, 0, 0, 0);
        this.m_collapsedConfigBox.setBorderColor(null);
        this.m_minimizedConfigBox = new ConfigBox((View)this, this.getMinimizedActions(), 0);
        this.m_minimizedConfigBox.setInsets(0, 0, 0, 0);
        this.m_minimizedConfigBox.setMinimizeMode(true);
        this.setInsets(this.m_borderWidth + this.m_borderToImage + this.m_image.getHeight(null) + this.m_imageToBranch, this.m_borderWidth + this.m_sidePadding, this.m_branchToBottom, this.m_borderWidth + this.m_sidePadding);
        Boolean val = (Boolean)n.getData("collapsed");
        if (val != null) {
            this.setCollapsed(val);
        } else {
            this.setCollapsed(true);
        }
    }

    public boolean isMinimized() {
        BPELGraphPane pane = (BPELGraphPane)this.getGraphPane();
        if (pane.isOptimized()) {
            return true;
        }
        BPELGraphPane graph = (BPELGraphPane)this.getGraphPane();
        BPELSettings settings = graph.getSettings();
        Boolean b = (Boolean)settings.m_iconizeStateMap.get("MINIMIZE_WHILES");
        return b == null ? false : b;
    }

    @Override
    public View getView() {
        return this;
    }

    public ConfigBox getConfigBox() {
        return this.m_configBox;
    }

    protected StatusBoxButton[] getStatusButtons() {
        this.m_statusButtons.clear();
        this.m_statusButtons.add(new ValidationStatusBoxButton(this));
        for (BPELModelerPlugin plugin : BPELPlugInManager.getPlugins()) {
            List<StatusBoxButton> buttons = plugin.addViewStatusButtons((View)this);
            if (buttons == null) continue;
            this.m_statusButtons.addAll(buttons);
        }
        return this.m_statusButtons.toArray(new StatusBoxButton[this.m_statusButtons.size()]);
    }

    protected void generateValidationReport() {
        Validatable a = this.getValidatableObject();
        if (a != null) {
            a.getValidationReport(this.createValidationContext(), true);
            this.updateStatusButtons();
        }
    }

    protected boolean hasWarning() {
        Validatable a = this.getValidatableObject();
        if (a != null) {
            ValidationReport r = a.getValidationReport(this.createValidationContext(), false);
            if (r == null) {
                return false;
            }
            return r.getState() != 0;
        }
        return false;
    }

    public void setHovered(boolean bHovered, MouseEvent evt) {
        if (this.isMinimized() && this.isCollapsed()) {
            BPELGraphPane graph = (BPELGraphPane)this.getGraphPane();
            if (bHovered) {
                this.m_bMagnified = true;
                graph.addMagnifyView((NodeRenderer)this);
            } else {
                this.m_bMagnified = false;
                graph.removeMagnifyView((NodeRenderer)this);
            }
        }
        this.m_viewStatusBox.clearHighlights();
        StatusBoxButton btn = this.m_viewStatusBox.hitTest(evt.getX(), evt.getY());
        if (btn != null) {
            btn.setHighLightOn(true);
        }
        this.m_configBox.clearHighlights();
        this.m_collapsedConfigBox.clearHighlights();
        ActionInfo info = this.hitActionArea(evt.getX(), evt.getY());
        if (info != null) {
            info.setHighlighted(bHovered);
        }
    }

    public ToolTipable getToolTipable(int x, int y) {
        ActionInfo info = this.hitActionArea(x, y);
        if (info != null) {
            return info.getToolTipable();
        }
        StatusBoxButton btn = this.m_viewStatusBox.hitTest(x, y);
        if (btn != null) {
            return btn;
        }
        return this;
    }

    public String getToolTipText() {
        While w = (While)this.getNode().getUserObject();
        String s = w.getCondition();
        if (Helper.hasValue((String)s)) {
            return "<html>&nbsp;<b>Condition Expression:</b><br>&nbsp;" + s + "&nbsp;</html>";
        }
        return "<html>&nbsp;<font color=red><b>ERROR</b></font><br>&nbsp;Condition Expression is invalid!&nbsp;</html>";
    }

    public boolean getAcceptsArrow() {
        return this.isCollapsed();
    }

    public List<GraphAction> getMinimizedActions() {
        ArrayList<GraphAction> actions = new ArrayList<GraphAction>();
        actions.add((GraphAction)this.m_collapseAction);
        return actions;
    }

    public List<GraphAction> getActions() {
        ArrayList<GraphAction> actions = new ArrayList<GraphAction>();
        this.m_collapseAction = new CollapseExpandViewAction((View)this, (Icon)new ImageIcon(GraphImageResource.COLLAPSE_ICON), (Icon)new ImageIcon(GraphImageResource.EXPAND_ICON));
        actions.add((GraphAction)this.m_collapseAction);
        actions.add(new EditExpressionAction((View)this, true));
        return actions;
    }

    public List<GraphAction> getCollapsedActions() {
        ArrayList<GraphAction> actions = new ArrayList<GraphAction>();
        actions.add((GraphAction)this.m_collapseAction);
        return actions;
    }

    public void setCollapsed(boolean bCollapse) {
        super.setCollapsed(bCollapse);
        this.m_collapseAction.setIconState();
        if (this.m_bMagnified) {
            this.m_bMagnified = false;
            ((BPELGraphPane)this.getGraphPane()).removeMagnifyView((NodeRenderer)this);
        }
    }

    public boolean handleMousePressed(MouseEvent evt) {
        StatusBoxButton btn = this.m_viewStatusBox.hitTest(evt.getX(), evt.getY());
        if (btn != null && btn.isVisible()) {
            btn.mouseClicked(evt);
            return true;
        }
        return false;
    }

    public Cursor getCursor(int x, int y) {
        StatusBoxButton btn = this.m_viewStatusBox.hitTest(x, y);
        if (btn != null && btn.isClickable()) {
            return Cursor.getPredefinedCursor(12);
        }
        ActionInfo info = this.hitActionArea(x, y);
        if (info != null) {
            return Cursor.getPredefinedCursor(12);
        }
        if (this.isSelected() && this.isDraggable()) {
            return Cursor.getPredefinedCursor(13);
        }
        return null;
    }

    public void editingStopped() {
        this.generateValidationReport();
        this.getGraphPane().repaint();
    }

    public ActionInfo hitActionArea(int x, int y) {
        if (this.isMinimized()) {
            return this.m_minimizedConfigBox.hitActionArea(x, y);
        }
        if (this.isCollapsed()) {
            return this.m_collapsedConfigBox.hitActionArea(x, y);
        }
        if (this.isSelected()) {
            return this.m_configBox.hitActionArea(x, y);
        }
        return null;
    }

    public void move(int x, int y) {
        super.move(x, y);
        this.m_minimizedConfigBox.move(x, y);
        this.m_configBox.move(x, y);
        this.m_viewStatusBox.move(x, y);
        this.m_collapsedConfigBox.move(x, y);
    }

    protected Rectangle computeMagnifiedBounds() {
        Image img = this.getActivityImage();
        int iWidth = 0;
        int iHeight = 0;
        if (img != null) {
            iWidth = img.getWidth(null);
            iHeight = img.getHeight(null);
        }
        String s = "While";
        int fontHeight = GraphUtils.getFontHeight((Font)TEXT_FONT);
        int strWidth = GraphUtils.getStringWidth((Font)TEXT_FONT, (String)s);
        int w = Math.max(iWidth, strWidth) + 2 * this.m_magnifiedHorzPadding;
        int h = this.m_magnifiedVertPadding + iHeight + this.m_magnifiedVertPadding + fontHeight + this.m_magnifiedVertPadding;
        Rectangle r = new Rectangle(this.m_bounds.x, this.m_bounds.y, w, h);
        r.x = this.m_bounds.x + this.m_bounds.width / 2 - r.width / 2;
        r.y = this.m_bounds.y + this.m_bounds.height / 2 - r.height / 2;
        r.x += this.m_bounds.width + 20;
        if (r.width < 80) {
            r.width = 80;
        }
        if (r.height < 80) {
            r.height = 80;
        }
        return r;
    }

    @Override
    public void paintMagnified(Graphics g) {
        int xOffset;
        Rectangle r = this.computeMagnifiedBounds();
        Image img = ImageCache.getImage("graph/bpel/while_47x47.png");
        String s = "";
        int strWidth = GraphUtils.getStringWidth((Font)TEXT_FONT, (String)s);
        int fontAscent = GraphUtils.getFontAscent((Font)TEXT_FONT);
        GraphUtils.paintTransparentRectangle((Graphics)g, (Rectangle)this.m_bounds, (Color)Color.cyan, (float)0.3f);
        Color lineClr = Color.cyan.darker();
        g.setColor(lineClr);
        g.drawRoundRect(this.m_bounds.x, this.m_bounds.y, this.m_bounds.width, this.m_bounds.height, 10, 10);
        GraphUtils.drawLine((Graphics)g, (int)this.rightX(), (int)this.topY(), (int)r.x, (int)(r.y + 10), (float)1.5f, (Color)Color.cyan.darker());
        GraphUtils.drawLine((Graphics)g, (int)this.rightX(), (int)this.bottomY(), (int)r.x, (int)(r.y + r.height - 10), (float)1.5f, (Color)Color.cyan.darker());
        Graphics2D g2 = (Graphics2D)g;
        Color c1 = new Color(223, 242, 249);
        Color c2 = new Color(197, 214, 233);
        GradientPaint gp = new GradientPaint(r.x, r.y, c1, r.x, r.y + r.height, c2);
        g2.setPaint(gp);
        g.fillRoundRect(r.x, r.y, r.width, r.height, 15, 15);
        g.setColor(lineClr);
        g.drawRoundRect(r.x, r.y, r.width, r.height, 15, 15);
        int iHeight = 0;
        if (img != null) {
            iHeight = img.getHeight(null);
            xOffset = (r.width - img.getWidth(null)) / 2;
            g.drawImage(img, r.x + xOffset, r.y + this.m_magnifiedVertPadding, null);
        }
        if (s != null) {
            xOffset = (r.width - strWidth) / 2;
            GraphUtils.paintText((String)s, (Graphics)g, (int)(r.x + xOffset), (int)(r.y + this.m_magnifiedVertPadding + iHeight + this.m_magnifiedVertPadding + fontAscent), (Color)this.getTextColor(), (Font)TEXT_FONT);
        }
        this.paintStatusIcons(g);
    }

    protected Color getTextColor() {
        return Color.black;
    }

    protected void paintSelectionBox(Graphics g, Rectangle r, int borderWidth) {
        BPELGraphPane graph = (BPELGraphPane)this.getGraphPane();
        Color c = graph.getSelectionColor();
        g.setColor(c);
        g.fillRect(r.x, r.y, r.width, borderWidth);
        g.fillRect(r.x, r.y + r.height - borderWidth, r.width, borderWidth);
        g.fillRect(r.x, r.y, borderWidth, r.height);
        g.fillRect(r.x + r.width - borderWidth, r.y, borderWidth, r.height);
        g.setColor(c.darker());
        g.drawRect(r.x, r.y, r.width, r.height);
        g.drawRect(r.x + borderWidth, r.y + borderWidth, r.width - 2 * borderWidth, r.height - 2 * borderWidth);
    }

    protected Icon getMinimizedIcon() {
        return ImageCache.getIcon("while_node");
    }

    public void paintMinimized(Graphics g, int layer) {
        if (this.isCollapsed()) {
            this.m_minimizedConfigBox.paint(g, Color.white);
            Icon icon = this.getMinimizedIcon();
            int iWidth = icon.getIconWidth();
            icon.paintIcon((Component)this.getGraphPane(), g, this.m_bounds.x + this.m_bounds.width / 2 - iWidth / 2, this.m_bounds.y + this.m_minimizedBorderWidth);
        } else {
            super.paint(g, layer);
            this.m_minimizedConfigBox.paint(g, BPELGraphPane.TAB_BACKGROUND_COLOR);
            g.setColor(m_branchBorderClr);
            g.drawRect(this.m_bounds.x + this.m_borderWidth, this.m_bounds.y + this.m_insets.top, this.m_bounds.width - 2 * this.m_borderWidth, this.m_bounds.height - this.m_insets.top - this.m_insets.bottom);
            int iWidth = this.m_minimizedImage.getWidth(null);
            g.drawImage(this.m_minimizedImage, this.m_connectionX - iWidth / 2, this.topY() + this.m_borderWidth + this.m_borderToImage, null);
        }
        if (this.isSelected()) {
            this.paintSelectionBox(g, this.m_bounds, this.m_minimizedBorderWidth);
        }
    }

    private Image getActivityImage() {
        return this.isEditable() ? this.m_image : this.m_disabledImage;
    }

    public void paint(Graphics g, int layer) {
        boolean bSelected = this.isSelected();
        if (bSelected) {
            g.setColor(BPELGraphPane.VIEW_SELECTION_BACKGROUND);
            g.fillRect(this.m_bounds.x, this.m_bounds.y, this.m_bounds.width, this.m_bounds.height);
        }
        if (this.isEditing()) {
            this.paintEditingMode(g);
            if (bSelected) {
                this.paintSelected(g);
            }
            return;
        }
        if (this.isMinimized()) {
            this.paintMinimized(g, layer);
            return;
        }
        Image img = this.getActivityImage();
        if (this.isCollapsed()) {
            this.m_collapsedConfigBox.paint(g, null);
            int iWidth = img.getWidth(null);
            g.drawImage(img, this.m_connectionX - iWidth / 2, this.topY() + this.m_borderWidth + this.m_borderToImage, null);
            this.paintStatusIcons(g);
        } else {
            this.paintChildViews(g, layer);
            this.paintConnections(g);
            if (bSelected) {
                this.m_configBox.paint(g, BPELGraphPane.TAB_BACKGROUND_COLOR);
            }
            g.setColor(m_branchBorderClr);
            g.drawRect(this.m_bounds.x + this.m_borderWidth, this.m_bounds.y + this.m_insets.top, this.m_bounds.width - 2 * this.m_borderWidth, this.m_bounds.height - this.m_insets.top - this.m_insets.bottom);
            int iWidth = img.getWidth(null);
            g.drawImage(img, this.m_connectionX - iWidth / 2, this.topY() + this.m_borderWidth + this.m_borderToImage, null);
            this.paintStatusIcons(g);
        }
        if (bSelected) {
            this.paintSelected(g);
        }
    }

    protected void paintStatusIcons(Graphics g) {
        this.m_viewStatusBox.paint(g);
    }

    @Override
    public void updateStatusButtons() {
        for (StatusBoxButton btn : this.m_statusButtons) {
            btn.updateStatus();
        }
        this.getGraphPane().repaint(this.m_bounds);
    }

    private void updateActions() {
        ConfigBox box = null;
        box = this.isMinimized() ? this.m_minimizedConfigBox : this.m_configBox;
        Iterator it = box.getActionInfos();
        while (it.hasNext()) {
            ActionInfo info = (ActionInfo)it.next();
            if (!(info.getAction() instanceof GraphAction)) continue;
            GraphAction ga = (GraphAction)info.getAction();
            ga.updateState();
        }
    }

    protected void paintSelected(Graphics g) {
        if (!this.isMinimized()) {
            BPELGraphPane graph = (BPELGraphPane)this.getGraphPane();
            BPELSettings settings = graph.getSettings();
            this.paintBorder(g, settings.m_selectedBorderBackgroundColor, this.m_borderWidth);
        }
    }

    protected Rectangle layoutMinimized(int x, int y, int w, int h, LayoutInfo info) {
        Node childNode;
        this.setInsets(this.m_minimizedBorderWidth + this.m_borderToImage + this.m_minimizedImage.getHeight(null) + this.m_imageToBranch, this.m_minimizedBorderWidth + this.m_sidePadding, this.m_branchToBottom, this.m_minimizedBorderWidth + this.m_sidePadding);
        this.notifyLayoutWillOccur();
        this.setBounds(x, y, 0, 0);
        Dimension configSize = this.m_minimizedConfigBox.getSize();
        int iWidth = this.m_minimizedImage.getWidth(null);
        int iHeight = this.m_minimizedImage.getHeight(null);
        int diamondToConfigSpacing = 3;
        if (this.isCollapsed()) {
            int radius = this.m_minimizedBorderWidth + diamondToConfigSpacing + configSize.width + diamondToConfigSpacing + iWidth / 2;
            this.setBounds(x, y, 2 * radius, this.m_minimizedBorderWidth + this.m_borderToImage + iHeight + this.m_minimizedBorderWidth);
            this.m_connectionX = this.midX();
            this.m_minimizedConfigBox.setBounds(this.m_bounds.x + this.m_minimizedBorderWidth + diamondToConfigSpacing, this.m_bounds.y + this.m_minimizedBorderWidth + this.m_borderToImage, configSize.width, configSize.height);
            return this.m_bounds;
        }
        Node whileNode = this.getNode();
        int numChildren = whileNode.getChildCount();
        if (numChildren == 3 && (childNode = whileNode.getChildNode(1)).getNodeType() == 103) {
            View v = this.getChildViewForNode(whileNode.getChildNode(0));
            if (v instanceof CollaxaDropView) {
                ((CollaxaDropView)v).setDropAllowed(false);
            }
            if ((v = this.getChildViewForNode(whileNode.getChildNode(2))) instanceof CollaxaDropView) {
                ((CollaxaDropView)v).setDropAllowed(false);
            }
        }
        this.m_bounds.height = this.m_insets.top + this.m_insets.bottom;
        int yPos = y + this.m_insets.top;
        int nChildren = this.m_children.size();
        boolean bTextMode = nChildren == 1;
        for (int i = 0; i < nChildren; ++i) {
            BaseView v = (BaseView)this.m_children.get(i);
            if (!(v instanceof CollaxaDropView)) continue;
            ((CollaxaDropView)v).setTextMode(bTextMode);
        }
        int maxLeft = 0;
        int maxRight = 0;
        int xPos = x + this.m_insets.left;
        for (int i = 0; i < nChildren; ++i) {
            BaseView v = (BaseView)this.m_children.get(i);
            if (i > 0) {
                yPos += this.m_verticalSpacing;
                this.m_bounds.height += this.m_verticalSpacing;
            }
            Rectangle r = v.layout(xPos, yPos, w, h, info);
            maxLeft = Math.max(maxLeft, v.getLeftWidth());
            maxRight = Math.max(maxRight, v.getRightWidth());
            yPos += r.height;
            this.m_bounds.height += r.height;
        }
        int minLeftWidth = this.m_borderWidth + configSize.width + this.m_imageToConfigTab + iWidth / 2;
        int minRigthWidth = iWidth / 2 + this.m_viewStatusBox.computeSize().width + this.m_borderWidth;
        int minRadius = Math.max(minLeftWidth, minRigthWidth);
        maxLeft = Math.max(maxLeft, minRadius);
        maxRight = Math.max(maxRight, minRadius);
        if (this.m_bounds.height < this.m_minimizedMinHeight) {
            this.m_bounds.height = this.m_minimizedMinHeight;
        }
        if (this.m_minimizedMinWidth / 2 > maxLeft) {
            maxLeft = this.m_minimizedMinWidth / 2;
        }
        if (this.m_minimizedMinWidth / 2 > maxRight) {
            maxRight = this.m_minimizedMinWidth / 2;
        }
        int halfImageWidth = this.m_minimizedImage.getWidth(null) / 2;
        maxLeft = Math.max(maxLeft, halfImageWidth + this.m_imageToConfigTab + configSize.width);
        maxRight = Math.max(maxRight, halfImageWidth);
        for (int i = 0; i < nChildren; ++i) {
            BaseView v = (BaseView)this.m_children.get(i);
            int xDiff = Math.max(0, maxLeft - v.getLeftWidth());
            if (xDiff <= 0) continue;
            v.move(xDiff, 0);
        }
        this.m_bounds.width = this.m_insets.left + maxLeft + maxRight + this.m_insets.right;
        this.m_connectionX = this.m_bounds.x + this.m_insets.left + maxLeft;
        this.stretchLastDropView();
        this.m_minimizedConfigBox.setBounds(this.m_connectionX - iWidth / 2 - configSize.width - 1, this.m_bounds.y + this.m_minimizedBorderWidth + this.m_borderToImage + iHeight / 2 - configSize.height / 2, configSize.width, configSize.height);
        return this.m_bounds;
    }

    public Rectangle layout(int x, int y, int w, int h, LayoutInfo info) {
        Node childNode;
        this.updateActions();
        this.updateStatusButtons();
        if (this.isEditing()) {
            return this.layoutEditingMode(x, y, w, h, info);
        }
        if (this.isMinimized()) {
            return this.layoutMinimized(x, y, w, h, info);
        }
        Image img = this.getActivityImage();
        this.setInsets(this.m_borderWidth + this.m_borderToImage + img.getHeight(null) + this.m_imageToBranch, this.m_borderWidth + this.m_sidePadding, this.m_branchToBottom, this.m_borderWidth + this.m_sidePadding);
        this.notifyLayoutWillOccur();
        this.setBounds(x, y, 0, 0);
        Dimension tabSize = this.m_configBox.getSize();
        int iWidth = img.getWidth(null);
        int iHeight = img.getHeight(null);
        int diamondToConfigSpacing = 3;
        if (this.isCollapsed()) {
            Dimension boxSize = this.m_collapsedConfigBox.getSize();
            Dimension statusDim = this.m_viewStatusBox.computeSize();
            int left = this.m_borderWidth + boxSize.width + diamondToConfigSpacing + iWidth / 2;
            int right = diamondToConfigSpacing + iWidth / 2 + statusDim.width + this.m_borderWidth;
            int width = 2 * Math.max(left, right);
            this.setBounds(x, y, width, this.m_borderWidth + this.m_borderToImage + iHeight + this.m_borderWidth);
            this.m_connectionX = this.midX();
            this.m_collapsedConfigBox.setBounds(this.m_connectionX - iWidth / 2 - diamondToConfigSpacing - boxSize.width, this.m_bounds.y + this.m_borderWidth + this.m_borderToImage + iHeight / 2 - tabSize.height / 2, boxSize.width, boxSize.height);
            this.m_viewStatusBox.layout(this.m_connectionX + iWidth / 2, this.m_bounds.y + this.m_borderWidth + this.m_borderToImage + iHeight / 2 - tabSize.height / 2);
            return this.m_bounds;
        }
        Node whileNode = this.getNode();
        int numChildren = whileNode.getChildCount();
        if (numChildren == 3 && (childNode = whileNode.getChildNode(1)).getNodeType() == 103) {
            View v = this.getChildViewForNode(whileNode.getChildNode(0));
            if (v instanceof CollaxaDropView) {
                ((CollaxaDropView)v).setDropAllowed(false);
            }
            if ((v = this.getChildViewForNode(whileNode.getChildNode(2))) instanceof CollaxaDropView) {
                ((CollaxaDropView)v).setDropAllowed(false);
            }
        }
        this.m_bounds.height = this.m_insets.top + this.m_insets.bottom;
        int yPos = y + this.m_insets.top;
        int nChildren = this.m_children.size();
        boolean bTextMode = nChildren == 1;
        for (int i = 0; i < nChildren; ++i) {
            BaseView v = (BaseView)this.m_children.get(i);
            if (!(v instanceof CollaxaDropView)) continue;
            ((CollaxaDropView)v).setTextMode(bTextMode);
        }
        int maxLeft = 0;
        int maxRight = 0;
        int xPos = x + this.m_insets.left;
        for (int i = 0; i < nChildren; ++i) {
            BaseView v = (BaseView)this.m_children.get(i);
            if (i > 0) {
                yPos += this.m_verticalSpacing;
                this.m_bounds.height += this.m_verticalSpacing;
            }
            Rectangle r = v.layout(xPos, yPos, w, h, info);
            maxLeft = Math.max(maxLeft, v.getLeftWidth());
            maxRight = Math.max(maxRight, v.getRightWidth());
            yPos += r.height;
            this.m_bounds.height += r.height;
        }
        int minLeftWidth = this.m_borderWidth + tabSize.width + this.m_imageToConfigTab + iWidth / 2;
        int minRigthWidth = iWidth / 2 + this.m_viewStatusBox.computeSize().width + this.m_borderWidth;
        int minRadius = Math.max(minLeftWidth, minRigthWidth);
        maxLeft = Math.max(maxLeft, minRadius);
        maxRight = Math.max(maxRight, minRadius);
        if (this.m_bounds.height < this.m_minHeight) {
            this.m_bounds.height = this.m_minHeight;
        }
        if (this.m_minWidth / 2 > maxLeft) {
            maxLeft = this.m_minWidth / 2;
        }
        if (this.m_minWidth / 2 > maxRight) {
            maxRight = this.m_minWidth / 2;
        }
        int halfImageWidth = img.getWidth(null) / 2;
        maxLeft = Math.max(maxLeft, halfImageWidth + this.m_imageToConfigTab + tabSize.width);
        maxRight = Math.max(maxRight, halfImageWidth);
        for (int i = 0; i < nChildren; ++i) {
            BaseView v = (BaseView)this.m_children.get(i);
            int xDiff = Math.max(0, maxLeft - v.getLeftWidth());
            if (xDiff <= 0) continue;
            v.move(xDiff, 0);
        }
        this.m_bounds.width = this.m_insets.left + maxLeft + maxRight + this.m_insets.right;
        this.m_connectionX = this.m_bounds.x + this.m_insets.left + maxLeft;
        this.stretchLastDropView();
        this.m_configBox.setBounds(this.m_connectionX - iWidth / 2 - this.m_imageToConfigTab - tabSize.width, this.m_bounds.y + this.m_borderWidth + this.m_borderToImage + iHeight / 2 - tabSize.height / 2, tabSize.width, tabSize.height);
        this.m_viewStatusBox.layout(this.m_connectionX + iWidth / 2, this.m_bounds.y + this.m_borderWidth + this.m_borderToImage + iHeight / 2 - tabSize.height / 2);
        return this.m_bounds;
    }

    @Override
    public Validatable getValidatableObject() {
        Object obj = this.getNode().getUserObject();
        if (obj instanceof Validatable) {
            return (Validatable)obj;
        }
        return null;
    }

    @Override
    public BPELGraphPane getBPELGraphPane() {
        return (BPELGraphPane)this.getGraphPane();
    }

    public String getVoiceAccessibleText() {
        return "While";
    }
}

