/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.views;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import oracle.tip.tools.ide.common.graph.view.View;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

class WarningHitBox {
    static Insets m_insets = new Insets(5, 5, 5, 5);
    View m_view;
    Rectangle m_bounds;
    boolean m_bHighLight;
    static Color m_bgColor = new Color(236, 233, 216);
    static Color m_borderColor = new Color(113, 111, 100);
    static Dimension m_dim = new Dimension();
    static Image m_image = ImageCache.getImage("graph/bpel/warning.png");

    WarningHitBox(View v) {
        this.m_view = v;
        this.m_bounds = new Rectangle();
    }

    void setHighLightOn(boolean bHighLight) {
        this.m_bHighLight = bHighLight;
    }

    boolean hitTest(int x, int y) {
        return this.m_bounds.contains(x, y);
    }

    void paint(Graphics g) {
        if (this.m_bHighLight) {
            g.setColor(m_bgColor);
            g.fillRect(this.m_bounds.x, this.m_bounds.y, this.m_bounds.width, this.m_bounds.height);
            g.setColor(m_borderColor);
            g.drawRect(this.m_bounds.x, this.m_bounds.y, this.m_bounds.width, this.m_bounds.height);
        }
        g.drawImage(m_image, this.m_bounds.x + WarningHitBox.m_insets.left, this.m_bounds.y + WarningHitBox.m_insets.top, null, null);
    }

    void setBounds(View v) {
        Rectangle r = v.getBounds();
        this.m_bounds.setBounds(r.x + r.width - WarningHitBox.m_dim.width, r.y, WarningHitBox.m_dim.width, WarningHitBox.m_dim.height);
    }

    void move(int x, int y) {
        this.m_bounds.x += x;
        this.m_bounds.y += y;
    }

    static {
        WarningHitBox.m_dim.width = WarningHitBox.m_insets.left + m_image.getWidth(null) + WarningHitBox.m_insets.right;
        WarningHitBox.m_dim.height = WarningHitBox.m_insets.top + m_image.getHeight(null) + WarningHitBox.m_insets.bottom;
    }
}

