/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.views;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.Icon;
import oracle.tip.tools.ide.common.graph.view.View;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.StatusBoxButton;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class ViewStatusBox {
    static Insets m_insets = new Insets(0, 0, 0, 0);
    static Color m_bgColor = new Color(236, 233, 216);
    static Color m_borderColor = BPELGraphPane.TAB_BORDER_COLOR;
    static Dimension m_dim = new Dimension();
    static Icon m_image = ImageCache.getIcon("activity_sensor_node");
    protected View m_view;
    protected Rectangle m_bounds;
    protected boolean m_bHighLight;
    protected int m_spacing = 0;
    protected ArrayList m_statusItems = new ArrayList();
    protected int m_orientation = 0;
    protected Color m_borderClr = null;
    protected Color m_bkgClr = null;

    public ViewStatusBox(View v, int orientation) {
        this.m_view = v;
        this.m_bounds = new Rectangle();
        this.m_orientation = orientation;
    }

    public void setBackground(Color c) {
        this.m_bkgClr = c;
    }

    public void setBorderColor(Color c) {
        this.m_borderClr = c;
    }

    public void addStatusBoxButton(StatusBoxButton btn) {
        this.m_statusItems.add(btn);
    }

    public void addStatusBoxButtons(StatusBoxButton[] btns) {
        if (btns != null) {
            for (int i = 0; i < btns.length; ++i) {
                this.m_statusItems.add(btns[i]);
            }
        }
    }

    public void clearHighlights() {
        for (StatusBoxButton o : this.m_statusItems) {
            o.setHighLightOn(false);
        }
    }

    public StatusBoxButton hitTest(int x, int y) {
        for (StatusBoxButton o : this.m_statusItems) {
            Rectangle r = o.getBounds();
            if (!r.contains(x, y)) continue;
            return o;
        }
        return null;
    }

    public void paint(Graphics g) {
        if (this.m_bkgClr != null) {
            g.setColor(this.m_bkgClr);
            g.fillRect(this.m_bounds.x, this.m_bounds.y, this.m_bounds.width, this.m_bounds.height);
        }
        if (this.m_borderClr != null) {
            g.setColor(this.m_borderClr);
            g.drawRect(this.m_bounds.x, this.m_bounds.y, this.m_bounds.width, this.m_bounds.height);
        }
        for (StatusBoxButton btn : this.m_statusItems) {
            if (!btn.isVisible()) continue;
            btn.paint(g);
        }
    }

    public void layout(int x, int y) {
        if (this.m_orientation == 0) {
            int w = this.m_spacing;
            int h = 0;
            int xPos = x;
            int yPos = y;
            for (StatusBoxButton btn : this.m_statusItems) {
                if (!btn.isVisible()) continue;
                Dimension dim = btn.getSize();
                btn.setBounds(xPos, yPos, dim.width, dim.height);
                h = Math.max(h, dim.height);
                w += dim.width + this.m_spacing;
                xPos += dim.width + this.m_spacing;
            }
            this.m_bounds.setBounds(x, y, w, h);
        } else {
            int w = 0;
            int h = this.m_spacing;
            int yPos = y;
            for (StatusBoxButton btn : this.m_statusItems) {
                if (!btn.isVisible()) continue;
                Dimension dim = btn.getSize();
                btn.setBounds(x, yPos, dim.width, dim.height);
                w = Math.max(w, dim.width);
                yPos += dim.height + this.m_spacing;
                h += dim.height + this.m_spacing;
            }
            this.m_bounds.setBounds(x, y, w, h);
        }
    }

    public Dimension computeSize() {
        if (this.m_orientation == 0) {
            int w = this.m_spacing;
            int h = 0;
            for (StatusBoxButton btn : this.m_statusItems) {
                if (!btn.isVisible()) continue;
                Dimension dim = btn.getSize();
                w += dim.width + this.m_spacing;
                h = Math.max(h, dim.height);
            }
            return new Dimension(w, h);
        }
        int w = 0;
        int h = this.m_spacing;
        for (StatusBoxButton btn : this.m_statusItems) {
            if (!btn.isVisible()) continue;
            Dimension dim = btn.getSize();
            h += dim.height + this.m_spacing;
            w = Math.max(w, dim.width);
        }
        return new Dimension(w, h);
    }

    public void move(int x, int y) {
        this.m_bounds.x += x;
        this.m_bounds.y += y;
        for (StatusBoxButton btn : this.m_statusItems) {
            btn.move(x, y);
        }
    }

    static {
        ViewStatusBox.m_dim.width = ViewStatusBox.m_insets.left + m_image.getIconWidth() + ViewStatusBox.m_insets.right;
        ViewStatusBox.m_dim.height = ViewStatusBox.m_insets.top + m_image.getIconHeight() + ViewStatusBox.m_insets.bottom;
    }
}

