/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.views;

import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import oracle.tip.tools.ide.common.bpelparser.validation.Validatable;
import oracle.tip.tools.ide.common.bpelparser.validation.ValidationContext;
import oracle.tip.tools.ide.common.bpelparser.validation.ValidationReport;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ui.GlobalImageCache;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.BasicStatusBoxButton;
import oracle.tip.tools.ide.pm.bpelgraph.views.ValidatableView;
import oracle.tip.tools.ide.pm.gui.dialogs.validationbrowser.ValidationBrowser;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class ValidationStatusBoxButton
extends BasicStatusBoxButton {
    protected ValidatableView m_taskView;
    protected String m_tooltip;

    public ValidationStatusBoxButton(ValidatableView v) {
        super(v.getView(), ImageCache.getIcon("graph/bpel/warning.png"));
        this.m_taskView = v;
        this.m_tooltip = BPELStringTranslator.getString("COLLAXALAF_ACTIVITY_ERROR");
        this.setVisible(false);
    }

    public void setIcon(Icon icon) {
        this.m_icon = icon;
    }

    public void setToolTipText(String s) {
        this.m_tooltip = s;
    }

    @Override
    public String getToolTipText() {
        return this.m_tooltip;
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
        BPELGraphPane graph = this.m_taskView.getBPELGraphPane();
        graph.setToolTipText(null);
        Validatable a = this.m_taskView.getValidatableObject();
        ValidationBrowser dlg = new ValidationBrowser(GraphUtils.getFrame((Component)((Object)graph)), graph, a);
        dlg.display();
    }

    @Override
    public void updateStatus() {
        BPELGraphPane graph = this.m_taskView.getBPELGraphPane();
        boolean bShowWarnings = graph.showValidationWarnings();
        boolean bWarnings = this.hasWarning();
        boolean bError = this.hasError();
        Icon icon = GlobalImageCache.getIcon((String)"error16");
        if (!bError && bWarnings) {
            icon = GlobalImageCache.getIcon((String)"warning16");
        }
        this.setIcon(icon);
        this.setVisible(bShowWarnings && (bWarnings || bError));
        if (bError) {
            this.setToolTipText(BPELStringTranslator.getString("COLLAXALAF_ACTIVITY_ERROR"));
        } else if (bWarnings) {
            this.setToolTipText(BPELStringTranslator.getString("VALIDATION_WARNING"));
        }
    }

    protected Validatable getValidatableObject() {
        return this.m_taskView.getValidatableObject();
    }

    protected ValidationContext createValidationContext() {
        BPELGraphModel model = (BPELGraphModel)this.m_taskView.getBPELGraphPane().getModel();
        return new ValidationContext(model.getProcess());
    }

    protected boolean hasWarning() {
        ValidationReport r;
        Validatable a = this.getValidatableObject();
        if (a != null && (r = a.getValidationReport(this.createValidationContext(), false)) != null) {
            return r.hasWarnings();
        }
        return false;
    }

    protected boolean hasError() {
        ValidationReport r;
        Validatable a = this.getValidatableObject();
        if (a != null && (r = a.getValidationReport(this.createValidationContext(), false)) != null) {
            return r.hasErrors();
        }
        return false;
    }
}

