/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.views;

import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.ICanTimeout;
import oracle.tip.tools.ide.common.graph.view.View;
import oracle.tip.tools.ide.pm.bpelgraph.views.BasicStatusBoxButton;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class TimeoutStatusButton
extends BasicStatusBoxButton {
    public TimeoutStatusButton(View v) {
        super(v, ImageCache.getIcon("graph/bpel/timeout.png"));
        this.setVisible(false);
    }

    @Override
    public boolean isClickable() {
        return false;
    }

    @Override
    public String getToolTipText() {
        Activity a = this.getActivity();
        if (a instanceof ICanTimeout) {
            ICanTimeout timeoutActivity = (ICanTimeout)a;
            String forStr = timeoutActivity.getFor();
            String untilStr = timeoutActivity.getUntil();
            if (Helper.hasValue((String)forStr)) {
                return BPELStringTranslator.getString("TIMEOUT_FOR_TIP") + forStr;
            }
            if (Helper.hasValue((String)untilStr)) {
                return BPELStringTranslator.getString("TIMEOUT_UNTIL_TIP") + untilStr;
            }
        }
        return BPELStringTranslator.getString("TIMEOUT_TIP");
    }

    @Override
    public void updateStatus() {
        Activity a = this.getActivity();
        if (a instanceof ICanTimeout) {
            ICanTimeout timeoutActivity = (ICanTimeout)a;
            String forStr = timeoutActivity.getFor();
            String untilStr = timeoutActivity.getUntil();
            this.setVisible(Helper.hasValue((String)forStr) || Helper.hasValue((String)untilStr));
        } else {
            this.setVisible(false);
        }
    }

    public Activity getActivity() {
        Object obj = this.m_view.getNode().getUserObject();
        if (obj instanceof Activity) {
            return (Activity)obj;
        }
        return null;
    }
}

