/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.views;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.UIManager;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.bpelparser.validation.Validatable;
import oracle.tip.tools.ide.common.bpelparser.validation.ValidationReport;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.graph.actions.GraphAction;
import oracle.tip.tools.ide.common.graph.model.DroppableBranchNode;
import oracle.tip.tools.ide.common.graph.model.Node;
import oracle.tip.tools.ide.common.graph.view.ActionInfo;
import oracle.tip.tools.ide.common.graph.view.BaseView;
import oracle.tip.tools.ide.common.graph.view.GraphPane;
import oracle.tip.tools.ide.common.graph.view.LayoutInfo;
import oracle.tip.tools.ide.common.graph.view.NodeRenderer;
import oracle.tip.tools.ide.common.graph.view.ToolTipable;
import oracle.tip.tools.ide.common.graph.view.View;
import oracle.tip.tools.ide.pm.bpelgraph.settings.BPELSettings;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELVerticalDropBranchView;
import oracle.tip.tools.ide.pm.bpelgraph.views.CollaxaDropView;
import oracle.tip.tools.ide.pm.bpelgraph.views.StatusBoxButton;
import oracle.tip.tools.ide.pm.bpelgraph.views.ValidatableView;
import oracle.tip.tools.ide.pm.bpelgraph.views.ValidationStatusBoxButton;
import oracle.tip.tools.ide.pm.bpelgraph.views.ViewStatusBox;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class SwitchDefaultView2
extends BPELVerticalDropBranchView
implements ValidatableView {
    public static Font CONDITION_FONT = UIManager.getFont("Label.font");
    public static String CONDITION_PLACE_HOLDER = "<condition>";
    protected Font m_font = UIManager.getFont("Label.font");
    protected int m_minWidth = 80;
    protected int m_minHeight = 80;
    protected int m_borderWidth = 2;
    protected int m_branchSidePadding = 1;
    protected ViewStatusBox m_viewStatusBox;
    protected List<StatusBoxButton> m_statusButtons = new ArrayList<StatusBoxButton>();
    protected boolean m_bHovering = false;
    protected Rectangle m_conditionTextBounds = new Rectangle();
    protected Rectangle m_conditionBox = new Rectangle();
    protected int m_conditionBoxPadding = 5;
    protected String m_conditionText;

    public SwitchDefaultView2(GraphPane pane, View parent, DroppableBranchNode n) {
        super(pane, parent, n);
        this.setDraggable(false);
        this.setCanSelect(true);
        this.m_viewStatusBox = new ViewStatusBox((View)this, 0);
        this.m_viewStatusBox.addStatusBoxButtons(this.getStatusButtons());
        this.setInsets(this.m_borderWidth, this.m_borderWidth + this.m_branchSidePadding, this.m_borderWidth, this.m_borderWidth + this.m_branchSidePadding);
        this.setCollapsable(true);
        this.setCollapsed(false);
        this.setCanDelete(false);
    }

    @Override
    public View getView() {
        return this;
    }

    public void setCollapsed(boolean bCollapse) {
        super.setCollapsed(bCollapse);
        ((BPELGraphPane)this.getGraphPane()).removeMagnifyView((NodeRenderer)this);
    }

    protected StatusBoxButton[] getStatusButtons() {
        this.m_statusButtons.add(new ValidationStatusBoxButton(this));
        return this.m_statusButtons.toArray(new StatusBoxButton[this.m_statusButtons.size()]);
    }

    protected void generateValidationReport() {
        Validatable a = this.getValidatableObject();
        if (a != null) {
            a.getValidationReport(this.createValidationContext(), true);
            this.updateStatusButtons();
        }
    }

    protected boolean hasWarning() {
        ValidationReport r;
        Validatable a = this.getValidatableObject();
        if (a != null && (r = a.getValidationReport(this.createValidationContext(), false)) != null) {
            return r.hasWarnings();
        }
        return false;
    }

    protected boolean hasError() {
        ValidationReport r;
        Validatable a = this.getValidatableObject();
        if (a != null && (r = a.getValidationReport(this.createValidationContext(), false)) != null) {
            return r.hasErrors();
        }
        return false;
    }

    public ToolTipable getToolTipable(int x, int y) {
        StatusBoxButton btn = this.m_viewStatusBox.hitTest(x, y);
        if (btn != null) {
            return btn;
        }
        ActionInfo info = this.hitActionArea(x, y);
        if (info != null) {
            return info.getToolTipable();
        }
        return this;
    }

    protected List<GraphAction> createActions() {
        ArrayList<GraphAction> actions = new ArrayList<GraphAction>();
        return actions;
    }

    public Cursor getCursor(int x, int y) {
        StatusBoxButton btn = this.m_viewStatusBox.hitTest(x, y);
        if (btn != null && btn.isClickable()) {
            return Cursor.getPredefinedCursor(12);
        }
        ActionInfo info = this.hitActionArea(x, y);
        return info == null ? null : Cursor.getPredefinedCursor(12);
    }

    public void editingStopped() {
        this.generateValidationReport();
        this.getGraphPane().repaint();
    }

    public void setHovered(boolean bHovered, MouseEvent evt) {
        ActionInfo info;
        boolean bRepaint = this.m_bHovering != bHovered;
        this.m_bHovering = bHovered;
        this.m_viewStatusBox.clearHighlights();
        StatusBoxButton btn = this.m_viewStatusBox.hitTest(evt.getX(), evt.getY());
        if (btn != null) {
            btn.setHighLightOn(true);
        }
        if ((info = this.hitActionArea(evt.getX(), evt.getY())) != null) {
            info.setHighlighted(bHovered);
        }
        if (bRepaint) {
            this.repaint();
        }
    }

    protected Color getSelectedBackgroundColor() {
        return BPELGraphPane.VIEW_SELECTION_BACKGROUND;
    }

    public void paint(Graphics g, int layer) {
        if (this.isEditing()) {
            this.paintEditingMode(g);
            if (this.isSelected()) {
                this.paintSelected(g);
            }
            return;
        }
        if (this.isSelected()) {
            g.setColor(this.getSelectedBackgroundColor());
            g.fillRect(this.m_bounds.x, this.m_bounds.y, this.m_bounds.width, this.m_bounds.height);
        }
        this.paintStatusIcons(g);
        g.setColor(BPELGraphPane.TAB_BORDER_COLOR);
        GraphUtils.drawRoundRect((Graphics)g, (int)this.m_conditionBox.x, (int)this.m_conditionBox.y, (int)this.m_conditionBox.width, (int)this.m_conditionBox.height, (float)1.0f, (Color)Color.lightGray);
        if (this.m_conditionTextBounds.width > 0 && this.m_conditionTextBounds.height > 0 && this.m_conditionText != null && this.m_conditionText.length() > 0) {
            g.setFont(CONDITION_FONT);
            g.setColor(Color.lightGray);
            g.drawString(this.m_conditionText, this.m_conditionTextBounds.x, this.m_conditionTextBounds.y + GraphUtils.getFontAscent((Font)CONDITION_FONT));
        }
        if (this.isCollapsed()) {
            this.paintConnections(g);
            if (this.isSelected()) {
                this.paintSelected(g);
            }
        } else {
            super.paint(g, layer);
        }
    }

    protected Image getImage() {
        return ImageCache.getImage("sequence.default.jpg");
    }

    protected String getText() {
        return "";
    }

    protected void paintSelectionBox(Graphics g, Rectangle r, int borderWidth) {
        BPELGraphPane pane = (BPELGraphPane)this.getGraphPane();
        BPELSettings settings = pane.getSettings();
        Color c = settings.m_selectedBorderBackgroundColor;
        g.setColor(c);
        g.fillRect(r.x, r.y, r.width, borderWidth);
        g.fillRect(r.x, r.y + r.height - borderWidth, r.width, borderWidth);
        g.fillRect(r.x, r.y, borderWidth, r.height);
        g.fillRect(r.x + r.width - borderWidth, r.y, borderWidth, r.height);
        g.setColor(c.darker());
        g.drawRect(r.x, r.y, r.width, r.height);
        g.drawRect(r.x + borderWidth, r.y + borderWidth, r.width - 2 * borderWidth, r.height - 2 * borderWidth);
    }

    protected void paintStatusIcons(Graphics g) {
        this.m_viewStatusBox.paint(g);
    }

    @Override
    public void updateStatusButtons() {
        for (StatusBoxButton btn : this.m_statusButtons) {
            btn.updateStatus();
        }
        this.getGraphPane().repaint(this.m_bounds);
    }

    public void move(int x, int y) {
        super.move(x, y);
        this.m_viewStatusBox.move(x, y);
        this.m_conditionBox.x += x;
        this.m_conditionBox.y += y;
        this.m_conditionTextBounds.x += x;
        this.m_conditionTextBounds.y += y;
    }

    protected void paintConnections(Graphics g) {
        int thickness = this.getGraphPane().getLineThickness();
        Color lineColor = this.getGraphPane().getLineColor();
        GraphUtils.drawVertLine((Graphics)g, (int)this.getConnectionX(), (int)this.topY(), (int)(this.topY() + this.m_borderWidth), (float)thickness, (Color)lineColor);
        if (this.m_children.size() > 0) {
            BaseView v = (BaseView)this.m_children.get(this.m_children.size() - 1);
            int lastViewY = v.bottomY();
            GraphUtils.drawVertLine((Graphics)g, (int)this.getConnectionX(), (int)this.bottomY(), (int)lastViewY, (float)thickness, (Color)lineColor);
        } else {
            GraphUtils.drawVertLine((Graphics)g, (int)this.getConnectionX(), (int)this.bottomY(), (int)(this.bottomY() - this.m_insets.bottom), (float)thickness, (Color)lineColor);
        }
    }

    protected void paintSelected(Graphics g) {
        BPELGraphPane pane = (BPELGraphPane)this.getGraphPane();
        BPELSettings settings = pane.getSettings();
        this.paintBorder(g, settings.m_selectedBorderBackgroundColor, this.m_borderWidth);
    }

    protected String getConditionDisplayText() {
        return "otherwise";
    }

    public Rectangle layout(int x, int y, int w, int h, LayoutInfo info) {
        int nChildren;
        Node childNode;
        if (this.isEditing()) {
            return this.layoutEditingMode(x, y, w, h, info);
        }
        this.updateStatusButtons();
        this.setInsets(this.m_borderWidth, this.m_borderWidth + this.m_branchSidePadding, this.m_borderWidth, this.m_borderWidth + this.m_branchSidePadding);
        this.notifyLayoutWillOccur();
        this.setBounds(x, y, 0, 0);
        this.m_conditionTextBounds.setBounds(x + this.m_borderWidth, y + this.m_borderWidth, 0, 0);
        if (this.isCollapsed()) {
            this.setBounds(x, y, 2 * this.m_borderWidth, 2 * this.m_borderWidth);
            this.m_connectionX = this.midX();
            return this.m_bounds;
        }
        int condTextHeight = GraphUtils.getFontHeight((Font)CONDITION_FONT);
        int condBoxHeight = this.m_conditionBoxPadding + condTextHeight + this.m_conditionBoxPadding;
        this.m_insets.top = this.m_borderWidth + condBoxHeight;
        Node graphNode = this.getNode();
        int numChildren = graphNode.getChildCount();
        if (numChildren == 3 && (childNode = graphNode.getChildNode(1)).getNodeType() == 103) {
            View v = this.getChildViewForNode(graphNode.getChildNode(0));
            if (v instanceof CollaxaDropView) {
                ((CollaxaDropView)v).setDropAllowed(false);
            }
            if ((v = this.getChildViewForNode(graphNode.getChildNode(2))) instanceof CollaxaDropView) {
                ((CollaxaDropView)v).setDropAllowed(false);
            }
        }
        boolean bTextMode = (nChildren = this.m_children.size()) == 1;
        for (int i = 0; i < nChildren; ++i) {
            BaseView v = (BaseView)this.m_children.get(i);
            if (!(v instanceof CollaxaDropView)) continue;
            ((CollaxaDropView)v).setTextMode(bTextMode);
        }
        this.m_bounds.height = this.m_insets.top + this.m_insets.bottom;
        int yPos = y + this.m_insets.top;
        int maxLeft = 0;
        int maxRight = 0;
        int xPos = x + this.m_insets.left;
        for (int i = 0; i < nChildren; ++i) {
            BaseView v = (BaseView)this.m_children.get(i);
            if (i > 0) {
                yPos += this.m_verticalSpacing;
                this.m_bounds.height += this.m_verticalSpacing;
            }
            Rectangle r = v.layout(xPos, yPos, w, h, info);
            maxLeft = Math.max(maxLeft, v.getLeftWidth());
            maxRight = Math.max(maxRight, v.getRightWidth());
            yPos += r.height;
            this.m_bounds.height += r.height;
        }
        if (this.m_bounds.height < this.m_minHeight) {
            this.m_bounds.height = this.m_minHeight;
        }
        this.m_conditionText = this.getConditionDisplayText();
        int condTextWidth = GraphUtils.getStringWidth((Font)CONDITION_FONT, (String)this.m_conditionText);
        if (condTextWidth > maxLeft + maxRight) {
            this.m_conditionText = Helper.stripString((String)this.m_conditionText, (Font)CONDITION_FONT, (int)(maxLeft + maxRight));
            condTextWidth = maxLeft + maxRight;
        }
        int condBoxWidth = this.m_conditionBoxPadding + condTextWidth + this.m_conditionBoxPadding;
        maxLeft = Math.max(maxLeft, condBoxWidth / 2);
        maxRight = Math.max(maxRight, condBoxWidth / 2);
        for (int i = 0; i < nChildren; ++i) {
            BaseView v = (BaseView)this.m_children.get(i);
            int xDiff = Math.max(0, maxLeft - v.getLeftWidth());
            if (xDiff <= 0) continue;
            v.move(xDiff, 0);
        }
        this.m_bounds.width = this.m_insets.left + maxLeft + maxRight + this.m_insets.right;
        this.m_connectionX = this.m_bounds.x + this.m_insets.left + maxLeft;
        this.m_conditionBox.setBounds(this.m_connectionX - condBoxWidth / 2, y + this.m_borderWidth, condBoxWidth, condBoxHeight);
        this.m_conditionTextBounds.setBounds(this.m_conditionBox.x + this.m_conditionBoxPadding, this.m_conditionBox.y + this.m_conditionBoxPadding, condTextWidth, condTextHeight);
        return this.m_bounds;
    }

    @Override
    public Validatable getValidatableObject() {
        Object obj = this.getNode().getUserObject();
        if (obj instanceof Validatable) {
            return (Validatable)obj;
        }
        return null;
    }

    @Override
    public BPELGraphPane getBPELGraphPane() {
        return (BPELGraphPane)this.getGraphPane();
    }

    public boolean handleMousePressed(MouseEvent evt) {
        StatusBoxButton btn = this.m_viewStatusBox.hitTest(evt.getX(), evt.getY());
        if (btn != null && btn.isVisible()) {
            btn.mouseClicked(evt);
            return true;
        }
        return false;
    }
}

