/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.views;

import java.awt.Color;
import java.awt.Image;
import oracle.tip.tools.ide.common.bpelparser.iface.SwitchOtherwise;
import oracle.tip.tools.ide.common.graph.view.GraphPane;
import oracle.tip.tools.ide.common.graph.view.Tabable;
import oracle.tip.tools.ide.common.graph.view.View;
import oracle.tip.tools.ide.common.graph.view.VoiceAccessible;
import oracle.tip.tools.ide.pm.bpelgraph.model.SwitchDefaultNode;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.BaseSwitchBranchView;
import oracle.tip.tools.ide.pm.bpelgraph.views.StateSaveableView;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class SwitchDefaultView
extends BaseSwitchBranchView
implements StateSaveableView,
Tabable,
VoiceAccessible {
    public SwitchDefaultView(GraphPane pane, View parent, SwitchDefaultNode n) {
        super(pane, parent, n);
        this.setCanDelete(true);
        this.setCanSelect(true);
        this.m_headerClr = Color.white;
        Boolean val = (Boolean)n.getData("collapsed");
        if (val != null) {
            this.setCollapsed(val);
        } else {
            this.setCollapsed(false);
        }
    }

    @Override
    protected String getText() {
        return "<default>";
    }

    @Override
    protected Image getImage() {
        return ImageCache.getImage("graph/bpel/switch_default.png");
    }

    @Override
    protected String getHeaderText() {
        SwitchOtherwise c = (SwitchOtherwise)this.getNode().getUserObject();
        String desc = c.getDescription();
        this.setToolTipText(desc);
        if (desc == null) {
            desc = "";
        }
        if (desc.length() > 40) {
            desc = desc.substring(0, 37) + "...";
        }
        if (desc.length() > 0) {
            desc = " " + desc;
        }
        return "<otherwise" + desc + ">";
    }

    @Override
    public boolean isEditable() {
        return false;
    }

    @Override
    public BPELGraphPane getBPELGraphPane() {
        return (BPELGraphPane)this.getGraphPane();
    }

    public String getVoiceAccessibleText() {
        return "Switch Otherwise";
    }
}

