/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.views;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.JTextComponent;
import oracle.tip.tools.ide.common.bpeldesigner.models.schema.NSResolverFactory;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.SwitchCase;
import oracle.tip.tools.ide.common.bpelparser.validation.Validatable;
import oracle.tip.tools.ide.common.bpelparser.validation.ValidationReport;
import oracle.tip.tools.ide.common.expressionbuilder.BpelExpressionBuilder;
import oracle.tip.tools.ide.common.expressionbuilder.ExpressionBuilderPicker;
import oracle.tip.tools.ide.common.expressionbuilders.FunctionsExpressionBuilderPicker;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.graph.actions.GraphAction;
import oracle.tip.tools.ide.common.graph.model.DroppableBranchNode;
import oracle.tip.tools.ide.common.graph.model.Node;
import oracle.tip.tools.ide.common.graph.view.ActionInfo;
import oracle.tip.tools.ide.common.graph.view.BaseView;
import oracle.tip.tools.ide.common.graph.view.GraphPane;
import oracle.tip.tools.ide.common.graph.view.LayoutInfo;
import oracle.tip.tools.ide.common.graph.view.NodeRenderer;
import oracle.tip.tools.ide.common.graph.view.ToolTipable;
import oracle.tip.tools.ide.common.graph.view.View;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.ui.rezpopup.RezPopup;
import oracle.tip.tools.ide.common.utils.NamespaceResolver;
import oracle.tip.tools.ide.common.xpath.editor.XPathEditorPane;
import oracle.tip.tools.ide.common.xpath.editor.util.VariableDataCallBack;
import oracle.tip.tools.ide.pm.addin.model.BPELXmlModel;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariableDataCallBackImpl;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariableExpressionBuilderPicker;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariablePickerPanel;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.settings.BPELSettings;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELVerticalDropBranchView;
import oracle.tip.tools.ide.pm.bpelgraph.views.CollaxaDropView;
import oracle.tip.tools.ide.pm.bpelgraph.views.StatusBoxButton;
import oracle.tip.tools.ide.pm.bpelgraph.views.ValidatableView;
import oracle.tip.tools.ide.pm.bpelgraph.views.ValidationStatusBoxButton;
import oracle.tip.tools.ide.pm.bpelgraph.views.ViewStatusBox;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class SwitchCaseView2
extends BPELVerticalDropBranchView
implements ValidatableView {
    public static Font CONDITION_FONT = UIManager.getFont("Label.font");
    public static String CONDITION_PLACE_HOLDER = "<condition>";
    protected Font m_font = UIManager.getFont("Label.font");
    protected int m_minWidth = 80;
    protected int m_minHeight = 80;
    protected int m_borderWidth = 2;
    protected int m_branchSidePadding = 1;
    protected ViewStatusBox m_viewStatusBox;
    protected List<StatusBoxButton> m_statusButtons = new ArrayList<StatusBoxButton>();
    protected boolean m_bHovering = false;
    protected Rectangle m_conditionTextBounds = new Rectangle();
    protected Rectangle m_conditionBox = new Rectangle();
    protected int m_conditionBoxPadding = 5;
    protected String m_conditionText;
    protected boolean m_bConditionHover = false;

    public SwitchCaseView2(GraphPane pane, View parent, DroppableBranchNode n) {
        super(pane, parent, n);
        this.setDraggable(false);
        this.setCanSelect(true);
        this.m_viewStatusBox = new ViewStatusBox((View)this, 0);
        this.m_viewStatusBox.addStatusBoxButtons(this.getStatusButtons());
        this.setInsets(this.m_borderWidth, this.m_borderWidth + this.m_branchSidePadding, this.m_borderWidth, this.m_borderWidth + this.m_branchSidePadding);
        this.setCollapsable(true);
        this.setCollapsed(false);
    }

    @Override
    public View getView() {
        return this;
    }

    public void setCollapsed(boolean bCollapse) {
        super.setCollapsed(bCollapse);
        ((BPELGraphPane)this.getGraphPane()).removeMagnifyView((NodeRenderer)this);
    }

    protected StatusBoxButton[] getStatusButtons() {
        this.m_statusButtons.add(new ValidationStatusBoxButton(this));
        return this.m_statusButtons.toArray(new StatusBoxButton[this.m_statusButtons.size()]);
    }

    protected void generateValidationReport() {
        Validatable a = this.getValidatableObject();
        if (a != null) {
            a.getValidationReport(this.createValidationContext(), true);
            this.updateStatusButtons();
        }
    }

    protected boolean hasWarning() {
        ValidationReport r;
        Validatable a = this.getValidatableObject();
        if (a != null && (r = a.getValidationReport(this.createValidationContext(), false)) != null) {
            return r.hasWarnings();
        }
        return false;
    }

    protected boolean hasError() {
        ValidationReport r;
        Validatable a = this.getValidatableObject();
        if (a != null && (r = a.getValidationReport(this.createValidationContext(), false)) != null) {
            return r.hasErrors();
        }
        return false;
    }

    public ToolTipable getToolTipable(int x, int y) {
        StatusBoxButton btn = this.m_viewStatusBox.hitTest(x, y);
        if (btn != null) {
            return btn;
        }
        ActionInfo info = this.hitActionArea(x, y);
        if (info != null) {
            return info.getToolTipable();
        }
        return this;
    }

    protected List<GraphAction> createActions() {
        ArrayList<GraphAction> actions = new ArrayList<GraphAction>();
        return actions;
    }

    public Cursor getCursor(int x, int y) {
        StatusBoxButton btn = this.m_viewStatusBox.hitTest(x, y);
        if (btn != null && btn.isClickable()) {
            return Cursor.getPredefinedCursor(12);
        }
        if (this.m_conditionBox.contains(x, y)) {
            return Cursor.getPredefinedCursor(12);
        }
        ActionInfo info = this.hitActionArea(x, y);
        return info == null ? null : Cursor.getPredefinedCursor(12);
    }

    public void editingStopped() {
        this.generateValidationReport();
        this.getGraphPane().repaint();
    }

    public void setHovered(boolean bHovered, MouseEvent evt) {
        ActionInfo info;
        boolean bRepaint = this.m_bHovering != bHovered;
        this.m_bHovering = bHovered;
        boolean bOldValue = this.m_bConditionHover;
        this.m_bConditionHover = this.m_conditionBox.contains(evt.getX(), evt.getY());
        if (bOldValue != this.m_bConditionHover) {
            bRepaint = true;
        }
        this.m_viewStatusBox.clearHighlights();
        StatusBoxButton btn = this.m_viewStatusBox.hitTest(evt.getX(), evt.getY());
        if (btn != null) {
            btn.setHighLightOn(true);
        }
        if ((info = this.hitActionArea(evt.getX(), evt.getY())) != null) {
            info.setHighlighted(bHovered);
        }
        if (bRepaint) {
            this.repaint();
        }
    }

    protected Color getSelectedBackgroundColor() {
        return BPELGraphPane.VIEW_SELECTION_BACKGROUND;
    }

    public void paint(Graphics g, int layer) {
        if (this.isEditing()) {
            this.paintEditingMode(g);
            if (this.isSelected()) {
                this.paintSelected(g);
            }
            return;
        }
        if (this.isSelected()) {
            g.setColor(this.getSelectedBackgroundColor());
            g.fillRect(this.m_bounds.x, this.m_bounds.y, this.m_bounds.width, this.m_bounds.height);
        }
        this.paintStatusIcons(g);
        if (this.m_bConditionHover && this.m_conditionBox.width > 0 && this.m_conditionBox.height > 0) {
            g.setColor(Color.cyan);
            g.fillRoundRect(this.m_conditionBox.x, this.m_conditionBox.y, this.m_conditionBox.width, this.m_conditionBox.height, 10, 10);
        }
        GraphUtils.drawRoundRect((Graphics)g, (int)this.m_conditionBox.x, (int)this.m_conditionBox.y, (int)this.m_conditionBox.width, (int)this.m_conditionBox.height, (float)1.0f, (Color)(this.m_bConditionHover ? Color.black : BPELGraphPane.TAB_BORDER_COLOR));
        if (this.m_conditionTextBounds.width > 0 && this.m_conditionTextBounds.height > 0 && this.m_conditionText != null && this.m_conditionText.length() > 0) {
            g.setFont(CONDITION_FONT);
            Color clr = Color.black;
            if (this.m_conditionText.equals(CONDITION_PLACE_HOLDER)) {
                clr = Color.lightGray;
            }
            g.setColor(clr);
            g.drawString(this.m_conditionText, this.m_conditionTextBounds.x, this.m_conditionTextBounds.y + GraphUtils.getFontAscent((Font)CONDITION_FONT));
        }
        if (this.isCollapsed()) {
            this.paintConnections(g);
            if (this.isSelected()) {
                this.paintSelected(g);
            }
        } else {
            super.paint(g, layer);
        }
    }

    protected Image getImage() {
        return ImageCache.getImage("sequence.default.jpg");
    }

    protected String getText() {
        return "";
    }

    protected void paintSelectionBox(Graphics g, Rectangle r, int borderWidth) {
        BPELGraphPane pane = (BPELGraphPane)this.getGraphPane();
        BPELSettings settings = pane.getSettings();
        Color c = settings.m_selectedBorderBackgroundColor;
        g.setColor(c);
        g.fillRect(r.x, r.y, r.width, borderWidth);
        g.fillRect(r.x, r.y + r.height - borderWidth, r.width, borderWidth);
        g.fillRect(r.x, r.y, borderWidth, r.height);
        g.fillRect(r.x + r.width - borderWidth, r.y, borderWidth, r.height);
        g.setColor(c.darker());
        g.drawRect(r.x, r.y, r.width, r.height);
        g.drawRect(r.x + borderWidth, r.y + borderWidth, r.width - 2 * borderWidth, r.height - 2 * borderWidth);
    }

    protected void paintStatusIcons(Graphics g) {
        if (this.m_viewStatusBox.m_bounds.y < 50) {
            System.out.println("m_viewStatusBox=" + this.m_viewStatusBox);
        }
        this.m_viewStatusBox.paint(g);
    }

    @Override
    public void updateStatusButtons() {
        for (StatusBoxButton btn : this.m_statusButtons) {
            btn.updateStatus();
        }
        this.getGraphPane().repaint(this.m_bounds);
    }

    public void move(int x, int y) {
        super.move(x, y);
        this.m_viewStatusBox.move(x, y);
        this.m_conditionBox.x += x;
        this.m_conditionBox.y += y;
        this.m_conditionTextBounds.x += x;
        this.m_conditionTextBounds.y += y;
    }

    protected void paintConnections(Graphics g) {
        int thickness = this.getGraphPane().getLineThickness();
        Color lineColor = this.getGraphPane().getLineColor();
        GraphUtils.drawVertLine((Graphics)g, (int)this.getConnectionX(), (int)this.topY(), (int)(this.topY() + this.m_borderWidth), (float)thickness, (Color)lineColor);
        if (this.m_children.size() > 0) {
            BaseView v = (BaseView)this.m_children.get(this.m_children.size() - 1);
            int lastViewY = v.bottomY();
            GraphUtils.drawVertLine((Graphics)g, (int)this.getConnectionX(), (int)this.bottomY(), (int)lastViewY, (float)thickness, (Color)lineColor);
        } else {
            GraphUtils.drawVertLine((Graphics)g, (int)this.getConnectionX(), (int)this.bottomY(), (int)(this.bottomY() - this.m_insets.bottom), (float)thickness, (Color)lineColor);
        }
    }

    protected void paintSelected(Graphics g) {
        BPELGraphPane pane = (BPELGraphPane)this.getGraphPane();
        BPELSettings settings = pane.getSettings();
        this.paintBorder(g, settings.m_selectedBorderBackgroundColor, this.m_borderWidth);
    }

    protected String getCondition() {
        SwitchCase sc = (SwitchCase)this.getNode().getUserObject();
        return sc.getCondition();
    }

    protected String getConditionDisplayText() {
        SwitchCase sc = (SwitchCase)this.getNode().getUserObject();
        String label = sc.getUserLabel();
        if (Helper.hasValue((String)label)) {
            return label;
        }
        String s = sc.getCondition();
        if (s == null || s.trim().length() == 0) {
            return CONDITION_PLACE_HOLDER;
        }
        int w = GraphUtils.getStringWidth((Font)CONDITION_FONT, (String)s);
        if (w > 100) {
            s = Helper.stripString((String)s, (Font)CONDITION_FONT, (int)100);
        }
        return s;
    }

    public Rectangle layout(int x, int y, int w, int h, LayoutInfo info) {
        int nChildren;
        Node childNode;
        if (this.isEditing()) {
            return this.layoutEditingMode(x, y, w, h, info);
        }
        this.updateStatusButtons();
        this.setInsets(this.m_borderWidth, this.m_borderWidth + this.m_branchSidePadding, this.m_borderWidth, this.m_borderWidth + this.m_branchSidePadding);
        this.notifyLayoutWillOccur();
        this.setBounds(x, y, 0, 0);
        this.m_conditionTextBounds.setBounds(x + this.m_borderWidth, y + this.m_borderWidth, 0, 0);
        if (this.isCollapsed()) {
            this.setBounds(x, y, 2 * this.m_borderWidth, 2 * this.m_borderWidth);
            this.m_connectionX = this.midX();
            return this.m_bounds;
        }
        Dimension statusDim = this.m_viewStatusBox.computeSize();
        int condTextHeight = GraphUtils.getFontHeight((Font)CONDITION_FONT);
        int condBoxHeight = this.m_conditionBoxPadding + condTextHeight + this.m_conditionBoxPadding;
        this.m_insets.top = this.m_borderWidth + Math.max(condBoxHeight, statusDim.height);
        Node graphNode = this.getNode();
        int numChildren = graphNode.getChildCount();
        if (numChildren == 3 && (childNode = graphNode.getChildNode(1)).getNodeType() == 103) {
            View v = this.getChildViewForNode(graphNode.getChildNode(0));
            if (v instanceof CollaxaDropView) {
                ((CollaxaDropView)v).setDropAllowed(false);
            }
            if ((v = this.getChildViewForNode(graphNode.getChildNode(2))) instanceof CollaxaDropView) {
                ((CollaxaDropView)v).setDropAllowed(false);
            }
        }
        boolean bTextMode = (nChildren = this.m_children.size()) == 1;
        for (int i = 0; i < nChildren; ++i) {
            BaseView v = (BaseView)this.m_children.get(i);
            if (!(v instanceof CollaxaDropView)) continue;
            ((CollaxaDropView)v).setTextMode(bTextMode);
        }
        this.m_bounds.height = this.m_insets.top + this.m_insets.bottom;
        int yPos = y + this.m_insets.top;
        int maxLeft = 0;
        int maxRight = 0;
        int xPos = x + this.m_insets.left;
        for (int i = 0; i < nChildren; ++i) {
            BaseView v = (BaseView)this.m_children.get(i);
            if (i > 0) {
                yPos += this.m_verticalSpacing;
                this.m_bounds.height += this.m_verticalSpacing;
            }
            Rectangle r = v.layout(xPos, yPos, w, h, info);
            maxLeft = Math.max(maxLeft, v.getLeftWidth());
            maxRight = Math.max(maxRight, v.getRightWidth());
            yPos += r.height;
            this.m_bounds.height += r.height;
        }
        if (this.m_bounds.height < this.m_minHeight) {
            this.m_bounds.height = this.m_minHeight;
        }
        this.m_conditionText = this.getConditionDisplayText();
        int condTextWidth = GraphUtils.getStringWidth((Font)CONDITION_FONT, (String)this.m_conditionText);
        int condBoxWidth = this.m_conditionBoxPadding + condTextWidth + this.m_conditionBoxPadding;
        int topWidth = 2 * (condBoxWidth / 2 + statusDim.width);
        int bottomWidth = 2 * Math.max(maxLeft, maxRight);
        int viewWidth = Math.max(topWidth, bottomWidth);
        maxLeft = viewWidth / 2;
        maxRight = viewWidth / 2;
        for (int i = 0; i < nChildren; ++i) {
            BaseView v = (BaseView)this.m_children.get(i);
            int xDiff = Math.max(0, maxLeft - v.getLeftWidth());
            if (xDiff <= 0) continue;
            v.move(xDiff, 0);
        }
        this.m_bounds.width = this.m_insets.left + viewWidth + this.m_insets.right;
        this.m_connectionX = this.m_bounds.x + this.m_insets.left + maxLeft;
        this.m_conditionBox.setBounds(this.m_connectionX - condBoxWidth / 2, y + this.m_borderWidth, condBoxWidth, condBoxHeight);
        this.m_conditionTextBounds.setBounds(this.m_conditionBox.x + this.m_conditionBoxPadding, this.m_conditionBox.y + this.m_conditionBoxPadding, condTextWidth, condTextHeight);
        this.m_viewStatusBox.layout(this.m_connectionX + this.m_conditionBox.width / 2, y + this.m_borderWidth);
        return this.m_bounds;
    }

    @Override
    public Validatable getValidatableObject() {
        Object obj = this.getNode().getUserObject();
        if (obj instanceof Validatable) {
            return (Validatable)obj;
        }
        return null;
    }

    @Override
    public BPELGraphPane getBPELGraphPane() {
        return (BPELGraphPane)this.getGraphPane();
    }

    public boolean handleMousePressed(MouseEvent evt) {
        if (this.m_conditionBox.contains(evt.getX(), evt.getY())) {
            this.editCondition();
            return true;
        }
        StatusBoxButton btn = this.m_viewStatusBox.hitTest(evt.getX(), evt.getY());
        if (btn != null && btn.isVisible()) {
            btn.mouseClicked(evt);
            return true;
        }
        return false;
    }

    private void editCondition() {
        RezPopup popup = new RezPopup();
        popup.addPopupComponent((Component)this.createConditionPanel((JPopupMenu)popup));
        popup.show((Component)((Object)this.getBPELGraphPane()), this.m_conditionBox.x, this.m_conditionBox.y + this.m_conditionBox.height);
    }

    protected final NamespaceResolver getNSResolver(Activity activity) {
        GraphPane graphPane = this.getGraphPane();
        BPELGraphModel graphModel = (BPELGraphModel)graphPane.getModel();
        Process processModel = graphModel.getProcess();
        return NSResolverFactory.getNSResolver((Activity)activity, (Process)processModel);
    }

    protected JPanel createConditionPanel(final JPopupMenu popup) {
        final BPELGraphPane graphPane = (BPELGraphPane)this.getGraphPane();
        final SwitchCase sc = (SwitchCase)this.getNode().getUserObject();
        String condition = sc.getCondition();
        String label = sc.getUserLabel();
        String desc = sc.getDescription();
        final JButton expressionBtn = new JButton(ImageCache.getIcon("edit_expression16"));
        expressionBtn.setToolTipText(BPELStringTranslator.getString("LAUNCH_EXPRESSION_BUILDER_TIP"));
        final JTextArea conditionArea = new JTextArea(condition);
        conditionArea.setWrapStyleWord(true);
        conditionArea.setLineWrap(true);
        final JButton okBtn = new JButton(BPELStringTranslator.getString("OK"));
        final JButton cancelBtn = new JButton(BPELStringTranslator.getString("CANCEL"));
        JPanel btnPnl = new JPanel(new GridLayout(1, 2, 5, 0));
        btnPnl.setOpaque(false);
        btnPnl.add(okBtn);
        btnPnl.add(cancelBtn);
        final JTextField labelField = new JTextField(label);
        PopupMenuListener l = new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                labelField.requestFocusInWindow();
            }
        };
        popup.addPopupMenuListener(l);
        final JTextField descField = new JTextField(desc);
        JLabel lbl = new JLabel();
        BPELStringTranslator.setLabel(lbl, labelField, BPELStringTranslator.getString("LABEL_LBL"));
        JLabel descLbl = new JLabel();
        BPELStringTranslator.setLabel(descLbl, descField, BPELStringTranslator.getString("DESCRIPTION_LBL"));
        JLabel condLbl = new JLabel();
        BPELStringTranslator.setLabel(condLbl, conditionArea, BPELStringTranslator.getString("CONDITION_LBL"));
        JToolBar tb = UIHelper.createToolBar();
        tb.add(expressionBtn);
        ActionListener lst = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object src = e.getSource();
                if (src == expressionBtn) {
                    NamespaceResolver nsResolver = SwitchCaseView2.this.getNSResolver((Activity)sc);
                    BPELXmlModel mainModel = graphPane.getBPELXmlModel();
                    VariableDataCallBackImpl dataCallBack = new VariableDataCallBackImpl(mainModel, (Activity)sc, nsResolver);
                    VariablePickerPanel p = new VariablePickerPanel(graphPane, dataCallBack, nsResolver);
                    VariableExpressionBuilderPicker picker = new VariableExpressionBuilderPicker(p, (Activity)sc);
                    ExpressionBuilderPicker[] pickers = new ExpressionBuilderPicker[]{picker, new FunctionsExpressionBuilderPicker(nsResolver)};
                    XPathEditorPane editorPane = new XPathEditorPane();
                    editorPane.initializeDocument();
                    editorPane.initializeEditorPane((VariableDataCallBack)dataCallBack, conditionArea.getText(), nsResolver, false);
                    popup.setVisible(false);
                    BpelExpressionBuilder dlg = new BpelExpressionBuilder(GraphUtils.getFrame((Component)((Object)graphPane)), (JTextComponent)editorPane, pickers);
                    if (dlg.display() == 0) {
                        conditionArea.setText(dlg.getExpressionText());
                    }
                    popup.setVisible(true);
                } else if (src == okBtn) {
                    popup.setVisible(false);
                    String label = labelField.getText();
                    sc.setUserLabel(label);
                    sc.setCondition(conditionArea.getText());
                    sc.setDescription(descField.getText());
                    graphPane.forceImmediateLayout(false);
                } else if (src == cancelBtn) {
                    popup.setVisible(false);
                }
            }
        };
        expressionBtn.addActionListener(lst);
        okBtn.addActionListener(lst);
        cancelBtn.addActionListener(lst);
        JPanel topPnl = new JPanel(new GridBagLayout());
        topPnl.setOpaque(false);
        GraphUtils.addComponent((Container)topPnl, (Component)lbl, (int)0, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)topPnl, (Component)labelField, (int)1, (int)0, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(0, 5, 0, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)topPnl, (Component)descLbl, (int)0, (int)1, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 0, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)topPnl, (Component)descField, (int)1, (int)1, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(5, 5, 0, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        JPanel p = new JPanel(new GridBagLayout());
        p.setBackground(Color.white);
        GraphUtils.addComponent((Container)p, (Component)topPnl, (int)0, (int)0, (int)2, (int)1, (int)17, (int)2, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)condLbl, (int)0, (int)1, (int)1, (int)1, (int)16, (int)0, (Insets)new Insets(5, 5, 2, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)tb, (int)0, (int)1, (int)1, (int)1, (int)14, (int)0, (Insets)new Insets(5, 5, 0, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)new JScrollPane(conditionArea), (int)0, (int)2, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)p, (Component)btnPnl, (int)0, (int)3, (int)2, (int)1, (int)13, (int)0, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        p.setPreferredSize(new Dimension(300, 200));
        return p;
    }
}

