/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.views;

import java.awt.Image;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import oracle.tip.tools.ide.common.bpelparser.iface.SwitchCase;
import oracle.tip.tools.ide.common.graph.actions.GraphAction;
import oracle.tip.tools.ide.common.graph.view.CollapseExpandViewAction;
import oracle.tip.tools.ide.common.graph.view.GraphImageResource;
import oracle.tip.tools.ide.common.graph.view.GraphPane;
import oracle.tip.tools.ide.common.graph.view.Tabable;
import oracle.tip.tools.ide.common.graph.view.View;
import oracle.tip.tools.ide.common.graph.view.VoiceAccessible;
import oracle.tip.tools.ide.pm.bpelgraph.actions.EditExpressionAction;
import oracle.tip.tools.ide.pm.bpelgraph.model.SwitchCaseNode;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.BaseSwitchBranchView;
import oracle.tip.tools.ide.pm.bpelgraph.views.StateSaveableView;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class SwitchCaseView
extends BaseSwitchBranchView
implements StateSaveableView,
Tabable,
VoiceAccessible {
    public SwitchCaseView(GraphPane pane, View parent, SwitchCaseNode n) {
        super(pane, parent, n);
        this.setCanSelect(true);
        Boolean val = (Boolean)n.getData("collapsed");
        if (val != null) {
            this.setCollapsed(val);
        } else {
            this.setCollapsed(false);
        }
    }

    @Override
    protected String getText() {
        return "<case>";
    }

    @Override
    protected Image getImage() {
        return ImageCache.getImage("graph/bpel/switchcase24x24.png");
    }

    @Override
    protected String getHeaderText() {
        SwitchCase c = (SwitchCase)this.getNode().getUserObject();
        String desc = c.getDescription();
        this.setToolTipText(desc);
        if (desc == null) {
            desc = "";
        }
        if (desc.length() > 40) {
            desc = desc.substring(0, 37) + "...";
        }
        if (desc.length() > 0) {
            desc = " " + desc;
        }
        return "<case" + desc + ">";
    }

    @Override
    protected List<GraphAction> createActions() {
        ArrayList<GraphAction> actions = new ArrayList<GraphAction>();
        actions.add(new EditExpressionAction((View)this, true));
        this.m_collapseAction = new CollapseExpandViewAction((View)this, (Icon)new ImageIcon(GraphImageResource.COLLAPSE_ICON), (Icon)new ImageIcon(GraphImageResource.EXPAND_ICON));
        actions.add((GraphAction)this.m_collapseAction);
        return actions;
    }

    @Override
    public BPELGraphPane getBPELGraphPane() {
        return (BPELGraphPane)this.getGraphPane();
    }

    public String getVoiceAccessibleText() {
        return "Switch Case " + this.getHeaderText();
    }
}

