/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.views;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.UIManager;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.graph.model.Edge;
import oracle.tip.tools.ide.common.graph.model.GraphModel;
import oracle.tip.tools.ide.common.graph.model.Node;
import oracle.tip.tools.ide.common.graph.model.PortNode;
import oracle.tip.tools.ide.common.graph.view.BaseView;
import oracle.tip.tools.ide.common.graph.view.EdgeRenderer;
import oracle.tip.tools.ide.common.graph.view.GraphPane;
import oracle.tip.tools.ide.common.graph.view.LayoutInfo;
import oracle.tip.tools.ide.common.graph.view.NodeRenderer;
import oracle.tip.tools.ide.common.graph.view.View;
import oracle.tip.tools.ide.common.ui.ShadowedTextLabel;
import oracle.tip.tools.ide.pm.bpelgraph.model.PartnerLinkConnection;
import oracle.tip.tools.ide.pm.bpelgraph.model.PartnerLinkNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.SwimLaneNode;
import oracle.tip.tools.ide.pm.bpelgraph.settings.BPELSettings;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELTaskView;
import oracle.tip.tools.ide.pm.bpelgraph.views.PartnerLinkEdgeRenderer;
import oracle.tip.tools.ide.pm.bpelgraph.views.PartnerLinkView;
import oracle.tip.tools.ide.pm.bpelgraph.views.PortView;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;

public class SwimLaneView
extends BaseView {
    static String SERVICES_TEXT = BPELStringTranslator.getString("COLLAXALAF_PARTNER_LINKS");
    static String REFERENCES_TEXT = BPELStringTranslator.getString("COLLAXALAF_PARTNER_LINKS");
    static Color m_headerClr = new Color(172, 168, 153);
    static Font m_headerFont = null;
    protected ShadowedTextLabel m_headerLbl;
    protected int m_minYPos = 2 * this.m_topPadding + GraphUtils.getFontHeight((Font)m_headerFont);
    protected int m_topPadding = 2;
    protected int m_verticalSpacing = 5;
    protected int m_minWidth = 130;

    public SwimLaneView(GraphPane pane, View parent, SwimLaneNode n) {
        super(pane, parent, (Node)n);
        this.setInsets(30, 0, 0, 1);
        Boolean val = (Boolean)n.getData("show_swimlanes");
        if (val != null) {
            this.setVisible(val);
        } else {
            this.setVisible(true);
        }
        this.m_headerLbl = new ShadowedTextLabel("Partner Links");
    }

    public void autoRouteEdges() {
        if (((SwimLaneNode)this.getNode()).getOrientation() == 2) {
            this.autoRouteLeftSwimLane();
        } else {
            this.autoRouteRightSwimLane();
        }
    }

    private ArrayList findPortViewsOfDirection(boolean bUpward) {
        ArrayList<PortView> lst = new ArrayList<PortView>();
        for (PartnerLinkView partnerLinkView : this.getConnectedPartnerLinkViews(true)) {
            Iterator portViewIterator = this.getConnectedPortIterator(partnerLinkView, true);
            while (portViewIterator.hasNext()) {
                EdgeRenderer r;
                PortView portView = (PortView)((Object)portViewIterator.next());
                Edge edge = this.getConnectedEdge(portView);
                if (edge == null || !((r = this.m_pane.getEdgeRendererForEdge(edge)) instanceof PartnerLinkEdgeRenderer)) continue;
                PartnerLinkEdgeRenderer edgeRenderer = (PartnerLinkEdgeRenderer)r;
                if (bUpward) {
                    if (edgeRenderer.getLeftConnectionPoint().y < edgeRenderer.getRightConnectionPoint().y) continue;
                    lst.add(portView);
                    continue;
                }
                if (edgeRenderer.getLeftConnectionPoint().y >= edgeRenderer.getRightConnectionPoint().y) continue;
                lst.add(portView);
            }
        }
        final boolean bSortBottomToTop = !bUpward;
        Comparator c = new Comparator(){

            public int compare(Object o1, Object o2) {
                Rectangle r1 = ((View)o1).getBounds();
                Rectangle r2 = ((View)o2).getBounds();
                if (r1.y > r2.y) {
                    return bSortBottomToTop ? -1 : 1;
                }
                if (r1.y < r2.y) {
                    return bSortBottomToTop ? 1 : -1;
                }
                return 0;
            }

            @Override
            public boolean equals(Object obj) {
                return obj == this;
            }
        };
        Collections.sort(lst, c);
        return lst;
    }

    private void autoRouteLeftSwimLane() {
        PartnerLinkEdgeRenderer edgeRenderer;
        EdgeRenderer r;
        Edge edge;
        int xOffset;
        int numEdges = this.getNumberOfEdges();
        if (numEdges == 0) {
            return;
        }
        ArrayList upwardPorts = this.findPortViewsOfDirection(true);
        ArrayList downwardPorts = this.findPortViewsOfDirection(false);
        int portClearance = 10;
        int gridSpacing = 5;
        int gridXOffsetPosition = portClearance;
        int rightMostConnectionPoint = 0;
        for (PortView portView : upwardPorts) {
            rightMostConnectionPoint = Math.max(rightMostConnectionPoint, portView.getConnectionPoint().x);
        }
        for (PortView portView : downwardPorts) {
            rightMostConnectionPoint = Math.max(rightMostConnectionPoint, portView.getConnectionPoint().x);
        }
        for (PortView portView : upwardPorts) {
            xOffset = rightMostConnectionPoint - portView.getConnectionPoint().x;
            edge = this.getConnectedEdge(portView);
            if (edge == null || !((r = this.m_pane.getEdgeRendererForEdge(edge)) instanceof PartnerLinkEdgeRenderer)) continue;
            edgeRenderer = (PartnerLinkEdgeRenderer)r;
            edgeRenderer.setEdgeKinkOffset(xOffset + (gridXOffsetPosition += gridSpacing));
        }
        for (PortView portView : downwardPorts) {
            xOffset = rightMostConnectionPoint - portView.getConnectionPoint().x;
            edge = this.getConnectedEdge(portView);
            if (edge == null || !((r = this.m_pane.getEdgeRendererForEdge(edge)) instanceof PartnerLinkEdgeRenderer)) continue;
            edgeRenderer = (PartnerLinkEdgeRenderer)r;
            edgeRenderer.setEdgeKinkOffset(xOffset + (gridXOffsetPosition += gridSpacing));
        }
    }

    private Edge getConnectedEdge(PortView view) {
        PortNode portNode;
        GraphPane pane = this.getGraphPane();
        GraphModel model = pane.getModel();
        Edge[] edges = model.getEdgesForPort(portNode = (PortNode)view.getNode());
        if (edges != null && edges.length > 0) {
            return edges[0];
        }
        return null;
    }

    Iterator getConnectedPortIterator(PartnerLinkView view, final boolean bSortBottomToTop) {
        GraphPane pane = this.getGraphPane();
        GraphModel model = pane.getModel();
        ArrayList<View> lst = new ArrayList<View>();
        PartnerLinkNode node = (PartnerLinkNode)view.getNode();
        for (Node childNode : node.getChildren()) {
            View portView;
            PortNode endpointPortNode;
            Edge[] portEdges;
            if (!(childNode instanceof PortNode) || (portEdges = model.getEdgesForPort(endpointPortNode = (PortNode)childNode)).length == 0 || (portView = this.getViewForPort(view, endpointPortNode)) == null) continue;
            lst.add(portView);
        }
        Comparator c = new Comparator(){

            public int compare(Object o1, Object o2) {
                Rectangle r1 = ((View)o1).getBounds();
                Rectangle r2 = ((View)o2).getBounds();
                if (r1.y > r2.y) {
                    return bSortBottomToTop ? -1 : 1;
                }
                if (r1.y < r2.y) {
                    return bSortBottomToTop ? 1 : -1;
                }
                return 0;
            }

            @Override
            public boolean equals(Object obj) {
                return obj == this;
            }
        };
        Collections.sort(lst, c);
        return lst.iterator();
    }

    private View getViewForPort(PartnerLinkView view, PortNode node) {
        Iterator iterator = view.getChildren();
        while (iterator.hasNext()) {
            View childView = (View)iterator.next();
            if (childView.getNode() != node) continue;
            return childView;
        }
        return null;
    }

    private void autoRouteRightSwimLane() {
        int edgeLength;
        Point rightPt;
        Point leftPt;
        PartnerLinkEdgeRenderer edgeRenderer;
        EdgeRenderer r;
        Edge edge;
        int xOffset;
        int numEdges = this.getNumberOfEdges();
        if (numEdges == 0) {
            return;
        }
        ArrayList upwardPorts = this.findPortViewsOfDirection(false);
        ArrayList downwardPorts = this.findPortViewsOfDirection(true);
        int portClearance = 10;
        int gridSpacing = 5;
        int gridXOffsetPosition = portClearance;
        int leftMostConnectionPoint = 0;
        for (PortView portView : upwardPorts) {
            leftMostConnectionPoint = Math.max(leftMostConnectionPoint, portView.getConnectionPoint().x);
        }
        for (PortView portView : downwardPorts) {
            leftMostConnectionPoint = Math.max(leftMostConnectionPoint, portView.getConnectionPoint().x);
        }
        for (PortView portView : downwardPorts) {
            xOffset = portView.getConnectionPoint().x - leftMostConnectionPoint;
            edge = this.getConnectedEdge(portView);
            if (edge == null || !((r = this.m_pane.getEdgeRendererForEdge(edge)) instanceof PartnerLinkEdgeRenderer)) continue;
            edgeRenderer = (PartnerLinkEdgeRenderer)r;
            leftPt = edgeRenderer.getLeftConnectionPoint();
            rightPt = edgeRenderer.getRightConnectionPoint();
            edgeLength = Math.abs(leftPt.x - rightPt.x);
            edgeRenderer.setEdgeKinkOffset(edgeLength - (xOffset + (gridXOffsetPosition += gridSpacing)));
        }
        for (PortView portView : upwardPorts) {
            xOffset = portView.getConnectionPoint().x - leftMostConnectionPoint;
            edge = this.getConnectedEdge(portView);
            if (edge == null || !((r = this.m_pane.getEdgeRendererForEdge(edge)) instanceof PartnerLinkEdgeRenderer)) continue;
            edgeRenderer = (PartnerLinkEdgeRenderer)r;
            leftPt = edgeRenderer.getLeftConnectionPoint();
            rightPt = edgeRenderer.getRightConnectionPoint();
            edgeLength = Math.abs(leftPt.x - rightPt.x);
            edgeRenderer.setEdgeKinkOffset(edgeLength - (xOffset + (gridXOffsetPosition += gridSpacing)));
        }
    }

    private int getNumberOfEdges() {
        int result = 0;
        GraphPane pane = this.getGraphPane();
        GraphModel model = pane.getModel();
        for (int i = 0; i < this.m_children.size(); ++i) {
            View endPointView = (View)this.m_children.get(i);
            if (!(endPointView instanceof PartnerLinkView)) continue;
            PartnerLinkNode node = (PartnerLinkNode)endPointView.getNode();
            for (Node childNode : node.getChildren()) {
                PortNode endpointPortNode;
                Edge[] portEdges;
                if (!(childNode instanceof PortNode) || (portEdges = model.getEdgesForPort(endpointPortNode = (PortNode)childNode)).length == 0) continue;
                ++result;
            }
        }
        return result;
    }

    private ArrayList getPartnerLinkConnectedViews(PartnerLinkView partnerLinkView, final boolean bSortBottomMostFirst) {
        ArrayList<NodeRenderer> lst = new ArrayList<NodeRenderer>();
        GraphPane pane = this.getGraphPane();
        GraphModel model = pane.getModel();
        PartnerLinkNode node = (PartnerLinkNode)partnerLinkView.getNode();
        for (Node childNode : node.getChildren()) {
            PortNode endpointPortNode;
            Edge[] portEdges;
            if (!(childNode instanceof PortNode) || (portEdges = model.getEdgesForPort(endpointPortNode = (PortNode)childNode)).length == 0) continue;
            for (int i = 0; i < portEdges.length; ++i) {
                Edge portEdge = portEdges[i];
                PortNode viewPortNode = portEdge.getSource() != endpointPortNode ? portEdge.getSource() : portEdge.getTarget();
                Node viewNode = viewPortNode.getParentNode();
                NodeRenderer r = pane.getNodeRendererForNode(viewNode);
                if (r == null) continue;
                lst.add(r);
            }
        }
        Comparator c = new Comparator(){

            public int compare(Object o1, Object o2) {
                Rectangle r1 = ((View)o1).getBounds();
                Rectangle r2 = ((View)o2).getBounds();
                if (r1.y > r2.y) {
                    return bSortBottomMostFirst ? -1 : 1;
                }
                if (r1.y < r2.y) {
                    return bSortBottomMostFirst ? 1 : -1;
                }
                return 0;
            }

            @Override
            public boolean equals(Object obj) {
                return obj == this;
            }
        };
        Collections.sort(lst, c);
        return lst;
    }

    private ArrayList getConnectedPartnerLinkViews(final boolean bSortBottomMostFirst) {
        ArrayList<View> connectedPartnerLinkViews = new ArrayList<View>();
        GraphPane pane = this.getGraphPane();
        GraphModel model = pane.getModel();
        block0: for (int i = 0; i < this.m_children.size(); ++i) {
            View partnerLinkView = (View)this.m_children.get(i);
            if (!(partnerLinkView instanceof PartnerLinkView)) continue;
            PartnerLinkNode node = (PartnerLinkNode)partnerLinkView.getNode();
            for (Node childNode : node.getChildren()) {
                PortNode endpointPortNode;
                Edge[] portEdges;
                if (!(childNode instanceof PortNode) || (portEdges = model.getEdgesForPort(endpointPortNode = (PortNode)childNode)).length == 0) continue;
                connectedPartnerLinkViews.add(partnerLinkView);
                continue block0;
            }
        }
        Comparator c = new Comparator(){

            public int compare(Object o1, Object o2) {
                Rectangle r1 = ((View)o1).getBounds();
                Rectangle r2 = ((View)o2).getBounds();
                if (r1.y > r2.y) {
                    return bSortBottomMostFirst ? -1 : 1;
                }
                if (r1.y < r2.y) {
                    return bSortBottomMostFirst ? 1 : -1;
                }
                return 0;
            }

            @Override
            public boolean equals(Object obj) {
                return obj == this;
            }
        };
        Collections.sort(connectedPartnerLinkViews, c);
        return connectedPartnerLinkViews;
    }

    void adjustPortConnectionPositions() {
        GraphPane pane = this.getGraphPane();
        GraphModel model = pane.getModel();
        for (int i = 0; i < this.m_children.size(); ++i) {
            View endPointView = (View)this.m_children.get(i);
            if (!(endPointView instanceof PartnerLinkView)) continue;
            PartnerLinkNode node = (PartnerLinkNode)endPointView.getNode();
            for (Node childNode : node.getChildren()) {
                PortNode target;
                PortNode source;
                boolean bLeftSwimLane;
                NodeRenderer view;
                Edge edge;
                PortNode taskPort;
                NodeRenderer taskPortRenderer;
                PortNode endpointPortNode;
                Edge[] portEdges;
                if (!(childNode instanceof PortNode) || (portEdges = model.getEdgesForPort(endpointPortNode = (PortNode)childNode)).length == 0 || (taskPortRenderer = pane.getNodeRendererForNode((Node)(taskPort = (edge = portEdges[0]).getSource() == endpointPortNode ? edge.getTarget() : edge.getSource()))) == null || !((view = taskPortRenderer.getParent()) instanceof BPELTaskView)) continue;
                BPELTaskView taskView = (BPELTaskView)view;
                boolean bl = bLeftSwimLane = ((SwimLaneNode)this.getNode()).getOrientation() == 2;
                if (bLeftSwimLane) {
                    PortView leftPortView = taskView.getLeftPortView();
                    if (leftPortView.getNode() != taskPort) {
                        model.deleteEdges(new Edge[]{edge});
                        if (endpointPortNode.getType() == 1) {
                            source = endpointPortNode;
                            target = (PortNode)leftPortView.getNode();
                        } else {
                            target = endpointPortNode;
                            source = (PortNode)leftPortView.getNode();
                        }
                        model.insertEdge((Edge)new PartnerLinkConnection(source, target));
                    }
                } else {
                    PortView rightPortView = taskView.getRightPortView();
                    if (rightPortView.getNode() != taskPort) {
                        model.deleteEdges(new Edge[]{edge});
                        if (endpointPortNode.getType() == 1) {
                            source = endpointPortNode;
                            target = (PortNode)rightPortView.getNode();
                        } else {
                            target = endpointPortNode;
                            source = (PortNode)rightPortView.getNode();
                        }
                        model.insertEdge((Edge)new PartnerLinkConnection(source, target));
                    }
                }
                taskView.setPortVisibility();
            }
        }
    }

    protected int computePartnerLinkPositionBasedOnAverage(PartnerLinkView partnerLinkView) {
        ArrayList lst = this.getPartnerLinkConnectedViews(partnerLinkView, false);
        int numViews = lst.size();
        if (numViews == 0) {
            return partnerLinkView.getBounds().y + partnerLinkView.getBounds().height / 2;
        }
        ArrayList<View> l2 = new ArrayList<View>();
        for (View view : lst) {
            if (GraphUtils.inCollapsedView((View)view)) continue;
            l2.add(view);
        }
        Iterator iterator = l2.iterator();
        int total = 0;
        while (iterator.hasNext()) {
            View view = (View)iterator.next();
            total += view.getBounds().y;
        }
        int average = total / numViews;
        if (average < this.m_minYPos) {
            average = this.m_minYPos;
        }
        return average;
    }

    Rectangle layoutPartnerLinks() {
        GraphPane pane = this.getGraphPane();
        GraphModel model = pane.getModel();
        for (int i = 0; i < this.m_children.size(); ++i) {
            Point pt;
            boolean bHasConnections;
            View endPointView = (View)this.m_children.get(i);
            if (!(endPointView instanceof PartnerLinkView)) continue;
            PartnerLinkView plinkView = (PartnerLinkView)endPointView;
            PartnerLinkNode node = (PartnerLinkNode)endPointView.getNode();
            boolean bl = bHasConnections = node.getChildCount() > 0;
            if (bHasConnections) {
                int yPos = this.computePartnerLinkPositionBasedOnAverage((PartnerLinkView)endPointView);
                for (Node childNode : node.getChildren()) {
                    PortNode endpointPortNode;
                    Edge[] portEdges;
                    if (!(childNode instanceof PortNode) || (portEdges = model.getEdgesForPort(endpointPortNode = (PortNode)childNode)).length <= 0) continue;
                    int diff = yPos - endPointView.getBounds().y;
                    endPointView.move(0, diff);
                }
                continue;
            }
            if (plinkView.isAbsolutePositioned() || (pt = node.getDropPoint()) == null) continue;
            int diff = pt.y - endPointView.getBounds().y;
            endPointView.move(0, diff);
        }
        this.resolvePartnerLinkPositionCollisions();
        Rectangle bounds = new Rectangle(this.m_bounds.x, this.m_bounds.y, this.m_bounds.width, this.m_bounds.height);
        for (int i = 0; i < this.m_children.size(); ++i) {
            View endPointView = (View)this.m_children.get(i);
            if (!(endPointView instanceof PartnerLinkView)) continue;
            bounds.add(endPointView.getBounds());
        }
        this.m_bounds = bounds;
        return this.m_bounds;
    }

    private void resolvePartnerLinkPositionCollisions() {
        ArrayList<PartnerLinkView> absolutePositionedViews = new ArrayList<PartnerLinkView>();
        ArrayList<PartnerLinkView> sortedList = new ArrayList<PartnerLinkView>();
        for (int i = 0; i < this.m_children.size(); ++i) {
            View endPointView = (View)this.m_children.get(i);
            if (!(endPointView instanceof PartnerLinkView)) continue;
            PartnerLinkView pv = (PartnerLinkView)endPointView;
            sortedList.add(pv);
            if (!pv.isAbsolutePositioned()) continue;
            absolutePositionedViews.add(pv);
            pv.setAbsolutePositioned(false);
        }
        Comparator c = new Comparator(){

            public int compare(Object o1, Object o2) {
                Rectangle r1 = ((View)o1).getBounds();
                Rectangle r2 = ((View)o2).getBounds();
                if (r1.y < r2.y) {
                    return -1;
                }
                if (r1.y > r2.y) {
                    return 1;
                }
                return 0;
            }

            @Override
            public boolean equals(Object obj) {
                return obj == this;
            }
        };
        Collections.sort(sortedList, c);
        int sz = sortedList.size();
        for (int i = 0; i < sz; ++i) {
            List overlaps;
            View view = (View)sortedList.get(i);
            View prevView = null;
            if (i > 0) {
                prevView = (View)sortedList.get(i - 1);
            }
            if ((overlaps = this.findOverlapViews(view, sortedList)).size() <= 0) continue;
            for (View overlapView : overlaps) {
                int spaceBefore;
                int overlapAmount;
                Rectangle overlapBounds = overlapView.getBounds();
                Rectangle viewBounds = view.getBounds();
                if (viewBounds.y + viewBounds.height > overlapBounds.y + overlapBounds.height) {
                    overlapAmount = viewBounds.y + viewBounds.height - (overlapBounds.y + overlapBounds.height);
                    spaceBefore = 0;
                    spaceBefore = prevView != null ? viewBounds.y - (prevView.getBounds().y + prevView.getBounds().height) : Math.max(0, viewBounds.y - (this.m_bounds.y + this.m_insets.top));
                    if (spaceBefore > 0) {
                        view.move(0, -Math.min(overlapAmount, spaceBefore));
                    }
                    if (viewBounds.y + viewBounds.height >= overlapBounds.y + overlapBounds.height) {
                        overlapAmount = viewBounds.y + viewBounds.height - overlapBounds.y;
                        overlapView.move(0, overlapAmount);
                        continue;
                    }
                    if (viewBounds.y + viewBounds.height < overlapBounds.y || overlapBounds.y + overlapBounds.height < viewBounds.y + viewBounds.height) continue;
                    overlapAmount = viewBounds.y + viewBounds.height - overlapBounds.y;
                    overlapView.move(0, overlapAmount);
                    continue;
                }
                if (viewBounds.y + viewBounds.height < overlapBounds.y) continue;
                overlapAmount = viewBounds.y + viewBounds.height - overlapBounds.y;
                spaceBefore = 0;
                spaceBefore = prevView != null ? viewBounds.y - (prevView.getBounds().y + prevView.getBounds().height) : Math.max(0, viewBounds.y - (this.m_bounds.y + this.m_insets.top));
                if (spaceBefore > 0) {
                    view.move(0, -Math.min(overlapAmount, spaceBefore));
                }
                if (viewBounds.y + viewBounds.height <= overlapBounds.y || overlapBounds.y + overlapBounds.height < viewBounds.y + viewBounds.height) continue;
                overlapAmount = viewBounds.y + viewBounds.height - overlapBounds.y;
                overlapView.move(0, overlapAmount);
            }
        }
        for (PartnerLinkView partnerLinkView : absolutePositionedViews) {
            partnerLinkView.setAbsolutePositioned(true);
        }
    }

    List findOverlapViews(View v, List views) {
        ArrayList<View> lst = new ArrayList<View>();
        Iterator viewIterator = views.iterator();
        Rectangle viewBounds = v.getBounds();
        while (viewIterator.hasNext()) {
            View currView = (View)viewIterator.next();
            if (currView == v) continue;
            Rectangle r = currView.getBounds();
            if (r.y < viewBounds.y || r.y > viewBounds.y + viewBounds.height) continue;
            lst.add(currView);
        }
        return lst;
    }

    ArrayList getLeftBiasedPortNodes() {
        return this.getBiasedPortNodes(true);
    }

    ArrayList getRightBiasedPortNodes() {
        return this.getBiasedPortNodes(false);
    }

    private ArrayList getBiasedPortNodes(boolean bFindLeftBiased) {
        ArrayList<PortNode> lst = new ArrayList<PortNode>();
        GraphPane pane = this.getGraphPane();
        Rectangle docBounds = pane.getDocumentBounds();
        int midPointX = docBounds.x + docBounds.width / 2;
        GraphModel model = pane.getModel();
        for (int i = 0; i < this.m_children.size(); ++i) {
            View v = (View)this.m_children.get(i);
            if (!(v instanceof PartnerLinkView)) continue;
            PartnerLinkNode node = (PartnerLinkNode)v.getNode();
            for (Node childNode : node.getChildren()) {
                NodeRenderer view;
                Edge edge;
                PortNode viewPort;
                NodeRenderer portNodeRenderer;
                PortNode pNode;
                Edge[] portEdges;
                if (!(childNode instanceof PortNode) || (portEdges = model.getEdgesForPort(pNode = (PortNode)childNode)).length <= 0 || (portNodeRenderer = pane.getNodeRendererForNode((Node)(viewPort = (edge = portEdges[0]).getSource() == pNode ? edge.getTarget() : edge.getSource()))) == null || (view = portNodeRenderer.getParent()) == null) continue;
                Rectangle viewBounds = view.getBounds();
                if (bFindLeftBiased) {
                    boolean bLeftBiased = midPointX > viewBounds.x + viewBounds.width / 2;
                    if (!bLeftBiased) continue;
                    lst.add(pNode);
                    continue;
                }
                boolean bRightBiased = midPointX < viewBounds.x + viewBounds.width / 2;
                if (!bRightBiased) continue;
                lst.add(pNode);
            }
        }
        return lst;
    }

    public boolean getVisible() {
        return this.m_bVisible;
    }

    public void setVisible(boolean bVisible) {
        this.m_bVisible = bVisible;
    }

    protected void paintBackground(Graphics g) {
        Color c = this.getBackgroundColor();
        if (c != null) {
            Color oldColor = g.getColor();
            g.setColor(c);
            g.fillRect(this.m_bounds.x, this.m_bounds.y, this.m_bounds.width, this.m_bounds.height);
            g.setColor(oldColor);
        }
    }

    public void paint(Graphics g, int layer) {
        if (!this.m_bVisible) {
            return;
        }
        super.paint(g, layer);
        SwimLaneNode node = (SwimLaneNode)this.getNode();
        Color dividerClr = this.getDividerColor();
        String text = null;
        if (node.getOrientation() == 2) {
            GraphUtils.drawVertLine((Graphics)g, (int)this.rightX(), (int)this.topY(), (int)this.bottomY(), (float)1.0f, (Color)dividerClr);
            text = SERVICES_TEXT;
        } else {
            GraphUtils.drawVertLine((Graphics)g, (int)this.leftX(), (int)this.topY(), (int)this.bottomY(), (float)1.0f, (Color)dividerClr);
            text = REFERENCES_TEXT;
        }
        g.setFont(m_headerFont);
        int h = GraphUtils.getFontHeight((Font)g.getFont());
        int strWidth = GraphUtils.getStringWidth((Font)g.getFont(), (String)text);
        int xPos = this.m_bounds.x + this.m_insets.left;
        int xOffset = (this.m_bounds.width - this.m_insets.left - this.m_insets.right - strWidth) / 2;
        g.setColor(this.getHeaderColor());
        GraphUtils.paintAntiAliasText((String)text, (Graphics)g, (int)(xPos + xOffset), (int)(this.m_bounds.y + h), (Color)this.getHeaderColor(), (Font)m_headerFont);
    }

    protected Color getBackgroundColor() {
        BPELGraphPane graph = (BPELGraphPane)this.getGraphPane();
        BPELSettings settings = graph.getSettings();
        return settings.m_swimlaneBackgroundColor;
    }

    protected Color getDividerColor() {
        BPELGraphPane graph = (BPELGraphPane)this.getGraphPane();
        BPELSettings settings = graph.getSettings();
        return settings.m_swimlaneDividerBackgroundColor;
    }

    protected Color getHeaderColor() {
        return Color.GRAY;
    }

    public int getPreferredSpan(int axis) {
        return 130;
    }

    public Rectangle layout(int x, int y, int w, int h, LayoutInfo info) {
        if (!this.m_bVisible) {
            this.setBounds(x, y, 0, 0);
            return this.m_bounds;
        }
        return this.layoutPorts(x, y, w, h, info);
    }

    Rectangle layoutPorts(int x, int y, int w, int h, LayoutInfo info) {
        View v;
        int i;
        this.m_bounds.setBounds(x, y, 0, 0);
        int xPos = x + this.m_insets.left;
        int yPos = y + this.m_insets.top;
        int width = 0;
        SwimLaneNode node = (SwimLaneNode)this.getNode();
        int orientation = node.getOrientation();
        int portOrientation = 4;
        if (orientation == 4) {
            portOrientation = 2;
        } else if (orientation == 2) {
            portOrientation = 4;
        }
        int numPortConnections = 0;
        int maxViewWidth = 0;
        for (i = 0; i < this.m_children.size(); ++i) {
            Rectangle r;
            v = (View)this.m_children.get(i);
            if (!(v instanceof PartnerLinkView)) continue;
            PartnerLinkView pv = (PartnerLinkView)v;
            pv.setPortOrientation(portOrientation);
            if (pv.isAbsolutePositioned()) {
                Rectangle currBounds = v.getBounds();
                r = v.layout(xPos, currBounds.y, v.getPreferredSpan(1), v.getPreferredSpan(0), info);
            } else {
                r = v.layout(xPos, yPos, v.getPreferredSpan(1), v.getPreferredSpan(0), info);
                yPos += r.height;
                if (i != this.m_children.size() - 1) {
                    yPos += this.m_verticalSpacing;
                }
            }
            numPortConnections += pv.getChildCount();
            maxViewWidth = Math.max(maxViewWidth, r.width);
            if (i != this.m_children.size() - 1) {
                yPos += this.m_verticalSpacing;
            }
            width = Math.max(width, r.width);
        }
        for (i = 0; i < this.m_children.size(); ++i) {
            v = (View)this.m_children.get(i);
            Rectangle r = v.getBounds();
            if (r.width >= maxViewWidth) continue;
            v.stretchToWidth(maxViewWidth);
        }
        if (width < this.m_minWidth) {
            width = this.m_minWidth;
        }
        this.m_bounds.width = width + this.m_insets.left + this.m_insets.right;
        for (i = 0; i < this.m_children.size(); ++i) {
            v = (View)this.m_children.get(i);
            int vWidth = v.getBounds().width;
            int diff = this.m_bounds.width - vWidth;
            if (diff <= 0) continue;
            v.move(diff / 2, 0);
        }
        this.m_bounds.setBounds(this.m_bounds.x, this.m_bounds.y, this.m_bounds.width, this.m_insets.top + this.m_insets.bottom);
        for (i = 0; i < this.m_children.size(); ++i) {
            v = (View)this.m_children.get(i);
            this.m_bounds.add(v.getBounds());
        }
        BPELGraphPane graph = (BPELGraphPane)this.getGraphPane();
        BPELSettings settings = graph.getSettings();
        if (!settings.m_bFixedWidthLanes) {
            int edgeSpacing = 10;
            int widthDueToEdges = numPortConnections * edgeSpacing;
            this.m_bounds.width += widthDueToEdges;
            if (portOrientation == 2) {
                for (int i2 = 0; i2 < this.m_children.size(); ++i2) {
                    View v2 = (View)this.m_children.get(i2);
                    v2.move(widthDueToEdges, 0);
                }
            }
        }
        return this.m_bounds;
    }

    public void move(int x, int y) {
        super.move(x, y);
    }

    static {
        m_headerFont = UIManager.getFont("Label.font").deriveFont(1, 13.0f);
    }
}

